(function() {
    var isIframe = (window.self != window.top);
    var width = window.innerWidth || document.documentElement.clientWidth;
    var height = window.innerHeight || document.documentElement.clientHeight;

    if (isIframe && ((width * height) < 100000)) {
        // Do not run into small iframes
        return;
    }

    var wrapped = top;
    var wrappedDocument = wrapped.document;
    var deprecatedProperties = ["webkitStorageInfo", "webkitIndexedDB", "mozHidden", "mozVisibilityState"];

    /**
     * Wrapper for window object
     */
    var wrapper = {
        listeners: {},

        /**
         * Removes the event listener previously registered with addEventListener()
         * @param eventType - A string representing the event type to remove
         * @param eventListener - The object that receives a notification when an event of the specified type occurs
         * @param options - An options object that specifies characteristics about the event listener
         */
        removeEventListener: function(eventType, eventListener, options) {
            if (wrapper.listeners[eventListener]) {
                var eventListenerWrapper = wrapper.listeners[eventListener];
                wrapped.removeEventListener(eventType, eventListenerWrapper, options);
            }
        },

        /**
         * Registers the specified listener on the EventTarget it's called on
         * @param eventType - A string representing the event type to listen for
         * @param eventListener - The object that receives a notification when an event of the specified type occurs
         * @param options - An options object that specifies characteristics about the event listener
         */
        addEventListener: function(eventType, eventListener, options) {
            var eventListenerWrapper;
            if (wrapper.listeners[eventListener]) {
                eventListenerWrapper = wrapper.listeners[eventListener];
            } else {
                var eventListenerWrapper = function(e) {
                    if (eventListener.handleEvent) {
                        with(wrapper) {
                            eventListener.handleEvent(e);
                        }
                    } else {
                        eventListener.call(wrapperDocument, e);
                    }
                };
                wrapper.listeners[eventListener] = eventListenerWrapper;
            }
            wrapped.addEventListener(eventType, eventListenerWrapper, options);
        },

        /**
         * Creates an event of the type specified
         * @param eventType - A string representing the event type to create
         */
        createEvent: function(eventType) {
            return wrapped.createEvent(eventType);
        },

        /**
         * Dispatches an event at the wrapper
         * @param event - The Event object to be dispatched.
         */
        dispatchEvent: function(event) {
            return wrapped.dispatchEvent(event);
        }
    };

    /**
     * Wrapper for document object
     */
    var wrapperDocument = {
        listeners: {},

        /**
         * Removes the event listener previously registered with addEventListener()
         * @param eventType - A string representing the event type to listen for
         * @param eventListener - The object that receives a notification when an event of the specified type occurs
         * @param options - An options object that specifies characteristics about the event listener
         */
        removeEventListener: function(eventType, eventListener, options) {
            if (wrapperDocument.listeners[eventListener]) {
                var eventListenerWrapper = wrapperDocument.listeners[eventListener];
                wrappedDocument.removeEventListener(eventType, eventListenerWrapper, options);
            }
        },

        /**
         * Registers the specified listener on the EventTarget it's called on
         * @param eventType - A string representing the event type to listen for
         * @param eventListener - The object that receives a notification when an event of the specified type occurs
         * @param options - An options object that specifies characteristics about the event listener
         */
        addEventListener: function(eventType, eventListener, options) {
            var eventListenerWrapper;
            if (wrapperDocument.listeners[eventListener]) {
                eventListenerWrapper = wrapperDocument.listeners[eventListener];
            } else {
                eventListenerWrapper = function(e) {
                    if (eventListener.handleEvent) {
                        with(wrapperDocument) {
                            eventListener.handleEvent(e);
                        }
                    } else {
                        eventListener.call(wrapperDocument, e);
                    }
                };
                wrapperDocument.listeners[eventListener] = eventListenerWrapper;
            }
            wrappedDocument.addEventListener(eventType, eventListenerWrapper, options);
        },

        /**
         * Creates an event of the type specified
         * @param eventType - A string representing the event type to create
         */
        createEvent: function(eventType) {
            return wrappedDocument.createEvent(eventType);
        },

        /**
         * Dispatches an event at the wrapper
         * @param event - The Event object to be dispatched.
         */
        dispatchEvent: function(event) {
            return wrappedDocument.dispatchEvent(event);
        }
    };

    (function() {
        'use strict';
        // Init GM commands api
        window.__adg_gm_commands_api = window.__adg_gm_commands_api || {
                commands: []
            };
    })();

    /**
     * Calls the specified event handler when body loaded
     * @param eventListener - The object that receives a notification when an event of the specified type occurs
     */
    var runAtBody = function(eventListener) {
        if (wrapperDocument.body) {
            if (eventListener) {
                eventListener.call(wrapperDocument);
            }
        } else {
            var listenEvents = ["load", "DOMNodeInserted", "DOMContentLoaded"];
            var eventListenerWrapper = function() {
                listenEvents.forEach(function(eventType) {
                    wrapperDocument.removeEventListener(eventType, eventListenerWrapper, false);
                });
                runAtBody(eventListener);
            };

            listenEvents.forEach(function(eventType) {
                wrapperDocument.addEventListener(eventType, eventListenerWrapper, false);
            })
        }
    };

    /**
     * Calls the specified event handler when document was successfully loaded
     * @param eventListener - The object that receives a notification when an event of the specified type occurs
     */
    var runAtDocumentEnd = function(eventListener) {
        if (document.readyState == "complete" || document.readyState == "loaded" || document.readyState == "interactive") {
            if (eventListener) {
                eventListener.call(wrapperDocument);
            }
        } else {
            var listenEvents = ["DOMContentLoaded", "load"];
            var eventListenerWrapper = function() {
                listenEvents.forEach(function(eventType) {
                    wrapperDocument.removeEventListener(eventType, eventListenerWrapper, false);
                });
                runAtDocumentEnd(eventListener);
            };

            listenEvents.forEach(function(eventType) {
                wrapperDocument.addEventListener(eventType, eventListenerWrapper, false);
            })
        }
    };

    /**
     * Copies the properties from wrappedObject to wrapperObject
     * @param wrappedObject - object from which properties copied
     * @param wrapperObject - object to which properties copied
     */
    var copyProperties = function(wrappedObject, wrapperObject) {
        var properties = [];
        for (prop in wrappedObject) {
            properties.push(prop);
        }

        properties.forEach(function(propertyName) {
            if (wrapperObject[propertyName] || deprecatedProperties.indexOf(propertyName) > -1) {
                return;
            }

            if (typeof(wrappedObject[propertyName]) === 'function') {
                var func = wrappedObject[propertyName];
                wrapperObject[propertyName] = function() {
                    return func.apply(wrappedObject, arguments);
                }
            } else {
                Object.defineProperty(wrapperObject, propertyName, {
                    get: function() {
                        return wrappedObject[propertyName];
                    },
                    set: function(property_value) {
                        wrappedObject[propertyName] = property_value;
                    }
                });
            }
        });
    };

    /**
     * Initialize window and document wrappers.
     * Schedule userscript to run.
     */
    var initializeWindowWrapper = function() {
        wrapper.window = wrapper;
        wrapper.Promise = wrapped.Promise;
        wrapper.XMLHttpRequest = wrapped.XMLHttpRequest;
        wrapper.DOMParser = wrapped.DOMParser;
        wrapper.MutationObserver = wrapped.MutationObserver;
        wrapper.document = wrapperDocument;
        wrapper.top = (window.top == window) ? wrapper : window.top;
        wrapper.parent = (window.parent == window) ? wrapper : window.parent;
        wrapper.self = wrapper;
        if (typeof InstallTrigger !== 'undefined') {
            wrapper.exportFunction = function(func, context, options) {
                if (options && options.defineAs) {
                    context[options.defineAs] = func;
                }

                return func;
            }

            wrapper.createObjectIn = function(context, options) {
                var newObject = {};
                if (options && options.defineAs) {
                    context[options.defineAs] = newObject;
                }

                return newObject;
            }
        }

        var isEventFunction = function(key) {
            return key === 'addEventListener' || key === 'removeEventListener' || key === 'createEvent' || key === 'dispatchEvent' || key.indexOf('on') === 0;
        };
        // https://github.com/AdguardTeam/AdguardForWindows/issues/1139
        var decorator = {
            get: function(target, key) {
                if (isEventFunction(key)) {
                    var wrappedFunction = target[key];
                    return function() {
                        wrappedFunction.apply(target, arguments);
                    }
                } else {
                    return target[key];
                }
            },
            set: function(target, key, value) {
                target[key] = value;
                return true;
            }
        };

        if (typeof Proxy != 'undefined') {
            wrapper.unsafeWindow = new Proxy(window, decorator);
        } else {
            wrapper.unsafeWindow = window;
        }
        copyProperties(wrappedDocument, wrapperDocument);
        copyProperties(wrapped, wrapper);
    };

    var log = function(message) {
        'use strict';
        if (console && console.log) {
            console.log(message);
        }
    };

    try {
        var isIframe = (window.self != window.top);
        var width = window.innerWidth || document.documentElement.clientWidth;
        var height = window.innerHeight || document.documentElement.clientHeight;

        if (isIframe && ((width * height) < 100000)) {
            // Do not run into small iframes
            return;
        }

        initializeWindowWrapper();
        var AdguardSettings = {"locale":"zh","appVersion":"1.4.0","licenseStatus":"NEEDS IMPLEMENTATION","uniqueName":"Adguard Assistant","feedbackUrl":"http:\/\/api.adguard.com","applicationId":"c4544497d45f","version":"3.0.116","sendAnonymousStatistic":"false","nonce":"6BB44CC1D3754673A870A7D8D1002553"};/* Injecting API Settings */
        var protectionFunction = function(params) {
            'use strict';
            return "768E5B450D9B4666BED15359B2BB258A0E5D233620064875A9107FD48A" + params + "4663CAB32DFC4DB6A6B7CD428D436B7CE8F4DC0457DE4";
        };
        var userscript = function(window, AdguardSettings, __adg_gm_commands_api) {
            with(wrapper) {

                /*Injecting GM_Resources = {dictionary};*/ var GM_Resources = {};
                /*Injecting ApiJs script*/ var __GM_api = {};
                (function () {
                    var settings = { apiurl: "/adguard-ajax-api/api.html", feedbackUrl: "/api/1.0/url-report.html" }; var utils = {
                        getHostWithProtocol: function () { var hostname = document.location.hostname; var protocol = document.location.protocol; var port = document.location.port == "80" ? "" : ":" + document.location.port; return protocol + "//" + hostname + port }, sendGetRequest: function (params, async) {
                            var url = utils.getHostWithProtocol() + settings.apiurl; url += "?"; url += utils.buildParameters(params); if (typeof async == "undefined") async = false; var xmlhttp =
                                new XMLHttpRequest; xmlhttp.open("GET", url, async); xmlhttp.send(); if (xmlhttp.readyState == 4) if (xmlhttp.status != 200) throw xmlhttp.statusText; return xmlhttp.responseText
                        }, sendPostRequest: function (params) { var url = utils.getHostWithProtocol() + settings.apiurl; var data = utils.buildParameters(params); var xmlhttp = new XMLHttpRequest; xmlhttp.open("POST", url, true); xmlhttp.send(data) }, buildParameters: function (params, omitParameters) {
                            var query = ""; for (var key in params) if (params.hasOwnProperty(key)) {
                                var value = params[key];
                                if (query) query += "&"; query += key; query += "="; if (omitParameters && omitParameters[key]) query += value; else query += encodeURIComponent(value)
                            } var calc = function (params) {
                                var ROTR = function (n, x) { return x >>> n | x << 32 - n }; var \u03a30 = function (x) { return ROTR(2, x) ^ ROTR(13, x) ^ ROTR(22, x) }; var \u03a31 = function (x) { return ROTR(6, x) ^ ROTR(11, x) ^ ROTR(25, x) }; var \u03c30 = function (x) { return ROTR(7, x) ^ ROTR(18, x) ^ x >>> 3 }; var \u03c31 = function (x) { return ROTR(17, x) ^ ROTR(19, x) ^ x >>> 10 }; var Ch = function (x, y, z) { return x & y ^ ~x & z }; var Maj = function (x,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          y, z) { return x & y ^ x & z ^ y & z }; var toHexStr = function (n) { var s = "", v; for (var i = 7; i >= 0; i--) { v = n >>> i * 4 & 15; s += v.toString(16) } return s }; var safeMathCeil = function (x) { var i = 0; for (; i <= x + 1; i++) if (i >= x) return i; return i }; var charCodeAt = function (str, index) {
                                    var character = str[index]; if (typeof character == "undefined") return NaN; if (character == " ") return 32; if (character == "!") return 33; if (character == '"') return 34; if (character == "#") return 35; if (character == "$") return 36; if (character == "%") return 37; if (character == "&") return 38;
                                    if (character == "'") return 39; if (character == "(") return 40; if (character == ")") return 41; if (character == "*") return 42; if (character == "+") return 43; if (character == ",") return 44; if (character == "-") return 45; if (character == ".") return 46; if (character == "/") return 47; if (character == "0") return 48; if (character == "1") return 49; if (character == "2") return 50; if (character == "3") return 51; if (character == "4") return 52; if (character == "5") return 53; if (character == "6") return 54; if (character == "7") return 55; if (character == "8") return 56;
                                    if (character == "9") return 57; if (character == ":") return 58; if (character == ";") return 59; if (character == "<") return 60; if (character == "=") return 61; if (character == ">") return 62; if (character == "?") return 63; if (character == "@") return 64; if (character == "A") return 65; if (character == "B") return 66; if (character == "C") return 67; if (character == "D") return 68; if (character == "E") return 69; if (character == "F") return 70; if (character == "G") return 71; if (character == "H") return 72; if (character == "I") return 73; if (character == "J") return 74;
                                    if (character == "K") return 75; if (character == "L") return 76; if (character == "M") return 77; if (character == "N") return 78; if (character == "O") return 79; if (character == "P") return 80; if (character == "Q") return 81; if (character == "R") return 82; if (character == "S") return 83; if (character == "T") return 84; if (character == "U") return 85; if (character == "V") return 86; if (character == "W") return 87; if (character == "X") return 88; if (character == "Y") return 89; if (character == "Z") return 90; if (character == "[") return 91; if (character == "\\") return 92;
                                    if (character == "]") return 93; if (character == "^") return 94; if (character == "_") return 95; if (character == "`") return 96; if (character == "a") return 97; if (character == "b") return 98; if (character == "c") return 99; if (character == "d") return 100; if (character == "e") return 101; if (character == "f") return 102; if (character == "g") return 103; if (character == "h") return 104; if (character == "i") return 105; if (character == "j") return 106; if (character == "k") return 107; if (character == "l") return 108; if (character == "m") return 109; if (character == "n") return 110;
                                    if (character == "o") return 111; if (character == "p") return 112; if (character == "q") return 113; if (character == "r") return 114; if (character == "s") return 115; if (character == "t") return 116; if (character == "u") return 117; if (character == "v") return 118; if (character == "w") return 119; if (character == "x") return 120; if (character == "y") return 121; if (character == "z") return 122; if (character == "{") return 123; if (character == "|") return 124; if (character == "}") return 125; if (character == "~") return 126; return character.charCodeAt(0)
                                }; var createSafeArray =
                                    function (size) { return {} }; var setArrayElement = function (array, index, value) { var i = protectionFunction(index); array[i] = value }; var getArrayElement = function (array, index) { var i = protectionFunction(index); return array[i] }; var hash = function (msg) {
                                    var K = createSafeArray(64); setArrayElement(K, 0, 1116352408); setArrayElement(K, 1, 1899447441); setArrayElement(K, 2, 3049323471); setArrayElement(K, 3, 3921009573); setArrayElement(K, 4, 961987163); setArrayElement(K, 5, 1508970993); setArrayElement(K, 6, 2453635748); setArrayElement(K,
                                        7, 2870763221); setArrayElement(K, 8, 3624381080); setArrayElement(K, 9, 310598401); setArrayElement(K, 10, 607225278); setArrayElement(K, 11, 1426881987); setArrayElement(K, 12, 1925078388); setArrayElement(K, 13, 2162078206); setArrayElement(K, 14, 2614888103); setArrayElement(K, 15, 3248222580); setArrayElement(K, 16, 3835390401); setArrayElement(K, 17, 4022224774); setArrayElement(K, 18, 264347078); setArrayElement(K, 19, 604807628); setArrayElement(K, 20, 770255983); setArrayElement(K, 21, 1249150122); setArrayElement(K, 22, 1555081692);
                                    setArrayElement(K, 23, 1996064986); setArrayElement(K, 24, 2554220882); setArrayElement(K, 25, 2821834349); setArrayElement(K, 26, 2952996808); setArrayElement(K, 27, 3210313671); setArrayElement(K, 28, 3336571891); setArrayElement(K, 29, 3584528711); setArrayElement(K, 30, 113926993); setArrayElement(K, 31, 338241895); setArrayElement(K, 32, 666307205); setArrayElement(K, 33, 773529912); setArrayElement(K, 34, 1294757372); setArrayElement(K, 35, 1396182291); setArrayElement(K, 36, 1695183700); setArrayElement(K, 37, 1986661051); setArrayElement(K,
                                        38, 2177026350); setArrayElement(K, 39, 2456956037); setArrayElement(K, 40, 2730485921); setArrayElement(K, 41, 2820302411); setArrayElement(K, 42, 3259730800); setArrayElement(K, 43, 3345764771); setArrayElement(K, 44, 3516065817); setArrayElement(K, 45, 3600352804); setArrayElement(K, 46, 4094571909); setArrayElement(K, 47, 275423344); setArrayElement(K, 48, 430227734); setArrayElement(K, 49, 506948616); setArrayElement(K, 50, 659060556); setArrayElement(K, 51, 883997877); setArrayElement(K, 52, 958139571); setArrayElement(K, 53, 1322822218);
                                    setArrayElement(K, 54, 1537002063); setArrayElement(K, 55, 1747873779); setArrayElement(K, 56, 1955562222); setArrayElement(K, 57, 2024104815); setArrayElement(K, 58, 2227730452); setArrayElement(K, 59, 2361852424); setArrayElement(K, 60, 2428436474); setArrayElement(K, 61, 2756734187); setArrayElement(K, 62, 3204031479); setArrayElement(K, 63, 3329325298); var H = createSafeArray(8); setArrayElement(H, 0, 1779033703); setArrayElement(H, 1, 3144134277); setArrayElement(H, 2, 1013904242); setArrayElement(H, 3, 2773480762); setArrayElement(H,
                                        4, 1359893119); setArrayElement(H, 5, 2600822924); setArrayElement(H, 6, 528734635); setArrayElement(H, 7, 1541459225); msg += String.fromCharCode(128); var l = msg.length / 4 + 2; var N = safeMathCeil(l / 16); var M = createSafeArray(N); for (var i = 0; i < N; i++) { setArrayElement(M, i, createSafeArray(16)); for (var j = 0; j < 16; j++) { var value = charCodeAt(msg, i * 64 + j * 4) << 24 | charCodeAt(msg, i * 64 + j * 4 + 1) << 16 | charCodeAt(msg, i * 64 + j * 4 + 2) << 8 | charCodeAt(msg, i * 64 + j * 4 + 3); setArrayElement(getArrayElement(M, i), j, value) } } setArrayElement(getArrayElement(M,
                                        N - 1), 14, (msg.length - 1) * 8 / Math.pow(2, 32)); setArrayElement(getArrayElement(M, N - 1), 14, Math.floor(getArrayElement(getArrayElement(M, N - 1), 14))); setArrayElement(getArrayElement(M, N - 1), 15, (msg.length - 1) * 8 & 4294967295); var W = createSafeArray(64); var a, b, c, d, e, f, g, h; for (var i = 0; i < N; i++) {
                                        for (var t = 0; t < 16; t++) { var wT = getArrayElement(getArrayElement(M, i), t); setArrayElement(W, t, wT) } for (var t = 16; t < 64; t++) {
                                            var wT = \u03c31(getArrayElement(W, t - 2)) + getArrayElement(W, t - 7) + \u03c30(getArrayElement(W, t - 15)) + getArrayElement(W,
                                                    t - 16) & 4294967295; setArrayElement(W, t, wT)
                                        } a = getArrayElement(H, 0); b = getArrayElement(H, 1); c = getArrayElement(H, 2); d = getArrayElement(H, 3); e = getArrayElement(H, 4); f = getArrayElement(H, 5); g = getArrayElement(H, 6); h = getArrayElement(H, 7); for (var t = 0; t < 64; t++) { var T1 = h + \u03a31(e) + Ch(e, f, g) + getArrayElement(K, t) + getArrayElement(W, t); var T2 = \u03a30(a) + Maj(a, b, c); h = g; g = f; f = e; e = d + T1 & 4294967295; d = c; c = b; b = a; a = T1 + T2 & 4294967295 } setArrayElement(H, 0, getArrayElement(H, 0) + a & 4294967295); setArrayElement(H, 1, getArrayElement(H,
                                                1) + b & 4294967295); setArrayElement(H, 2, getArrayElement(H, 2) + c & 4294967295); setArrayElement(H, 3, getArrayElement(H, 3) + d & 4294967295); setArrayElement(H, 4, getArrayElement(H, 4) + e & 4294967295); setArrayElement(H, 5, getArrayElement(H, 5) + f & 4294967295); setArrayElement(H, 6, getArrayElement(H, 6) + g & 4294967295); setArrayElement(H, 7, getArrayElement(H, 7) + h & 4294967295)
                                    } var hex = ""; hex += toHexStr(getArrayElement(H, 0)); hex += toHexStr(getArrayElement(H, 1)); hex += toHexStr(getArrayElement(H, 2)); hex += toHexStr(getArrayElement(H, 3));
                                    hex += toHexStr(getArrayElement(H, 4)); hex += toHexStr(getArrayElement(H, 5)); hex += toHexStr(getArrayElement(H, 6)); hex += toHexStr(getArrayElement(H, 7)); return hex
                                }; var keys = ["type", "unique_name", "variable_key", "variable_value", "url"]; var sign = ""; for (var i = 0; i < keys.length; i++) { var value = params[keys[i]]; if (typeof value != "undefined") sign += value } sign = protectionFunction(sign); sign = hash(sign); return sign
                            }; if (query) query += "&"; query += "sn=" + calc(params); return query
                        }, INTEGER_PREFIX: "[I;", STRING_PREFIX: "[LString;",
                        BOOLEAN_PREFIX: "[B;", convertFromGmProperty: function (value) {
                            if (typeof value == "undefined") return value; if (value == "" || value == null) return; try { if (value.indexOf(utils.INTEGER_PREFIX) == 0) return parseInt(value.substring(utils.INTEGER_PREFIX.length)); else if (value.indexOf(utils.BOOLEAN_PREFIX) == 0) return value.substring(utils.BOOLEAN_PREFIX.length) === "true"; else if (value.indexOf(utils.STRING_PREFIX) == 0) return value.substring(utils.STRING_PREFIX.length) } catch (ex) {
                                if (console && console.log) console.log("Cannot convert value from GM property: " +
                                    ex)
                            } return value
                        }, convertToGmProperty: function (value) { var isInteger = function (val) { return typeof val == "number" && val % 1 === 0 }; var isBoolean = function (val) { return typeof val == "boolean" }; try { if (isInteger(value)) return utils.INTEGER_PREFIX + value; else if (isBoolean(value)) return utils.BOOLEAN_PREFIX + value; else return utils.STRING_PREFIX + value } catch (ex) { if (console && console.log) console.log("Cannot convert value to GM property: " + ex); return value } }
                    }; var Base64 = {
                        _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
                        encode: function (input) { var output = ""; var chr1, chr2, chr3, enc1, enc2, enc3, enc4; var i = 0; input = Base64._utf8_encode(input); while (i < input.length) { chr1 = input.charCodeAt(i++); chr2 = input.charCodeAt(i++); chr3 = input.charCodeAt(i++); enc1 = chr1 >> 2; enc2 = (chr1 & 3) << 4 | chr2 >> 4; enc3 = (chr2 & 15) << 2 | chr3 >> 6; enc4 = chr3 & 63; if (isNaN(chr2)) enc3 = enc4 = 64; else if (isNaN(chr3)) enc4 = 64; output = output + Base64._keyStr.charAt(enc1) + Base64._keyStr.charAt(enc2) + Base64._keyStr.charAt(enc3) + Base64._keyStr.charAt(enc4) } return output }, decode: function (input) {
                            var output =
                                ""; var chr1, chr2, chr3; var enc1, enc2, enc3, enc4; var i = 0; input = input.replace(/[^A-Za-z0-9\+\/\=]/g, ""); while (i < input.length) { enc1 = Base64._keyStr.indexOf(input.charAt(i++)); enc2 = Base64._keyStr.indexOf(input.charAt(i++)); enc3 = Base64._keyStr.indexOf(input.charAt(i++)); enc4 = Base64._keyStr.indexOf(input.charAt(i++)); chr1 = enc1 << 2 | enc2 >> 4; chr2 = (enc2 & 15) << 4 | enc3 >> 2; chr3 = (enc3 & 3) << 6 | enc4; output = output + String.fromCharCode(chr1); if (enc3 != 64) output = output + String.fromCharCode(chr2); if (enc4 != 64) output = output + String.fromCharCode(chr3) } output =
                                Base64._utf8_decode(output); return output
                        }, _utf8_encode: function (string) { string = string.replace(/\r\n/g, "\n"); var utftext = ""; for (var n = 0; n < string.length; n++) { var c = string.charCodeAt(n); if (c < 128) utftext += String.fromCharCode(c); else if (c > 127 && c < 2048) { utftext += String.fromCharCode(c >> 6 | 192); utftext += String.fromCharCode(c & 63 | 128) } else { utftext += String.fromCharCode(c >> 12 | 224); utftext += String.fromCharCode(c >> 6 & 63 | 128); utftext += String.fromCharCode(c & 63 | 128) } } return utftext }, _utf8_decode: function (utftext) {
                            var string =
                                ""; var i = 0; var c = 0; var c1 = 0; var c2 = 0; var c3 = 0; while (i < utftext.length) { c = utftext.charCodeAt(i); if (c < 128) { string += String.fromCharCode(c); i++ } else if (c > 191 && c < 224) { c2 = utftext.charCodeAt(i + 1); string += String.fromCharCode((c & 31) << 6 | c2 & 63); i += 2 } else { c2 = utftext.charCodeAt(i + 1); c3 = utftext.charCodeAt(i + 2); string += String.fromCharCode((c & 15) << 12 | (c2 & 63) << 6 | c3 & 63); i += 3 } } return string
                        }
                    }; var exportFunction = function (func, context) { return function () { return func.apply(context, arguments) } }; var fns = ["indexOf", "lastIndexOf",
                        "filter", "forEach", "every", "map", "some", "slice"]; fns.forEach(function (funcName) { if (typeof Array[funcName] !== "function") { var obj = {}; obj[funcName] = { value: function (arraylikeObj) { return Array.prototype[funcName].apply(arraylikeObj, Array.prototype.slice.call(arguments, 1)) }, enumerable: false, writable: true, configurable: true }; Object.defineProperties(Array, obj) } }); __GM_api.GM_info = {
                        script: { name: AdguardSettings.uniqueName, version: AdguardSettings.version }, scriptMetaStr: "", scriptWillUpdate: true, version: "0.9.16",
                        uuid: "uuid"
                    }; var GM_valuesCache = Object.create(null); __GM_api.GM_setValue = function (name, value) { if (typeof value == "undefined") { GM_log("Trying to set " + name + " property to undefined"); return } var gmValue = utils.convertToGmProperty(value); var params = { "type": "gm-set-value", "unique_name": AdguardSettings.uniqueName, "variable_key": name, "variable_value": gmValue }; var currentValue = GM_valuesCache[name]; if (typeof currentValue != "undefined" && currentValue == gmValue) return; GM_valuesCache[name] = gmValue; utils.sendPostRequest(params) };
                    __GM_api.GM_getValue = function (name, defaultValue) { var params = { "type": "gm-get-value", "unique_name": AdguardSettings.uniqueName, "variable_key": name }; var gmValue = GM_valuesCache[name]; if (typeof gmValue == "undefined") { var gmValue = utils.sendGetRequest(params); GM_valuesCache[name] = gmValue } var resultValue = utils.convertFromGmProperty(gmValue); if (typeof resultValue == "undefined") return defaultValue; return resultValue }; __GM_api.GM_deleteValue = function (name) {
                        var params = {
                            "type": "gm-delete-value", "unique_name": AdguardSettings.uniqueName,
                            "variable_key": name
                        }; delete GM_valuesCache[name]; utils.sendPostRequest(params)
                    }; __GM_api.GM_listValues = function () { var params = { "type": "gm-list-values", "unique_name": AdguardSettings.uniqueName }; var result = utils.sendGetRequest(params); try { return JSON.parse(result) } catch (ex) { GM_log(ex); return [] } }; __GM_api.GM_getResourceText = function (resourceName) { return Base64.decode(GM_getResourceURL(resourceName)) }; __GM_api.GM_getResourceURL = function (resourceName) {
                        var result = GM_Resources[resourceName]; if (typeof result ===
                            "undefined") throw "Resource " + resourceName + " not found"; return result
                    }; __GM_api.GM_xmlhttpRequest = function (details) {
                        details.url = details.url ? details.url : ""; details.data = details.data ? details.data : ""; details.headers = details.headers ? details.headers : ""; details.overrideMimeType = details.overrideMimeType ? details.overrideMimeType : ""; details.method = details.method ? details.method : ""; details.user = details.user ? details.user : ""; details.password = details.password ? details.password : ""; var encodeHeaders = function (headers) {
                            if (typeof headers ==
                                "object") { var result = ""; for (header in headers) result += encodeURIComponent(header) + ":" + encodeURIComponent(headers[header]) + ","; return result.slice(0, -1) } if (typeof headers == "string") return encodeURIComponent(headers); return null
                        }; var url = utils.getHostWithProtocol(); var method = details.method ? details.method : "GET"; var params = {
                            "type": "gm-xml-http-request", "unique_name": AdguardSettings.uniqueName, "url": details.url, "data": details.data, "headers": encodeHeaders(details.headers), "method": details.method, "overridemimetype": details.overrideMimeType,
                            "user": details.user, "password": details.password
                        }; var data = utils.buildParameters(params, { "headers": true }); if (method == "GET") { url += settings.apiurl; url += "?"; url += data } else url += settings.apiurl; var async = details.synchronous ? !details.synchronous : true; var xmlhttp = new XMLHttpRequest; xmlhttp.open(method, url, async); xmlhttp.onreadystatechange = function () {
                            var responseState = {
                                responseXML: "", responseText: xmlhttp.readyState == 4 ? xmlhttp.responseText : "", readyState: xmlhttp.readyState, responseHeaders: xmlhttp.readyState ==
                                4 ? xmlhttp.getAllResponseHeaders() : "", status: xmlhttp.readyState == 4 ? xmlhttp.status : 0, statusText: xmlhttp.readyState == 4 ? xmlhttp.statusText : "", finalUrl: xmlhttp.readyState == 4 ? xmlhttp.finalUrl : ""
                            }; if (details["onreadystatechange"]) details["onreadystatechange"](responseState); if (xmlhttp.readyState == 4) { if (details["onload"] && xmlhttp.status >= 200 && xmlhttp.status < 300) details["onload"](responseState); if (details["onerror"] && (xmlhttp.status < 200 || xmlhttp.status >= 300)) details["onerror"](responseState) }
                        }; if (async) {
                            xmlhttp.timeout =
                                details.timeout ? details.timeout : 15E3; xmlhttp.ontimeout = function () { if (details.ontimeout) details.ontimeout(xmlhttp) }; if (method == "GET") xmlhttp.send(); else xmlhttp.send(data); return xmlhttp
                        } else { if (method == "GET") xmlhttp.send(); else xmlhttp.send(data); return xmlhttp.responseText }
                    }; __GM_api.GM_registerMenuCommand = function (caption, commandFunc, accessKey) {
                        if (!__adg_gm_commands_api) return; if (!caption || !commandFunc) { GM_log("Caption or commandFunc should be set to register menu command"); return } var command = {
                            "caption": caption,
                            "commandFunc": commandFunc
                        }; __adg_gm_commands_api.commands.push(command); var event = document.createEvent("Events"); event.initEvent("__adg_gm_command_registered", true, true); event.data = {}; document.dispatchEvent(event)
                    }; __GM_api.GM_addStyle = function (css) {
                        var style = document.createElement("style"); style.setAttribute("nonce", AdguardSettings.nonce); style.type = "text/css"; if (style.styleSheet) style.styleSheet.cssText = css; else style.appendChild(document.createTextNode(css)); var head = document.getElementsByTagName("head");
                        if (head && head.length > 0 && head[0]) head[0].appendChild(style)
                    }; __GM_api.GM_setClipboard = function (text) { window.prompt("Copy to clipboard: Ctrl+C, Enter", text) }; __GM_api.GM_openInTab = function (url) { return window.open(url, "_blank") }; __GM_api.GM_log = function (message) { if (window.console && window.console.log) window.console.log(message) }; __GM_api.ADG_addRule = function (rule) { var params = { "type": "add", "rule": rule }; utils.sendGetRequest(params) }; __GM_api.ADG_removeRule = function (rule) {
                        var params = { "type": "remove", "rule": rule };
                        utils.sendGetRequest(params)
                    }; __GM_api.ADG_temporaryDontBlock = function (timeout) { if (!timeout) timeout = 30; var domainName = document.location.hostname; var parameter = "@@||" + domainName + "$document"; var params = { "type": "notblock", "timeout": timeout, "rule": parameter }; utils.sendGetRequest(params) }; __GM_api.ADG_sendComplaint = function (url, comment, complaintType) {
                        var details = {}; details.url = AdguardSettings.feedbackUrl + settings.feedbackUrl; details.method = "POST"; details.data = "applicationId=" + encodeURIComponent(AdguardSettings.applicationId) +
                            "&messageType=" + encodeURIComponent(complaintType) + "&url=" + encodeURIComponent(url) + "&comment=" + encodeURIComponent(comment); details.headers = "Content-Type: application/x-www-form-urlencoded"; GM_xmlhttpRequest(details)
                    }; __GM_api.ADG_sendAbuse = function (url) { var params = { "type": "send-abuse", "url": url }; utils.sendGetRequest(params) }
                })(); var GM_info = __GM_api.GM_info; var GM_setValue = __GM_api.GM_setValue.bind(__GM_api); var GM_getValue = __GM_api.GM_getValue.bind(__GM_api); var GM_deleteValue = __GM_api.GM_deleteValue.bind(__GM_api);
                var GM_listValues = __GM_api.GM_listValues.bind(__GM_api); var GM_getResourceText = __GM_api.GM_getResourceText.bind(__GM_api); var GM_openInTab = __GM_api.GM_openInTab.bind(__GM_api); var GM_getResourceURL = __GM_api.GM_getResourceURL.bind(__GM_api); var GM_xmlhttpRequest = __GM_api.GM_xmlhttpRequest.bind(__GM_api); var GM_registerMenuCommand = __GM_api.GM_registerMenuCommand.bind(__GM_api); var GM_addStyle = __GM_api.GM_addStyle.bind(__GM_api); var GM_setClipboard = __GM_api.GM_setClipboard.bind(__GM_api);
                var GM_log = __GM_api.GM_log.bind(__GM_api); var ADG_addRule = __GM_api.ADG_addRule.bind(__GM_api); var ADG_removeRule = __GM_api.ADG_removeRule.bind(__GM_api); var ADG_temporaryDontBlock = __GM_api.ADG_temporaryDontBlock.bind(__GM_api); var ADG_sendComplaint = __GM_api.ADG_sendComplaint.bind(__GM_api); var ADG_sendAbuse = __GM_api.ADG_sendAbuse.bind(__GM_api); var unsafeWindow = window;
                /*Injecting list of Requires joined by "\r\n"*/
                /*Injecting Content*/  // ==UserScript==
// @name	Adguard Assistant
// @name:ru	Помощник Adguard
// @name:uk Помічник Adguard
// @name:de	Adguard-Assistent
// @name:sr	Koristi Adguard-ovog pomoćnika
// @name:pl	Asystent Adguarda
// @name:zh	使用 Adguard 助手
// @name:it	Assistente Adguard
// @name:es	Asistente de Adguard
// @name:id	Asisten Aguard
// @namespace	Adguard
// @adg:permanent	true
// @description	Provides easy and convenient way to manage filtering right from the browser
// @description:ru Позволяет легко и быстро управлять фильтрацией прямо из браузера
// @description:uk Забезпечує легкий та зручний спосіб управління фільтрацією прямо з браузеру
// @description:de  Bietet einen einfachen und bequemen Weg, um Filter direkt aus dem Browser zu verwalten
// @description:tr Tarayıcı içinden kolay ve uygun biçimde filtrelemeyi yönetmenizi sağlar.
// @description:ko 브라우저에서 바로 필터링 할 수 있는 쉽고 편리한 방법을 제공 합니다.
// @description:sr	Pruža lak i zgodan način za upravljanje filtriranjem direktno iz pregledača.
// @description:pl	Zapewnia łatwy i dogodny sposób na zarządzaniem filtrowaniem bezpośrednio z przeglądarek
// @description:zh	提供简单方便的方法来管理浏览器筛选
// @description:zh-TW	提供簡單方便的方法來管理瀏覽器過濾
// @description:sk	Poskytuje pohodlný spôsob na manažment filtrov priamo z prehliadača
// @description:fr	Fournit un moyen facile et pratique de gérer le filtrage à partir du navigateur
// @description:it	Fornisce un modo facile e comodo per gestire il filtraggio direttamente dal browser
// @description:vi	Cung cấp cách dễ dàng và thuận tiện để quản lý lọc ngay trong trình duyệt
// @description:es	Permite fácilmente gestionar los filtros desde el navegador
// @description:id	Menyediakan cara mudah dan nyaman untuk mengelola penyaringan langsung dari peramban
// @description:hu	Könnyű és kényelmes módot nyújt egyenesen a böngészőből történő szűrések kezeléséhez
// @version	3.0.116
// @downloadURL	https://cdn.adguard.com/public/Userscripts/AdguardAssistant/3.0/assistant.user.js
// @updateURL	https://cdn.adguard.com/public/Userscripts/AdguardAssistant/3.0/assistant.meta.js
// @exclude	*://mil.ru/*
// @exclude	*://feedly.com/*
// @exclude	*wikipedia.org*
// @exclude	*icloud.com*
// @exclude *hangouts.google.com*
// @exclude *www.facebook.com/plugins/сomments*
// @exclude *disqus.com/embed/comments*
// @exclude *vk.com/widget_comments*
// @exclude *www.youtube.com/embed/*
// @exclude *://outlook.live.com*
// @grant	GM_getValue
// @grant	GM_setValue
// @grant	property:settings
// ==/UserScript==
                var GM_Resources = {
                    'jquery.js':
                        '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',
                    'jquery-ui.js':
                        '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',
                    'templates.html':
                        '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',
                    'button.css':
                        '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',
                    'selector.css':
                        '77u/LnNnX3NlbGVjdGVkIHsNCn0NCg0KLnNnX3N1Z2dlc3RlZCB7DQogICAgYmFja2dyb3VuZC1jb2xvcjogI0ZGNSAhaW1wb3J0YW50Ow0KICAgIGJhY2tncm91bmQtaW1hZ2U6IG5vbmUgIWltcG9ydGFudDsNCn0NCg0KLnNnX2JvcmRlciB7DQogICAgcG9zaXRpb246IGFic29sdXRlICFpbXBvcnRhbnQ7DQogICAgei1pbmRleDogMjE0NzQ4MzY0NiAhaW1wb3J0YW50Ow0KICAgIGJhY2tncm91bmQ6IHdoaXRlICFpbXBvcnRhbnQ7DQogICAgYmFja2dyb3VuZC1jb2xvcjogIzEzYTM1ZSAhaW1wb3J0YW50Ow0KICAgIG1hcmdpbjogMHB4ICFpbXBvcnRhbnQ7DQogICAgcGFkZGluZzogMHB4ICFpbXBvcnRhbnQ7DQogICAgZGlzcGxheTogYmxvY2s7DQogICAgZmxvYXQ6IG5vbmUgIWltcG9ydGFudDsNCiAgICBib3JkZXI6IDAgIWltcG9ydGFudDsNCiAgICBmb250LXN0eWxlOiBub3JtYWwgIWltcG9ydGFudDsNCiAgICBvdXRsaW5lOiAwICFpbXBvcnRhbnQ7DQogICAgdmVydGljYWwtYWxpZ246IGJhc2VsaW5lICFpbXBvcnRhbnQ7DQogICAgdGV4dC1hbGlnbjogbGVmdCAhaW1wb3J0YW50Ow0KICAgIGxpbmUtaGVpZ2h0OiAxMnB4ICFpbXBvcnRhbnQ7DQoJYm94LXNpemluZzogY29udGVudC1ib3ggIWltcG9ydGFudDsNCn0NCg0KLnNnX2JvdHRvbV9ib3JkZXIgew0KICAgIGZvbnQtc2l6ZTogMTBweCAhaW1wb3J0YW50Ow0KICAgIGZvbnQtd2VpZ2h0OiBib2xkOw0KICAgIGNvbG9yOiB3aGl0ZSAhaW1wb3J0YW50Ow0KICAgIHBhZGRpbmc6IDJweCAwcHggMnB4IDVweCAhaW1wb3J0YW50Ow0KICAgIG92ZXJmbG93OiBoaWRkZW4gIWltcG9ydGFudDsNCn0NCg0KLnNnX2JvcmRlcl9yZWQgew0KICAgIGJhY2tncm91bmQtY29sb3I6ICNGMDAgIWltcG9ydGFudDsNCn0NCg0KLnNnX2hpZ2hsaWdodGVkIHsNCn0NCg0KLnNnX3JlamVjdGVkIHsNCiAgICBiYWNrZ3JvdW5kLWNvbG9yOiAjRkE4MDcyICFpbXBvcnRhbnQ7DQogICAgYmFja2dyb3VuZC1pbWFnZTogbm9uZSAhaW1wb3J0YW50Ow0KfQ0KDQppbWcuc2dfcmVqZWN0ZWQgew0KICAgIGJvcmRlcjogNXB4IHNvbGlkICNGMDAgIWltcG9ydGFudDsNCn0NCg0KaW1nLnNnX3N1Z2dlc3RlZCB7DQogICAgYm9yZGVyOiA1cHggc29saWQgI0ZGNSAhaW1wb3J0YW50Ow0KfQ0KDQppbWcuc2dfc2VsZWN0ZWQgew0KICAgIGJvcmRlcjogNXB4IHNvbGlkICMwRjAgIWltcG9ydGFudDsNCn0NCg0KI19zZ19kaXYuc2dfdG9wIHsNCiAgICB0b3A6IDVweCAhaW1wb3J0YW50Ow0KfQ0KDQojX3NnX2Rpdi5zZ19ib3R0b20gew0KICAgIGJvdHRvbTogNXB4ICFpbXBvcnRhbnQ7DQp9DQoNCiNfc2dfZGl2IGlucHV0IHsNCiAgICBtYXJnaW4tcmlnaHQ6IDEwcHggIWltcG9ydGFudDsNCiAgICBmb250LXNpemU6IDE1cHggIWltcG9ydGFudDsNCn0NCg0KI19zZ19wYXRoX2ZpZWxkIHsNCiAgICB3aWR0aDogNDAwcHggIWltcG9ydGFudDsNCn0NCg0KI19zZ19kaXYgLnNnX25ld19saW5lIHsNCiAgICBjbGVhcjogYm90aCAhaW1wb3J0YW50Ow0KfQ0KDQojX3NnX2RpdiAuc2dfb3B0aW9uIHsNCiAgICBmbG9hdDogbGVmdCAhaW1wb3J0YW50Ow0KfQ0KDQojX3NnX2RpdiAuc2dfc2VsZWN0ZWRfb3B0aW9uIHsNCiAgICB0ZXh0LWRlY29yYXRpb246IHVuZGVybGluZTsNCn0NCg==',
                    'jquery-ui.css':
                        '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',
                    'dialog.css':
                        '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'};


                (function() {
                    var UserscriptsSupport=function(){var showGmMenu=function(){var localization={"ru":{"title":"\u041c\u0435\u043d\u044e \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0439","closeButton":"\u0417\u0430\u043a\u0440\u044b\u0442\u044c"},"en":{"title":"Userscripts Menu","closeButton":"Close"},getString:function(name){var strings=localization[AdguardSettings.locale]||localization.en;return strings[name]}};var changeText=function(element,text){if(typeof element.textContent!="undefined")element.textContent=
                        text;else element.innerText=text};var removeElementById=function(id){var el=document.getElementById(id);if(el&&el.parentNode)el.parentNode.removeChild(el)};var onCloseButtonClicked=function(){removeElementById("adg_gm_dialog_container");removeElementById("adg_gm_overlay");removeElementById("adg_gm_menu_style")};var addMenuStyle=function(){var styleEl=document.getElementById("adg_gm_menu_style");if(styleEl){GM_log("Userscripts menu style has been already added");return}var menuStyle="body .adg_gm_fixed_container{background-color:transparent!important;position:fixed!important;z-index:2147483645!important;width:100%!important;height:100%!important;top:0!important;left:0!important;display:block!important;visibility:visible!important;font:400 16px Arial!important;color:#333!important;padding:0!important;margin:0!important;border-radius:0!important}body .adg_gm_fixed_container.adg_gm_overlay{background-color:#000!important;opacity:.6!important;padding:0!important;margin:0!important}body .adg_gm_fixed_container .adg_gm_dialog{width:400px!important;background-color:#fff!important;opacity:1!important;border:1px solid #000!important;margin:30px auto!important;padding:0!important;border-radius:0!important}body .adg_gm_fixed_container .adg_gm_dialog .adg_gm_dialog_header{min-height:20px!important;border-bottom:1px solid #e5e5e5!important;padding:15px!important;margin:0!important;width:auto!important;height:auto!important;border-radius:0!important;background-color:transparent!important}body .adg_gm_fixed_container .adg_gm_dialog .adg_gm_dialog_header h4{font:700 22px Arial!important;font-size:22px!important;text-align:center!important;padding:5px 30px!important;margin:0!important;width:auto!important;height:auto!important}body .adg_gm_fixed_container .adg_gm_dialog .adg_gm_dialog_footer{background-color:#FAFAFA!important;border-top:1px solid #e5e5e5;text-align:right!important;padding:20px 30px!important;margin:0!important;width:auto!important;height:auto!important;border-radius:0!important}body .adg_gm_fixed_container .adg_gm_button{display:inline-block!important;background:#58595b!important;font:400 16px Arial!important;font-family:Arial!important;text-align:center!important;color:#fff!important;text-decoration:none!important;cursor:pointer;padding:10px 20px!important;margin:0!important;width:auto!important;height:auto!important}body .adg_gm_fixed_container .adg_gm_button:hover{background:#6E6F71!important}body .adg_gm_fixed_container .adg_gm_dialog .adg_gm_dialog_content{border-radius:0!important;width:auto!important;height:auto!important;background-color:transparent!important;margin:0!important;padding:0!important}body .adg_gm_fixed_container .adg_gm_dialog .adg_gm_dialog_content .adg_gm_command{border-bottom:1px solid #e6e6e6!important;cursor:pointer;font:400 16px Arial!important;font-size:16px;padding:20px 30px;margin:0!important;width:auto!important;height:auto!important;border-radius:0!important}body .adg_gm_fixed_container .adg_gm_dialog .adg_gm_dialog_content .adg_gm_command:hover{background-color:#defae5}body .adg_gm_fixed_container .adg_gm_dialog .adg_gm_dialog_content .adg_gm_command:last-child{border-bottom:0 solid #e6e6e6!important}";
                        styleEl=document.createElement("style");styleEl.id="adg_gm_menu_style";styleEl.setAttribute("type","text/css");styleEl.innerHTML=menuStyle;document.body.appendChild(styleEl)};var addMenuOverlay=function(){var overlayEl=document.getElementById("adg_gm_overlay");if(overlayEl){GM_log("Overlay is already created");return}overlayEl=document.createElement("div");overlayEl.className="adg_gm_fixed_container adg_gm_overlay";overlayEl.id="adg_gm_overlay";document.body.appendChild(overlayEl)};var createCommandElement=
                        function(command){var commandEl=document.createElement("div");commandEl.className="adg_gm_command";changeText(commandEl,command.caption);commandEl.onclick=function(){try{onCloseButtonClicked();command.commandFunc()}catch(ex){GM_log("Cannot execute command: "+ex)}};return commandEl};var createDialogContent=function(commands){var contentElement=document.createElement("div");contentElement.className="adg_gm_dialog_content";for(var i=0;i<commands.length;i++){var commandEl=createCommandElement(commands[i]);
                        contentElement.appendChild(commandEl)}return contentElement};var createDialog=function(){var dialogContainer=document.createElement("div");dialogContainer.id="adg_gm_dialog_container";dialogContainer.className="adg_gm_fixed_container";var dialog=document.createElement("div");dialog.className="adg_gm_dialog";dialogContainer.appendChild(dialog);var dialogHeader=document.createElement("div");dialogHeader.className="adg_gm_dialog_header";var title=document.createElement("h4");changeText(title,localization.getString("title"));
                        dialogHeader.appendChild(title);dialog.appendChild(dialogHeader);var dialogContent=createDialogContent(__adg_gm_commands_api.commands);dialog.appendChild(dialogContent);var dialogFooter=document.createElement("div");dialogFooter.className="adg_gm_dialog_footer";dialog.appendChild(dialogFooter);var closeButton=document.createElement("a");closeButton.className="adg_gm_button";closeButton.id="adg_gm_menu_close_button";closeButton.onclick=onCloseButtonClicked;changeText(closeButton,localization.getString("closeButton"));
                        dialogFooter.appendChild(closeButton);return dialogContainer};var addMenu=function(){var dialogEl=document.getElementById("adg_gm_dialog_container");if(dialogEl){GM_log("Menu is already created");return}dialogEl=createDialog();document.body.appendChild(dialogEl)};if(!__adg_gm_commands_api||!__adg_gm_commands_api.commands){GM_log("No GM commands registered, cannot show menu");return}addMenuStyle();addMenuOverlay();addMenu()};this.showMenuCommandRegistered=false;var isGmCommandsRegistered=function(){return typeof __adg_gm_commands_api!=
                        "undefined"&&(__adg_gm_commands_api!==null&&(typeof __adg_gm_commands_api.commands!="undefined"&&(__adg_gm_commands_api.commands!==null&&__adg_gm_commands_api.commands.length>0)))};var handleMenuCommandsChange=function(){if(this.showMenuCommandRegistered)return;if(isGmCommandsRegistered())document.addEventListener("keydown",function(e){var evt=window.event?window.event:e;if(evt.keyCode==77&&(evt.shiftKey&&evt.altKey))showGmMenu()});this.showMenuCommandRegistered=true};this.init=function(){handleMenuCommandsChange();
                        document.addEventListener("__adg_gm_command_registered",function(){handleMenuCommandsChange()})}};
                    var AdguardBrowser=function(){var searchString=function(data){for(var i=0;i<data.length;i++){var dataString=data[i].string;var dataProp=data[i].prop;this.versionSearchString=data[i].versionSearch||data[i].identity;if(dataString){if(dataString.indexOf(data[i].subString)!=-1)return data[i].identity}else if(dataProp)return data[i].identity}};var searchVersion=function(dataString){var index=dataString.indexOf(this.versionSearchString);if(index==-1)return;return parseFloat(dataString.substring(index+this.versionSearchString.length+
                        1))};var dataBrowser=[{string:navigator.userAgent,subString:"Chrome",identity:"Chrome"},{string:navigator.userAgent,subString:"OmniWeb",versionSearch:"OmniWeb/",identity:"OmniWeb"},{string:navigator.vendor,subString:"Apple",identity:"Safari",versionSearch:"Version"},{prop:window.opera,identity:"Opera",versionSearch:"Version"},{string:navigator.vendor,subString:"iCab",identity:"iCab"},{string:navigator.vendor,subString:"KDE",identity:"Konqueror"},{string:navigator.userAgent,subString:"Firefox",identity:"Firefox"},
                        {string:navigator.vendor,subString:"Camino",identity:"Camino"},{string:navigator.userAgent,subString:"Netscape",identity:"Netscape"},{string:navigator.userAgent,subString:"MSIE",identity:"Explorer",versionSearch:"MSIE"},{string:navigator.userAgent,subString:"Gecko",identity:"Mozilla",versionSearch:"rv"},{string:navigator.userAgent,subString:"Mozilla",identity:"Netscape",versionSearch:"Mozilla"}];var dataOS=[{string:navigator.platform,subString:"Win",identity:"Windows"},{string:navigator.platform,
                        subString:"Mac",identity:"Mac"},{string:navigator.userAgent,subString:"iPhone",identity:"iPhone/iPod"},{string:navigator.platform,subString:"Linux",identity:"Linux"}];this.name=searchString(dataBrowser)||"An unknown browser";this.version=parseInt(searchVersion(navigator.userAgent)||(searchVersion(navigator.appVersion)||0));this.OS=searchString(dataOS)||"an unknown OS";this.isIE=this.name=="Explorer";this.isIETenCompatible=this.isIE&&(this.version>=10&&!document.doctype);this.isPositionFixedSupported=
                        function(){if(!this.isIE)return true;if(this.isIE&&this.version>8)return true;if(this.isIETenCompatible)return false;var container=document.body;if(document.createElement&&(container&&(container.appendChild&&container.removeChild))){var el=document.createElement("div");if(!el.getBoundingClientRect)return null;el.innerHTML="x";el.style.cssText="position:fixed;top:100px;";container.appendChild(el);var originalHeight=container.style.height,originalScrollTop=container.scrollTop;container.style.height=
                            "3000px";container.scrollTop=500;var elementTop=el.getBoundingClientRect().top;container.style.height=originalHeight;var isSupported=elementTop===100;container.removeChild(el);container.scrollTop=originalScrollTop;return isSupported}return null};this.isCompatibilityMode=function(){if(!this.isIE)return false;var engine=5;if(document.documentMode)engine=document.documentMode;else if(document.compatMode)if(document.compatMode=="CSS1Compat")engine=7;return engine<=7},function(){return!this.isCompatibilityMode()}};
                    var AdguardButton=function(options){var browser=new AdguardBrowser;var self=this;var constants={wotAlertIgnore:"alertIgnore"};var validatePage=function(){if(window!=top)return false;return document.getElementsByTagName("head").length&&document.getElementsByTagName("body").length};var validateBrowser=function(){if(browser.isPositionFixedSupported())return true;return browser.isIE&&browser.version>=7};var preventDefault=function(e,selection){if(!e)e=window.event;if(e.preventDefault)e.preventDefault();
                        if(selection&&document.selection)document.selection.empty()};var stopPropagation=function(e){if(!e)e=window.event;if(e.stopPropagation)e.stopPropagation();else e.cancelBubble=true};var bind=function(element,event,func){if(document.addEventListener)element.addEventListener(event,func,false);else if(element.attachEvent)element.attachEvent("on"+event,func,false)};var addedStyles={};var loadStyle=function(name){if(addedStyles[name])return;GM_addStyle(GM_getResourceText(name));addedStyles[name]=true};
                        var isString=function(str){return typeof str=="string"};var trim=function(str){if(!str||!isString(str))return str;return str.replace(/^\s\s*/,"").replace(/\s\s*$/,"")};var addClass=function(element,className){if(!className||!isString(className))return;var classNames=className.split(" ");var setClass=" "+element.className+" ";for(var i=0;i<classNames.length;i++)if(!~setClass.indexOf(" "+classNames[i]+" "))setClass+=classNames[i]+" ";element.className=trim(setClass)};var jsMorph=function(obj,prop,params,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ease,onMorphInit,onMorph,onMorphEnd){var IE=!document.getElementsByClassName,getInitProp=function(obj,prop,duration,speed,onMorphInit,jsMorph){var initProp={},dims,cS,fS,objStyle=obj.style,font,tmpStyle,moz,maxVal=0,help,outside,pad=[],opacity,color,getDim=function(obj){return[obj.offsetWidth,obj.offsetHeight,obj.offsetLeft,obj.offsetTop]},getStyle=function(){if(document.body.currentStyle)return function(obj,prop){return obj.currentStyle[prop.replace(/\-(\w)/g,function(){return arguments[1].toUpperCase()})]};
                        else return function(obj,prop){return document.defaultView.getComputedStyle(obj,null).getPropertyValue(prop)}}(),units=function(obj){var units={},oD,objStyle=obj.style,sniff=document.createElement("div"),sniffStyle=sniff.style;sniffStyle.cssText="position:absolute;left:0;top:-10ex;width:10em;height:72pt;";obj.appendChild(sniff);oD=getDim(sniff).concat(getDim(obj));units={em:oD[0]/10,pt:oD[1]/72,pc:oD[1]/6,"in":oD[1],cm:oD[1]/2.54,mm:oD[1]/25.4,ex:Math.abs(oD[3])/10,"%font":oD[0]/1E3,"%line":oD[0]/
                        1E3};sniffStyle.cssText+=";font-size:"+prop["font-size"]+(prop["font-family"]?";font-family:"+prop["font-family"]:"")+";";oD=getDim(sniff);obj.removeChild(sniff);units["exn"]=Math.abs(oD[3]/10);tmpStyle=objStyle.cssText;objStyle.cssText+=";position:absolute;left:0%;top:0%;";oD=getDim(obj);objStyle.cssText+=";left:-100%;top:-100%;";oD=oD.concat(getDim(obj));objStyle.cssText=tmpStyle;units["%outX"]=(oD[2]-oD[6])/100;units["%outY"]=(oD[3]-oD[7])/100;return units},unit2px=function(xS,n,dims){if(xS[2]!=
                            "px"&&xS[2]!="")if(xS[2]!="%")xS[1]*=dims[xS[2]];else if(!n.match(/^(font)/))xS[1]*=n.match(/width|left|right|padding|margin|text-ind/)?dims["%outX"]:dims["%outY"];else xS[1]*=dims["%"+n.split("-")[0]]},convertColor=function(color){var cS=color.split("#");if(cS[1]){cS=cS[1].split("");cS=cS.length<6?(cS[0]+cS[0]+cS[1]+cS[1]+cS[2]+cS[2]).split(""):cS;return[parseInt(cS[0]+cS[1],16),parseInt(cS[2]+cS[3],16),parseInt(cS[4]+cS[5],16)]}else return/rgb\((.*)\)/.exec(cS[0])[1].replace(/\s*/g,"").split(",")};
                            obj.initStyle=obj.style.cssText;if(prop["font-size"])font=/([\-0-9\.]+)([a-z%]+)(!*)/.exec(prop["font-size"]);for(var n in prop){opacity=n.match(/opacity/);color=n.match(/color/);if(!(n.replace(/\-(\w)/g,function(){return arguments[1].toUpperCase()})in objStyle)&&!opacity){delete prop[n];continue}fS=/([\-0-9\.]+)([a-z%]*)(\s*~*)/.exec(prop[n])||[];prop[n]=prop[n].toString().replace("~","");if(IE&&opacity){cS=/\opacity=([0-9]+)\)/.exec(getStyle(obj,"filter"));cS=["",cS==null?100:cS[1],""];fS=["",fS[1]*=
                                100,""];prop[n]=fS[1]+")"}else if(color){cS=convertColor(getStyle(obj,n=="border-color"?"border-left-color":n));fS=convertColor(prop[n])}else cS=/([\-0-9\.]+)(\D*)/.exec(getStyle(obj,n.match(/^(padding|margin)$/)?n+"-left":n.match(/^(border-width)$/)?"border-left-width":n.match(/(border-radius)$/)?(moz=(n.match(/^(\-\w+\-)/)||["",""])[1])+"border-"+(moz=="-moz-"?"radius-topleft":"top-left-radius"):n))||["0px",0,"px"];if(!cS[1]&&n.match(/^(height|width)/)){objStyle.zoom=1;pad[0]=/([\-0-9\.]+)([a-z%]*)/.exec(getStyle(obj,
                                "padding-"+(n=="width"?"left":"top")));pad[1]=/([\-0-9\.]+)([a-z%]*)/.exec(getStyle(obj,"padding-"+(n=="width"?"right":"bottom")));if(pad[0]&&pad[0][2]!="px"||pad[1]&&pad[1][2]!="px"){unit2px(pad[0],"padding",dims||(dims=units(obj)));unit2px(pad[1],"padding",dims)}cS=["",(n=="width"?obj.clientWidth:obj.clientHeight)-pad[0][n=="width"?0:1]-pad[1][n=="width"?0:1],"px"]}if(fS[3]&&!color){if(fS[2]&&fS[2]!="px"){dims=dims||units(obj);fS[1]=+fS[1]+ +cS[1]/dims[fS[2]]}else fS[1]=+fS[1]+ +cS[1];prop[n]=fS[1]+
                                fS[2]}if((cS[2]&&cS[2]!="px"||cS[2]!=fS[2])&&!color){unit2px(cS,n,dims||(dims=units(obj)));unit2px(fS,n,dims);if(font&&n!="font-size"){if(fS[2]=="em")fS[1]*=font[1]/(font[2]!="em"?dims["em"]:1);if(fS[2]=="ex")fS[1]*=dims["exn"]/dims["ex"]}}if(color){help=[];for(var m=cS.length;m--;){help[m]=fS[m]-cS[m];if(maxVal<help[m])maxVal=help[m]}initProp[n]={full:cS,delta:help}}else{cS[1]=parseFloat(cS[1]);help=parseFloat(fS[1])-cS[1];if(maxVal<Math.abs(help))maxVal=help*(opacity&&!IE?100:1);initProp[n]={pre:IE&&
                            opacity?"filter:alpha(opacity=":n+":",full:cS[1],delta:help,unit:fS[2]==""?IE&&opacity?")":"":"px"}}}maxVal=12+Math.abs(duration/maxVal*(!speed&&speed!=0?1:speed));if(jsMorph.speed&&maxVal>jsMorph.speed);else jsMorph.speed=maxVal;initProp.speed=maxVal;if(onMorphInit)onMorphInit(initProp,dims);return initProp},timer=function(res){if(!res)return(new Date).getTime()-timer.sT||0;else{timer.sT=(new Date).getTime();return 0}},anim=function(time,timer,backwards,frames,initProps,objs,jsMorph,IE){var tmpCSS,
                            ease,cont=false,iPs,tmpTime,rewind,params,prop,initProp,val;for(var m=initProps.length;m--;){iPs=initProps[m];params=iPs.params;prop=iPs.prop;initProp=iPs.initProp;tmpTime=time-(iPs.newTime||0)-params.delay;if(objs&&(!objs[m]&&!iPs.newTime))continue;tmpCSS="";if(tmpTime>0){rewind=backwards||iPs.obj.backwards;ease=iPs.ease(tmpTime/params.duration);if(tmpTime<params.duration){cont=true;iPs.done=null;for(var n in prop)if(n.indexOf("color")!=-1){val=[];for(var o=initProp[n].full.length;o--;)val[o]=initProp[n].delta[o]?
                            Math.round(+initProp[n].full[o]+(!rewind?ease:1-ease)*initProp[n].delta[o]):initProp[n].full[o];tmpCSS+=";"+n+":rgb("+val+")"}else{val=(!rewind?ease:1-ease)*initProp[n].delta;if(IE)val=Math.round(val);tmpCSS+=";"+initProp[n].pre+(initProp[n].full+val)+initProp[n].unit}iPs.objStyle.cssText+=tmpCSS}else if(!iPs.done){if(params.doEnd)if(!rewind){for(var n in prop)tmpCSS+=";"+initProp[n].pre+prop[n];iPs.objStyle.cssText+=tmpCSS}else iPs.objStyle.cssText=iPs.obj.initStyle;else{for(var n in prop)tmpCSS+=
                            ";"+initProp[n].pre+(initProp[n].full+(!rewind?initProp[n].delta:0))+initProp[n].unit;iPs.objStyle.cssText+=tmpCSS}if(iPs.onMorphEnd)iPs.onMorphEnd(iPs.obj,timer(),frames,initProp.speed,jsMorph.speed,iPs.objStyle.cssText);iPs.done=true;iPs.newTime=null}if(iPs.onMorph)iPs.onMorph(iPs.obj,iPs.objStyle,time,frames+1,initProp.speed,jsMorph.speed,ease,iPs.objStyle.cssText)}else cont=true}if(cont)jsMorph.timer=window.setTimeout(function(){anim(timer(),timer,backwards,++frames,initProps,objs,jsMorph,IE)},
                            jsMorph.speed);else{jsMorph.timer=null;if(m<=0&&jsMorph.onMorphEnd)jsMorph.onMorphEnd(objs,timer(),frames,jsMorph.speed)}},initProp=[];this.reset=function(obj,prop,params,ease,onMorphInit,onMorph,onMorphEnd){for(var n=initProp.length;n--;){for(var m in initProp[n])m=null;initProp[n]=null;initProp.pop()}if(obj)this.concat(obj,prop,params,ease,onMorphInit,onMorph,onMorphEnd);return this};this.init=function(last){var len=initProp.length,objStyle,tmpStyle;for(var n=last?len-1:0,m=len;n<m;n++){if(initProp[n].obj.initStyle!=
                            undefined&&last==undefined){objStyle=initProp[n].obj.style;tmpStyle=objStyle.cssText;if(initProp[n].obj.initStyle!=tmpStyle)objStyle.cssText=initProp[n].obj.initStyle;else tmpStyle=null}initProp[n]["initProp"]=getInitProp(initProp[n].obj,initProp[n].prop,initProp[n].params.duration,initProp[n].params.speed,initProp[n].onMorphInit,this);if(tmpStyle&&last==undefined)objStyle.cssText=tmpStyle}return this};this.concat=function(obj,prop,params,ease,onMorphInit,onMorph,onMorphEnd){if(!obj.pop&&!obj.item)obj=
                            [obj];if(!params)params={};for(var n=obj.length;n--;){if(typeof obj[n]=="string")obj[n]=document.getElementById(obj[n]);initProp[initProp.length]={obj:obj[n],objStyle:obj[n].style,prop:prop,params:{duration:params.duration||500,delay:params.delay||0,speed:params.speed!=undefined?params.speed:1,doEnd:params.doEnd!=undefined?params.doEnd:true},ease:ease||function(n){return n},onMorphInit:onMorphInit,onMorph:onMorph,onMorphEnd:onMorphEnd};this.init(true)}return this};if(obj)this.concat(obj,prop,params,
                            ease,onMorphInit,onMorph,onMorphEnd);this.stop=function(obj){window.clearTimeout(this.timer)};this.start=function(obj){var time=timer();if(obj&&(obj.pop||obj.item))arguments=obj;for(var objs=[],n=arguments.length;n--;)for(var m=initProp.length;m--;)if(initProp[m].obj==arguments[n]){initProp[m].newTime=this.timer?time:0.1;objs[m]=true}window.clearTimeout(this.timer);anim(this.timer?time:timer(true),timer,this.backwards,1,initProp,objs.length?objs:null,this,IE);return this}};var loadAssistant=function(){options.browser=
                            browser;options.adguardButton=self;options.getScriptNonce=getScriptNonce;options.getStyleNonce=getStyleNonce;closeTip();loadStyle("selector.css");loadTemplates(function(){var adguard=new Adguard(options);adguard.init()})};var loadTemplates=function(success){if(AdguardQuery("#adguard-menu-template").size()>0){if(success)success();return}AdguardQuery("head").append(GM_getResourceText("templates.html"));if(success)success()};var setButtonStyles=function(button){if(!browser.isPositionFixedSupported()){addClass(button,
                            "adguard-assistant-button-absolute");if(options.buttonPositionTop)addClass(button,"adguard-assistant-button-top");else addClass(button,"adguard-assistant-button-bottom-hack")}else{addClass(button,"adguard-assistant-button-fixed");if(options.buttonPositionTop)addClass(button,"adguard-assistant-button-top");else addClass(button,"adguard-assistant-button-bottom")}if(options.buttonPositionLeft)addClass(button,"adguard-assistant-button-left");else addClass(button,"adguard-assistant-button-right")};var getElementsByClassName=
                            function(className,context){var indexOf=[].indexOf||function(prop){for(var i=0;i<this.length;i++)if(this[i]===prop)return i;return-1};var elems=document.querySelectorAll?context.querySelectorAll("."+className):function(){var all=context.getElementsByTagName("*"),elements=[],i=0;for(;i<all.length;i++)if(all[i].className&&((" "+all[i].className+" ").indexOf(" "+className+" ")>-1&&indexOf.call(elements,all[i])===-1))elements.push(all[i]);return elements}();return elems};var getTip=function(){var tip=
                            getElementsByClassName("adgurd-alert-cont",document.getElementsByTagName("body")[0])[0];return tip};var createInnerAllert=function(){var wrap=document.createElement("div");wrap.className="adgurd-alert-wrap";wrap.appendChild(createInnerAlertLogo());wrap.appendChild(createInnerAlertContent());return wrap};var createInnerAlertLogo=function(){var alertLogo=document.createElement("div");alertLogo.className=getWotClassName();return alertLogo};var createInnerAlertContent=function(){var alertCont=document.createElement("div");
                            alertCont.className="adgurd-alert-cont";var alertTail=document.createElement("div");alertTail.className="adgurd-alert-tail";var alertHead=document.createElement("div");alertHead.className="adgurd-alert-head";var alertText=document.createElement("div");alertText.className="adgurd-alert-text";var alertMore=document.createElement("div");alertMore.className="adgurd-alert-more";alertCont.appendChild(alertTail);alertCont.appendChild(alertHead);alertCont.appendChild(alertText);alertCont.appendChild(alertMore);
                            alertCont.style.opacity=0;alertCont.style.display="none";return alertCont};var makeTip=function(head,text,links,color,linkColor,textColor){var cont=getTip();cont.style.display="block";if(color)cont.style.background=color;var headCont=getElementsByClassName("adgurd-alert-head",cont)[0];headCont.innerHTML=head;var textCont=getElementsByClassName("adgurd-alert-text",cont)[0];textCont.innerHTML=text;if(textColor){headCont.style.color=textColor;textCont.style.color=textColor}color=color?color:"#000";var transparentColor=
                            options.buttonPositionLeft?"transparent "+color+" transparent transparent ":"transparent transparent transparent "+color;getElementsByClassName("adgurd-alert-tail",cont)[0].style.borderColor=transparentColor;var hyperLinkArea=getElementsByClassName("adgurd-alert-more",cont)[0];createTipHyperLinks(hyperLinkArea,linkColor,links)};var createTipHyperLinks=function(hyperLinkArea,linkColor,links){for(link in links){var a=document.createElement("a");a.innerHTML=links[link]["text"];a.href=links[link]["href"];
                            if(link!="ignoreLink")a.target="_blank";if(linkColor)a.style.color=linkColor;hyperLinkArea.appendChild(a)}};var fireEvent=function(name,data){var event=document.createEvent("Events");event.initEvent(name,true,true);event.data=data;document.dispatchEvent(event)};document.addEventListener("wot-score",function(e){if(!self.adguardButtonLoaded)return;var wotData=e.data.wotData;options.wotData=wotData;fireEvent("wot-accepted",null);setWotButtonStyle()});var setWotButtonStyle=function(){var logo=AdguardQuery(".adgurd-alert-wrap").children().first().get(0);
                            var className=getWotClassName();logo.className=className};var getWotClassName=function(){var reputation=options.wotData?options.wotData.reputation:null;var base=options.largeIcon?"adgurd-alert-logo-big":"adgurd-alert-logo-small";if(reputation){if(reputation<40)return base+"-red";if(reputation>=40&&reputation<60)return base+"-orange";if(reputation>=60)return base}else return base};var renderButton=function(){var button=document.createElement("div");button.className="adgurd-alert";setButtonStyles(button);
                            var inner=createInnerAllert();button.appendChild(inner);self.adguardButtonLoaded=true;bind(button,"click",function(e){preventDefault(e);stopPropagation(e);loadAssistant();button.parentNode.removeChild(button)});document.getElementsByTagName("body")[0].appendChild(button)};var changePaths=function(debug){if(debug=="true")return;if(options.isChangedPaths)return;var path;var hostname=document.location.host;var protocol=document.location.protocol;var subPath=protocol+"//"+hostname;for(path in options.paths)options.paths[path]=
                            subPath+options.apiurl+options.paths[path]+"?v="+options.version;options.isChangedPaths=true};var quickReady=function(fn){if(document.readyState!="loading")setTimeout(fn,100);else AdguardQuery(document).ready(fn)};var loadButton=function(){self=this.adguardButton;options.hostNameAscii=punycode.ToASCII(document.location.hostname);options.hostNameUnicode=punycode.ToUnicode(document.location.hostname);if(options.alreadyLoaded){afterContentLoaded();return}quickReady(afterContentLoaded)};Object.keys=Object.keys||
                            function(o){var result=[];for(var name in o)if(o.hasOwnProperty(name))result.push(name);return result};var getLocale=function(language){var localization=localizations[language];if(localization)return localization;if(language.indexOf("-")>0)language=language.split("-")[0];localization=localizations[language]||localizations.en;return localization};var getStrings=function(){if(options.adguardStrings)return options.adguardStrings;else{options.adguardStrings=getLocale(options.locale);return options.adguardStrings}};
                        var getAlertLocale=function(){return getStrings().alert};var tipsSettings={closeTipTimeout:1E4,fadeAnimation:1500,delayWelcomeTipTimeout:3E3,delayWotAlertTimeout:1E3,closeWotAlertTimeout:7E3};var closeTip=function(element,timeout){if(!element)element=getTip();if(!element)return;var closeTimeout=timeout||tipsSettings.closeTipTimeout;if(options.closeTipTimeout){window.clearTimeout(options.closeTipTimeout);(new jsMorph(element,{opacity:0},{duration:tipsSettings.fadeAnimation},null,null,null,function(){element.style.display=
                            "none"})).start();return}var timeOut=setTimeout(function(){(new jsMorph(element,{opacity:0},{duration:tipsSettings.fadeAnimation},null,null,null,function(){element.style.display="none"})).start()},closeTimeout);options.closeTipTimeout=timeOut};var showWelcomeTip=function(){if(!options.assistantFirstStart)return;options.assistantFirstStart=false;adguardButton.saveSettings();var locale=getAlertLocale();makeTip(locale.welcomeHead,locale.welcomeMessage,{link1:locale.welcomeLink},null,null,"white");var tip=
                            getTip();setTimeout(function(){(new jsMorph(tip,{opacity:1},{duration:tipsSettings.fadeAnimation})).start();closeTip(tip)},tipsSettings.delayWelcomeTipTimeout)};var validateJSON=function(){if(!JSON)return false;if(!JSON.parse||!JSON.stringify)if(JSON.decode){JSON.parse=JSON.decode;if(JSON.encode)JSON.stringify=JSON.encode;else return false}else return false;return true};var afterContentLoaded=function(){if(!validatePage()||!validateBrowser())return;if(isButtonAlreadyExists())return;changePaths();
                            loadStyle("button.css");loadWorkaroundStyles();renderButton();showWelcomeTip()};var isButtonAlreadyExists=function(){return AdguardQuery(".adgurd-alert").length>0};var addCustomStyle=function(css){var head=document.getElementsByTagName("head")[0];if(head){var style=document.createElement("style");style.setAttribute("type","text/css");style.appendChild(document.createTextNode(css));head.appendChild(style)}};var loadWorkaroundStyles=function(){if(options.hostNameUnicode.indexOf("vk.com")==0||options.hostNameUnicode.indexOf("new.vk.com")==
                            0)addCustomStyle(".adguard-assistant-button-right {right: 10px !important;}"+"#chat_onl_wrap {bottom: 50px !important;}");if(options.hostNameUnicode.indexOf("www.nuernberg.de")==0)addCustomStyle("body{position:static !important}")};var getViewport=function(){var viewPortWidth;var viewPortHeight;if(typeof window.innerWidth!="undefined")viewPortWidth=window.innerWidth,viewPortHeight=window.innerHeight;else if(typeof document.documentElement!="undefined"&&(typeof document.documentElement.clientWidth!=
                            "undefined"&&document.documentElement.clientWidth!=0))viewPortWidth=document.documentElement.clientWidth,viewPortHeight=document.documentElement.clientHeight;else viewPortWidth=document.getElementsByTagName("body")[0].clientWidth,viewPortHeight=document.getElementsByTagName("body")[0].clientHeight;return[viewPortWidth,viewPortHeight]};var isVisibleWindowHeightEnough=function(){var viewPort=getViewport();var height=viewPort[1];if(height<250)return false;return true};var pfx=["webkit","moz","ms","o",
                            ""];var fullScreenPrefix=function(obj,method){var i=0,currentMethod,type;while(i<pfx.length&&!obj[currentMethod]){currentMethod=method;if(pfx[i]=="")currentMethod=currentMethod.substr(0,1).toLowerCase()+currentMethod.substr(1);currentMethod=pfx[i]+currentMethod;type=typeof obj[currentMethod];if(type!="undefined"){pfx=[pfx[i]];return type=="function"?obj[currentMethod]():obj[currentMethod]}i++}};var updateActions={1:function(){options.largeIcon=true;return 1}};var defaultConfig={buttonPositionTop:false,
                            buttonPositionLeft:false,largeIcon:true,assistantFirstStart:true,showWarnings:true,scriptVersion:1};this.saveSettings=function(){var filtered={};for(var prop in options){if(!options.hasOwnProperty(prop))continue;if(!(prop in defaultConfig))continue;filtered[prop]=options[prop]}GM_setValue("settings",JSON.stringify(filtered))};var validateSettings=function(settings){if(!settings)throw"Invalid settings object";for(var prop in settings){if(!settings.hasOwnProperty(prop))continue;var property=defaultConfig[prop];
                            if(typeof property!=typeof settings[prop])throw"Invalid settings object";}if(settings.scriptVersion>defaultConfig.scriptVersion)throw"Invalid settings object";};var loadSettings=function(){var config;var settings=GM_getValue("settings");try{config=JSON.parse(settings);validateSettings(config)}catch(ex){config=JSON.parse(JSON.stringify(defaultConfig));if(typeof settings!="undefined")config.assistantFirstStart=false;GM_setValue("settings",JSON.stringify(config))}config.sendAnonymousStatistic=AdguardSettings.sendAnonymousStatistic;
                            config.locale=AdguardSettings.locale;config.version=AdguardSettings.version;config.nonce=AdguardSettings.nonce;for(var key in config){var value=config[key];options[key]=value}var needSaveSettings=checkForUpdates();if(needSaveSettings)adguardButton.saveSettings()};var checkForUpdates=function(){if(typeof options.scriptVersion=="undefined"||options.scriptVersion<defaultConfig.scriptVersion){var updateAction=getUpdateAction(options.scriptVersion);if(updateAction)updateAction();options.scriptVersion=
                            defaultConfig.scriptVersion;checkForUpdates();return true}return false};var getScriptNonce=function(){if(typeof config.nonce!="undefined")return config.nonce;if(typeof config.AdguardScriptNonce=="undefined"){var nonce=document.querySelector("script[nonce]");if(nonce==null){config.AdguardScriptNonce=null;return null}var attrib=nonce.getAttribute("nonce");config.AdguardScriptNonce=attrib;return attrib}else return config.AdguardScriptNonce};var getStyleNonce=function(){if(typeof config.nonce!="undefined")return config.nonce;
                            if(typeof config.AdguardStyleNonce=="undefined"){var nonce=document.querySelector("style[nonce]");if(nonce==null){config.AdguardStyleNonce=null;return null}var attrib=nonce.getAttribute("nonce");config.AdguardStyleNonce=attrib;return attrib}else return config.AdguardStyleNonce};var getUpdateAction=function(version){if(typeof version=="undefined")return updateActions["1"];else{var step=parseInt(version)+1;return updateActions[step]}};this.init=function(needLoad){if(document.documentMode&&document.documentMode<
                            8)return;if(!isVisibleWindowHeightEnough())return;var alredyLoadButton=typeof window["AdguardAlreadyLoaded"]!="undefined"&&(typeof needLoad!="undefined"&&!needLoad);if(alredyLoadButton)return;if(!validateJSON())return;loadSettings();getScriptNonce();AdguardQuery(document).on("webkitfullscreenchange mozfullscreenchange fullscreenchange",function(){var elem=AdguardQuery(".adgurd-alert");if(fullScreenPrefix(document,"FullScreen")||fullScreenPrefix(document,"IsFullScreen"))elem.addClass("adg-hide");else elem.removeClass("adg-hide")});
                            window["AdguardAlreadyLoaded"]=true;options.alreadyLoaded=needLoad;options.wotLoaded=false;window.iframeData={domainName:document.domain};loadButton()}};
                    (function(e,t){function _(e){var t=M[e]={};return v.each(e.split(y),function(e,n){t[n]=!0}),t}function H(e,n,r){if(r===t&&e.nodeType===1){var i="data-"+n.replace(P,"-$1").toLowerCase();r=e.getAttribute(i);if(typeof r=="string"){try{r=r==="true"?!0:r==="false"?!1:r==="null"?null:+r+""===r?+r:D.test(r)?v.parseJSON(r):r}catch(s){}v.data(e,n,r)}else r=t}return r}function B(e){var t;for(t in e){if(t==="data"&&v.isEmptyObject(e[t]))continue;if(t!=="toJSON")return!1}return!0}function et(){return!1}function tt(){return!0}
                        function ut(e){return!e||(!e.parentNode||e.parentNode.nodeType===11)}function at(e,t){do e=e[t];while(e&&e.nodeType!==1);return e}function ft(e,t,n){t=t||0;if(v.isFunction(t))return v.grep(e,function(e,r){var i=!!t.call(e,r,e);return i===n});if(t.nodeType)return v.grep(e,function(e,r){return e===t===n});if(typeof t=="string"){var r=v.grep(e,function(e){return e.nodeType===1});if(it.test(t))return v.filter(t,r,!n);t=v.filter(t,r)}return v.grep(e,function(e,r){return v.inArray(e,t)>=0===n})}function lt(e){var t=
                            ct.split("|"),n=e.createDocumentFragment();if(n.createElement)while(t.length)n.createElement(t.pop());return n}function Lt(e,t){return e.getElementsByTagName(t)[0]||e.appendChild(e.ownerDocument.createElement(t))}function At(e,t){if(t.nodeType!==1||!v.hasData(e))return;var n,r,i,s=v._data(e),o=v._data(t,s),u=s.events;if(u){delete o.handle,o.events={};for(n in u)for(r=0,i=u[n].length;r<i;r++)v.event.add(t,n,u[n][r])}o.data&&(o.data=v.extend({},o.data))}function Ot(e,t){var n;if(t.nodeType!==1)return;
                            t.clearAttributes&&t.clearAttributes(),t.mergeAttributes&&t.mergeAttributes(e),n=t.nodeName.toLowerCase(),n==="object"?(t.parentNode&&(t.outerHTML=e.outerHTML),v.support.html5Clone&&(e.innerHTML&&(!v.trim(t.innerHTML)&&(t.innerHTML=e.innerHTML)))):n==="input"&&Et.test(e.type)?(t.defaultChecked=t.checked=e.checked,t.value!==e.value&&(t.value=e.value)):n==="option"?t.selected=e.defaultSelected:n==="input"||n==="textarea"?t.defaultValue=e.defaultValue:n==="script"&&(t.text!==e.text&&(t.text=e.text)),
                                t.removeAttribute(v.expando)}function Mt(e){return typeof e.getElementsByTagName!="undefined"?e.getElementsByTagName("*"):typeof e.querySelectorAll!="undefined"?e.querySelectorAll("*"):[]}function _t(e){Et.test(e.type)&&(e.defaultChecked=e.checked)}function Qt(e,t){if(t in e)return t;var n=t.charAt(0).toUpperCase()+t.slice(1),r=t,i=Jt.length;while(i--){t=Jt[i]+n;if(t in e)return t}return r}function Gt(e,t){return e=t||e,v.css(e,"display")==="none"||!v.contains(e.ownerDocument,e)}function Yt(e,t){var n,
                            r,i=[],s=0,o=e.length;for(;s<o;s++){n=e[s];if(!n.style)continue;i[s]=v._data(n,"olddisplay"),t?(!i[s]&&(n.style.display==="none"&&(n.style.display="")),n.style.display===""&&(Gt(n)&&(i[s]=v._data(n,"olddisplay",nn(n.nodeName))))):(r=Dt(n,"display"),!i[s]&&(r!=="none"&&v._data(n,"olddisplay",r)))}for(s=0;s<o;s++){n=e[s];if(!n.style)continue;if(!t||(n.style.display==="none"||n.style.display===""))n.style.display=t?i[s]||"":"none"}return e}function Zt(e,t,n){var r=Rt.exec(t);return r?Math.max(0,r[1]-
                            (n||0))+(r[2]||"px"):t}function en(e,t,n,r){var i=n===(r?"border":"content")?4:t==="width"?1:0,s=0;for(;i<4;i+=2)n==="margin"&&(s+=v.css(e,n+$t[i],!0)),r?(n==="content"&&(s-=parseFloat(Dt(e,"padding"+$t[i]))||0),n!=="margin"&&(s-=parseFloat(Dt(e,"border"+$t[i]+"Width"))||0)):(s+=parseFloat(Dt(e,"padding"+$t[i]))||0,n!=="padding"&&(s+=parseFloat(Dt(e,"border"+$t[i]+"Width"))||0));return s}function tn(e,t,n){var r=t==="width"?e.offsetWidth:e.offsetHeight,i=!0,s=v.support.boxSizing&&v.css(e,"boxSizing")===
                            "border-box";if(r<=0||r==null){r=Dt(e,t);if(r<0||r==null)r=e.style[t];if(Ut.test(r))return r;i=s&&(v.support.boxSizingReliable||r===e.style[t]),r=parseFloat(r)||0}return r+en(e,t,n||(s?"border":"content"),i)+"px"}function nn(e){if(Wt[e])return Wt[e];var t=v("<"+e+">").appendTo(i.body),n=t.css("display");t.remove();if(n==="none"||n===""){Pt=i.body.appendChild(Pt||v.extend(i.createElement("iframe"),{frameBorder:0,width:0,height:0}));if(!Ht||!Pt.createElement)Ht=(Pt.contentWindow||Pt.contentDocument).document,
                            Ht.write("<!doctype html><html><body>"),Ht.close();t=Ht.body.appendChild(Ht.createElement(e)),n=Dt(t,"display"),i.body.removeChild(Pt)}return Wt[e]=n,n}function fn(e,t,n,r){var i;if(v.isArray(t))v.each(t,function(t,i){n||sn.test(e)?r(e,i):fn(e+"["+(typeof i=="object"?t:"")+"]",i,n,r)});else if(!n&&v.type(t)==="object")for(i in t)fn(e+"["+i+"]",t[i],n,r);else r(e,t)}function Cn(e){return function(t,n){typeof t!="string"&&(n=t,t="*");var r,i,s,o=t.toLowerCase().split(y),u=0,a=o.length;if(v.isFunction(n))for(;u<
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            a;u++)r=o[u],s=/^\+/.test(r),s&&(r=r.substr(1)||"*"),i=e[r]=e[r]||[],i[s?"unshift":"push"](n)}}function kn(e,n,r,i,s,o){s=s||n.dataTypes[0],o=o||{},o[s]=!0;var u,a=e[s],f=0,l=a?a.length:0,c=e===Sn;for(;f<l&&(c||!u);f++)u=a[f](n,r,i),typeof u=="string"&&(!c||o[u]?u=t:(n.dataTypes.unshift(u),u=kn(e,n,r,i,u,o)));return(c||!u)&&(!o["*"]&&(u=kn(e,n,r,i,"*",o))),u}function Ln(e,n){var r,i,s=v.ajaxSettings.flatOptions||{};for(r in n)n[r]!==t&&((s[r]?e:i||(i={}))[r]=n[r]);i&&v.extend(!0,e,i)}function An(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 n,r){var i,s,o,u,a=e.contents,f=e.dataTypes,l=e.responseFields;for(s in l)s in r&&(n[l[s]]=r[s]);while(f[0]==="*")f.shift(),i===t&&(i=e.mimeType||n.getResponseHeader("content-type"));if(i)for(s in a)if(a[s]&&a[s].test(i)){f.unshift(s);break}if(f[0]in r)o=f[0];else{for(s in r){if(!f[0]||e.converters[s+" "+f[0]]){o=s;break}u||(u=s)}o=o||u}if(o)return o!==f[0]&&f.unshift(o),r[o]}function On(e,t){var n,r,i,s,o=e.dataTypes.slice(),u=o[0],a={},f=0;e.dataFilter&&(t=e.dataFilter(t,e.dataType));if(o[1])for(n in e.converters)a[n.toLowerCase()]=
                            e.converters[n];for(;i=o[++f];)if(i!=="*"){if(u!=="*"&&u!==i){n=a[u+" "+i]||a["* "+i];if(!n)for(r in a){s=r.split(" ");if(s[1]===i){n=a[u+" "+s[0]]||a["* "+s[0]];if(n){n===!0?n=a[r]:a[r]!==!0&&(i=s[0],o.splice(f--,0,i));break}}}if(n!==!0)if(n&&e["throws"])t=n(t);else try{t=n(t)}catch(l){return{state:"parsererror",error:n?l:"No conversion from "+u+" to "+i}}}u=i}return{state:"success",data:t}}function Fn(){try{return new e.XMLHttpRequest}catch(t){}}function In(){try{return new e.ActiveXObject("Microsoft.XMLHTTP")}catch(t){}}
                        function $n(){return setTimeout(function(){qn=t},0),qn=v.now()}function Jn(e,t){v.each(t,function(t,n){var r=(Vn[t]||[]).concat(Vn["*"]),i=0,s=r.length;for(;i<s;i++)if(r[i].call(e,t,n))return})}function Kn(e,t,n){var r,i=0,s=0,o=Xn.length,u=v.Deferred().always(function(){delete a.elem}),a=function(){var t=qn||$n(),n=Math.max(0,f.startTime+f.duration-t),r=n/f.duration||0,i=1-r,s=0,o=f.tweens.length;for(;s<o;s++)f.tweens[s].run(i);return u.notifyWith(e,[f,i,n]),i<1&&o?n:(u.resolveWith(e,[f]),!1)},f=
                            u.promise({elem:e,props:v.extend({},t),opts:v.extend(!0,{specialEasing:{}},n),originalProperties:t,originalOptions:n,startTime:qn||$n(),duration:n.duration,tweens:[],createTween:function(t,n,r){var i=v.Tween(e,f.opts,t,n,f.opts.specialEasing[t]||f.opts.easing);return f.tweens.push(i),i},stop:function(t){var n=0,r=t?f.tweens.length:0;for(;n<r;n++)f.tweens[n].run(1);return t?u.resolveWith(e,[f,t]):u.rejectWith(e,[f,t]),this}}),l=f.props;Qn(l,f.opts.specialEasing);for(;i<o;i++){r=Xn[i].call(f,e,l,f.opts);
                            if(r)return r}return Jn(f,l),v.isFunction(f.opts.start)&&f.opts.start.call(e,f),v.fx.timer(v.extend(a,{anim:f,queue:f.opts.queue,elem:e})),f.progress(f.opts.progress).done(f.opts.done,f.opts.complete).fail(f.opts.fail).always(f.opts.always)}function Qn(e,t){var n,r,i,s,o;for(n in e){r=v.camelCase(n),i=t[r],s=e[n],v.isArray(s)&&(i=s[1],s=e[n]=s[0]),n!==r&&(e[r]=s,delete e[n]),o=v.cssHooks[r];if(o&&"expand"in o){s=o.expand(s),delete e[r];for(n in s)n in e||(e[n]=s[n],t[n]=i)}else t[r]=i}}function Gn(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   t,n){var r,i,s,o,u,a,f,l,c,h=this,p=e.style,d={},m=[],g=e.nodeType&&Gt(e);n.queue||(l=v._queueHooks(e,"fx"),l.unqueued==null&&(l.unqueued=0,c=l.empty.fire,l.empty.fire=function(){l.unqueued||c()}),l.unqueued++,h.always(function(){h.always(function(){l.unqueued--,v.queue(e,"fx").length||l.empty.fire()})})),e.nodeType===1&&(("height"in t||"width"in t)&&(n.overflow=[p.overflow,p.overflowX,p.overflowY],v.css(e,"display")==="inline"&&(v.css(e,"float")==="none"&&(!v.support.inlineBlockNeedsLayout||nn(e.nodeName)===
                        "inline"?p.display="inline-block":p.zoom=1)))),n.overflow&&(p.overflow="hidden",v.support.shrinkWrapBlocks||h.done(function(){p.overflow=n.overflow[0],p.overflowX=n.overflow[1],p.overflowY=n.overflow[2]}));for(r in t){s=t[r];if(Un.exec(s)){delete t[r],a=a||s==="toggle";if(s===(g?"hide":"show"))continue;m.push(r)}}o=m.length;if(o){u=v._data(e,"fxshow")||v._data(e,"fxshow",{}),"hidden"in u&&(g=u.hidden),a&&(u.hidden=!g),g?v(e).show():h.done(function(){v(e).hide()}),h.done(function(){var t;v.removeData(e,
                            "fxshow",!0);for(t in d)v.style(e,t,d[t])});for(r=0;r<o;r++)i=m[r],f=h.createTween(i,g?u[i]:0),d[i]=u[i]||v.style(e,i),i in u||(u[i]=f.start,g&&(f.end=f.start,f.start=i==="width"||i==="height"?1:0))}}function Yn(e,t,n,r,i){return new Yn.prototype.init(e,t,n,r,i)}function Zn(e,t){var n,r={height:e},i=0;t=t?1:0;for(;i<4;i+=2-t)n=$t[i],r["margin"+n]=r["padding"+n]=e;return t&&(r.opacity=r.width=e),r}function tr(e){return v.isWindow(e)?e:e.nodeType===9?e.defaultView||e.parentWindow:!1}var n,r,i=e.document,
                            s=e.location,o=e.navigator,u=e.jQuery,a=e.$,f=Array.prototype.push,l=Array.prototype.slice,c=null,h=Object.prototype.toString,p=Object.prototype.hasOwnProperty,d=null,v=function(e,t){return new v.fn.init(e,t,n)},m=/[\-+]?(?:\d*\.|)\d+(?:[eE][\-+]?\d+|)/.source,g=/\S/,y=/\s+/,b=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,w=/^(?:[^#<]*(<[\w\W]+>)[^>]*$|#([\w\-]*)$)/,E=/^<(\w+)\s*\/?>(?:<\/\1>|)$/,S=/^[\],:{}\s]*$/,x=/(?:^|:|,)(?:\s*\[)+/g,T=/\\(?:["\\\/bfnrt]|u[\da-fA-F]{4})/g,N=/"[^"\\\r\n]*"|true|false|null|-?(?:\d\d*\.|)\d+(?:[eE][\-+]?\d+|)/g,
                            C=/^-ms-/,k=/-([\da-z])/gi,L=function(e,t){return(t+"").toUpperCase()},A=function(){i.addEventListener?(i.removeEventListener("DOMContentLoaded",A,!1),v.ready()):i.readyState==="complete"&&(i.detachEvent("onreadystatechange",A),v.ready())},O={};v.fn=v.prototype={constructor:v,init:function(e,n,r){var s,o,u,a;if(!e)return this;if(e.nodeType)return this.context=this[0]=e,this.length=1,this;if(typeof e=="string"){e.charAt(0)==="<"&&(e.charAt(e.length-1)===">"&&e.length>=3)?s=[null,e,null]:s=w.exec(e);
                            if(s&&(s[1]||!n)){if(s[1])return n=n instanceof v?n[0]:n,a=n&&n.nodeType?n.ownerDocument||n:i,e=v.parseHTML(s[1],a,!0),E.test(s[1])&&(v.isPlainObject(n)&&this.attr.call(e,n,!0)),v.merge(this,e);o=i.getElementById(s[2]);if(o&&o.parentNode){if(o.id!==s[2])return r.find(e);this.length=1,this[0]=o}return this.context=i,this.selector=e,this}return!n||n.jquery?(n||r).find(e):this.constructor(n).find(e)}return v.isFunction(e)?r.ready(e):(e.selector!==t&&(this.selector=e.selector,this.context=e.context),
                            v.makeArray(e,this))},selector:"",jquery:"1.8.3",length:0,size:function(){return this.length},toArray:function(){return l.call(this)},get:function(e){return e==null?this.toArray():e<0?this[this.length+e]:this[e]},pushStack:function(e,t,n){var r=v.merge(this.constructor(),e);return r.prevObject=this,r.context=this.context,t==="find"?r.selector=this.selector+(this.selector?" ":"")+n:t&&(r.selector=this.selector+"."+t+"("+n+")"),r},each:function(e,t){return v.each(this,e,t)},ready:function(e){return v.ready.promise().done(e),
                            this},eq:function(e){return e=+e,e===-1?this.slice(e):this.slice(e,e+1)},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},slice:function(){return this.pushStack(l.apply(this,arguments),"slice",l.call(arguments).join(","))},map:function(e){return this.pushStack(v.map(this,function(t,n){return e.call(t,n,t)}))},end:function(){return this.prevObject||this.constructor(null)},push:f,sort:[].sort,splice:[].splice},v.fn.init.prototype=v.fn,v.extend=v.fn.extend=function(){var e,n,r,
                            i,s,o,u=arguments[0]||{},a=1,f=arguments.length,l=!1;typeof u=="boolean"&&(l=u,u=arguments[1]||{},a=2),typeof u!="object"&&(!v.isFunction(u)&&(u={})),f===a&&(u=this,--a);for(;a<f;a++)if((e=arguments[a])!=null)for(n in e){r=u[n],i=e[n];if(u===i)continue;l&&(i&&(v.isPlainObject(i)||(s=v.isArray(i))))?(s?(s=!1,o=r&&v.isArray(r)?r:[]):o=r&&v.isPlainObject(r)?r:{},u[n]=v.extend(l,o,i)):i!==t&&(u[n]=i)}return u},v.extend({noConflict:function(t){return e.$===v&&(e.$=a),t&&(e.jQuery===v&&(e.jQuery=u)),v},
                            isReady:!1,readyWait:1,holdReady:function(e){e?v.readyWait++:v.ready(!0)},ready:function(e){if(e===!0?--v.readyWait:v.isReady)return;if(!i.body)return setTimeout(v.ready,1);v.isReady=!0;if(e!==!0&&--v.readyWait>0)return;r.resolveWith(i,[v]),v.fn.trigger&&v(i).trigger("ready").off("ready")},isFunction:function(e){return v.type(e)==="function"},isArray:Array.isArray||function(e){return v.type(e)==="array"},isWindow:function(e){return e!=null&&e==e.window},isNumeric:function(e){return!isNaN(parseFloat(e))&&
                                isFinite(e)},type:function(e){return e==null?String(e):O[h.call(e)]||"object"},isPlainObject:function(e){if(!e||(v.type(e)!=="object"||(e.nodeType||v.isWindow(e))))return!1;try{if(e.constructor&&(!p.call(e,"constructor")&&!p.call(e.constructor.prototype,"isPrototypeOf")))return!1}catch(n){return!1}var r;for(r in e);return r===t||p.call(e,r)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},error:function(e){throw new Error(e);},parseHTML:function(e,t,n){var r;return!e||typeof e!="string"?
                                null:(typeof t=="boolean"&&(n=t,t=0),t=t||i,(r=E.exec(e))?[t.createElement(r[1])]:(r=v.buildFragment([e],t,n?null:[]),v.merge([],(r.cacheable?v.clone(r.fragment):r.fragment).childNodes)))},parseJSON:function(t){if(!t||typeof t!="string")return null;t=v.trim(t);if(e.JSON&&e.JSON.parse)return e.JSON.parse(t);if(S.test(t.replace(T,"@").replace(N,"]").replace(x,"")))return(new Function("return "+t))();v.error("Invalid JSON: "+t)},parseXML:function(n){var r,i;if(!n||typeof n!="string")return null;try{e.DOMParser?
                                (i=new DOMParser,r=i.parseFromString(n,"text/xml")):(r=new ActiveXObject("Microsoft.XMLDOM"),r.async="false",r.loadXML(n))}catch(s){r=t}return(!r||(!r.documentElement||r.getElementsByTagName("parsererror").length))&&v.error("Invalid XML: "+n),r},noop:function(){},globalEval:function(t){t&&(g.test(t)&&(e.execScript||function(t){e.eval.call(e,t)})(t))},camelCase:function(e){return e.replace(C,"ms-").replace(k,L)},nodeName:function(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()},
                            each:function(e,n,r){var i,s=0,o=e.length,u=o===t||v.isFunction(e);if(r)if(u)for(i in e){if(n.apply(e[i],r)===!1)break}else for(;s<o;){if(n.apply(e[s++],r)===!1)break}else if(u)for(i in e){if(n.call(e[i],i,e[i])===!1)break}else for(;s<o;)if(n.call(e[s],s,e[s++])===!1)break;return e},trim:d&&!d.call("\ufeff\u00a0")?function(e){return e==null?"":d.call(e)}:function(e){return e==null?"":(e+"").replace(b,"")},makeArray:function(e,t){var n,r=t||[];return e!=null&&(n=v.type(e),e.length==null||(n==="string"||
                            (n==="function"||(n==="regexp"||v.isWindow(e))))?f.call(r,e):v.merge(r,e)),r},inArray:function(e,t,n){var r;if(t){if(c)return c.call(t,e,n);r=t.length,n=n?n<0?Math.max(0,r+n):n:0;for(;n<r;n++)if(n in t&&t[n]===e)return n}return-1},merge:function(e,n){var r=n.length,i=e.length,s=0;if(typeof r=="number")for(;s<r;s++)e[i++]=n[s];else while(n[s]!==t)e[i++]=n[s++];return e.length=i,e},grep:function(e,t,n){var r,i=[],s=0,o=e.length;n=!!n;for(;s<o;s++)r=!!t(e[s],s),n!==r&&i.push(e[s]);return i},map:function(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      n,r){var i,s,o=[],u=0,a=e.length,f=e instanceof v||a!==t&&(typeof a=="number"&&(a>0&&(e[0]&&e[a-1])||(a===0||v.isArray(e))));if(f)for(;u<a;u++)i=n(e[u],u,r),i!=null&&(o[o.length]=i);else for(s in e)i=n(e[s],s,r),i!=null&&(o[o.length]=i);return o.concat.apply([],o)},guid:1,proxy:function(e,n){var r,i,s;return typeof n=="string"&&(r=e[n],n=e,e=r),v.isFunction(e)?(i=l.call(arguments,2),s=function(){return e.apply(n,i.concat(l.call(arguments)))},s.guid=e.guid=e.guid||v.guid++,s):t},access:function(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         n,r,i,s,o,u){var a,f=r==null,l=0,c=e.length;if(r&&typeof r=="object"){for(l in r)v.access(e,n,l,r[l],1,o,i);s=1}else if(i!==t){a=u===t&&v.isFunction(i),f&&(a?(a=n,n=function(e,t,n){return a.call(v(e),n)}):(n.call(e,i),n=null));if(n)for(;l<c;l++)n(e[l],r,a?i.call(e[l],l,n(e[l],r)):i,u);s=1}return s?e:f?n.call(e):c?n(e[0],r):o},now:function(){return(new Date).getTime()}}),v.ready.promise=function(t){if(!r){r=v.Deferred();if(i.readyState==="complete")setTimeout(v.ready,1);else if(i.addEventListener)i.addEventListener("DOMContentLoaded",
                            A,!1),e.addEventListener("load",v.ready,!1);else{i.attachEvent("onreadystatechange",A),e.attachEvent("onload",v.ready);var n=!1;try{n=e.frameElement==null&&i.documentElement}catch(s){}n&&(n.doScroll&&function o(){if(!v.isReady){try{n.doScroll("left")}catch(e){return setTimeout(o,50)}v.ready()}}())}}return r.promise(t)},v.each("Boolean Number String Function Array Date RegExp Object".split(" "),function(e,t){O["[object "+t+"]"]=t.toLowerCase()}),n=v(i);var M={};v.Callbacks=function(e){e=typeof e==
                        "string"?M[e]||_(e):v.extend({},e);var n,r,i,s,o,u,a=[],f=!e.once&&[],l=function(t){n=e.memory&&t,r=!0,u=s||0,s=0,o=a.length,i=!0;for(;a&&u<o;u++)if(a[u].apply(t[0],t[1])===!1&&e.stopOnFalse){n=!1;break}i=!1,a&&(f?f.length&&l(f.shift()):n?a=[]:c.disable())},c={add:function(){if(a){var t=a.length;(function r(t){v.each(t,function(t,n){var i=v.type(n);i==="function"?(!e.unique||!c.has(n))&&a.push(n):n&&(n.length&&(i!=="string"&&r(n)))})})(arguments),i?o=a.length:n&&(s=t,l(n))}return this},remove:function(){return a&&
                        v.each(arguments,function(e,t){var n;while((n=v.inArray(t,a,n))>-1)a.splice(n,1),i&&(n<=o&&o--,n<=u&&u--)}),this},has:function(e){return v.inArray(e,a)>-1},empty:function(){return a=[],this},disable:function(){return a=f=n=t,this},disabled:function(){return!a},lock:function(){return f=t,n||c.disable(),this},locked:function(){return!f},fireWith:function(e,t){return t=t||[],t=[e,t.slice?t.slice():t],a&&((!r||f)&&(i?f.push(t):l(t))),this},fire:function(){return c.fireWith(this,arguments),this},fired:function(){return!!r}};
                            return c},v.extend({Deferred:function(e){var t=[["resolve","done",v.Callbacks("once memory"),"resolved"],["reject","fail",v.Callbacks("once memory"),"rejected"],["notify","progress",v.Callbacks("memory")]],n="pending",r={state:function(){return n},always:function(){return i.done(arguments).fail(arguments),this},then:function(){var e=arguments;return v.Deferred(function(n){v.each(t,function(t,r){var s=r[0],o=e[t];i[r[1]](v.isFunction(o)?function(){var e=o.apply(this,arguments);e&&v.isFunction(e.promise)?
                            e.promise().done(n.resolve).fail(n.reject).progress(n.notify):n[s+"With"](this===i?n:this,[e])}:n[s])}),e=null}).promise()},promise:function(e){return e!=null?v.extend(e,r):r}},i={};return r.pipe=r.then,v.each(t,function(e,s){var o=s[2],u=s[3];r[s[1]]=o.add,u&&o.add(function(){n=u},t[e^1][2].disable,t[2][2].lock),i[s[0]]=o.fire,i[s[0]+"With"]=o.fireWith}),r.promise(i),e&&e.call(i,i),i},when:function(e){var t=0,n=l.call(arguments),r=n.length,i=r!==1||e&&v.isFunction(e.promise)?r:0,s=i===1?e:v.Deferred(),
                            o=function(e,t,n){return function(r){t[e]=this,n[e]=arguments.length>1?l.call(arguments):r,n===u?s.notifyWith(t,n):--i||s.resolveWith(t,n)}},u,a,f;if(r>1){u=new Array(r),a=new Array(r),f=new Array(r);for(;t<r;t++)n[t]&&v.isFunction(n[t].promise)?n[t].promise().done(o(t,f,n)).fail(s.reject).progress(o(t,a,u)):--i}return i||s.resolveWith(f,n),s.promise()}}),v.support=function(){var t,n,r,s,o,u,a,f,l,c,h,p=i.createElement("div");p.setAttribute("className","t"),p.innerHTML="  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>",
                            n=p.getElementsByTagName("*"),r=p.getElementsByTagName("a")[0];if(!n||(!r||!n.length))return{};s=i.createElement("select"),o=s.appendChild(i.createElement("option")),u=p.getElementsByTagName("input")[0],r.style.cssText="top:1px;float:left;opacity:.5",t={leadingWhitespace:p.firstChild.nodeType===3,tbody:!p.getElementsByTagName("tbody").length,htmlSerialize:!!p.getElementsByTagName("link").length,style:/top/.test(r.getAttribute("style")),hrefNormalized:r.getAttribute("href")==="/a",opacity:/^0.5/.test(r.style.opacity),
                            cssFloat:!!r.style.cssFloat,checkOn:u.value==="on",optSelected:o.selected,getSetAttribute:p.className!=="t",enctype:!!i.createElement("form").enctype,html5Clone:i.createElement("nav").cloneNode(!0).outerHTML!=="<:nav></:nav>",boxModel:i.compatMode==="CSS1Compat",submitBubbles:!0,changeBubbles:!0,focusinBubbles:!1,deleteExpando:!0,noCloneEvent:!0,inlineBlockNeedsLayout:!1,shrinkWrapBlocks:!1,reliableMarginRight:!0,boxSizingReliable:!0,pixelPosition:!1},u.checked=!0,t.noCloneChecked=u.cloneNode(!0).checked,
                            s.disabled=!0,t.optDisabled=!o.disabled;try{delete p.test}catch(d){t.deleteExpando=!1}!p.addEventListener&&(p.attachEvent&&(p.fireEvent&&(p.attachEvent("onclick",h=function(){t.noCloneEvent=!1}),p.cloneNode(!0).fireEvent("onclick"),p.detachEvent("onclick",h)))),u=i.createElement("input"),u.value="t",u.setAttribute("type","radio"),t.radioValue=u.value==="t",u.setAttribute("checked","checked"),u.setAttribute("name","t"),p.appendChild(u),a=i.createDocumentFragment(),a.appendChild(p.lastChild),t.checkClone=
                            a.cloneNode(!0).cloneNode(!0).lastChild.checked,t.appendChecked=u.checked,a.removeChild(u),a.appendChild(p);if(p.attachEvent)for(l in{submit:!0,change:!0,focusin:!0})f="on"+l,c=f in p,c||(p.setAttribute(f,"return;"),c=typeof p[f]=="function"),t[l+"Bubbles"]=c;return v(function(){var n,r,s,o,u="padding:0;margin:0;border:0;display:block;overflow:hidden;",a=i.getElementsByTagName("body")[0];if(!a)return;n=i.createElement("div"),n.style.cssText="visibility:hidden;border:0;width:0;height:0;position:static;top:0;margin-top:1px",
                            a.insertBefore(n,a.firstChild),r=i.createElement("div"),n.appendChild(r),r.innerHTML="<table><tr><td></td><td>t</td></tr></table>",s=r.getElementsByTagName("td"),s[0].style.cssText="padding:0;margin:0;border:0;display:none",c=s[0].offsetHeight===0,s[0].style.display="",s[1].style.display="none",t.reliableHiddenOffsets=c&&s[0].offsetHeight===0,r.innerHTML="",r.style.cssText="box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%;",
                            t.boxSizing=r.offsetWidth===4,t.doesNotIncludeMarginInBodyOffset=a.offsetTop!==1,e.getComputedStyle&&(t.pixelPosition=(e.getComputedStyle(r,null)||{}).top!=="1%",t.boxSizingReliable=(e.getComputedStyle(r,null)||{width:"4px"}).width==="4px",o=i.createElement("div"),o.style.cssText=r.style.cssText=u,o.style.marginRight=o.style.width="0",r.style.width="1px",r.appendChild(o),t.reliableMarginRight=!parseFloat((e.getComputedStyle(o,null)||{}).marginRight)),typeof r.style.zoom!="undefined"&&(r.innerHTML=
                            "",r.style.cssText=u+"width:1px;padding:1px;display:inline;zoom:1",t.inlineBlockNeedsLayout=r.offsetWidth===3,r.style.display="block",r.style.overflow="visible",r.innerHTML="<div></div>",r.firstChild.style.width="5px",t.shrinkWrapBlocks=r.offsetWidth!==3,n.style.zoom=1),a.removeChild(n),n=r=s=o=null}),a.removeChild(p),n=r=s=o=u=a=p=null,t}();var D=/(?:\{[\s\S]*\}|\[[\s\S]*\])$/,P=/([A-Z])/g;v.extend({cache:{},deletedIds:[],uuid:0,expando:"jQuery"+(v.fn.jquery+Math.random()).replace(/\D/g,""),noData:{embed:!0,
                            object:"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",applet:!0},hasData:function(e){return e=e.nodeType?v.cache[e[v.expando]]:e[v.expando],!!e&&!B(e)},data:function(e,n,r,i){if(!v.acceptData(e))return;var s,o,u=v.expando,a=typeof n=="string",f=e.nodeType,l=f?v.cache:e,c=f?e[u]:e[u]&&u;if((!c||(!l[c]||!i&&!l[c].data))&&(a&&r===t))return;c||(f?e[u]=c=v.deletedIds.pop()||v.guid++:c=u),l[c]||(l[c]={},f||(l[c].toJSON=v.noop));if(typeof n=="object"||typeof n=="function")i?l[c]=v.extend(l[c],n):l[c].data=
                            v.extend(l[c].data,n);return s=l[c],i||(s.data||(s.data={}),s=s.data),r!==t&&(s[v.camelCase(n)]=r),a?(o=s[n],o==null&&(o=s[v.camelCase(n)])):o=s,o},removeData:function(e,t,n){if(!v.acceptData(e))return;var r,i,s,o=e.nodeType,u=o?v.cache:e,a=o?e[v.expando]:v.expando;if(!u[a])return;if(t){r=n?u[a]:u[a].data;if(r){v.isArray(t)||(t in r?t=[t]:(t=v.camelCase(t),t in r?t=[t]:t=t.split(" ")));for(i=0,s=t.length;i<s;i++)delete r[t[i]];if(!(n?B:v.isEmptyObject)(r))return}}if(!n){delete u[a].data;if(!B(u[a]))return}o?
                            v.cleanData([e],!0):v.support.deleteExpando||u!=u.window?delete u[a]:u[a]=null},_data:function(e,t,n){return v.data(e,t,n,!0)},acceptData:function(e){var t=e.nodeName&&v.noData[e.nodeName.toLowerCase()];return!t||t!==!0&&e.getAttribute("classid")===t}}),v.fn.extend({data:function(e,n){var r,i,s,o,u,a=this[0],f=0,l=null;if(e===t){if(this.length){l=v.data(a);if(a.nodeType===1&&!v._data(a,"parsedAttrs")){s=a.attributes;for(u=s.length;f<u;f++)o=s[f].name,o.indexOf("data-")||(o=v.camelCase(o.substring(5)),
                            H(a,o,l[o]));v._data(a,"parsedAttrs",!0)}}return l}return typeof e=="object"?this.each(function(){v.data(this,e)}):(r=e.split(".",2),r[1]=r[1]?"."+r[1]:"",i=r[1]+"!",v.access(this,function(n){if(n===t)return l=this.triggerHandler("getData"+i,[r[0]]),l===t&&(a&&(l=v.data(a,e),l=H(a,e,l))),l===t&&r[1]?this.data(r[0]):l;r[1]=n,this.each(function(){var t=v(this);t.triggerHandler("setData"+i,r),v.data(this,e,n),t.triggerHandler("changeData"+i,r)})},null,n,arguments.length>1,null,!1))},removeData:function(e){return this.each(function(){v.removeData(this,
                            e)})}}),v.extend({queue:function(e,t,n){var r;if(e)return t=(t||"fx")+"queue",r=v._data(e,t),n&&(!r||v.isArray(n)?r=v._data(e,t,v.makeArray(n)):r.push(n)),r||[]},dequeue:function(e,t){t=t||"fx";var n=v.queue(e,t),r=n.length,i=n.shift(),s=v._queueHooks(e,t),o=function(){v.dequeue(e,t)};i==="inprogress"&&(i=n.shift(),r--),i&&(t==="fx"&&n.unshift("inprogress"),delete s.stop,i.call(e,o,s)),!r&&(s&&s.empty.fire())},_queueHooks:function(e,t){var n=t+"queueHooks";return v._data(e,n)||v._data(e,n,{empty:v.Callbacks("once memory").add(function(){v.removeData(e,
                                t+"queue",!0),v.removeData(e,n,!0)})})}}),v.fn.extend({queue:function(e,n){var r=2;return typeof e!="string"&&(n=e,e="fx",r--),arguments.length<r?v.queue(this[0],e):n===t?this:this.each(function(){var t=v.queue(this,e,n);v._queueHooks(this,e),e==="fx"&&(t[0]!=="inprogress"&&v.dequeue(this,e))})},dequeue:function(e){return this.each(function(){v.dequeue(this,e)})},delay:function(e,t){return e=v.fx?v.fx.speeds[e]||e:e,t=t||"fx",this.queue(t,function(t,n){var r=setTimeout(t,e);n.stop=function(){clearTimeout(r)}})},
                            clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,n){var r,i=1,s=v.Deferred(),o=this,u=this.length,a=function(){--i||s.resolveWith(o,[o])};typeof e!="string"&&(n=e,e=t),e=e||"fx";while(u--)r=v._data(o[u],e+"queueHooks"),r&&(r.empty&&(i++,r.empty.add(a)));return a(),s.promise(n)}});var j,F,I,q=/[\t\r\n]/g,R=/\r/g,U=/^(?:button|input)$/i,z=/^(?:button|input|object|select|textarea)$/i,W=/^a(?:rea|)$/i,X=/^(?:autofocus|autoplay|async|checked|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped|selected)$/i,
                            V=v.support.getSetAttribute;v.fn.extend({attr:function(e,t){return v.access(this,v.attr,e,t,arguments.length>1)},removeAttr:function(e){return this.each(function(){v.removeAttr(this,e)})},prop:function(e,t){return v.access(this,v.prop,e,t,arguments.length>1)},removeProp:function(e){return e=v.propFix[e]||e,this.each(function(){try{this[e]=t,delete this[e]}catch(n){}})},addClass:function(e){var t,n,r,i,s,o,u;if(v.isFunction(e))return this.each(function(t){v(this).addClass(e.call(this,t,this.className))});
                            if(e&&typeof e=="string"){t=e.split(y);for(n=0,r=this.length;n<r;n++){i=this[n];if(i.nodeType===1)if(!i.className&&t.length===1)i.className=e;else{s=" "+i.className+" ";for(o=0,u=t.length;o<u;o++)s.indexOf(" "+t[o]+" ")<0&&(s+=t[o]+" ");i.className=v.trim(s)}}}return this},removeClass:function(e){var n,r,i,s,o,u,a;if(v.isFunction(e))return this.each(function(t){v(this).removeClass(e.call(this,t,this.className))});if(e&&typeof e=="string"||e===t){n=(e||"").split(y);for(u=0,a=this.length;u<a;u++){i=
                            this[u];if(i.nodeType===1&&i.className){r=(" "+i.className+" ").replace(q," ");for(s=0,o=n.length;s<o;s++)while(r.indexOf(" "+n[s]+" ")>=0)r=r.replace(" "+n[s]+" "," ");i.className=e?v.trim(r):""}}}return this},toggleClass:function(e,t){var n=typeof e,r=typeof t=="boolean";return v.isFunction(e)?this.each(function(n){v(this).toggleClass(e.call(this,n,this.className,t),t)}):this.each(function(){if(n==="string"){var i,s=0,o=v(this),u=t,a=e.split(y);while(i=a[s++])u=r?u:!o.hasClass(i),o[u?"addClass":
                            "removeClass"](i)}else if(n==="undefined"||n==="boolean")this.className&&v._data(this,"__className__",this.className),this.className=this.className||e===!1?"":v._data(this,"__className__")||""})},hasClass:function(e){var t=" "+e+" ",n=0,r=this.length;for(;n<r;n++)if(this[n].nodeType===1&&(" "+this[n].className+" ").replace(q," ").indexOf(t)>=0)return!0;return!1},val:function(e){var n,r,i,s=this[0];if(!arguments.length){if(s)return n=v.valHooks[s.type]||v.valHooks[s.nodeName.toLowerCase()],n&&("get"in
                        n&&(r=n.get(s,"value"))!==t)?r:(r=s.value,typeof r=="string"?r.replace(R,""):r==null?"":r);return}return i=v.isFunction(e),this.each(function(r){var s,o=v(this);if(this.nodeType!==1)return;i?s=e.call(this,r,o.val()):s=e,s==null?s="":typeof s=="number"?s+="":v.isArray(s)&&(s=v.map(s,function(e){return e==null?"":e+""})),n=v.valHooks[this.type]||v.valHooks[this.nodeName.toLowerCase()];if(!n||(!("set"in n)||n.set(this,s,"value")===t))this.value=s})}}),v.extend({valHooks:{option:{get:function(e){var t=
                            e.attributes.value;return!t||t.specified?e.value:e.text}},select:{get:function(e){var t,n,r=e.options,i=e.selectedIndex,s=e.type==="select-one"||i<0,o=s?null:[],u=s?i+1:r.length,a=i<0?u:s?i:0;for(;a<u;a++){n=r[a];if((n.selected||a===i)&&((v.support.optDisabled?!n.disabled:n.getAttribute("disabled")===null)&&(!n.parentNode.disabled||!v.nodeName(n.parentNode,"optgroup")))){t=v(n).val();if(s)return t;o.push(t)}}return o},set:function(e,t){var n=v.makeArray(t);return v(e).find("option").each(function(){this.selected=
                            v.inArray(v(this).val(),n)>=0}),n.length||(e.selectedIndex=-1),n}}},attrFn:{},attr:function(e,n,r,i){var s,o,u,a=e.nodeType;if(!e||(a===3||(a===8||a===2)))return;if(i&&v.isFunction(v.fn[n]))return v(e)[n](r);if(typeof e.getAttribute=="undefined")return v.prop(e,n,r);u=a!==1||!v.isXMLDoc(e),u&&(n=n.toLowerCase(),o=v.attrHooks[n]||(X.test(n)?F:j));if(r!==t){if(r===null){v.removeAttr(e,n);return}return o&&("set"in o&&(u&&(s=o.set(e,r,n))!==t))?s:(e.setAttribute(n,r+""),r)}return o&&("get"in o&&(u&&(s=
                            o.get(e,n))!==null))?s:(s=e.getAttribute(n),s===null?t:s)},removeAttr:function(e,t){var n,r,i,s,o=0;if(t&&e.nodeType===1){r=t.split(y);for(;o<r.length;o++)i=r[o],i&&(n=v.propFix[i]||i,s=X.test(i),s||v.attr(e,i,""),e.removeAttribute(V?i:n),s&&(n in e&&(e[n]=!1)))}},attrHooks:{type:{set:function(e,t){if(U.test(e.nodeName)&&e.parentNode)v.error("type property can't be changed");else if(!v.support.radioValue&&(t==="radio"&&v.nodeName(e,"input"))){var n=e.value;return e.setAttribute("type",t),n&&(e.value=
                            n),t}}},value:{get:function(e,t){return j&&v.nodeName(e,"button")?j.get(e,t):t in e?e.value:null},set:function(e,t,n){if(j&&v.nodeName(e,"button"))return j.set(e,t,n);e.value=t}}},propFix:{tabindex:"tabIndex",readonly:"readOnly","for":"htmlFor","class":"className",maxlength:"maxLength",cellspacing:"cellSpacing",cellpadding:"cellPadding",rowspan:"rowSpan",colspan:"colSpan",usemap:"useMap",frameborder:"frameBorder",contenteditable:"contentEditable"},prop:function(e,n,r){var i,s,o,u=e.nodeType;if(!e||
                            (u===3||(u===8||u===2)))return;return o=u!==1||!v.isXMLDoc(e),o&&(n=v.propFix[n]||n,s=v.propHooks[n]),r!==t?s&&("set"in s&&(i=s.set(e,r,n))!==t)?i:e[n]=r:s&&("get"in s&&(i=s.get(e,n))!==null)?i:e[n]},propHooks:{tabIndex:{get:function(e){var n=e.getAttributeNode("tabindex");return n&&n.specified?parseInt(n.value,10):z.test(e.nodeName)||W.test(e.nodeName)&&e.href?0:t}}}}),F={get:function(e,n){var r,i=v.prop(e,n);return i===!0||typeof i!="boolean"&&((r=e.getAttributeNode(n))&&r.nodeValue!==!1)?n.toLowerCase():
                            t},set:function(e,t,n){var r;return t===!1?v.removeAttr(e,n):(r=v.propFix[n]||n,r in e&&(e[r]=!0),e.setAttribute(n,n.toLowerCase())),n}},V||(I={name:!0,id:!0,coords:!0},j=v.valHooks.button={get:function(e,n){var r;return r=e.getAttributeNode(n),r&&(I[n]?r.value!=="":r.specified)?r.value:t},set:function(e,t,n){var r=e.getAttributeNode(n);return r||(r=i.createAttribute(n),e.setAttributeNode(r)),r.value=t+""}},v.each(["width","height"],function(e,t){v.attrHooks[t]=v.extend(v.attrHooks[t],{set:function(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    n){if(n==="")return e.setAttribute(t,"auto"),n}})}),v.attrHooks.contenteditable={get:j.get,set:function(e,t,n){t===""&&(t="false"),j.set(e,t,n)}}),v.support.hrefNormalized||v.each(["href","src","width","height"],function(e,n){v.attrHooks[n]=v.extend(v.attrHooks[n],{get:function(e){var r=e.getAttribute(n,2);return r===null?t:r}})}),v.support.style||(v.attrHooks.style={get:function(e){return e.style.cssText.toLowerCase()||t},set:function(e,t){return e.style.cssText=t+""}}),v.support.optSelected||(v.propHooks.selected=
                            v.extend(v.propHooks.selected,{get:function(e){var t=e.parentNode;return t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex),null}})),v.support.enctype||(v.propFix.enctype="encoding"),v.support.checkOn||v.each(["radio","checkbox"],function(){v.valHooks[this]={get:function(e){return e.getAttribute("value")===null?"on":e.value}}}),v.each(["radio","checkbox"],function(){v.valHooks[this]=v.extend(v.valHooks[this],{set:function(e,t){if(v.isArray(t))return e.checked=v.inArray(v(e).val(),t)>=0}})});
                        var $=/^(?:textarea|input|select)$/i,J=/^([^\.]*|)(?:\.(.+)|)$/,K=/(?:^|\s)hover(\.\S+|)\b/,Q=/^key/,G=/^(?:mouse|contextmenu)|click/,Y=/^(?:focusinfocus|focusoutblur)$/,Z=function(e){return v.event.special.hover?e:e.replace(K,"mouseenter$1 mouseleave$1")};v.event={add:function(e,n,r,i,s){var o,u,a,f,l,c,h,p,d,m,g;if(e.nodeType===3||(e.nodeType===8||(!n||(!r||!(o=v._data(e))))))return;r.handler&&(d=r,r=d.handler,s=d.selector),r.guid||(r.guid=v.guid++),a=o.events,a||(o.events=a={}),u=o.handle,u||(o.handle=
                            u=function(e){return typeof v=="undefined"||!!e&&v.event.triggered===e.type?t:v.event.dispatch.apply(u.elem,arguments)},u.elem=e),n=v.trim(Z(n)).split(" ");for(f=0;f<n.length;f++){l=J.exec(n[f])||[],c=l[1],h=(l[2]||"").split(".").sort(),g=v.event.special[c]||{},c=(s?g.delegateType:g.bindType)||c,g=v.event.special[c]||{},p=v.extend({type:c,origType:l[1],data:i,handler:r,guid:r.guid,selector:s,needsContext:s&&v.expr.match.needsContext.test(s),namespace:h.join(".")},d),m=a[c];if(!m){m=a[c]=[],m.delegateCount=
                            0;if(!g.setup||g.setup.call(e,i,h,u)===!1)e.addEventListener?e.addEventListener(c,u,!1):e.attachEvent&&e.attachEvent("on"+c,u)}g.add&&(g.add.call(e,p),p.handler.guid||(p.handler.guid=r.guid)),s?m.splice(m.delegateCount++,0,p):m.push(p),v.event.global[c]=!0}e=null},global:{},remove:function(e,t,n,r,i){var s,o,u,a,f,l,c,h,p,d,m,g=v.hasData(e)&&v._data(e);if(!g||!(h=g.events))return;t=v.trim(Z(t||"")).split(" ");for(s=0;s<t.length;s++){o=J.exec(t[s])||[],u=a=o[1],f=o[2];if(!u){for(u in h)v.event.remove(e,
                            u+t[s],n,r,!0);continue}p=v.event.special[u]||{},u=(r?p.delegateType:p.bindType)||u,d=h[u]||[],l=d.length,f=f?new RegExp("(^|\\.)"+f.split(".").sort().join("\\.(?:.*\\.|)")+"(\\.|$)"):null;for(c=0;c<d.length;c++)m=d[c],(i||a===m.origType)&&((!n||n.guid===m.guid)&&((!f||f.test(m.namespace))&&((!r||(r===m.selector||r==="**"&&m.selector))&&(d.splice(c--,1),m.selector&&d.delegateCount--,p.remove&&p.remove.call(e,m)))));d.length===0&&(l!==d.length&&((!p.teardown||p.teardown.call(e,f,g.handle)===!1)&&v.removeEvent(e,
                            u,g.handle),delete h[u]))}v.isEmptyObject(h)&&(delete g.handle,v.removeData(e,"events",!0))},customEvent:{getData:!0,setData:!0,changeData:!0},trigger:function(n,r,s,o){if(!s||s.nodeType!==3&&s.nodeType!==8){var u,a,f,l,c,h,p,d,m,g,y=n.type||n,b=[];if(Y.test(y+v.event.triggered))return;y.indexOf("!")>=0&&(y=y.slice(0,-1),a=!0),y.indexOf(".")>=0&&(b=y.split("."),y=b.shift(),b.sort());if((!s||v.event.customEvent[y])&&!v.event.global[y])return;n=typeof n=="object"?n[v.expando]?n:new v.Event(y,n):new v.Event(y),
                            n.type=y,n.isTrigger=!0,n.exclusive=a,n.namespace=b.join("."),n.namespace_re=n.namespace?new RegExp("(^|\\.)"+b.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,h=y.indexOf(":")<0?"on"+y:"";if(!s){u=v.cache;for(f in u)u[f].events&&(u[f].events[y]&&v.event.trigger(n,r,u[f].handle.elem,!0));return}n.result=t,n.target||(n.target=s),r=r!=null?v.makeArray(r):[],r.unshift(n),p=v.event.special[y]||{};if(p.trigger&&p.trigger.apply(s,r)===!1)return;m=[[s,p.bindType||y]];if(!o&&(!p.noBubble&&!v.isWindow(s))){g=p.delegateType||
                            y,l=Y.test(g+y)?s:s.parentNode;for(c=s;l;l=l.parentNode)m.push([l,g]),c=l;c===(s.ownerDocument||i)&&m.push([c.defaultView||(c.parentWindow||e),g])}for(f=0;f<m.length&&!n.isPropagationStopped();f++)l=m[f][0],n.type=m[f][1],d=(v._data(l,"events")||{})[n.type]&&v._data(l,"handle"),d&&d.apply(l,r),d=h&&l[h],d&&(v.acceptData(l)&&(d.apply&&(d.apply(l,r)===!1&&n.preventDefault())));return n.type=y,!o&&(!n.isDefaultPrevented()&&((!p._default||p._default.apply(s.ownerDocument,r)===!1)&&((y!=="click"||!v.nodeName(s,
                            "a"))&&(v.acceptData(s)&&(h&&(s[y]&&((y!=="focus"&&y!=="blur"||n.target.offsetWidth!==0)&&(!v.isWindow(s)&&(c=s[h],c&&(s[h]=null),v.event.triggered=y,s[y](),v.event.triggered=t,c&&(s[h]=c)))))))))),n.result}return},dispatch:function(n){n=v.event.fix(n||e.event);var r,i,s,o,u,a,f,c,h,p,d=(v._data(this,"events")||{})[n.type]||[],m=d.delegateCount,g=l.call(arguments),y=!n.exclusive&&!n.namespace,b=v.event.special[n.type]||{},w=[];g[0]=n,n.delegateTarget=this;if(b.preDispatch&&b.preDispatch.call(this,
                                n)===!1)return;if(m&&(!n.button||n.type!=="click"))for(s=n.target;s!=this;s=s.parentNode||this)if(s.disabled!==!0||n.type!=="click"){u={},f=[];for(r=0;r<m;r++)c=d[r],h=c.selector,u[h]===t&&(u[h]=c.needsContext?v(h,this).index(s)>=0:v.find(h,this,null,[s]).length),u[h]&&f.push(c);f.length&&w.push({elem:s,matches:f})}d.length>m&&w.push({elem:this,matches:d.slice(m)});for(r=0;r<w.length&&!n.isPropagationStopped();r++){a=w[r],n.currentTarget=a.elem;for(i=0;i<a.matches.length&&!n.isImmediatePropagationStopped();i++){c=
                            a.matches[i];if(y||(!n.namespace&&!c.namespace||n.namespace_re&&n.namespace_re.test(c.namespace)))n.data=c.data,n.handleObj=c,o=((v.event.special[c.origType]||{}).handle||c.handler).apply(a.elem,g),o!==t&&(n.result=o,o===!1&&(n.preventDefault(),n.stopPropagation()))}}return b.postDispatch&&b.postDispatch.call(this,n),n.result},props:"attrChange attrName relatedNode srcElement altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),
                            fixHooks:{},keyHooks:{props:"char charCode key keyCode".split(" "),filter:function(e,t){return e.which==null&&(e.which=t.charCode!=null?t.charCode:t.keyCode),e}},mouseHooks:{props:"button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),filter:function(e,n){var r,s,o,u=n.button,a=n.fromElement;return e.pageX==null&&(n.clientX!=null&&(r=e.target.ownerDocument||i,s=r.documentElement,o=r.body,e.pageX=n.clientX+(s&&s.scrollLeft||(o&&o.scrollLeft||0))-
                                (s&&s.clientLeft||(o&&o.clientLeft||0)),e.pageY=n.clientY+(s&&s.scrollTop||(o&&o.scrollTop||0))-(s&&s.clientTop||(o&&o.clientTop||0)))),!e.relatedTarget&&(a&&(e.relatedTarget=a===e.target?n.toElement:a)),!e.which&&(u!==t&&(e.which=u&1?1:u&2?3:u&4?2:0)),e}},fix:function(e){if(e[v.expando])return e;var t,n,r=e,s=v.event.fixHooks[e.type]||{},o=s.props?this.props.concat(s.props):this.props;e=v.Event(r);for(t=o.length;t;)n=o[--t],e[n]=r[n];return e.target||(e.target=r.srcElement||i),e.target.nodeType===
                            3&&(e.target=e.target.parentNode),e.metaKey=!!e.metaKey,s.filter?s.filter(e,r):e},special:{load:{noBubble:!0},focus:{delegateType:"focusin"},blur:{delegateType:"focusout"},beforeunload:{setup:function(e,t,n){v.isWindow(this)&&(this.onbeforeunload=n)},teardown:function(e,t){this.onbeforeunload===t&&(this.onbeforeunload=null)}}},simulate:function(e,t,n,r){var i=v.extend(new v.Event,n,{type:e,isSimulated:!0,originalEvent:{}});r?v.event.trigger(i,null,t):v.event.dispatch.call(t,i),i.isDefaultPrevented()&&
                            n.preventDefault()}},v.event.handle=v.event.dispatch,v.removeEvent=i.removeEventListener?function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n,!1)}:function(e,t,n){var r="on"+t;e.detachEvent&&(typeof e[r]=="undefined"&&(e[r]=null),e.detachEvent(r,n))},v.Event=function(e,t){if(!(this instanceof v.Event))return new v.Event(e,t);e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||(e.returnValue===!1||e.getPreventDefault&&e.getPreventDefault())?tt:et):
                            this.type=e,t&&v.extend(this,t),this.timeStamp=e&&e.timeStamp||v.now(),this[v.expando]=!0},v.Event.prototype={preventDefault:function(){this.isDefaultPrevented=tt;var e=this.originalEvent;if(!e)return;e.preventDefault?e.preventDefault():e.returnValue=!1},stopPropagation:function(){this.isPropagationStopped=tt;var e=this.originalEvent;if(!e)return;e.stopPropagation&&e.stopPropagation(),e.cancelBubble=!0},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=tt,this.stopPropagation()},
                            isDefaultPrevented:et,isPropagationStopped:et,isImmediatePropagationStopped:et},v.each({mouseenter:"mouseover",mouseleave:"mouseout"},function(e,t){v.event.special[e]={delegateType:t,bindType:t,handle:function(e){var n,r=this,i=e.relatedTarget,s=e.handleObj,o=s.selector;if(!i||i!==r&&!v.contains(r,i))e.type=s.origType,n=s.handler.apply(this,arguments),e.type=t;return n}}}),v.support.submitBubbles||(v.event.special.submit={setup:function(){if(v.nodeName(this,"form"))return!1;v.event.add(this,"click._submit keypress._submit",
                            function(e){var n=e.target,r=v.nodeName(n,"input")||v.nodeName(n,"button")?n.form:t;r&&(!v._data(r,"_submit_attached")&&(v.event.add(r,"submit._submit",function(e){e._submit_bubble=!0}),v._data(r,"_submit_attached",!0)))})},postDispatch:function(e){e._submit_bubble&&(delete e._submit_bubble,this.parentNode&&(!e.isTrigger&&v.event.simulate("submit",this.parentNode,e,!0)))},teardown:function(){if(v.nodeName(this,"form"))return!1;v.event.remove(this,"._submit")}}),v.support.changeBubbles||(v.event.special.change=
                        {setup:function(){if($.test(this.nodeName)){if(this.type==="checkbox"||this.type==="radio")v.event.add(this,"propertychange._change",function(e){e.originalEvent.propertyName==="checked"&&(this._just_changed=!0)}),v.event.add(this,"click._change",function(e){this._just_changed&&(!e.isTrigger&&(this._just_changed=!1)),v.event.simulate("change",this,e,!0)});return!1}v.event.add(this,"beforeactivate._change",function(e){var t=e.target;$.test(t.nodeName)&&(!v._data(t,"_change_attached")&&(v.event.add(t,
                            "change._change",function(e){this.parentNode&&(!e.isSimulated&&(!e.isTrigger&&v.event.simulate("change",this.parentNode,e,!0)))}),v._data(t,"_change_attached",!0)))})},handle:function(e){var t=e.target;if(this!==t||(e.isSimulated||(e.isTrigger||t.type!=="radio"&&t.type!=="checkbox")))return e.handleObj.handler.apply(this,arguments)},teardown:function(){return v.event.remove(this,"._change"),!$.test(this.nodeName)}}),v.support.focusinBubbles||v.each({focus:"focusin",blur:"focusout"},function(e,t){var n=
                            0,r=function(e){v.event.simulate(t,e.target,v.event.fix(e),!0)};v.event.special[t]={setup:function(){n++===0&&i.addEventListener(e,r,!0)},teardown:function(){--n===0&&i.removeEventListener(e,r,!0)}}}),v.fn.extend({on:function(e,n,r,i,s){var o,u;if(typeof e=="object"){typeof n!="string"&&(r=r||n,n=t);for(u in e)this.on(u,n,r,e[u],s);return this}r==null&&i==null?(i=n,r=n=t):i==null&&(typeof n=="string"?(i=r,r=t):(i=r,r=n,n=t));if(i===!1)i=et;else if(!i)return this;return s===1&&(o=i,i=function(e){return v().off(e),
                            o.apply(this,arguments)},i.guid=o.guid||(o.guid=v.guid++)),this.each(function(){v.event.add(this,e,i,r,n)})},one:function(e,t,n,r){return this.on(e,t,n,r,1)},off:function(e,n,r){var i,s;if(e&&(e.preventDefault&&e.handleObj))return i=e.handleObj,v(e.delegateTarget).off(i.namespace?i.origType+"."+i.namespace:i.origType,i.selector,i.handler),this;if(typeof e=="object"){for(s in e)this.off(s,n,e[s]);return this}if(n===!1||typeof n=="function")r=n,n=t;return r===!1&&(r=et),this.each(function(){v.event.remove(this,
                            e,r,n)})},bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},live:function(e,t,n){return v(this.context).on(e,this.selector,t,n),this},die:function(e,t){return v(this.context).off(e,this.selector||"**",t),this},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return arguments.length===1?this.off(e,"**"):this.off(t,e||"**",n)},trigger:function(e,t){return this.each(function(){v.event.trigger(e,t,this)})},triggerHandler:function(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       t){if(this[0])return v.event.trigger(e,t,this[0],!0)},toggle:function(e){var t=arguments,n=e.guid||v.guid++,r=0,i=function(n){var i=(v._data(this,"lastToggle"+e.guid)||0)%r;return v._data(this,"lastToggle"+e.guid,i+1),n.preventDefault(),t[i].apply(this,arguments)||!1};i.guid=n;while(r<t.length)t[r++].guid=n;return this.click(i)},hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)}}),v.each("blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu".split(" "),
                            function(e,t){v.fn[t]=function(e,n){return n==null&&(n=e,e=null),arguments.length>0?this.on(t,null,e,n):this.trigger(t)},Q.test(t)&&(v.event.fixHooks[t]=v.event.keyHooks),G.test(t)&&(v.event.fixHooks[t]=v.event.mouseHooks)}),function(e,t){function nt(e,t,n,r){n=n||[],t=t||g;var i,s,a,f,l=t.nodeType;if(!e||typeof e!="string")return n;if(l!==1&&l!==9)return[];a=o(t);if(!a&&!r)if(i=R.exec(e))if(f=i[1])if(l===9){s=t.getElementById(f);if(!s||!s.parentNode)return n;if(s.id===f)return n.push(s),n}else{if(t.ownerDocument&&
                            ((s=t.ownerDocument.getElementById(f))&&(u(t,s)&&s.id===f)))return n.push(s),n}else{if(i[2])return S.apply(n,x.call(t.getElementsByTagName(e),0)),n;if((f=i[3])&&(Z&&t.getElementsByClassName))return S.apply(n,x.call(t.getElementsByClassName(f),0)),n}return vt(e.replace(j,"$1"),t,n,r,a)}function rt(e){return function(t){var n=t.nodeName.toLowerCase();return n==="input"&&t.type===e}}function it(e){return function(t){var n=t.nodeName.toLowerCase();return(n==="input"||n==="button")&&t.type===e}}function st(e){return N(function(t){return t=
                            +t,N(function(n,r){var i,s=e([],n.length,t),o=s.length;while(o--)n[i=s[o]]&&(n[i]=!(r[i]=n[i]))})})}function ot(e,t,n){if(e===t)return n;var r=e.nextSibling;while(r){if(r===t)return-1;r=r.nextSibling}return 1}function ut(e,t){var n,r,s,o,u,a,f,l=L[d][e+" "];if(l)return t?0:l.slice(0);u=e,a=[],f=i.preFilter;while(u){if(!n||(r=F.exec(u)))r&&(u=u.slice(r[0].length)||u),a.push(s=[]);n=!1;if(r=I.exec(u))s.push(n=new m(r.shift())),u=u.slice(n.length),n.type=r[0].replace(j," ");for(o in i.filter)(r=J[o].exec(u))&&
                        ((!f[o]||(r=f[o](r)))&&(s.push(n=new m(r.shift())),u=u.slice(n.length),n.type=o,n.matches=r));if(!n)break}return t?u.length:u?nt.error(e):L(e,a).slice(0)}function at(e,t,r){var i=t.dir,s=r&&t.dir==="parentNode",o=w++;return t.first?function(t,n,r){while(t=t[i])if(s||t.nodeType===1)return e(t,n,r)}:function(t,r,u){if(!u){var a,f=b+" "+o+" ",l=f+n;while(t=t[i])if(s||t.nodeType===1){if((a=t[d])===l)return t.sizset;if(typeof a=="string"&&a.indexOf(f)===0){if(t.sizset)return t}else{t[d]=l;if(e(t,r,u))return t.sizset=
                            !0,t;t.sizset=!1}}}else while(t=t[i])if(s||t.nodeType===1)if(e(t,r,u))return t}}function ft(e){return e.length>1?function(t,n,r){var i=e.length;while(i--)if(!e[i](t,n,r))return!1;return!0}:e[0]}function lt(e,t,n,r,i){var s,o=[],u=0,a=e.length,f=t!=null;for(;u<a;u++)if(s=e[u])if(!n||n(s,r,i))o.push(s),f&&t.push(u);return o}function ct(e,t,n,r,i,s){return r&&(!r[d]&&(r=ct(r))),i&&(!i[d]&&(i=ct(i,s))),N(function(s,o,u,a){var f,l,c,h=[],p=[],d=o.length,v=s||dt(t||"*",u.nodeType?[u]:u,[]),m=e&&(s||!t)?
                            lt(v,h,e,u,a):v,g=n?i||(s?e:d||r)?[]:o:m;n&&n(m,g,u,a);if(r){f=lt(g,p),r(f,[],u,a),l=f.length;while(l--)if(c=f[l])g[p[l]]=!(m[p[l]]=c)}if(s){if(i||e){if(i){f=[],l=g.length;while(l--)(c=g[l])&&f.push(m[l]=c);i(null,g=[],f,a)}l=g.length;while(l--)(c=g[l])&&((f=i?T.call(s,c):h[l])>-1&&(s[f]=!(o[f]=c)))}}else g=lt(g===o?g.splice(d,g.length):g),i?i(null,o,g,a):S.apply(o,g)})}function ht(e){var t,n,r,s=e.length,o=i.relative[e[0].type],u=o||i.relative[" "],a=o?1:0,f=at(function(e){return e===t},u,!0),l=
                            at(function(e){return T.call(t,e)>-1},u,!0),h=[function(e,n,r){return!o&&(r||n!==c)||((t=n).nodeType?f(e,n,r):l(e,n,r))}];for(;a<s;a++)if(n=i.relative[e[a].type])h=[at(ft(h),n)];else{n=i.filter[e[a].type].apply(null,e[a].matches);if(n[d]){r=++a;for(;r<s;r++)if(i.relative[e[r].type])break;return ct(a>1&&ft(h),a>1&&e.slice(0,a-1).join("").replace(j,"$1"),n,a<r&&ht(e.slice(a,r)),r<s&&ht(e=e.slice(r)),r<s&&e.join(""))}h.push(n)}return ft(h)}function pt(e,t){var r=t.length>0,s=e.length>0,o=function(u,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               a,f,l,h){var p,d,v,m=[],y=0,w="0",x=u&&[],T=h!=null,N=c,C=u||s&&i.find.TAG("*",h&&a.parentNode||a),k=b+=N==null?1:Math.E;T&&(c=a!==g&&a,n=o.el);for(;(p=C[w])!=null;w++){if(s&&p){for(d=0;v=e[d];d++)if(v(p,a,f)){l.push(p);break}T&&(b=k,n=++o.el)}r&&((p=!v&&p)&&y--,u&&x.push(p))}y+=w;if(r&&w!==y){for(d=0;v=t[d];d++)v(x,m,a,f);if(u){if(y>0)while(w--)!x[w]&&(!m[w]&&(m[w]=E.call(l)));m=lt(m)}S.apply(l,m),T&&(!u&&(m.length>0&&(y+t.length>1&&nt.uniqueSort(l))))}return T&&(b=k,c=N),x};return o.el=0,r?N(o):
                            o}function dt(e,t,n){var r=0,i=t.length;for(;r<i;r++)nt(e,t[r],n);return n}function vt(e,t,n,r,s){var o,u,f,l,c,h=ut(e),p=h.length;if(!r&&h.length===1){u=h[0]=h[0].slice(0);if(u.length>2&&((f=u[0]).type==="ID"&&(t.nodeType===9&&(!s&&i.relative[u[1].type])))){t=i.find.ID(f.matches[0].replace($,""),t,s)[0];if(!t)return n;e=e.slice(u.shift().length)}for(o=J.POS.test(e)?-1:u.length-1;o>=0;o--){f=u[o];if(i.relative[l=f.type])break;if(c=i.find[l])if(r=c(f.matches[0].replace($,""),z.test(u[0].type)&&t.parentNode||
                                t,s)){u.splice(o,1),e=r.length&&u.join("");if(!e)return S.apply(n,x.call(r,0)),n;break}}}return a(e,h)(r,t,s,n,z.test(e)),n}function mt(){}var n,r,i,s,o,u,a,f,l,c,h=!0,p="undefined",d=("sizcache"+Math.random()).replace(".",""),m=String,g=e.document,y=g.documentElement,b=0,w=0,E=[].pop,S=[].push,x=[].slice,T=[].indexOf||function(e){var t=0,n=this.length;for(;t<n;t++)if(this[t]===e)return t;return-1},N=function(e,t){return e[d]=t==null||t,e},C=function(){var e={},t=[];return N(function(n,r){return t.push(n)>
                        i.cacheLength&&delete e[t.shift()],e[n+" "]=r},e)},k=C(),L=C(),A=C(),O="[\\x20\\t\\r\\n\\f]",M="(?:\\\\.|[-\\w]|[^\\x00-\\xa0])+",_=M.replace("w","w#"),D="([*^$|!~]?=)",P="\\["+O+"*("+M+")"+O+"*(?:"+D+O+"*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|("+_+")|)|)"+O+"*\\]",H=":("+M+")(?:\\((?:(['\"])((?:\\\\.|[^\\\\])*?)\\2|([^()[\\]]*|(?:(?:"+P+")|[^:]|\\\\.)*|.*))\\)|)",B=":(even|odd|eq|gt|lt|nth|first|last)(?:\\("+O+"*((?:-\\d)?\\d*)"+O+"*\\)|)(?=[^-]|$)",j=new RegExp("^"+O+"+|((?:^|[^\\\\])(?:\\\\.)*)"+O+
                            "+$","g"),F=new RegExp("^"+O+"*,"+O+"*"),I=new RegExp("^"+O+"*([\\x20\\t\\r\\n\\f>+~])"+O+"*"),q=new RegExp(H),R=/^(?:#([\w\-]+)|(\w+)|\.([\w\-]+))$/,U=/^:not/,z=/[\x20\t\r\n\f]*[+~]/,W=/:not\($/,X=/h\d/i,V=/input|select|textarea|button/i,$=/\\(?!\\)/g,J={ID:new RegExp("^#("+M+")"),CLASS:new RegExp("^\\.("+M+")"),NAME:new RegExp("^\\[name=['\"]?("+M+")['\"]?\\]"),TAG:new RegExp("^("+M.replace("w","w*")+")"),ATTR:new RegExp("^"+P),PSEUDO:new RegExp("^"+H),POS:new RegExp(B,"i"),CHILD:new RegExp("^:(only|nth|first|last)-child(?:\\("+
                            O+"*(even|odd|(([+-]|)(\\d*)n|)"+O+"*(?:([+-]|)"+O+"*(\\d+)|))"+O+"*\\)|)","i"),needsContext:new RegExp("^"+O+"*[>+~]|"+B,"i")},K=function(e){var t=g.createElement("div");try{return e(t)}catch(n){return!1}finally{t=null}},Q=K(function(e){return e.appendChild(g.createComment("")),!e.getElementsByTagName("*").length}),G=K(function(e){return e.innerHTML="<a href='#'></a>",e.firstChild&&(typeof e.firstChild.getAttribute!==p&&e.firstChild.getAttribute("href")==="#")}),Y=K(function(e){e.innerHTML="<select></select>";
                            var t=typeof e.lastChild.getAttribute("multiple");return t!=="boolean"&&t!=="string"}),Z=K(function(e){return e.innerHTML="<div class='hidden e'></div><div class='hidden'></div>",!e.getElementsByClassName||!e.getElementsByClassName("e").length?!1:(e.lastChild.className="e",e.getElementsByClassName("e").length===2)}),et=K(function(e){e.id=d+0,e.innerHTML="<a name='"+d+"'></a><div name='"+d+"'></div>",y.insertBefore(e,y.firstChild);var t=g.getElementsByName&&g.getElementsByName(d).length===2+g.getElementsByName(d+
                                0).length;return r=!g.getElementById(d),y.removeChild(e),t});try{x.call(y.childNodes,0)[0].nodeType}catch(tt){x=function(e){var t,n=[];for(;t=this[e];e++)n.push(t);return n}}nt.matches=function(e,t){return nt(e,null,null,t)},nt.matchesSelector=function(e,t){return nt(t,null,null,[e]).length>0},s=nt.getText=function(e){var t,n="",r=0,i=e.nodeType;if(i)if(i===1||(i===9||i===11)){if(typeof e.textContent=="string")return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=s(e)}else{if(i===3||i===4)return e.nodeValue}else for(;t=
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      e[r];r++)n+=s(t);return n},o=nt.isXML=function(e){var t=e&&(e.ownerDocument||e).documentElement;return t?t.nodeName!=="HTML":!1},u=nt.contains=y.contains?function(e,t){var n=e.nodeType===9?e.documentElement:e,r=t&&t.parentNode;return e===r||!!(r&&(r.nodeType===1&&(n.contains&&n.contains(r))))}:y.compareDocumentPosition?function(e,t){return t&&!!(e.compareDocumentPosition(t)&16)}:function(e,t){while(t=t.parentNode)if(t===e)return!0;return!1},nt.attr=function(e,t){var n,r=o(e);return r||(t=t.toLowerCase()),
                            (n=i.attrHandle[t])?n(e):r||Y?e.getAttribute(t):(n=e.getAttributeNode(t),n?typeof e[t]=="boolean"?e[t]?t:null:n.specified?n.value:null:null)},i=nt.selectors={cacheLength:50,createPseudo:N,match:J,attrHandle:G?{}:{href:function(e){return e.getAttribute("href",2)},type:function(e){return e.getAttribute("type")}},find:{ID:r?function(e,t,n){if(typeof t.getElementById!==p&&!n){var r=t.getElementById(e);return r&&r.parentNode?[r]:[]}}:function(e,n,r){if(typeof n.getElementById!==p&&!r){var i=n.getElementById(e);
                            return i?i.id===e||typeof i.getAttributeNode!==p&&i.getAttributeNode("id").value===e?[i]:t:[]}},TAG:Q?function(e,t){if(typeof t.getElementsByTagName!==p)return t.getElementsByTagName(e)}:function(e,t){var n=t.getElementsByTagName(e);if(e==="*"){var r,i=[],s=0;for(;r=n[s];s++)r.nodeType===1&&i.push(r);return i}return n},NAME:et&&function(e,t){if(typeof t.getElementsByName!==p)return t.getElementsByName(name)},CLASS:Z&&function(e,t,n){if(typeof t.getElementsByClassName!==p&&!n)return t.getElementsByClassName(e)}},
                            relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace($,""),e[3]=(e[4]||(e[5]||"")).replace($,""),e[2]==="~="&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),e[1]==="nth"?(e[2]||nt.error(e[0]),e[3]=+(e[3]?e[4]+(e[5]||1):2*(e[2]==="even"||e[2]==="odd")),e[4]=+(e[6]+e[7]||e[2]==="odd")):e[2]&&nt.error(e[0]),e},PSEUDO:function(e){var t,
                                n;if(J.CHILD.test(e[0]))return null;if(e[3])e[2]=e[3];else if(t=e[4])q.test(t)&&((n=ut(t,!0))&&((n=t.indexOf(")",t.length-n)-t.length)&&(t=t.slice(0,n),e[0]=e[0].slice(0,n)))),e[2]=t;return e.slice(0,3)}},filter:{ID:r?function(e){return e=e.replace($,""),function(t){return t.getAttribute("id")===e}}:function(e){return e=e.replace($,""),function(t){var n=typeof t.getAttributeNode!==p&&t.getAttributeNode("id");return n&&n.value===e}},TAG:function(e){return e==="*"?function(){return!0}:(e=e.replace($,
                                "").toLowerCase(),function(t){return t.nodeName&&t.nodeName.toLowerCase()===e})},CLASS:function(e){var t=k[d][e+" "];return t||(t=new RegExp("(^|"+O+")"+e+"("+O+"|$)"))&&k(e,function(e){return t.test(e.className||(typeof e.getAttribute!==p&&e.getAttribute("class")||""))})},ATTR:function(e,t,n){return function(r,i){var s=nt.attr(r,e);return s==null?t==="!=":t?(s+="",t==="="?s===n:t==="!="?s!==n:t==="^="?n&&s.indexOf(n)===0:t==="*="?n&&s.indexOf(n)>-1:t==="$="?n&&s.substr(s.length-n.length)===n:t===
                            "~="?(" "+s+" ").indexOf(n)>-1:t==="|="?s===n||s.substr(0,n.length+1)===n+"-":!1):!0}},CHILD:function(e,t,n,r){return e==="nth"?function(e){var t,i,s=e.parentNode;if(n===1&&r===0)return!0;if(s){i=0;for(t=s.firstChild;t;t=t.nextSibling)if(t.nodeType===1){i++;if(e===t)break}}return i-=r,i===n||i%n===0&&i/n>=0}:function(t){var n=t;switch(e){case "only":case "first":while(n=n.previousSibling)if(n.nodeType===1)return!1;if(e==="first")return!0;n=t;case "last":while(n=n.nextSibling)if(n.nodeType===1)return!1;
                                return!0}}},PSEUDO:function(e,t){var n,r=i.pseudos[e]||(i.setFilters[e.toLowerCase()]||nt.error("unsupported pseudo: "+e));return r[d]?r(t):r.length>1?(n=[e,e,"",t],i.setFilters.hasOwnProperty(e.toLowerCase())?N(function(e,n){var i,s=r(e,t),o=s.length;while(o--)i=T.call(e,s[o]),e[i]=!(n[i]=s[o])}):function(e){return r(e,0,n)}):r}},pseudos:{not:N(function(e){var t=[],n=[],r=a(e.replace(j,"$1"));return r[d]?N(function(e,t,n,i){var s,o=r(e,null,i,[]),u=e.length;while(u--)if(s=o[u])e[u]=!(t[u]=s)}):function(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             i,s){return t[0]=e,r(t,null,s,n),!n.pop()}}),has:N(function(e){return function(t){return nt(e,t).length>0}}),contains:N(function(e){return function(t){return(t.textContent||(t.innerText||s(t))).indexOf(e)>-1}}),enabled:function(e){return e.disabled===!1},disabled:function(e){return e.disabled===!0},checked:function(e){var t=e.nodeName.toLowerCase();return t==="input"&&!!e.checked||t==="option"&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,e.selected===!0},parent:function(e){return!i.pseudos.empty(e)},
                                empty:function(e){var t;e=e.firstChild;while(e){if(e.nodeName>"@"||((t=e.nodeType)===3||t===4))return!1;e=e.nextSibling}return!0},header:function(e){return X.test(e.nodeName)},text:function(e){var t,n;return e.nodeName.toLowerCase()==="input"&&((t=e.type)==="text"&&((n=e.getAttribute("type"))==null||n.toLowerCase()===t))},radio:rt("radio"),checkbox:rt("checkbox"),file:rt("file"),password:rt("password"),image:rt("image"),submit:it("submit"),reset:it("reset"),button:function(e){var t=e.nodeName.toLowerCase();
                                    return t==="input"&&e.type==="button"||t==="button"},input:function(e){return V.test(e.nodeName)},focus:function(e){var t=e.ownerDocument;return e===t.activeElement&&((!t.hasFocus||t.hasFocus())&&!!(e.type||(e.href||~e.tabIndex)))},active:function(e){return e===e.ownerDocument.activeElement},first:st(function(){return[0]}),last:st(function(e,t){return[t-1]}),eq:st(function(e,t,n){return[n<0?n+t:n]}),even:st(function(e,t){for(var n=0;n<t;n+=2)e.push(n);return e}),odd:st(function(e,t){for(var n=1;n<
                                t;n+=2)e.push(n);return e}),lt:st(function(e,t,n){for(var r=n<0?n+t:n;--r>=0;)e.push(r);return e}),gt:st(function(e,t,n){for(var r=n<0?n+t:n;++r<t;)e.push(r);return e})}},f=y.compareDocumentPosition?function(e,t){return e===t?(l=!0,0):(!e.compareDocumentPosition||!t.compareDocumentPosition?e.compareDocumentPosition:e.compareDocumentPosition(t)&4)?-1:1}:function(e,t){if(e===t)return l=!0,0;if(e.sourceIndex&&t.sourceIndex)return e.sourceIndex-t.sourceIndex;var n,r,i=[],s=[],o=e.parentNode,u=t.parentNode,
                            a=o;if(o===u)return ot(e,t);if(!o)return-1;if(!u)return 1;while(a)i.unshift(a),a=a.parentNode;a=u;while(a)s.unshift(a),a=a.parentNode;n=i.length,r=s.length;for(var f=0;f<n&&f<r;f++)if(i[f]!==s[f])return ot(i[f],s[f]);return f===n?ot(e,s[f],-1):ot(i[f],t,1)},[0,0].sort(f),h=!l,nt.uniqueSort=function(e){var t,n=[],r=1,i=0;l=h,e.sort(f);if(l){for(;t=e[r];r++)t===e[r-1]&&(i=n.push(r));while(i--)e.splice(n[i],1)}return e},nt.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e);
                        },a=nt.compile=function(e,t){var n,r=[],i=[],s=A[d][e+" "];if(!s){t||(t=ut(e)),n=t.length;while(n--)s=ht(t[n]),s[d]?r.push(s):i.push(s);s=A(e,pt(i,r))}return s},g.querySelectorAll&&function(){var e,t=vt,n=/'|\\/g,r=/\=[\x20\t\r\n\f]*([^'"\]]*)[\x20\t\r\n\f]*\]/g,i=[":focus"],s=[":active"],u=y.matchesSelector||(y.mozMatchesSelector||(y.webkitMatchesSelector||(y.oMatchesSelector||y.msMatchesSelector)));K(function(e){e.innerHTML="<select><option selected=''></option></select>",e.querySelectorAll("[selected]").length||
                        i.push("\\["+O+"*(?:checked|disabled|ismap|multiple|readonly|selected|value)"),e.querySelectorAll(":checked").length||i.push(":checked")}),K(function(e){e.innerHTML="<p test=''></p>",e.querySelectorAll("[test^='']").length&&i.push("[*^$]="+O+"*(?:\"\"|'')"),e.innerHTML="<input type='hidden'/>",e.querySelectorAll(":enabled").length||i.push(":enabled",":disabled")}),i=new RegExp(i.join("|")),vt=function(e,r,s,o,u){if(!o&&(!u&&!i.test(e))){var a,f,l=!0,c=d,h=r,p=r.nodeType===9&&e;if(r.nodeType===1&&
                            r.nodeName.toLowerCase()!=="object"){a=ut(e),(l=r.getAttribute("id"))?c=l.replace(n,"\\$&"):r.setAttribute("id",c),c="[id='"+c+"'] ",f=a.length;while(f--)a[f]=c+a[f].join("");h=z.test(e)&&r.parentNode||r,p=a.join(",")}if(p)try{return S.apply(s,x.call(h.querySelectorAll(p),0)),s}catch(v){}finally{l||r.removeAttribute("id")}}return t(e,r,s,o,u)},u&&(K(function(t){e=u.call(t,"div");try{u.call(t,"[test!='']:sizzle"),s.push("!=",H)}catch(n){}}),s=new RegExp(s.join("|")),nt.matchesSelector=function(t,n){n=
                            n.replace(r,"='$1']");if(!o(t)&&(!s.test(n)&&!i.test(n)))try{var a=u.call(t,n);if(a||(e||t.document&&t.document.nodeType!==11))return a}catch(f){}return nt(n,null,null,[t]).length>0})}(),i.pseudos.nth=i.pseudos.eq,i.filters=mt.prototype=i.pseudos,i.setFilters=new mt,nt.attr=v.attr,v.find=nt,v.expr=nt.selectors,v.expr[":"]=v.expr.pseudos,v.unique=nt.uniqueSort,v.text=nt.getText,v.isXMLDoc=nt.isXML,v.contains=nt.contains}(e);var nt=/Until$/,rt=/^(?:parents|prev(?:Until|All))/,it=/^.[^:#\[\.,]*$/,st=
                            v.expr.match.needsContext,ot={children:!0,contents:!0,next:!0,prev:!0};v.fn.extend({find:function(e){var t,n,r,i,s,o,u=this;if(typeof e!="string")return v(e).filter(function(){for(t=0,n=u.length;t<n;t++)if(v.contains(u[t],this))return!0});o=this.pushStack("","find",e);for(t=0,n=this.length;t<n;t++){r=o.length,v.find(e,this[t],o);if(t>0)for(i=r;i<o.length;i++)for(s=0;s<r;s++)if(o[s]===o[i]){o.splice(i--,1);break}}return o},has:function(e){var t,n=v(e,this),r=n.length;return this.filter(function(){for(t=
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0;t<r;t++)if(v.contains(this,n[t]))return!0})},not:function(e){return this.pushStack(ft(this,e,!1),"not",e)},filter:function(e){return this.pushStack(ft(this,e,!0),"filter",e)},is:function(e){return!!e&&(typeof e=="string"?st.test(e)?v(e,this.context).index(this[0])>=0:v.filter(e,this).length>0:this.filter(e).length>0)},closest:function(e,t){var n,r=0,i=this.length,s=[],o=st.test(e)||typeof e!="string"?v(e,t||this.context):0;for(;r<i;r++){n=this[r];while(n&&(n.ownerDocument&&(n!==t&&n.nodeType!==
                        11))){if(o?o.index(n)>-1:v.find.matchesSelector(n,e)){s.push(n);break}n=n.parentNode}}return s=s.length>1?v.unique(s):s,this.pushStack(s,"closest",e)},index:function(e){return e?typeof e=="string"?v.inArray(this[0],v(e)):v.inArray(e.jquery?e[0]:e,this):this[0]&&this[0].parentNode?this.prevAll().length:-1},add:function(e,t){var n=typeof e=="string"?v(e,t):v.makeArray(e&&e.nodeType?[e]:e),r=v.merge(this.get(),n);return this.pushStack(ut(n[0])||ut(r[0])?r:v.unique(r))},addBack:function(e){return this.add(e==
                        null?this.prevObject:this.prevObject.filter(e))}}),v.fn.andSelf=v.fn.addBack,v.each({parent:function(e){var t=e.parentNode;return t&&t.nodeType!==11?t:null},parents:function(e){return v.dir(e,"parentNode")},parentsUntil:function(e,t,n){return v.dir(e,"parentNode",n)},next:function(e){return at(e,"nextSibling")},prev:function(e){return at(e,"previousSibling")},nextAll:function(e){return v.dir(e,"nextSibling")},prevAll:function(e){return v.dir(e,"previousSibling")},nextUntil:function(e,t,n){return v.dir(e,
                            "nextSibling",n)},prevUntil:function(e,t,n){return v.dir(e,"previousSibling",n)},siblings:function(e){return v.sibling((e.parentNode||{}).firstChild,e)},children:function(e){return v.sibling(e.firstChild)},contents:function(e){return v.nodeName(e,"iframe")?e.contentDocument||e.contentWindow.document:v.merge([],e.childNodes)}},function(e,t){v.fn[e]=function(n,r){var i=v.map(this,t,n);return nt.test(e)||(r=n),r&&(typeof r=="string"&&(i=v.filter(r,i))),i=this.length>1&&!ot[e]?v.unique(i):i,this.length>
                        1&&(rt.test(e)&&(i=i.reverse())),this.pushStack(i,e,l.call(arguments).join(","))}}),v.extend({filter:function(e,t,n){return n&&(e=":not("+e+")"),t.length===1?v.find.matchesSelector(t[0],e)?[t[0]]:[]:v.find.matches(e,t)},dir:function(e,n,r){var i=[],s=e[n];while(s&&(s.nodeType!==9&&(r===t||(s.nodeType!==1||!v(s).is(r)))))s.nodeType===1&&i.push(s),s=s[n];return i},sibling:function(e,t){var n=[];for(;e;e=e.nextSibling)e.nodeType===1&&(e!==t&&n.push(e));return n}});var ct="abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",
                            ht=/ jQuery\d+="(?:null|\d+)"/g,pt=/^\s+/,dt=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,vt=/<([\w:]+)/,mt=/<tbody/i,gt=/<|&#?\w+;/,yt=/<(?:script|style|link)/i,bt=/<(?:script|object|embed|option|style)/i,wt=new RegExp("<(?:"+ct+")[\\s/>]","i"),Et=/^(?:checkbox|radio)$/,St=/checked\s*(?:[^=]|=\s*.checked.)/i,xt=/\/(java|ecma)script/i,Tt=/^\s*<!(?:\[CDATA\[|\-\-)|[\]\-]{2}>\s*$/g,Nt={option:[1,"<select multiple='multiple'>","</select>"],legend:[1,"<fieldset>","</fieldset>"],
                                thead:[1,"<table>","</table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],col:[2,"<table><tbody></tbody><colgroup>","</colgroup></table>"],area:[1,"<map>","</map>"],_default:[0,"",""]},Ct=lt(i),kt=Ct.appendChild(i.createElement("div"));Nt.optgroup=Nt.option,Nt.tbody=Nt.tfoot=Nt.colgroup=Nt.caption=Nt.thead,Nt.th=Nt.td,v.support.htmlSerialize||(Nt._default=[1,"X<div>","</div>"]),v.fn.extend({text:function(e){return v.access(this,function(e){return e===
                        t?v.text(this):this.empty().append((this[0]&&this[0].ownerDocument||i).createTextNode(e))},null,e,arguments.length)},wrapAll:function(e){if(v.isFunction(e))return this.each(function(t){v(this).wrapAll(e.call(this,t))});if(this[0]){var t=v(e,this[0].ownerDocument).eq(0).clone(!0);this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){var e=this;while(e.firstChild&&e.firstChild.nodeType===1)e=e.firstChild;return e}).append(this)}return this},wrapInner:function(e){return v.isFunction(e)?this.each(function(t){v(this).wrapInner(e.call(this,
                            t))}):this.each(function(){var t=v(this),n=t.contents();n.length?n.wrapAll(e):t.append(e)})},wrap:function(e){var t=v.isFunction(e);return this.each(function(n){v(this).wrapAll(t?e.call(this,n):e)})},unwrap:function(){return this.parent().each(function(){v.nodeName(this,"body")||v(this).replaceWith(this.childNodes)}).end()},append:function(){return this.domManip(arguments,!0,function(e){(this.nodeType===1||this.nodeType===11)&&this.appendChild(e)})},prepend:function(){return this.domManip(arguments,
                            !0,function(e){(this.nodeType===1||this.nodeType===11)&&this.insertBefore(e,this.firstChild)})},before:function(){if(!ut(this[0]))return this.domManip(arguments,!1,function(e){this.parentNode.insertBefore(e,this)});if(arguments.length){var e=v.clean(arguments);return this.pushStack(v.merge(e,this),"before",this.selector)}},after:function(){if(!ut(this[0]))return this.domManip(arguments,!1,function(e){this.parentNode.insertBefore(e,this.nextSibling)});if(arguments.length){var e=v.clean(arguments);
                            return this.pushStack(v.merge(this,e),"after",this.selector)}},remove:function(e,t){var n,r=0;for(;(n=this[r])!=null;r++)if(!e||v.filter(e,[n]).length)!t&&(n.nodeType===1&&(v.cleanData(n.getElementsByTagName("*")),v.cleanData([n]))),n.parentNode&&n.parentNode.removeChild(n);return this},empty:function(){var e,t=0;for(;(e=this[t])!=null;t++){e.nodeType===1&&v.cleanData(e.getElementsByTagName("*"));while(e.firstChild)e.removeChild(e.firstChild)}return this},clone:function(e,t){return e=e==null?!1:e,
                            t=t==null?e:t,this.map(function(){return v.clone(this,e,t)})},html:function(e){return v.access(this,function(e){var n=this[0]||{},r=0,i=this.length;if(e===t)return n.nodeType===1?n.innerHTML.replace(ht,""):t;if(typeof e=="string"&&(!yt.test(e)&&((v.support.htmlSerialize||!wt.test(e))&&((v.support.leadingWhitespace||!pt.test(e))&&!Nt[(vt.exec(e)||["",""])[1].toLowerCase()])))){e=e.replace(dt,"<$1></$2>");try{for(;r<i;r++)n=this[r]||{},n.nodeType===1&&(v.cleanData(n.getElementsByTagName("*")),n.innerHTML=
                            e);n=0}catch(s){}}n&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(e){return ut(this[0])?this.length?this.pushStack(v(v.isFunction(e)?e():e),"replaceWith",e):this:v.isFunction(e)?this.each(function(t){var n=v(this),r=n.html();n.replaceWith(e.call(this,t,r))}):(typeof e!="string"&&(e=v(e).detach()),this.each(function(){var t=this.nextSibling,n=this.parentNode;v(this).remove(),t?v(t).before(e):v(n).append(e)}))},detach:function(e){return this.remove(e,!0)},domManip:function(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  n,r){e=[].concat.apply([],e);var i,s,o,u,a=0,f=e[0],l=[],c=this.length;if(!v.support.checkClone&&(c>1&&(typeof f=="string"&&St.test(f))))return this.each(function(){v(this).domManip(e,n,r)});if(v.isFunction(f))return this.each(function(i){var s=v(this);e[0]=f.call(this,i,n?s.html():t),s.domManip(e,n,r)});if(this[0]){i=v.buildFragment(e,this,l),o=i.fragment,s=o.firstChild,o.childNodes.length===1&&(o=s);if(s){n=n&&v.nodeName(s,"tr");for(u=i.cacheable||c-1;a<c;a++)r.call(n&&v.nodeName(this[a],"table")?
                            Lt(this[a],"tbody"):this[a],a===u?o:v.clone(o,!0,!0))}o=s=null,l.length&&v.each(l,function(e,t){t.src?v.ajax?v.ajax({url:t.src,type:"GET",dataType:"script",async:!1,global:!1,"throws":!0}):v.error("no ajax"):v.globalEval((t.text||(t.textContent||(t.innerHTML||""))).replace(Tt,"")),t.parentNode&&t.parentNode.removeChild(t)})}return this}}),v.buildFragment=function(e,n,r){var s,o,u,a=e[0];return n=n||i,n=!n.nodeType&&n[0]||n,n=n.ownerDocument||n,e.length===1&&(typeof a=="string"&&(a.length<512&&(n===
                        i&&(a.charAt(0)==="<"&&(!bt.test(a)&&((v.support.checkClone||!St.test(a))&&((v.support.html5Clone||!wt.test(a))&&(o=!0,s=v.fragments[a],u=s!==t)))))))),s||(s=n.createDocumentFragment(),v.clean(e,n,s,r),o&&(v.fragments[a]=u&&s)),{fragment:s,cacheable:o}},v.fragments={},v.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(e,t){v.fn[e]=function(n){var r,i=0,s=[],o=v(n),u=o.length,a=this.length===1&&this[0].parentNode;if((a==null||
                            a&&(a.nodeType===11&&a.childNodes.length===1))&&u===1)return o[t](this[0]),this;for(;i<u;i++)r=(i>0?this.clone(!0):this).get(),v(o[i])[t](r),s=s.concat(r);return this.pushStack(s,e,o.selector)}}),v.extend({clone:function(e,t,n){var r,i,s,o;v.support.html5Clone||(v.isXMLDoc(e)||!wt.test("<"+e.nodeName+">"))?o=e.cloneNode(!0):(kt.innerHTML=e.outerHTML,kt.removeChild(o=kt.firstChild));if((!v.support.noCloneEvent||!v.support.noCloneChecked)&&((e.nodeType===1||e.nodeType===11)&&!v.isXMLDoc(e))){Ot(e,o),
                            r=Mt(e),i=Mt(o);for(s=0;r[s];++s)i[s]&&Ot(r[s],i[s])}if(t){At(e,o);if(n){r=Mt(e),i=Mt(o);for(s=0;r[s];++s)At(r[s],i[s])}}return r=i=null,o},clean:function(e,t,n,r){var s,o,u,a,f,l,c,h,p,d,m,g,y=t===i&&Ct,b=[];if(!t||typeof t.createDocumentFragment=="undefined")t=i;for(s=0;(u=e[s])!=null;s++){typeof u=="number"&&(u+="");if(!u)continue;if(typeof u=="string")if(!gt.test(u))u=t.createTextNode(u);else{y=y||lt(t),c=t.createElement("div"),y.appendChild(c),u=u.replace(dt,"<$1></$2>"),a=(vt.exec(u)||["",""])[1].toLowerCase(),
                            f=Nt[a]||Nt._default,l=f[0],c.innerHTML=f[1]+u+f[2];while(l--)c=c.lastChild;if(!v.support.tbody){h=mt.test(u),p=a==="table"&&!h?c.firstChild&&c.firstChild.childNodes:f[1]==="<table>"&&!h?c.childNodes:[];for(o=p.length-1;o>=0;--o)v.nodeName(p[o],"tbody")&&(!p[o].childNodes.length&&p[o].parentNode.removeChild(p[o]))}!v.support.leadingWhitespace&&(pt.test(u)&&c.insertBefore(t.createTextNode(pt.exec(u)[0]),c.firstChild)),u=c.childNodes,c.parentNode.removeChild(c)}u.nodeType?b.push(u):v.merge(b,u)}c&&
                        (u=c=y=null);if(!v.support.appendChecked)for(s=0;(u=b[s])!=null;s++)v.nodeName(u,"input")?_t(u):typeof u.getElementsByTagName!="undefined"&&v.grep(u.getElementsByTagName("input"),_t);if(n){m=function(e){if(!e.type||xt.test(e.type))return r?r.push(e.parentNode?e.parentNode.removeChild(e):e):n.appendChild(e)};for(s=0;(u=b[s])!=null;s++)if(!v.nodeName(u,"script")||!m(u))n.appendChild(u),typeof u.getElementsByTagName!="undefined"&&(g=v.grep(v.merge([],u.getElementsByTagName("script")),m),b.splice.apply(b,
                            [s+1,0].concat(g)),s+=g.length)}return b},cleanData:function(e,t){var n,r,i,s,o=0,u=v.expando,a=v.cache,f=v.support.deleteExpando,l=v.event.special;for(;(i=e[o])!=null;o++)if(t||v.acceptData(i)){r=i[u],n=r&&a[r];if(n){if(n.events)for(s in n.events)l[s]?v.event.remove(i,s):v.removeEvent(i,s,n.handle);a[r]&&(delete a[r],f?delete i[u]:i.removeAttribute?i.removeAttribute(u):i[u]=null,v.deletedIds.push(r))}}}}),function(){var e,t;v.uaMatch=function(e){e=e.toLowerCase();var t=/(chrome)[ \/]([\w.]+)/.exec(e)||
                            (/(webkit)[ \/]([\w.]+)/.exec(e)||(/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(e)||(/(msie) ([\w.]+)/.exec(e)||(e.indexOf("compatible")<0&&/(mozilla)(?:.*? rv:([\w.]+)|)/.exec(e)||[]))));return{browser:t[1]||"",version:t[2]||"0"}},e=v.uaMatch(o.userAgent),t={},e.browser&&(t[e.browser]=!0,t.version=e.version),t.chrome?t.webkit=!0:t.webkit&&(t.safari=!0),v.browser=t,v.sub=function(){function e(t,n){return new e.fn.init(t,n)}v.extend(!0,e,this),e.superclass=this,e.fn=e.prototype=this(),e.fn.constructor=
                            e,e.sub=this.sub,e.fn.init=function(r,i){return i&&(i instanceof v&&(!(i instanceof e)&&(i=e(i)))),v.fn.init.call(this,r,i,t)},e.fn.init.prototype=e.fn;var t=e(i);return e}}();var Dt,Pt,Ht,Bt=/alpha\([^)]*\)/i,jt=/opacity=([^)]*)/,Ft=/^(top|right|bottom|left)$/,It=/^(none|table(?!-c[ea]).+)/,qt=/^margin/,Rt=new RegExp("^("+m+")(.*)$","i"),Ut=new RegExp("^("+m+")(?!px)[a-z%]+$","i"),zt=new RegExp("^([-+])=("+m+")","i"),Wt={BODY:"block"},Xt={position:"absolute",visibility:"hidden",display:"block"},
                            Vt={letterSpacing:0,fontWeight:400},$t=["Top","Right","Bottom","Left"],Jt=["Webkit","O","Moz","ms"],Kt=v.fn.toggle;v.fn.extend({css:function(e,n){return v.access(this,function(e,n,r){return r!==t?v.style(e,n,r):v.css(e,n)},e,n,arguments.length>1)},show:function(){return Yt(this,!0)},hide:function(){return Yt(this)},toggle:function(e,t){var n=typeof e=="boolean";return v.isFunction(e)&&v.isFunction(t)?Kt.apply(this,arguments):this.each(function(){(n?e:Gt(this))?v(this).show():v(this).hide()})}}),v.extend({cssHooks:{opacity:{get:function(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          t){if(t){var n=Dt(e,"opacity");return n===""?"1":n}}}},cssNumber:{fillOpacity:!0,fontWeight:!0,lineHeight:!0,opacity:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{"float":v.support.cssFloat?"cssFloat":"styleFloat"},style:function(e,n,r,i){if(!e||(e.nodeType===3||(e.nodeType===8||!e.style)))return;var s,o,u,a=v.camelCase(n),f=e.style;n=v.cssProps[a]||(v.cssProps[a]=Qt(f,a)),u=v.cssHooks[n]||v.cssHooks[a];if(r===t)return u&&("get"in u&&(s=u.get(e,!1,i))!==t)?s:f[n];o=typeof r,o==="string"&&((s=
                            zt.exec(r))&&(r=(s[1]+1)*s[2]+parseFloat(v.css(e,n)),o="number"));if(r==null||o==="number"&&isNaN(r))return;o==="number"&&(!v.cssNumber[a]&&(r+="px"));if(!u||(!("set"in u)||(r=u.set(e,r,i))!==t))try{f[n]=r}catch(l){}},css:function(e,n,r,i){var s,o,u,a=v.camelCase(n);return n=v.cssProps[a]||(v.cssProps[a]=Qt(e.style,a)),u=v.cssHooks[n]||v.cssHooks[a],u&&("get"in u&&(s=u.get(e,!0,i))),s===t&&(s=Dt(e,n)),s==="normal"&&(n in Vt&&(s=Vt[n])),r||i!==t?(o=parseFloat(s),r||v.isNumeric(o)?o||0:s):s},swap:function(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         t,n){var r,i,s={};for(i in t)s[i]=e.style[i],e.style[i]=t[i];r=n.call(e);for(i in t)e.style[i]=s[i];return r}}),e.getComputedStyle?Dt=function(t,n){var r,i,s,o,u=e.getComputedStyle(t,null),a=t.style;return u&&(r=u.getPropertyValue(n)||u[n],r===""&&(!v.contains(t.ownerDocument,t)&&(r=v.style(t,n))),Ut.test(r)&&(qt.test(n)&&(i=a.width,s=a.minWidth,o=a.maxWidth,a.minWidth=a.maxWidth=a.width=r,r=u.width,a.width=i,a.minWidth=s,a.maxWidth=o))),r}:i.documentElement.currentStyle&&(Dt=function(e,t){var n,
                            r,i=e.currentStyle&&e.currentStyle[t],s=e.style;return i==null&&(s&&(s[t]&&(i=s[t]))),Ut.test(i)&&(!Ft.test(t)&&(n=s.left,r=e.runtimeStyle&&e.runtimeStyle.left,r&&(e.runtimeStyle.left=e.currentStyle.left),s.left=t==="fontSize"?"1em":i,i=s.pixelLeft+"px",s.left=n,r&&(e.runtimeStyle.left=r))),i===""?"auto":i}),v.each(["height","width"],function(e,t){v.cssHooks[t]={get:function(e,n,r){if(n)return e.offsetWidth===0&&It.test(Dt(e,"display"))?v.swap(e,Xt,function(){return tn(e,t,r)}):tn(e,t,r)},set:function(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       n,r){return Zt(e,n,r?en(e,t,r,v.support.boxSizing&&v.css(e,"boxSizing")==="border-box"):0)}}}),v.support.opacity||(v.cssHooks.opacity={get:function(e,t){return jt.test((t&&e.currentStyle?e.currentStyle.filter:e.style.filter)||"")?0.01*parseFloat(RegExp.$1)+"":t?"1":""},set:function(e,t){var n=e.style,r=e.currentStyle,i=v.isNumeric(t)?"alpha(opacity="+t*100+")":"",s=r&&r.filter||(n.filter||"");n.zoom=1;if(t>=1&&(v.trim(s.replace(Bt,""))===""&&n.removeAttribute)){n.removeAttribute("filter");if(r&&!r.filter)return}n.filter=
                            Bt.test(s)?s.replace(Bt,i):s+" "+i}}),v(function(){v.support.reliableMarginRight||(v.cssHooks.marginRight={get:function(e,t){return v.swap(e,{display:"inline-block"},function(){if(t)return Dt(e,"marginRight")})}}),!v.support.pixelPosition&&(v.fn.position&&v.each(["top","left"],function(e,t){v.cssHooks[t]={get:function(e,n){if(n){var r=Dt(e,t);return Ut.test(r)?v(e).position()[t]+"px":r}}}}))}),v.expr&&(v.expr.filters&&(v.expr.filters.hidden=function(e){return e.offsetWidth===0&&e.offsetHeight===0||
                            !v.support.reliableHiddenOffsets&&(e.style&&e.style.display||Dt(e,"display"))==="none"},v.expr.filters.visible=function(e){return!v.expr.filters.hidden(e)})),v.each({margin:"",padding:"",border:"Width"},function(e,t){v.cssHooks[e+t]={expand:function(n){var r,i=typeof n=="string"?n.split(" "):[n],s={};for(r=0;r<4;r++)s[e+$t[r]+t]=i[r]||(i[r-2]||i[0]);return s}},qt.test(e)||(v.cssHooks[e+t].set=Zt)});var rn=/%20/g,sn=/\[\]$/,on=/\r?\n/g,un=/^(?:color|date|datetime|datetime-local|email|hidden|month|number|password|range|search|tel|text|time|url|week)$/i,
                            an=/^(?:select|textarea)/i;v.fn.extend({serialize:function(){return v.param(this.serializeArray())},serializeArray:function(){return this.map(function(){return this.elements?v.makeArray(this.elements):this}).filter(function(){return this.name&&(!this.disabled&&(this.checked||(an.test(this.nodeName)||un.test(this.type))))}).map(function(e,t){var n=v(this).val();return n==null?null:v.isArray(n)?v.map(n,function(e,n){return{name:t.name,value:e.replace(on,"\r\n")}}):{name:t.name,value:n.replace(on,"\r\n")}}).get()}}),
                            v.param=function(e,n){var r,i=[],s=function(e,t){t=v.isFunction(t)?t():t==null?"":t,i[i.length]=encodeURIComponent(e)+"="+encodeURIComponent(t)};n===t&&(n=v.ajaxSettings&&v.ajaxSettings.traditional);if(v.isArray(e)||e.jquery&&!v.isPlainObject(e))v.each(e,function(){s(this.name,this.value)});else for(r in e)fn(r,e[r],n,s);return i.join("&").replace(rn,"+")};var ln,cn,hn=/#.*$/,pn=/^(.*?):[ \t]*([^\r\n]*)\r?$/mg,dn=/^(?:about|app|app\-storage|.+\-extension|file|res|widget):$/,vn=/^(?:GET|HEAD)$/,mn=
                            /^\/\//,gn=/\?/,yn=/<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi,bn=/([?&])_=[^&]*/,wn=/^([\w\+\.\-]+:)(?:\/\/([^\/?#:]*)(?::(\d+)|)|)/,En=v.fn.load,Sn={},xn={},Tn=["*/"]+["*"];try{cn=s.href}catch(Nn){cn=i.createElement("a"),cn.href="",cn=cn.href}ln=wn.exec(cn.toLowerCase())||[],v.fn.load=function(e,n,r){if(typeof e!="string"&&En)return En.apply(this,arguments);if(!this.length)return this;var i,s,o,u=this,a=e.indexOf(" ");return a>=0&&(i=e.slice(a,e.length),e=e.slice(0,a)),v.isFunction(n)?
                            (r=n,n=t):n&&(typeof n=="object"&&(s="POST")),v.ajax({url:e,type:s,dataType:"html",data:n,complete:function(e,t){r&&u.each(r,o||[e.responseText,t,e])}}).done(function(e){o=arguments,u.html(i?v("<div>").append(e.replace(yn,"")).find(i):e)}),this},v.each("ajaxStart ajaxStop ajaxComplete ajaxError ajaxSuccess ajaxSend".split(" "),function(e,t){v.fn[t]=function(e){return this.on(t,e)}}),v.each(["get","post"],function(e,n){v[n]=function(e,r,i,s){return v.isFunction(r)&&(s=s||i,i=r,r=t),v.ajax({type:n,
                            url:e,data:r,success:i,dataType:s})}}),v.extend({getScript:function(e,n){return v.get(e,t,n,"script")},getJSON:function(e,t,n){return v.get(e,t,n,"json")},ajaxSetup:function(e,t){return t?Ln(e,v.ajaxSettings):(t=e,e=v.ajaxSettings),Ln(e,t),e},ajaxSettings:{url:cn,isLocal:dn.test(ln[1]),global:!0,type:"GET",contentType:"application/x-www-form-urlencoded; charset=UTF-8",processData:!0,async:!0,accepts:{xml:"application/xml, text/xml",html:"text/html",text:"text/plain",json:"application/json, text/javascript",
                            "*":Tn},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:"responseXML",text:"responseText"},converters:{"* text":e.String,"text html":!0,"text json":v.parseJSON,"text xml":v.parseXML},flatOptions:{context:!0,url:!0}},ajaxPrefilter:Cn(Sn),ajaxTransport:Cn(xn),ajax:function(e,n){function T(e,n,s,a){var l,y,b,w,S,T=n;if(E===2)return;E=2,u&&clearTimeout(u),o=t,i=a||"",x.readyState=e>0?4:0,s&&(w=An(c,x,s));if(e>=200&&e<300||e===304)c.ifModified&&(S=x.getResponseHeader("Last-Modified"),
                        S&&(v.lastModified[r]=S),S=x.getResponseHeader("Etag"),S&&(v.etag[r]=S)),e===304?(T="notmodified",l=!0):(l=On(c,w),T=l.state,y=l.data,b=l.error,l=!b);else{b=T;if(!T||e)T="error",e<0&&(e=0)}x.status=e,x.statusText=(n||T)+"",l?d.resolveWith(h,[y,T,x]):d.rejectWith(h,[x,T,b]),x.statusCode(g),g=t,f&&p.trigger("ajax"+(l?"Success":"Error"),[x,c,l?y:b]),m.fireWith(h,[x,T]),f&&(p.trigger("ajaxComplete",[x,c]),--v.active||v.event.trigger("ajaxStop"))}typeof e=="object"&&(n=e,e=t),n=n||{};var r,i,s,o,u,a,f,
                            l,c=v.ajaxSetup({},n),h=c.context||c,p=h!==c&&(h.nodeType||h instanceof v)?v(h):v.event,d=v.Deferred(),m=v.Callbacks("once memory"),g=c.statusCode||{},b={},w={},E=0,S="canceled",x={readyState:0,setRequestHeader:function(e,t){if(!E){var n=e.toLowerCase();e=w[n]=w[n]||e,b[e]=t}return this},getAllResponseHeaders:function(){return E===2?i:null},getResponseHeader:function(e){var n;if(E===2){if(!s){s={};while(n=pn.exec(i))s[n[1].toLowerCase()]=n[2]}n=s[e.toLowerCase()]}return n===t?null:n},overrideMimeType:function(e){return E||
                            (c.mimeType=e),this},abort:function(e){return e=e||S,o&&o.abort(e),T(0,e),this}};d.promise(x),x.success=x.done,x.error=x.fail,x.complete=m.add,x.statusCode=function(e){if(e){var t;if(E<2)for(t in e)g[t]=[g[t],e[t]];else t=e[x.status],x.always(t)}return this},c.url=((e||c.url)+"").replace(hn,"").replace(mn,ln[1]+"//"),c.dataTypes=v.trim(c.dataType||"*").toLowerCase().split(y),c.crossDomain==null&&(a=wn.exec(c.url.toLowerCase()),c.crossDomain=!(!a||a[1]===ln[1]&&(a[2]===ln[2]&&(a[3]||(a[1]==="http:"?
                            80:443))==(ln[3]||(ln[1]==="http:"?80:443))))),c.data&&(c.processData&&(typeof c.data!="string"&&(c.data=v.param(c.data,c.traditional)))),kn(Sn,c,n,x);if(E===2)return x;f=c.global,c.type=c.type.toUpperCase(),c.hasContent=!vn.test(c.type),f&&(v.active++===0&&v.event.trigger("ajaxStart"));if(!c.hasContent){c.data&&(c.url+=(gn.test(c.url)?"&":"?")+c.data,delete c.data),r=c.url;if(c.cache===!1){var N=v.now(),C=c.url.replace(bn,"$1_="+N);c.url=C+(C===c.url?(gn.test(c.url)?"&":"?")+"_="+N:"")}}(c.data&&
                        (c.hasContent&&c.contentType!==!1)||n.contentType)&&x.setRequestHeader("Content-Type",c.contentType),c.ifModified&&(r=r||c.url,v.lastModified[r]&&x.setRequestHeader("If-Modified-Since",v.lastModified[r]),v.etag[r]&&x.setRequestHeader("If-None-Match",v.etag[r])),x.setRequestHeader("Accept",c.dataTypes[0]&&c.accepts[c.dataTypes[0]]?c.accepts[c.dataTypes[0]]+(c.dataTypes[0]!=="*"?", "+Tn+"; q=0.01":""):c.accepts["*"]);for(l in c.headers)x.setRequestHeader(l,c.headers[l]);if(!c.beforeSend||c.beforeSend.call(h,
                                x,c)!==!1&&E!==2){S="abort";for(l in{success:1,error:1,complete:1})x[l](c[l]);o=kn(xn,c,n,x);if(!o)T(-1,"No Transport");else{x.readyState=1,f&&p.trigger("ajaxSend",[x,c]),c.async&&(c.timeout>0&&(u=setTimeout(function(){x.abort("timeout")},c.timeout)));try{E=1,o.send(b,T)}catch(k){if(!(E<2))throw k;T(-1,k)}}return x}return x.abort()},active:0,lastModified:{},etag:{}});var Mn=[],_n=/\?/,Dn=/(=)\?(?=&|$)|\?\?/,Pn=v.now();v.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=Mn.pop()||v.expando+
                            "_"+Pn++;return this[e]=!0,e}}),v.ajaxPrefilter("json jsonp",function(n,r,i){var s,o,u,a=n.data,f=n.url,l=n.jsonp!==!1,c=l&&Dn.test(f),h=l&&(!c&&(typeof a=="string"&&(!(n.contentType||"").indexOf("application/x-www-form-urlencoded")&&Dn.test(a))));if(n.dataTypes[0]==="jsonp"||(c||h))return s=n.jsonpCallback=v.isFunction(n.jsonpCallback)?n.jsonpCallback():n.jsonpCallback,o=e[s],c?n.url=f.replace(Dn,"$1"+s):h?n.data=a.replace(Dn,"$1"+s):l&&(n.url+=(_n.test(f)?"&":"?")+n.jsonp+"="+s),n.converters["script json"]=
                            function(){return u||v.error(s+" was not called"),u[0]},n.dataTypes[0]="json",e[s]=function(){u=arguments},i.always(function(){e[s]=o,n[s]&&(n.jsonpCallback=r.jsonpCallback,Mn.push(s)),u&&(v.isFunction(o)&&o(u[0])),u=o=t}),"script"}),v.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/javascript|ecmascript/},converters:{"text script":function(e){return v.globalEval(e),e}}}),v.ajaxPrefilter("script",function(e){e.cache===
                        t&&(e.cache=!1),e.crossDomain&&(e.type="GET",e.global=!1)}),v.ajaxTransport("script",function(e){if(e.crossDomain){var n,r=i.head||(i.getElementsByTagName("head")[0]||i.documentElement);return{send:function(s,o){n=i.createElement("script"),n.async="async",e.scriptCharset&&(n.charset=e.scriptCharset),n.src=e.url,n.onload=n.onreadystatechange=function(e,i){if(i||(!n.readyState||/loaded|complete/.test(n.readyState)))n.onload=n.onreadystatechange=null,r&&(n.parentNode&&r.removeChild(n)),n=t,i||o(200,
                            "success")},r.insertBefore(n,r.firstChild)},abort:function(){n&&n.onload(0,1)}}}});var Hn,Bn=e.ActiveXObject?function(){for(var e in Hn)Hn[e](0,1)}:!1,jn=0;v.ajaxSettings.xhr=e.ActiveXObject?function(){return!this.isLocal&&Fn()||In()}:Fn,function(e){v.extend(v.support,{ajax:!!e,cors:!!e&&"withCredentials"in e})}(v.ajaxSettings.xhr()),v.support.ajax&&v.ajaxTransport(function(n){if(!n.crossDomain||v.support.cors){var r;return{send:function(i,s){var o,u,a=n.xhr();n.username?a.open(n.type,n.url,n.async,
                            n.username,n.password):a.open(n.type,n.url,n.async);if(n.xhrFields)for(u in n.xhrFields)a[u]=n.xhrFields[u];n.mimeType&&(a.overrideMimeType&&a.overrideMimeType(n.mimeType)),!n.crossDomain&&(!i["X-Requested-With"]&&(i["X-Requested-With"]="XMLHttpRequest"));try{for(u in i)a.setRequestHeader(u,i[u])}catch(f){}a.send(n.hasContent&&n.data||null),r=function(e,i){var u,f,l,c,h;try{if(r&&(i||a.readyState===4)){r=t,o&&(a.onreadystatechange=v.noop,Bn&&delete Hn[o]);if(i)a.readyState!==4&&a.abort();else{u=a.status,
                            l=a.getAllResponseHeaders(),c={},h=a.responseXML,h&&(h.documentElement&&(c.xml=h));try{c.text=a.responseText}catch(p){}try{f=a.statusText}catch(p){f=""}!u&&(n.isLocal&&!n.crossDomain)?u=c.text?200:404:u===1223&&(u=204)}}}catch(d){i||s(-1,d)}c&&s(u,f,c,l)},n.async?a.readyState===4?setTimeout(r,0):(o=++jn,Bn&&(Hn||(Hn={},v(e).unload(Bn)),Hn[o]=r),a.onreadystatechange=r):r()},abort:function(){r&&r(0,1)}}}});var qn,Rn,Un=/^(?:toggle|show|hide)$/,zn=new RegExp("^(?:([-+])=|)("+m+")([a-z%]*)$","i"),Wn=
                            /queueHooks$/,Xn=[Gn],Vn={"*":[function(e,t){var n,r,i=this.createTween(e,t),s=zn.exec(t),o=i.cur(),u=+o||0,a=1,f=20;if(s){n=+s[2],r=s[3]||(v.cssNumber[e]?"":"px");if(r!=="px"&&u){u=v.css(i.elem,e,!0)||(n||1);do a=a||".5",u/=a,v.style(i.elem,e,u+r);while(a!==(a=i.cur()/o)&&(a!==1&&--f))}i.unit=r,i.start=u,i.end=s[1]?u+(s[1]+1)*n:n}return i}]};v.Animation=v.extend(Kn,{tweener:function(e,t){v.isFunction(e)?(t=e,e=["*"]):e=e.split(" ");var n,r=0,i=e.length;for(;r<i;r++)n=e[r],Vn[n]=Vn[n]||[],Vn[n].unshift(t)},
                            prefilter:function(e,t){t?Xn.unshift(e):Xn.push(e)}}),v.Tween=Yn,Yn.prototype={constructor:Yn,init:function(e,t,n,r,i,s){this.elem=e,this.prop=n,this.easing=i||"swing",this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=s||(v.cssNumber[n]?"":"px")},cur:function(){var e=Yn.propHooks[this.prop];return e&&e.get?e.get(this):Yn.propHooks._default.get(this)},run:function(e){var t,n=Yn.propHooks[this.prop];return this.options.duration?this.pos=t=v.easing[this.easing](e,this.options.duration*
                            e,0,1,this.options.duration):this.pos=t=e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):Yn.propHooks._default.set(this),this}},Yn.prototype.init.prototype=Yn.prototype,Yn.propHooks={_default:{get:function(e){var t;return e.elem[e.prop]==null||!!e.elem.style&&e.elem.style[e.prop]!=null?(t=v.css(e.elem,e.prop,!1,""),!t||t==="auto"?0:t):e.elem[e.prop]},set:function(e){v.fx.step[e.prop]?v.fx.step[e.prop](e):e.elem.style&&
                        (e.elem.style[v.cssProps[e.prop]]!=null||v.cssHooks[e.prop])?v.style(e.elem,e.prop,e.now+e.unit):e.elem[e.prop]=e.now}}},Yn.propHooks.scrollTop=Yn.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&(e.elem.parentNode&&(e.elem[e.prop]=e.now))}},v.each(["toggle","show","hide"],function(e,t){var n=v.fn[t];v.fn[t]=function(r,i,s){return r==null||(typeof r=="boolean"||!e&&(v.isFunction(r)&&v.isFunction(i)))?n.apply(this,arguments):this.animate(Zn(t,!0),r,i,s)}}),v.fn.extend({fadeTo:function(e,t,n,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       r){return this.filter(Gt).css("opacity",0).show().end().animate({opacity:t},e,n,r)},animate:function(e,t,n,r){var i=v.isEmptyObject(e),s=v.speed(t,n,r),o=function(){var t=Kn(this,v.extend({},e),s);i&&t.stop(!0)};return i||s.queue===!1?this.each(o):this.queue(s.queue,o)},stop:function(e,n,r){var i=function(e){var t=e.stop;delete e.stop,t(r)};return typeof e!="string"&&(r=n,n=e,e=t),n&&(e!==!1&&this.queue(e||"fx",[])),this.each(function(){var t=!0,n=e!=null&&e+"queueHooks",s=v.timers,o=v._data(this);
                            if(n)o[n]&&(o[n].stop&&i(o[n]));else for(n in o)o[n]&&(o[n].stop&&(Wn.test(n)&&i(o[n])));for(n=s.length;n--;)s[n].elem===this&&((e==null||s[n].queue===e)&&(s[n].anim.stop(r),t=!1,s.splice(n,1)));(t||!r)&&v.dequeue(this,e)})}}),v.each({slideDown:Zn("show"),slideUp:Zn("hide"),slideToggle:Zn("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(e,t){v.fn[e]=function(e,n,r){return this.animate(t,e,n,r)}}),v.speed=function(e,t,n){var r=e&&typeof e=="object"?
                            v.extend({},e):{complete:n||(!n&&t||v.isFunction(e)&&e),duration:e,easing:n&&t||t&&(!v.isFunction(t)&&t)};r.duration=v.fx.off?0:typeof r.duration=="number"?r.duration:r.duration in v.fx.speeds?v.fx.speeds[r.duration]:v.fx.speeds._default;if(r.queue==null||r.queue===!0)r.queue="fx";return r.old=r.complete,r.complete=function(){v.isFunction(r.old)&&r.old.call(this),r.queue&&v.dequeue(this,r.queue)},r},v.easing={linear:function(e){return e},swing:function(e){return 0.5-Math.cos(e*Math.PI)/2}},v.timers=
                            [],v.fx=Yn.prototype.init,v.fx.tick=function(){var e,n=v.timers,r=0;qn=v.now();for(;r<n.length;r++)e=n[r],!e()&&(n[r]===e&&n.splice(r--,1));n.length||v.fx.stop(),qn=t},v.fx.timer=function(e){e()&&(v.timers.push(e)&&(!Rn&&(Rn=setInterval(v.fx.tick,v.fx.interval))))},v.fx.interval=13,v.fx.stop=function(){clearInterval(Rn),Rn=null},v.fx.speeds={slow:600,fast:200,_default:400},v.fx.step={},v.expr&&(v.expr.filters&&(v.expr.filters.animated=function(e){return v.grep(v.timers,function(t){return e===t.elem}).length}));
                        var er=/^(?:body|html)$/i;v.fn.offset=function(e){if(arguments.length)return e===t?this:this.each(function(t){v.offset.setOffset(this,e,t)});var n,r,i,s,o,u,a,f={top:0,left:0},l=this[0],c=l&&l.ownerDocument;if(!c)return;return(r=c.body)===l?v.offset.bodyOffset(l):(n=c.documentElement,v.contains(n,l)?(typeof l.getBoundingClientRect!="undefined"&&(f=l.getBoundingClientRect()),i=tr(c),s=n.clientTop||(r.clientTop||0),o=n.clientLeft||(r.clientLeft||0),u=i.pageYOffset||n.scrollTop,a=i.pageXOffset||n.scrollLeft,
                        {top:f.top+u-s,left:f.left+a-o}):f)},v.offset={bodyOffset:function(e){var t=e.offsetTop,n=e.offsetLeft;return v.support.doesNotIncludeMarginInBodyOffset&&(t+=parseFloat(v.css(e,"marginTop"))||0,n+=parseFloat(v.css(e,"marginLeft"))||0),{top:t,left:n}},setOffset:function(e,t,n){var r=v.css(e,"position");r==="static"&&(e.style.position="relative");var i=v(e),s=i.offset(),o=v.css(e,"top"),u=v.css(e,"left"),a=(r==="absolute"||r==="fixed")&&v.inArray("auto",[o,u])>-1,f={},l={},c,h;a?(l=i.position(),c=l.top,
                            h=l.left):(c=parseFloat(o)||0,h=parseFloat(u)||0),v.isFunction(t)&&(t=t.call(e,n,s)),t.top!=null&&(f.top=t.top-s.top+c),t.left!=null&&(f.left=t.left-s.left+h),"using"in t?t.using.call(e,f):i.css(f)}},v.fn.extend({position:function(){if(!this[0])return;var e=this[0],t=this.offsetParent(),n=this.offset(),r=er.test(t[0].nodeName)?{top:0,left:0}:t.offset();return n.top-=parseFloat(v.css(e,"marginTop"))||0,n.left-=parseFloat(v.css(e,"marginLeft"))||0,r.top+=parseFloat(v.css(t[0],"borderTopWidth"))||0,
                            r.left+=parseFloat(v.css(t[0],"borderLeftWidth"))||0,{top:n.top-r.top,left:n.left-r.left}},offsetParent:function(){return this.map(function(){var e=this.offsetParent||i.body;while(e&&(!er.test(e.nodeName)&&v.css(e,"position")==="static"))e=e.offsetParent;return e||i.body})}}),v.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(e,n){var r=/Y/.test(n);v.fn[e]=function(i){return v.access(this,function(e,i,s){var o=tr(e);if(s===t)return o?n in o?o[n]:o.document.documentElement[i]:e[i];
                            o?o.scrollTo(r?v(o).scrollLeft():s,r?s:v(o).scrollTop()):e[i]=s},e,i,arguments.length,null)}}),v.each({Height:"height",Width:"width"},function(e,n){v.each({padding:"inner"+e,content:n,"":"outer"+e},function(r,i){v.fn[i]=function(i,s){var o=arguments.length&&(r||typeof i!="boolean"),u=r||(i===!0||s===!0?"margin":"border");return v.access(this,function(n,r,i){var s;return v.isWindow(n)?n.document.documentElement["client"+e]:n.nodeType===9?(s=n.documentElement,Math.max(n.body["scroll"+e],s["scroll"+
                        e],n.body["offset"+e],s["offset"+e],s["client"+e])):i===t?v.css(n,r,i,u):v.style(n,r,i,u)},n,o?i:t,o,null)}})}),e.jQuery=e.$=v})(window);
                    (function(a){var r=a.fn.domManip,d="_tmplitem",q=/^[^<]*(<[\w\W]+>)[^>]*$|\{\{\! /,b={},f={},e,p={key:0,data:{}},i=0,c=0,l=[];function g(g,d,h,e){var c={data:e||(e===0||e===false)?e:d?d.data:{},_wrap:d?d._wrap:null,tmpl:null,parent:d||null,nodes:[],calls:u,nest:w,wrap:x,html:v,update:t};g&&a.extend(c,g,{nodes:[],parent:d});if(h){c.tmpl=h;c._ctnt=c._ctnt||c.tmpl(a,c);c.key=++i;(l.length?f:b)[i]=c}return c}a.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},
                        function(f,d){a.fn[f]=function(n){var g=[],i=a(n),k,h,m,l,j=this.length===1&&this[0].parentNode;e=b||{};if(j&&(j.nodeType===11&&(j.childNodes.length===1&&i.length===1))){i[d](this[0]);g=this}else{for(h=0,m=i.length;h<m;h++){c=h;k=(h>0?this.clone(true):this).get();a(i[h])[d](k);g=g.concat(k)}c=0;g=this.pushStack(g,f,i.selector)}l=e;e=null;a.tmpl.complete(l);return g}});a.fn.extend({tmpl:function(d,c,b){return a.tmpl(this[0],d,c,b)},tmplItem:function(){return a.tmplItem(this[0])},template:function(b){return a.template(b,
                        this[0])},domManip:function(d,m,k){if(d[0]&&a.isArray(d[0])){var g=a.makeArray(arguments),h=d[0],j=h.length,i=0,f;while(i<j&&!(f=a.data(h[i++],"tmplItem")));if(f&&c)g[2]=function(b){a.tmpl.afterManip(this,b,k)};r.apply(this,g)}else r.apply(this,arguments);c=0;!e&&a.tmpl.complete(b);return this}});a.extend({tmpl:function(d,h,e,c){var i,k=!c;if(k){c=p;d=a.template[d]||a.template(null,d);f={}}else if(!d){d=c.tmpl;b[c.key]=c;c.nodes=[];c.wrapped&&n(c,c.wrapped);return a(j(c,null,c.tmpl(a,c)))}if(!d)return[];
                        if(typeof h==="function")h=h.call(c||{});e&&(e.wrapped&&n(e,e.wrapped));i=a.isArray(h)?a.map(h,function(a){return a?g(e,c,d,a):null}):[g(e,c,d,h)];return k?a(j(c,null,i)):i},tmplItem:function(b){var c;if(b instanceof a)b=b[0];while(b&&(b.nodeType===1&&(!(c=a.data(b,"tmplItem"))&&(b=b.parentNode))));return c||p},template:function(c,b){if(b){if(typeof b==="string")b=o(b);else if(b instanceof a)b=b[0]||{};if(b.nodeType)b=a.data(b,"tmpl")||a.data(b,"tmpl",o(b.innerHTML));return typeof c==="string"?a.template[c]=
                        b:b}return c?typeof c!=="string"?a.template(null,c):a.template[c]||a.template(null,q.test(c)?c:a(c)):null},encode:function(a){return(""+a).split("<").join("&lt;").split(">").join("&gt;").split('"').join("&#34;").split("'").join("&#39;")}});a.extend(a.tmpl,{tag:{tmpl:{_default:{$2:"null"},open:"if($notnull_1){__=__.concat($item.nest($1,$2));}"},wrap:{_default:{$2:"null"},open:"$item.calls(__,$1,$2);__=[];",close:"call=$item.calls();__=call._.concat($item.wrap(call,__));"},each:{_default:{$2:"$index, $value"},
                        open:"if($notnull_1){$.each($1a,function($2){with(this){",close:"}});}"},"if":{open:"if(($notnull_1) && $1a){",close:"}"},"else":{_default:{$1:"true"},open:"}else if(($notnull_1) && $1a){"},html:{open:"if($notnull_1){__.push($1a);}"},"=":{_default:{$1:"$data"},open:"if($notnull_1){__.push($.encode($1a));}"},"!":{open:""}},complete:function(){b={}},afterManip:function(f,b,d){var e=b.nodeType===11?a.makeArray(b.childNodes):b.nodeType===1?[b]:[];d.call(f,b);m(e);c++}});function j(e,g,f){var b,c=f?a.map(f,
                        function(a){return typeof a==="string"?e.key?a.replace(/(<\w+)(?=[\s>])(?![^>]*_tmplitem)([^>]*)/g,"$1 "+d+'="'+e.key+'" $2'):a:j(a,e,a._ctnt)}):e;if(g)return c;c=c.join("");c.replace(/^\s*([^<\s][^<]*)?(<[\w\W]+>)([^>]*[^>\s])?\s*$/,function(f,c,e,d){b=a(e).get();m(b);if(c)b=k(c).concat(b);if(d)b=b.concat(k(d))});return b?b:k(c)}function k(c){var b=document.createElement("div");b.innerHTML=c;return a.makeArray(b.childNodes)}function o(b){return new Function("jQuery","$item","var $=jQuery,call,__=[],$data=$item.data;with($data){__.push('"+
                        a.trim(b).replace(/([\\'])/g,"\\$1").replace(/[\r\t\n]/g," ").replace(/\$\{([^\}]*)\}/g,"{{= $1}}").replace(/\{\{(\/?)(\w+|.)(?:\(((?:[^\}]|\}(?!\}))*?)?\))?(?:\s+(.*?)?)?(\(((?:[^\}]|\}(?!\}))*?)\))?\s*\}\}/g,function(m,l,k,g,b,c,d){var j=a.tmpl.tag[k],i,e,f;if(!j)throw"Unknown template tag: "+k;i=j._default||[];if(c&&!/\w$/.test(b)){b+=c;c=""}if(b){b=h(b);d=d?","+h(d)+")":c?")":"";e=c?b.indexOf(".")>-1?b+h(c):"("+b+").call($item"+d:b;f=c?e:"(typeof("+b+")==='function'?("+b+").call($item):("+b+"))"}else f=
                            e=i.$1||"null";g=h(g);return"');"+j[l?"close":"open"].split("$notnull_1").join(b?"typeof("+b+")!=='undefined' && ("+b+")!=null":"true").split("$1a").join(f).split("$1").join(e).split("$2").join(g||(i.$2||""))+"__.push('"})+"');}return __;")}function n(c,b){c._wrap=j(c,true,a.isArray(b)?b:[q.test(b)?b:a(b).html()]).join("")}function h(a){return a?a.replace(/\\'/g,"'").replace(/\\\\/g,"\\"):null}function s(b){var a=document.createElement("div");a.appendChild(b.cloneNode(true));return a.innerHTML}function m(o){var n=
                        "_"+c,k,j,l={},e,p,h;for(e=0,p=o.length;e<p;e++){if((k=o[e]).nodeType!==1)continue;j=k.getElementsByTagName("*");for(h=j.length-1;h>=0;h--)m(j[h]);m(k)}function m(j){var p,h=j,k,e,m;if(m=j.getAttribute(d)){while(h.parentNode&&((h=h.parentNode).nodeType===1&&!(p=h.getAttribute(d))));if(p!==m){h=h.parentNode?h.nodeType===11?0:h.getAttribute(d)||0:0;if(!(e=b[m])){e=f[m];e=g(e,b[h]||f[h]);e.key=++i;b[i]=e}c&&o(m)}j.removeAttribute(d)}else if(c&&(e=a.data(j,"tmplItem"))){o(e.key);b[e.key]=e;h=a.data(j.parentNode,
                        "tmplItem");h=h?h.key:0}if(e){k=e;while(k&&k.key!=h){k.nodes.push(j);k=k.parent}delete e._ctnt;delete e._wrap;a.data(j,"tmplItem",e)}function o(a){a=a+n;e=l[a]=l[a]||g(e,b[e.parent.key+n]||e.parent)}}}function u(a,d,c,b){if(!a)return l.pop();l.push({_:a,tmpl:d,item:this,data:c,options:b})}function w(d,c,b){return a.tmpl(a.template(d),c,b,this)}function x(b,d){var c=b.options||{};c.wrapped=d;return a.tmpl(a.template(b.tmpl),b.data,c,b.item)}function v(d,c){var b=this._wrap;return a.map(a(a.isArray(b)?
                        b.join(""):b).filter(d||"*"),function(a){return c?a.innerText||a.textContent:a.outerHTML||s(a)})}function t(){var b=this.nodes;a.tmpl(null,null,null,this).insertBefore(b[0]);a(b).remove()}})(jQuery);
                    (function(e,t){function i(t,i){var n,a,o,r=t.nodeName.toLowerCase();return"area"===r?(n=t.parentNode,a=n.name,t.href&&(a&&"map"===n.nodeName.toLowerCase())?(o=e("img[usemap=#"+a+"]")[0],!!o&&s(o)):!1):(/input|select|textarea|button|object/.test(r)?!t.disabled:"a"===r?t.href||i:i)&&s(t)}function s(t){return e.expr.filters.visible(t)&&!e(t).parents().addBack().filter(function(){return"hidden"===e.css(this,"visibility")}).length}var n=0,a=/^ui-id-\d+$/;e.ui=e.ui||{},e.extend(e.ui,{version:"1.10.4",keyCode:{BACKSPACE:8,
                        COMMA:188,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,LEFT:37,NUMPAD_ADD:107,NUMPAD_DECIMAL:110,NUMPAD_DIVIDE:111,NUMPAD_ENTER:108,NUMPAD_MULTIPLY:106,NUMPAD_SUBTRACT:109,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SPACE:32,TAB:9,UP:38}}),e.fn.extend({focus:function(t){return function(i,s){return"number"==typeof i?this.each(function(){var t=this;setTimeout(function(){e(t).focus(),s&&s.call(t)},i)}):t.apply(this,arguments)}}(e.fn.focus),scrollParent:function(){var t;return t=e.ui.ie&&/(static|relative)/.test(this.css("position"))||
                    /absolute/.test(this.css("position"))?this.parents().filter(function(){return/(relative|absolute|fixed)/.test(e.css(this,"position"))&&/(auto|scroll)/.test(e.css(this,"overflow")+e.css(this,"overflow-y")+e.css(this,"overflow-x"))}).eq(0):this.parents().filter(function(){return/(auto|scroll)/.test(e.css(this,"overflow")+e.css(this,"overflow-y")+e.css(this,"overflow-x"))}).eq(0),/fixed/.test(this.css("position"))||!t.length?e(document):t},zIndex:function(i){if(i!==t)return this.css("zIndex",i);if(this.length)for(var s,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            n,a=e(this[0]);a.length&&a[0]!==document;){if(s=a.css("position"),("absolute"===s||("relative"===s||"fixed"===s))&&(n=parseInt(a.css("zIndex"),10),!isNaN(n)&&0!==n))return n;a=a.parent()}return 0},uniqueId:function(){return this.each(function(){this.id||(this.id="ui-id-"+ ++n)})},removeUniqueId:function(){return this.each(function(){a.test(this.id)&&e(this).removeAttr("id")})}}),e.extend(e.expr[":"],{data:e.expr.createPseudo?e.expr.createPseudo(function(t){return function(i){return!!e.data(i,t)}}):
                        function(t,i,s){return!!e.data(t,s[3])},focusable:function(t){return i(t,!isNaN(e.attr(t,"tabindex")))},tabbable:function(t){var s=e.attr(t,"tabindex"),n=isNaN(s);return(n||s>=0)&&i(t,!n)}}),e("<a>").outerWidth(1).jquery||e.each(["Width","Height"],function(i,s){function n(t,i,s,n){return e.each(a,function(){i-=parseFloat(e.css(t,"padding"+this))||0,s&&(i-=parseFloat(e.css(t,"border"+this+"Width"))||0),n&&(i-=parseFloat(e.css(t,"margin"+this))||0)}),i}var a="Width"===s?["Left","Right"]:["Top","Bottom"],
                        o=s.toLowerCase(),r={innerWidth:e.fn.innerWidth,innerHeight:e.fn.innerHeight,outerWidth:e.fn.outerWidth,outerHeight:e.fn.outerHeight};e.fn["inner"+s]=function(i){return i===t?r["inner"+s].call(this):this.each(function(){e(this).css(o,n(this,i)+"px")})},e.fn["outer"+s]=function(t,i){return"number"!=typeof t?r["outer"+s].call(this,t):this.each(function(){e(this).css(o,n(this,t,!0,i)+"px")})}}),e.fn.addBack||(e.fn.addBack=function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}),
                    e("<a>").data("a-b","a").removeData("a-b").data("a-b")&&(e.fn.removeData=function(t){return function(i){return arguments.length?t.call(this,e.camelCase(i)):t.call(this)}}(e.fn.removeData)),e.ui.ie=!!/msie [\w.]+/.exec(navigator.userAgent.toLowerCase()),e.support.selectstart="onselectstart"in document.createElement("div"),e.fn.extend({disableSelection:function(){return this.bind((e.support.selectstart?"selectstart":"mousedown")+".ui-disableSelection",function(e){e.preventDefault()})},enableSelection:function(){return this.unbind(".ui-disableSelection")}}),
                        e.extend(e.ui,{plugin:{add:function(t,i,s){var n,a=e.ui[t].prototype;for(n in s)a.plugins[n]=a.plugins[n]||[],a.plugins[n].push([i,s[n]])},call:function(e,t,i){var s,n=e.plugins[t];if(n&&(e.element[0].parentNode&&11!==e.element[0].parentNode.nodeType))for(s=0;n.length>s;s++)e.options[n[s][0]]&&n[s][1].apply(e.element,i)}},hasScroll:function(t,i){if("hidden"===e(t).css("overflow"))return!1;var s=i&&"left"===i?"scrollLeft":"scrollTop",n=!1;return t[s]>0?!0:(t[s]=1,n=t[s]>0,t[s]=0,n)}})})(jQuery);
                    (function(e,t){var i=0,s=Array.prototype.slice,n=e.cleanData;e.cleanData=function(t){for(var i,s=0;null!=(i=t[s]);s++)try{e(i).triggerHandler("remove")}catch(a){}n(t)},e.widget=function(i,s,n){var a,o,r,h,l={},u=i.split(".")[0];i=i.split(".")[1],a=u+"-"+i,n||(n=s,s=e.Widget),e.expr[":"][a.toLowerCase()]=function(t){return!!e.data(t,a)},e[u]=e[u]||{},o=e[u][i],r=e[u][i]=function(e,i){return this._createWidget?(arguments.length&&this._createWidget(e,i),t):new r(e,i)},e.extend(r,o,{version:n.version,
                        _proto:e.extend({},n),_childConstructors:[]}),h=new s,h.options=e.widget.extend({},h.options),e.each(n,function(i,n){return e.isFunction(n)?(l[i]=function(){var e=function(){return s.prototype[i].apply(this,arguments)},t=function(e){return s.prototype[i].apply(this,e)};return function(){var i,s=this._super,a=this._superApply;return this._super=e,this._superApply=t,i=n.apply(this,arguments),this._super=s,this._superApply=a,i}}(),t):(l[i]=n,t)}),r.prototype=e.widget.extend(h,{widgetEventPrefix:o?h.widgetEventPrefix||
                    i:i},l,{constructor:r,namespace:u,widgetName:i,widgetFullName:a}),o?(e.each(o._childConstructors,function(t,i){var s=i.prototype;e.widget(s.namespace+"."+s.widgetName,r,i._proto)}),delete o._childConstructors):s._childConstructors.push(r),e.widget.bridge(i,r)},e.widget.extend=function(i){for(var n,a,o=s.call(arguments,1),r=0,h=o.length;h>r;r++)for(n in o[r])a=o[r][n],o[r].hasOwnProperty(n)&&(a!==t&&(i[n]=e.isPlainObject(a)?e.isPlainObject(i[n])?e.widget.extend({},i[n],a):e.widget.extend({},a):a));
                        return i},e.widget.bridge=function(i,n){var a=n.prototype.widgetFullName||i;e.fn[i]=function(o){var r="string"==typeof o,h=s.call(arguments,1),l=this;return o=!r&&h.length?e.widget.extend.apply(null,[o].concat(h)):o,r?this.each(function(){var s,n=e.data(this,a);return n?e.isFunction(n[o])&&"_"!==o.charAt(0)?(s=n[o].apply(n,h),s!==n&&s!==t?(l=s&&s.jquery?l.pushStack(s.get()):s,!1):t):e.error("no such method '"+o+"' for "+i+" widget instance"):e.error("cannot call methods on "+i+" prior to initialization; "+
                        "attempted to call method '"+o+"'")}):this.each(function(){var t=e.data(this,a);t?t.option(o||{})._init():e.data(this,a,new n(o,this))}),l}},e.Widget=function(){},e.Widget._childConstructors=[],e.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",defaultElement:"<div>",options:{disabled:!1,create:null},_createWidget:function(t,s){s=e(s||(this.defaultElement||this))[0],this.element=e(s),this.uuid=i++,this.eventNamespace="."+this.widgetName+this.uuid,this.options=e.widget.extend({},this.options,
                        this._getCreateOptions(),t),this.bindings=e(),this.hoverable=e(),this.focusable=e(),s!==this&&(e.data(s,this.widgetFullName,this),this._on(!0,this.element,{remove:function(e){e.target===s&&this.destroy()}}),this.document=e(s.style?s.ownerDocument:s.document||s),this.window=e(this.document[0].defaultView||this.document[0].parentWindow)),this._create(),this._trigger("create",null,this._getCreateEventData()),this._init()},_getCreateOptions:e.noop,_getCreateEventData:e.noop,_create:e.noop,_init:e.noop,
                        destroy:function(){this._destroy(),this.element.unbind(this.eventNamespace).removeData(this.widgetName).removeData(this.widgetFullName).removeData(e.camelCase(this.widgetFullName)),this.widget().unbind(this.eventNamespace).removeAttr("aria-disabled").removeClass(this.widgetFullName+"-disabled "+"ui-state-disabled"),this.bindings.unbind(this.eventNamespace),this.hoverable.removeClass("ui-state-hover"),this.focusable.removeClass("ui-state-focus")},_destroy:e.noop,widget:function(){return this.element},
                        option:function(i,s){var n,a,o,r=i;if(0===arguments.length)return e.widget.extend({},this.options);if("string"==typeof i)if(r={},n=i.split("."),i=n.shift(),n.length){for(a=r[i]=e.widget.extend({},this.options[i]),o=0;n.length-1>o;o++)a[n[o]]=a[n[o]]||{},a=a[n[o]];if(i=n.pop(),1===arguments.length)return a[i]===t?null:a[i];a[i]=s}else{if(1===arguments.length)return this.options[i]===t?null:this.options[i];r[i]=s}return this._setOptions(r),this},_setOptions:function(e){var t;for(t in e)this._setOption(t,
                            e[t]);return this},_setOption:function(e,t){return this.options[e]=t,"disabled"===e&&(this.widget().toggleClass(this.widgetFullName+"-disabled ui-state-disabled",!!t).attr("aria-disabled",t),this.hoverable.removeClass("ui-state-hover"),this.focusable.removeClass("ui-state-focus")),this},enable:function(){return this._setOption("disabled",!1)},disable:function(){return this._setOption("disabled",!0)},_on:function(i,s,n){var a,o=this;"boolean"!=typeof i&&(n=s,s=i,i=!1),n?(s=a=e(s),this.bindings=this.bindings.add(s)):
                            (n=s,s=this.element,a=this.widget()),e.each(n,function(n,r){function h(){return i||o.options.disabled!==!0&&!e(this).hasClass("ui-state-disabled")?("string"==typeof r?o[r]:r).apply(o,arguments):t}"string"!=typeof r&&(h.guid=r.guid=r.guid||(h.guid||e.guid++));var l=n.match(/^(\w+)\s*(.*)$/),u=l[1]+o.eventNamespace,c=l[2];c?a.delegate(c,u,h):s.bind(u,h)})},_off:function(e,t){t=(t||"").split(" ").join(this.eventNamespace+" ")+this.eventNamespace,e.unbind(t).undelegate(t)},_delay:function(e,t){function i(){return("string"==
                        typeof e?s[e]:e).apply(s,arguments)}var s=this;return setTimeout(i,t||0)},_hoverable:function(t){this.hoverable=this.hoverable.add(t),this._on(t,{mouseenter:function(t){e(t.currentTarget).addClass("ui-state-hover")},mouseleave:function(t){e(t.currentTarget).removeClass("ui-state-hover")}})},_focusable:function(t){this.focusable=this.focusable.add(t),this._on(t,{focusin:function(t){e(t.currentTarget).addClass("ui-state-focus")},focusout:function(t){e(t.currentTarget).removeClass("ui-state-focus")}})},
                        _trigger:function(t,i,s){var n,a,o=this.options[t];if(s=s||{},i=e.Event(i),i.type=(t===this.widgetEventPrefix?t:this.widgetEventPrefix+t).toLowerCase(),i.target=this.element[0],a=i.originalEvent)for(n in a)n in i||(i[n]=a[n]);return this.element.trigger(i,s),!(e.isFunction(o)&&o.apply(this.element[0],[i].concat(s))===!1||i.isDefaultPrevented())}},e.each({show:"fadeIn",hide:"fadeOut"},function(t,i){e.Widget.prototype["_"+t]=function(s,n,a){"string"==typeof n&&(n={effect:n});var o,r=n?n===!0||"number"==
                    typeof n?i:n.effect||i:t;n=n||{},"number"==typeof n&&(n={duration:n}),o=!e.isEmptyObject(n),n.complete=a,n.delay&&s.delay(n.delay),o&&(e.effects&&e.effects.effect[r])?s[t](n):r!==t&&s[r]?s[r](n.duration,n.easing,a):s.queue(function(i){e(this)[t](),a&&a.call(s[0]),i()})}})})(jQuery);
                    (function(e){var t=!1;e(document).mouseup(function(){t=!1}),e.widget("ui.mouse",{version:"1.10.4",options:{cancel:"input,textarea,button,select,option",distance:1,delay:0},_mouseInit:function(){var t=this;this.element.bind("mousedown."+this.widgetName,function(e){return t._mouseDown(e)}).bind("click."+this.widgetName,function(i){return!0===e.data(i.target,t.widgetName+".preventClickEvent")?(e.removeData(i.target,t.widgetName+".preventClickEvent"),i.stopImmediatePropagation(),!1):undefined}),this.started=
                        !1},_mouseDestroy:function(){this.element.unbind("."+this.widgetName),this._mouseMoveDelegate&&e(document).unbind("mousemove."+this.widgetName,this._mouseMoveDelegate).unbind("mouseup."+this.widgetName,this._mouseUpDelegate)},_mouseDown:function(i){if(!t){this._mouseStarted&&this._mouseUp(i),this._mouseDownEvent=i;var s=this,n=1===i.which,a="string"==typeof this.options.cancel&&i.target.nodeName?e(i.target).closest(this.options.cancel).length:!1;return n&&(!a&&this._mouseCapture(i))?(this.mouseDelayMet=
                        !this.options.delay,this.mouseDelayMet||(this._mouseDelayTimer=setTimeout(function(){s.mouseDelayMet=!0},this.options.delay)),this._mouseDistanceMet(i)&&(this._mouseDelayMet(i)&&(this._mouseStarted=this._mouseStart(i)!==!1,!this._mouseStarted))?(i.preventDefault(),!0):(!0===e.data(i.target,this.widgetName+".preventClickEvent")&&e.removeData(i.target,this.widgetName+".preventClickEvent"),this._mouseMoveDelegate=function(e){return s._mouseMove(e)},this._mouseUpDelegate=function(e){return s._mouseUp(e)},
                        e(document).bind("mousemove."+this.widgetName,this._mouseMoveDelegate).bind("mouseup."+this.widgetName,this._mouseUpDelegate),i.preventDefault(),t=!0,!0)):!0}},_mouseMove:function(t){return e.ui.ie&&((!document.documentMode||9>document.documentMode)&&!t.button)?this._mouseUp(t):this._mouseStarted?(this._mouseDrag(t),t.preventDefault()):(this._mouseDistanceMet(t)&&(this._mouseDelayMet(t)&&(this._mouseStarted=this._mouseStart(this._mouseDownEvent,t)!==!1,this._mouseStarted?this._mouseDrag(t):this._mouseUp(t))),
                        !this._mouseStarted)},_mouseUp:function(t){return e(document).unbind("mousemove."+this.widgetName,this._mouseMoveDelegate).unbind("mouseup."+this.widgetName,this._mouseUpDelegate),this._mouseStarted&&(this._mouseStarted=!1,t.target===this._mouseDownEvent.target&&e.data(t.target,this.widgetName+".preventClickEvent",!0),this._mouseStop(t)),!1},_mouseDistanceMet:function(e){return Math.max(Math.abs(this._mouseDownEvent.pageX-e.pageX),Math.abs(this._mouseDownEvent.pageY-e.pageY))>=this.options.distance},
                        _mouseDelayMet:function(){return this.mouseDelayMet},_mouseStart:function(){},_mouseDrag:function(){},_mouseStop:function(){},_mouseCapture:function(){return!0}})})(jQuery);
                    (function(e,t){function i(e,t,i){return[parseFloat(e[0])*(p.test(e[0])?t/100:1),parseFloat(e[1])*(p.test(e[1])?i/100:1)]}function s(t,i){return parseInt(e.css(t,i),10)||0}function n(t){var i=t[0];return 9===i.nodeType?{width:t.width(),height:t.height(),offset:{top:0,left:0}}:e.isWindow(i)?{width:t.width(),height:t.height(),offset:{top:t.scrollTop(),left:t.scrollLeft()}}:i.preventDefault?{width:0,height:0,offset:{top:i.pageY,left:i.pageX}}:{width:t.outerWidth(),height:t.outerHeight(),offset:t.offset()}}
                        e.ui=e.ui||{};var a,o=Math.max,r=Math.abs,h=Math.round,l=/left|center|right/,u=/top|center|bottom/,c=/[\+\-]\d+(\.[\d]+)?%?/,d=/^\w+/,p=/%$/,f=e.fn.position;e.position={scrollbarWidth:function(){if(a!==t)return a;var i,s,n=e("<div style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'><div style='height:100px;width:auto;'></div></div>"),o=n.children()[0];return e("body").append(n),i=o.offsetWidth,n.css("overflow","scroll"),s=o.offsetWidth,i===s&&(s=n[0].clientWidth),n.remove(),
                            a=i-s},getScrollInfo:function(t){var i=t.isWindow||t.isDocument?"":t.element.css("overflow-x"),s=t.isWindow||t.isDocument?"":t.element.css("overflow-y"),n="scroll"===i||"auto"===i&&t.width<t.element[0].scrollWidth,a="scroll"===s||"auto"===s&&t.height<t.element[0].scrollHeight;return{width:a?e.position.scrollbarWidth():0,height:n?e.position.scrollbarWidth():0}},getWithinInfo:function(t){var i=e(t||window),s=e.isWindow(i[0]),n=!!i[0]&&9===i[0].nodeType;return{element:i,isWindow:s,isDocument:n,offset:i.offset()||
                        {left:0,top:0},scrollLeft:i.scrollLeft(),scrollTop:i.scrollTop(),width:s?i.width():i.outerWidth(),height:s?i.height():i.outerHeight()}}},e.fn.position=function(t){if(!t||!t.of)return f.apply(this,arguments);t=e.extend({},t);var a,p,m,g,v,b,_=e(t.of),y=e.position.getWithinInfo(t.within),x=e.position.getScrollInfo(y),w=(t.collision||"flip").split(" "),k={};return b=n(_),_[0].preventDefault&&(t.at="left top"),p=b.width,m=b.height,g=b.offset,v=e.extend({},g),e.each(["my","at"],function(){var e,i,s=(t[this]||
                        "").split(" ");1===s.length&&(s=l.test(s[0])?s.concat(["center"]):u.test(s[0])?["center"].concat(s):["center","center"]),s[0]=l.test(s[0])?s[0]:"center",s[1]=u.test(s[1])?s[1]:"center",e=c.exec(s[0]),i=c.exec(s[1]),k[this]=[e?e[0]:0,i?i[0]:0],t[this]=[d.exec(s[0])[0],d.exec(s[1])[0]]}),1===w.length&&(w[1]=w[0]),"right"===t.at[0]?v.left+=p:"center"===t.at[0]&&(v.left+=p/2),"bottom"===t.at[1]?v.top+=m:"center"===t.at[1]&&(v.top+=m/2),a=i(k.at,p,m),v.left+=a[0],v.top+=a[1],this.each(function(){var n,
                            l,u=e(this),c=u.outerWidth(),d=u.outerHeight(),f=s(this,"marginLeft"),b=s(this,"marginTop"),D=c+f+s(this,"marginRight")+x.width,T=d+b+s(this,"marginBottom")+x.height,C=e.extend({},v),M=i(k.my,u.outerWidth(),u.outerHeight());"right"===t.my[0]?C.left-=c:"center"===t.my[0]&&(C.left-=c/2),"bottom"===t.my[1]?C.top-=d:"center"===t.my[1]&&(C.top-=d/2),C.left+=M[0],C.top+=M[1],e.support.offsetFractions||(C.left=h(C.left),C.top=h(C.top)),n={marginLeft:f,marginTop:b},e.each(["left","top"],function(i,s){e.ui.position[w[i]]&&
                        e.ui.position[w[i]][s](C,{targetWidth:p,targetHeight:m,elemWidth:c,elemHeight:d,collisionPosition:n,collisionWidth:D,collisionHeight:T,offset:[a[0]+M[0],a[1]+M[1]],my:t.my,at:t.at,within:y,elem:u})}),t.using&&(l=function(e){var i=g.left-C.left,s=i+p-c,n=g.top-C.top,a=n+m-d,h={target:{element:_,left:g.left,top:g.top,width:p,height:m},element:{element:u,left:C.left,top:C.top,width:c,height:d},horizontal:0>s?"left":i>0?"right":"center",vertical:0>a?"top":n>0?"bottom":"middle"};c>p&&(p>r(i+s)&&(h.horizontal=
                            "center")),d>m&&(m>r(n+a)&&(h.vertical="middle")),h.important=o(r(i),r(s))>o(r(n),r(a))?"horizontal":"vertical",t.using.call(this,e,h)}),u.offset(e.extend(C,{using:l}))})},e.ui.position={fit:{left:function(e,t){var i,s=t.within,n=s.isWindow?s.scrollLeft:s.offset.left,a=s.width,r=e.left-t.collisionPosition.marginLeft,h=n-r,l=r+t.collisionWidth-a-n;t.collisionWidth>a?h>0&&0>=l?(i=e.left+h+t.collisionWidth-a-n,e.left+=h-i):e.left=l>0&&0>=h?n:h>l?n+a-t.collisionWidth:n:h>0?e.left+=h:l>0?e.left-=l:e.left=
                            o(e.left-r,e.left)},top:function(e,t){var i,s=t.within,n=s.isWindow?s.scrollTop:s.offset.top,a=t.within.height,r=e.top-t.collisionPosition.marginTop,h=n-r,l=r+t.collisionHeight-a-n;t.collisionHeight>a?h>0&&0>=l?(i=e.top+h+t.collisionHeight-a-n,e.top+=h-i):e.top=l>0&&0>=h?n:h>l?n+a-t.collisionHeight:n:h>0?e.top+=h:l>0?e.top-=l:e.top=o(e.top-r,e.top)}},flip:{left:function(e,t){var i,s,n=t.within,a=n.offset.left+n.scrollLeft,o=n.width,h=n.isWindow?n.scrollLeft:n.offset.left,l=e.left-t.collisionPosition.marginLeft,
                            u=l-h,c=l+t.collisionWidth-o-h,d="left"===t.my[0]?-t.elemWidth:"right"===t.my[0]?t.elemWidth:0,p="left"===t.at[0]?t.targetWidth:"right"===t.at[0]?-t.targetWidth:0,f=-2*t.offset[0];0>u?(i=e.left+d+p+f+t.collisionWidth-o-a,(0>i||r(u)>i)&&(e.left+=d+p+f)):c>0&&(s=e.left-t.collisionPosition.marginLeft+d+p+f-h,(s>0||c>r(s))&&(e.left+=d+p+f))},top:function(e,t){var i,s,n=t.within,a=n.offset.top+n.scrollTop,o=n.height,h=n.isWindow?n.scrollTop:n.offset.top,l=e.top-t.collisionPosition.marginTop,u=l-h,c=l+
                            t.collisionHeight-o-h,d="top"===t.my[1],p=d?-t.elemHeight:"bottom"===t.my[1]?t.elemHeight:0,f="top"===t.at[1]?t.targetHeight:"bottom"===t.at[1]?-t.targetHeight:0,m=-2*t.offset[1];0>u?(s=e.top+p+f+m+t.collisionHeight-o-a,e.top+p+f+m>u&&((0>s||r(u)>s)&&(e.top+=p+f+m))):c>0&&(i=e.top-t.collisionPosition.marginTop+p+f+m-h,e.top+p+f+m>c&&((i>0||c>r(i))&&(e.top+=p+f+m)))}},flipfit:{left:function(){e.ui.position.flip.left.apply(this,arguments),e.ui.position.fit.left.apply(this,arguments)},top:function(){e.ui.position.flip.top.apply(this,
                            arguments),e.ui.position.fit.top.apply(this,arguments)}}},function(){var t,i,s,n,a,o=document.getElementsByTagName("body")[0],r=document.createElement("div");t=document.createElement(o?"div":"body"),s={visibility:"hidden",width:0,height:0,border:0,margin:0,background:"none"},o&&e.extend(s,{position:"absolute",left:"-1000px",top:"-1000px"});for(a in s)t.style[a]=s[a];t.appendChild(r),i=o||document.documentElement,i.insertBefore(t,i.firstChild),r.style.cssText="position: absolute; left: 10.7432222px;",
                            n=e(r).offset().left,e.support.offsetFractions=n>10&&11>n,t.innerHTML="",i.removeChild(t)}()})(jQuery);
                    (function(e){var t=5;e.widget("ui.slider",e.ui.mouse,{version:"1.10.4",widgetEventPrefix:"slide",options:{animate:!1,distance:0,max:100,min:0,orientation:"horizontal",range:!1,step:1,value:0,values:null,change:null,slide:null,start:null,stop:null},_create:function(){this._keySliding=!1,this._mouseSliding=!1,this._animateOff=!0,this._handleIndex=null,this._detectOrientation(),this._mouseInit(),this.element.addClass("ui-slider ui-slider-"+this.orientation+" ui-widget"+" ui-widget-content"+" ui-corner-all"),
                        this._refresh(),this._setOption("disabled",this.options.disabled),this._animateOff=!1},_refresh:function(){this._createRange(),this._createHandles(),this._setupEvents(),this._refreshValue()},_createHandles:function(){var t,i,s=this.options,n=this.element.find(".ui-slider-handle").addClass("ui-state-default ui-corner-all"),a="<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>",o=[];for(i=s.values&&s.values.length||1,n.length>i&&(n.slice(i).remove(),n=n.slice(0,i)),t=n.length;i>
                    t;t++)o.push(a);this.handles=n.add(e(o.join("")).appendTo(this.element)),this.handle=this.handles.eq(0),this.handles.each(function(t){e(this).data("ui-slider-handle-index",t)})},_createRange:function(){var t=this.options,i="";t.range?(t.range===!0&&(t.values?t.values.length&&2!==t.values.length?t.values=[t.values[0],t.values[0]]:e.isArray(t.values)&&(t.values=t.values.slice(0)):t.values=[this._valueMin(),this._valueMin()]),this.range&&this.range.length?this.range.removeClass("ui-slider-range-min ui-slider-range-max").css({left:"",
                        bottom:""}):(this.range=e("<div></div>").appendTo(this.element),i="ui-slider-range ui-widget-header ui-corner-all"),this.range.addClass(i+("min"===t.range||"max"===t.range?" ui-slider-range-"+t.range:""))):(this.range&&this.range.remove(),this.range=null)},_setupEvents:function(){var e=this.handles.add(this.range).filter("a");this._off(e),this._on(e,this._handleEvents),this._hoverable(e),this._focusable(e)},_destroy:function(){this.handles.remove(),this.range&&this.range.remove(),this.element.removeClass("ui-slider ui-slider-horizontal ui-slider-vertical ui-widget ui-widget-content ui-corner-all"),
                        this._mouseDestroy()},_mouseCapture:function(t){var i,s,n,a,o,r,h,l,u=this,c=this.options;return c.disabled?!1:(this.elementSize={width:this.element.outerWidth(),height:this.element.outerHeight()},this.elementOffset=this.element.offset(),i={x:t.pageX,y:t.pageY},s=this._normValueFromMouse(i),n=this._valueMax()-this._valueMin()+1,this.handles.each(function(t){var i=Math.abs(s-u.values(t));(n>i||n===i&&(t===u._lastChangedValue||u.values(t)===c.min))&&(n=i,a=e(this),o=t)}),r=this._start(t,o),r===!1?!1:
                        (this._mouseSliding=!0,this._handleIndex=o,a.addClass("ui-state-active").focus(),h=a.offset(),l=!e(t.target).parents().addBack().is(".ui-slider-handle"),this._clickOffset=l?{left:0,top:0}:{left:t.pageX-h.left-a.width()/2,top:t.pageY-h.top-a.height()/2-(parseInt(a.css("borderTopWidth"),10)||0)-(parseInt(a.css("borderBottomWidth"),10)||0)+(parseInt(a.css("marginTop"),10)||0)},this.handles.hasClass("ui-state-hover")||this._slide(t,o,s),this._animateOff=!0,!0))},_mouseStart:function(){return!0},_mouseDrag:function(e){var t=
                    {x:e.pageX,y:e.pageY},i=this._normValueFromMouse(t);return this._slide(e,this._handleIndex,i),!1},_mouseStop:function(e){return this.handles.removeClass("ui-state-active"),this._mouseSliding=!1,this._stop(e,this._handleIndex),this._change(e,this._handleIndex),this._handleIndex=null,this._clickOffset=null,this._animateOff=!1,!1},_detectOrientation:function(){this.orientation="vertical"===this.options.orientation?"vertical":"horizontal"},_normValueFromMouse:function(e){var t,i,s,n,a;return"horizontal"===
                    this.orientation?(t=this.elementSize.width,i=e.x-this.elementOffset.left-(this._clickOffset?this._clickOffset.left:0)):(t=this.elementSize.height,i=e.y-this.elementOffset.top-(this._clickOffset?this._clickOffset.top:0)),s=i/t,s>1&&(s=1),0>s&&(s=0),"vertical"===this.orientation&&(s=1-s),n=this._valueMax()-this._valueMin(),a=this._valueMin()+s*n,this._trimAlignValue(a)},_start:function(e,t){var i={handle:this.handles[t],value:this.value()};return this.options.values&&(this.options.values.length&&(i.value=
                        this.values(t),i.values=this.values())),this._trigger("start",e,i)},_slide:function(e,t,i){var s,n,a;this.options.values&&this.options.values.length?(s=this.values(t?0:1),2===this.options.values.length&&(this.options.range===!0&&((0===t&&i>s||1===t&&s>i)&&(i=s))),i!==this.values(t)&&(n=this.values(),n[t]=i,a=this._trigger("slide",e,{handle:this.handles[t],value:i,values:n}),s=this.values(t?0:1),a!==!1&&this.values(t,i))):i!==this.value()&&(a=this._trigger("slide",e,{handle:this.handles[t],value:i}),
                    a!==!1&&this.value(i))},_stop:function(e,t){var i={handle:this.handles[t],value:this.value()};this.options.values&&(this.options.values.length&&(i.value=this.values(t),i.values=this.values())),this._trigger("stop",e,i)},_change:function(e,t){if(!this._keySliding&&!this._mouseSliding){var i={handle:this.handles[t],value:this.value()};this.options.values&&(this.options.values.length&&(i.value=this.values(t),i.values=this.values())),this._lastChangedValue=t,this._trigger("change",e,i)}},value:function(e){return arguments.length?
                        (this.options.value=this._trimAlignValue(e),this._refreshValue(),this._change(null,0),undefined):this._value()},values:function(t,i){var s,n,a;if(arguments.length>1)return this.options.values[t]=this._trimAlignValue(i),this._refreshValue(),this._change(null,t),undefined;if(!arguments.length)return this._values();if(!e.isArray(arguments[0]))return this.options.values&&this.options.values.length?this._values(t):this.value();for(s=this.options.values,n=arguments[0],a=0;s.length>a;a+=1)s[a]=this._trimAlignValue(n[a]),
                        this._change(null,a);this._refreshValue()},_setOption:function(t,i){var s,n=0;switch("range"===t&&(this.options.range===!0&&("min"===i?(this.options.value=this._values(0),this.options.values=null):"max"===i&&(this.options.value=this._values(this.options.values.length-1),this.options.values=null))),e.isArray(this.options.values)&&(n=this.options.values.length),e.Widget.prototype._setOption.apply(this,arguments),t){case "orientation":this._detectOrientation(),this.element.removeClass("ui-slider-horizontal ui-slider-vertical").addClass("ui-slider-"+
                        this.orientation),this._refreshValue();break;case "value":this._animateOff=!0,this._refreshValue(),this._change(null,0),this._animateOff=!1;break;case "values":for(this._animateOff=!0,this._refreshValue(),s=0;n>s;s+=1)this._change(null,s);this._animateOff=!1;break;case "min":case "max":this._animateOff=!0,this._refreshValue(),this._animateOff=!1;break;case "range":this._animateOff=!0,this._refresh(),this._animateOff=!1}},_value:function(){var e=this.options.value;return e=this._trimAlignValue(e)},
                        _values:function(e){var t,i,s;if(arguments.length)return t=this.options.values[e],t=this._trimAlignValue(t);if(this.options.values&&this.options.values.length){for(i=this.options.values.slice(),s=0;i.length>s;s+=1)i[s]=this._trimAlignValue(i[s]);return i}return[]},_trimAlignValue:function(e){if(this._valueMin()>=e)return this._valueMin();if(e>=this._valueMax())return this._valueMax();var t=this.options.step>0?this.options.step:1,i=(e-this._valueMin())%t,s=e-i;return 2*Math.abs(i)>=t&&(s+=i>0?t:-t),
                            parseFloat(s.toFixed(5))},_valueMin:function(){return this.options.min},_valueMax:function(){return this.options.max},_refreshValue:function(){var t,i,s,n,a,o=this.options.range,r=this.options,h=this,l=this._animateOff?!1:r.animate,u={};this.options.values&&this.options.values.length?this.handles.each(function(s){i=100*((h.values(s)-h._valueMin())/(h._valueMax()-h._valueMin())),u["horizontal"===h.orientation?"left":"bottom"]=i+"%",e(this).stop(1,1)[l?"animate":"css"](u,r.animate),h.options.range===
                        !0&&("horizontal"===h.orientation?(0===s&&h.range.stop(1,1)[l?"animate":"css"]({left:i+"%"},r.animate),1===s&&h.range[l?"animate":"css"]({width:i-t+"%"},{queue:!1,duration:r.animate})):(0===s&&h.range.stop(1,1)[l?"animate":"css"]({bottom:i+"%"},r.animate),1===s&&h.range[l?"animate":"css"]({height:i-t+"%"},{queue:!1,duration:r.animate}))),t=i}):(s=this.value(),n=this._valueMin(),a=this._valueMax(),i=a!==n?100*((s-n)/(a-n)):0,u["horizontal"===this.orientation?"left":"bottom"]=i+"%",this.handle.stop(1,
                            1)[l?"animate":"css"](u,r.animate),"min"===o&&("horizontal"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({width:i+"%"},r.animate)),"max"===o&&("horizontal"===this.orientation&&this.range[l?"animate":"css"]({width:100-i+"%"},{queue:!1,duration:r.animate})),"min"===o&&("vertical"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({height:i+"%"},r.animate)),"max"===o&&("vertical"===this.orientation&&this.range[l?"animate":"css"]({height:100-i+"%"},{queue:!1,duration:r.animate})))},
                        _handleEvents:{keydown:function(i){var s,n,a,o,r=e(i.target).data("ui-slider-handle-index");switch(i.keyCode){case e.ui.keyCode.HOME:case e.ui.keyCode.END:case e.ui.keyCode.PAGE_UP:case e.ui.keyCode.PAGE_DOWN:case e.ui.keyCode.UP:case e.ui.keyCode.RIGHT:case e.ui.keyCode.DOWN:case e.ui.keyCode.LEFT:if(i.preventDefault(),!this._keySliding&&(this._keySliding=!0,e(i.target).addClass("ui-state-active"),s=this._start(i,r),s===!1))return}switch(o=this.options.step,n=a=this.options.values&&this.options.values.length?
                            this.values(r):this.value(),i.keyCode){case e.ui.keyCode.HOME:a=this._valueMin();break;case e.ui.keyCode.END:a=this._valueMax();break;case e.ui.keyCode.PAGE_UP:a=this._trimAlignValue(n+(this._valueMax()-this._valueMin())/t);break;case e.ui.keyCode.PAGE_DOWN:a=this._trimAlignValue(n-(this._valueMax()-this._valueMin())/t);break;case e.ui.keyCode.UP:case e.ui.keyCode.RIGHT:if(n===this._valueMax())return;a=this._trimAlignValue(n+o);break;case e.ui.keyCode.DOWN:case e.ui.keyCode.LEFT:if(n===this._valueMin())return;
                            a=this._trimAlignValue(n-o)}this._slide(i,r,a)},click:function(e){e.preventDefault()},keyup:function(t){var i=e(t.target).data("ui-slider-handle-index");this._keySliding&&(this._keySliding=!1,this._stop(t,i),this._change(t,i),e(t.target).removeClass("ui-state-active"))}}})})(jQuery);
                    (function(e){function t(t,i){var s=(t.attr("aria-describedby")||"").split(/\s+/);s.push(i),t.data("ui-tooltip-id",i).attr("aria-describedby",e.trim(s.join(" ")))}function i(t){var i=t.data("ui-tooltip-id"),s=(t.attr("aria-describedby")||"").split(/\s+/),n=e.inArray(i,s);-1!==n&&s.splice(n,1),t.removeData("ui-tooltip-id"),s=e.trim(s.join(" ")),s?t.attr("aria-describedby",s):t.removeAttr("aria-describedby")}var s=0;e.widget("ui.tooltip",{version:"1.10.4",options:{content:function(){var t=e(this).attr("title")||
                        "";return e("<a>").text(t).html()},hide:!0,items:"[title]:not([disabled])",position:{my:"left top+15",at:"left bottom",collision:"flipfit flip"},show:!0,tooltipClass:null,track:!1,close:null,open:null},_create:function(){this._on({mouseover:"open",focusin:"open"}),this.tooltips={},this.parents={},this.options.disabled&&this._disable()},_setOption:function(t,i){var s=this;return"disabled"===t?(this[i?"_disable":"_enable"](),this.options[t]=i,void 0):(this._super(t,i),"content"===t&&e.each(this.tooltips,
                        function(e,t){s._updateContent(t)}),void 0)},_disable:function(){var t=this;e.each(this.tooltips,function(i,s){var n=e.Event("blur");n.target=n.currentTarget=s[0],t.close(n,!0)}),this.element.find(this.options.items).addBack().each(function(){var t=e(this);t.is("[title]")&&t.data("ui-tooltip-title",t.attr("title")).attr("title","")})},_enable:function(){this.element.find(this.options.items).addBack().each(function(){var t=e(this);t.data("ui-tooltip-title")&&t.attr("title",t.data("ui-tooltip-title"))})},
                        open:function(t){var i=this,s=e(t?t.target:this.element).closest(this.options.items);s.length&&(!s.data("ui-tooltip-id")&&(s.attr("title")&&s.data("ui-tooltip-title",s.attr("title")),s.data("ui-tooltip-open",!0),t&&("mouseover"===t.type&&s.parents().each(function(){var t,s=e(this);s.data("ui-tooltip-open")&&(t=e.Event("blur"),t.target=t.currentTarget=this,i.close(t,!0)),s.attr("title")&&(s.uniqueId(),i.parents[this.id]={element:this,title:s.attr("title")},s.attr("title",""))})),this._updateContent(s,
                            t)))},_updateContent:function(e,t){var i,s=this.options.content,n=this,a=t?t.type:null;return"string"==typeof s?this._open(t,e,s):(i=s.call(e[0],function(i){e.data("ui-tooltip-open")&&n._delay(function(){t&&(t.type=a),this._open(t,e,i)})}),i&&this._open(t,e,i),void 0)},_open:function(i,s,n){function a(e){l.of=e,o.is(":hidden")||o.position(l)}var o,r,h,l=e.extend({},this.options.position);if(n){if(o=this._find(s),o.length)return o.find(".ui-tooltip-content").html(n),void 0;s.is("[title]")&&(i&&"mouseover"===
                        i.type?s.attr("title",""):s.removeAttr("title")),o=this._tooltip(s),t(s,o.attr("id")),o.find(".ui-tooltip-content").html(n),this.options.track&&(i&&/^mouse/.test(i.type))?(this._on(this.document,{mousemove:a}),a(i)):o.position(e.extend({of:s},this.options.position)),o.hide(),this._show(o,this.options.show),this.options.show&&(this.options.show.delay&&(h=this.delayedShow=setInterval(function(){o.is(":visible")&&(a(l.of),clearInterval(h))},e.fx.interval))),this._trigger("open",i,{tooltip:o}),r={keyup:function(t){if(t.keyCode===
                            e.ui.keyCode.ESCAPE){var i=e.Event(t);i.currentTarget=s[0],this.close(i,!0)}},remove:function(){this._removeTooltip(o)}},i&&"mouseover"!==i.type||(r.mouseleave="close"),i&&"focusin"!==i.type||(r.focusout="close"),this._on(!0,s,r)}},close:function(t){var s=this,n=e(t?t.currentTarget:this.element),a=this._find(n);this.closing||(clearInterval(this.delayedShow),n.data("ui-tooltip-title")&&n.attr("title",n.data("ui-tooltip-title")),i(n),a.stop(!0),this._hide(a,this.options.hide,function(){s._removeTooltip(e(this))}),
                            n.removeData("ui-tooltip-open"),this._off(n,"mouseleave focusout keyup"),n[0]!==this.element[0]&&this._off(n,"remove"),this._off(this.document,"mousemove"),t&&("mouseleave"===t.type&&e.each(this.parents,function(t,i){e(i.element).attr("title",i.title),delete s.parents[t]})),this.closing=!0,this._trigger("close",t,{tooltip:a}),this.closing=!1)},_tooltip:function(t){var i="ui-tooltip-"+s++,n=e("<div>").attr({id:i,role:"tooltip"}).addClass("ui-tooltip ui-widget ui-corner-all ui-widget-content "+(this.options.tooltipClass||
                            ""));return e("<div>").addClass("ui-tooltip-content").appendTo(n),n.appendTo(this.document[0].body),this.tooltips[i]=t,n},_find:function(t){var i=t.data("ui-tooltip-id");return i?e("#"+i):e()},_removeTooltip:function(e){e.remove(),delete this.tooltips[e.attr("id")]},_destroy:function(){var t=this;e.each(this.tooltips,function(i,s){var n=e.Event("blur");n.target=n.currentTarget=s[0],t.close(n,!0),e("#"+i).remove(),s.data("ui-tooltip-title")&&(s.attr("title",s.data("ui-tooltip-title")),s.removeData("ui-tooltip-title"))})}})})(jQuery);
                    (function(e,t){var i="ui-effects-";e.effects={effect:{}},function(e,t){function i(e,t,i){var s=c[t.type]||{};return null==e?i||!t.def?null:t.def:(e=s.floor?~~e:parseFloat(e),isNaN(e)?t.def:s.mod?(e+s.mod)%s.mod:0>e?0:e>s.max?s.max:e)}function s(i){var s=l(),n=s._rgba=[];return i=i.toLowerCase(),f(h,function(e,a){var o,r=a.re.exec(i),h=r&&a.parse(r),l=a.space||"rgba";return h?(o=s[l](h),s[u[l].cache]=o[u[l].cache],n=s._rgba=o._rgba,!1):t}),n.length?("0,0,0,0"===n.join()&&e.extend(n,a.transparent),
                        s):a[i]}function n(e,t,i){return i=(i+1)%1,1>6*i?e+6*(t-e)*i:1>2*i?t:2>3*i?e+6*(t-e)*(2/3-i):e}var a,o="backgroundColor borderBottomColor borderLeftColor borderRightColor borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor",r=/^([\-+])=\s*(\d+\.?\d*)/,h=[{re:/rgba?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,parse:function(e){return[e[1],e[2],e[3],e[4]]}},{re:/rgba?\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,
                            parse:function(e){return[2.55*e[1],2.55*e[2],2.55*e[3],e[4]]}},{re:/#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})/,parse:function(e){return[parseInt(e[1],16),parseInt(e[2],16),parseInt(e[3],16)]}},{re:/#([a-f0-9])([a-f0-9])([a-f0-9])/,parse:function(e){return[parseInt(e[1]+e[1],16),parseInt(e[2]+e[2],16),parseInt(e[3]+e[3],16)]}},{re:/hsla?\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,space:"hsla",parse:function(e){return[e[1],e[2]/100,e[3]/100,e[4]]}}],
                        l=e.Color=function(t,i,s,n){return new e.Color.fn.parse(t,i,s,n)},u={rgba:{props:{red:{idx:0,type:"byte"},green:{idx:1,type:"byte"},blue:{idx:2,type:"byte"}}},hsla:{props:{hue:{idx:0,type:"degrees"},saturation:{idx:1,type:"percent"},lightness:{idx:2,type:"percent"}}}},c={"byte":{floor:!0,max:255},percent:{max:1},degrees:{mod:360,floor:!0}},d=l.support={},p=e("<p>")[0],f=e.each;p.style.cssText="background-color:rgba(1,1,1,.5)",d.rgba=p.style.backgroundColor.indexOf("rgba")>-1,f(u,function(e,t){t.cache=
                        "_"+e,t.props.alpha={idx:3,type:"percent",def:1}}),l.fn=e.extend(l.prototype,{parse:function(n,o,r,h){if(n===t)return this._rgba=[null,null,null,null],this;(n.jquery||n.nodeType)&&(n=e(n).css(o),o=t);var c=this,d=e.type(n),p=this._rgba=[];return o!==t&&(n=[n,o,r,h],d="array"),"string"===d?this.parse(s(n)||a._default):"array"===d?(f(u.rgba.props,function(e,t){p[t.idx]=i(n[t.idx],t)}),this):"object"===d?(n instanceof l?f(u,function(e,t){n[t.cache]&&(c[t.cache]=n[t.cache].slice())}):f(u,function(t,s){var a=
                        s.cache;f(s.props,function(e,t){if(!c[a]&&s.to){if("alpha"===e||null==n[e])return;c[a]=s.to(c._rgba)}c[a][t.idx]=i(n[e],t,!0)}),c[a]&&(0>e.inArray(null,c[a].slice(0,3))&&(c[a][3]=1,s.from&&(c._rgba=s.from(c[a]))))}),this):t},is:function(e){var i=l(e),s=!0,n=this;return f(u,function(e,a){var o,r=i[a.cache];return r&&(o=n[a.cache]||(a.to&&a.to(n._rgba)||[]),f(a.props,function(e,i){return null!=r[i.idx]?s=r[i.idx]===o[i.idx]:t})),s}),s},_space:function(){var e=[],t=this;return f(u,function(i,s){t[s.cache]&&
                    e.push(i)}),e.pop()},transition:function(e,t){var s=l(e),n=s._space(),a=u[n],o=0===this.alpha()?l("transparent"):this,r=o[a.cache]||a.to(o._rgba),h=r.slice();return s=s[a.cache],f(a.props,function(e,n){var a=n.idx,o=r[a],l=s[a],u=c[n.type]||{};null!==l&&(null===o?h[a]=l:(u.mod&&(l-o>u.mod/2?o+=u.mod:o-l>u.mod/2&&(o-=u.mod)),h[a]=i((l-o)*t+o,n)))}),this[n](h)},blend:function(t){if(1===this._rgba[3])return this;var i=this._rgba.slice(),s=i.pop(),n=l(t)._rgba;return l(e.map(i,function(e,t){return(1-
                        s)*n[t]+s*e}))},toRgbaString:function(){var t="rgba(",i=e.map(this._rgba,function(e,t){return null==e?t>2?1:0:e});return 1===i[3]&&(i.pop(),t="rgb("),t+i.join()+")"},toHslaString:function(){var t="hsla(",i=e.map(this.hsla(),function(e,t){return null==e&&(e=t>2?1:0),t&&(3>t&&(e=Math.round(100*e)+"%")),e});return 1===i[3]&&(i.pop(),t="hsl("),t+i.join()+")"},toHexString:function(t){var i=this._rgba.slice(),s=i.pop();return t&&i.push(~~(255*s)),"#"+e.map(i,function(e){return e=(e||0).toString(16),1===
                    e.length?"0"+e:e}).join("")},toString:function(){return 0===this._rgba[3]?"transparent":this.toRgbaString()}}),l.fn.parse.prototype=l.fn,u.hsla.to=function(e){if(null==e[0]||(null==e[1]||null==e[2]))return[null,null,null,e[3]];var t,i,s=e[0]/255,n=e[1]/255,a=e[2]/255,o=e[3],r=Math.max(s,n,a),h=Math.min(s,n,a),l=r-h,u=r+h,c=0.5*u;return t=h===r?0:s===r?60*(n-a)/l+360:n===r?60*(a-s)/l+120:60*(s-n)/l+240,i=0===l?0:0.5>=c?l/u:l/(2-u),[Math.round(t)%360,i,c,null==o?1:o]},u.hsla.from=function(e){if(null==
                        e[0]||(null==e[1]||null==e[2]))return[null,null,null,e[3]];var t=e[0]/360,i=e[1],s=e[2],a=e[3],o=0.5>=s?s*(1+i):s+i-s*i,r=2*s-o;return[Math.round(255*n(r,o,t+1/3)),Math.round(255*n(r,o,t)),Math.round(255*n(r,o,t-1/3)),a]},f(u,function(s,n){var a=n.props,o=n.cache,h=n.to,u=n.from;l.fn[s]=function(s){if(h&&(!this[o]&&(this[o]=h(this._rgba))),s===t)return this[o].slice();var n,r=e.type(s),c="array"===r||"object"===r?s:arguments,d=this[o].slice();return f(a,function(e,t){var s=c["object"===r?e:t.idx];
                        null==s&&(s=d[t.idx]),d[t.idx]=i(s,t)}),u?(n=l(u(d)),n[o]=d,n):l(d)},f(a,function(t,i){l.fn[t]||(l.fn[t]=function(n){var a,o=e.type(n),h="alpha"===t?this._hsla?"hsla":"rgba":s,l=this[h](),u=l[i.idx];return"undefined"===o?u:("function"===o&&(n=n.call(this,u),o=e.type(n)),null==n&&i.empty?this:("string"===o&&(a=r.exec(n),a&&(n=u+parseFloat(a[2])*("+"===a[1]?1:-1))),l[i.idx]=n,this[h](l)))})})}),l.hook=function(t){var i=t.split(" ");f(i,function(t,i){e.cssHooks[i]={set:function(t,n){var a,o,r="";if("transparent"!==
                        n&&("string"!==e.type(n)||(a=s(n)))){if(n=l(a||n),!d.rgba&&1!==n._rgba[3]){for(o="backgroundColor"===i?t.parentNode:t;(""===r||"transparent"===r)&&(o&&o.style);)try{r=e.css(o,"backgroundColor"),o=o.parentNode}catch(h){}n=n.blend(r&&"transparent"!==r?r:"_default")}n=n.toRgbaString()}try{t.style[i]=n}catch(h){}}},e.fx.step[i]=function(t){t.colorInit||(t.start=l(t.elem,i),t.end=l(t.end),t.colorInit=!0),e.cssHooks[i].set(t.elem,t.start.transition(t.end,t.pos))}})},l.hook(o),e.cssHooks.borderColor={expand:function(e){var t=
                    {};return f(["Top","Right","Bottom","Left"],function(i,s){t["border"+s+"Color"]=e}),t}},a=e.Color.names={aqua:"#00ffff",black:"#000000",blue:"#0000ff",fuchsia:"#ff00ff",gray:"#808080",green:"#008000",lime:"#00ff00",maroon:"#800000",navy:"#000080",olive:"#808000",purple:"#800080",red:"#ff0000",silver:"#c0c0c0",teal:"#008080",white:"#ffffff",yellow:"#ffff00",transparent:[null,null,null,0],_default:"#ffffff"}}(jQuery),function(){function i(t){var i,s,n=t.ownerDocument.defaultView?t.ownerDocument.defaultView.getComputedStyle(t,
                        null):t.currentStyle,a={};if(n&&(n.length&&(n[0]&&n[n[0]])))for(s=n.length;s--;)i=n[s],"string"==typeof n[i]&&(a[e.camelCase(i)]=n[i]);else for(i in n)"string"==typeof n[i]&&(a[i]=n[i]);return a}function s(t,i){var s,n,o={};for(s in i)n=i[s],t[s]!==n&&(a[s]||(e.fx.step[s]||!isNaN(parseFloat(n)))&&(o[s]=n));return o}var n=["add","remove","toggle"],a={border:1,borderBottom:1,borderColor:1,borderLeft:1,borderRight:1,borderTop:1,borderWidth:1,margin:1,padding:1};e.each(["borderLeftStyle","borderRightStyle",
                        "borderBottomStyle","borderTopStyle"],function(t,i){e.fx.step[i]=function(e){("none"!==e.end&&!e.setAttr||1===e.pos&&!e.setAttr)&&(jQuery.style(e.elem,i,e.end),e.setAttr=!0)}}),e.fn.addBack||(e.fn.addBack=function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}),e.effects.animateClass=function(t,a,o,r){var h=e.speed(a,o,r);return this.queue(function(){var a,o=e(this),r=o.attr("class")||"",l=h.children?o.find("*").addBack():o;l=l.map(function(){var t=e(this);return{el:t,start:i(this)}}),
                        a=function(){e.each(n,function(e,i){t[i]&&o[i+"Class"](t[i])})},a(),l=l.map(function(){return this.end=i(this.el[0]),this.diff=s(this.start,this.end),this}),o.attr("class",r),l=l.map(function(){var t=this,i=e.Deferred(),s=e.extend({},h,{queue:!1,complete:function(){i.resolve(t)}});return this.el.animate(this.diff,s),i.promise()}),e.when.apply(e,l.get()).done(function(){a(),e.each(arguments,function(){var t=this.el;e.each(this.diff,function(e){t.css(e,"")})}),h.complete.call(o[0])})})},e.fn.extend({addClass:function(t){return function(i,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    s,n,a){return s?e.effects.animateClass.call(this,{add:i},s,n,a):t.apply(this,arguments)}}(e.fn.addClass),removeClass:function(t){return function(i,s,n,a){return arguments.length>1?e.effects.animateClass.call(this,{remove:i},s,n,a):t.apply(this,arguments)}}(e.fn.removeClass),toggleClass:function(i){return function(s,n,a,o,r){return"boolean"==typeof n||n===t?a?e.effects.animateClass.call(this,n?{add:s}:{remove:s},a,o,r):i.apply(this,arguments):e.effects.animateClass.call(this,{toggle:s},n,a,o)}}(e.fn.toggleClass),
                        switchClass:function(t,i,s,n,a){return e.effects.animateClass.call(this,{add:i,remove:t},s,n,a)}})}(),function(){function s(t,i,s,n){return e.isPlainObject(t)&&(i=t,t=t.effect),t={effect:t},null==i&&(i={}),e.isFunction(i)&&(n=i,s=null,i={}),("number"==typeof i||e.fx.speeds[i])&&(n=s,s=i,i={}),e.isFunction(s)&&(n=s,s=null),i&&e.extend(t,i),s=s||i.duration,t.duration=e.fx.off?0:"number"==typeof s?s:s in e.fx.speeds?e.fx.speeds[s]:e.fx.speeds._default,t.complete=n||i.complete,t}function n(t){return!t||
                    ("number"==typeof t||e.fx.speeds[t])?!0:"string"!=typeof t||e.effects.effect[t]?e.isFunction(t)?!0:"object"!=typeof t||t.effect?!1:!0:!0}e.extend(e.effects,{version:"1.10.4",save:function(e,t){for(var s=0;t.length>s;s++)null!==t[s]&&e.data(i+t[s],e[0].style[t[s]])},restore:function(e,s){var n,a;for(a=0;s.length>a;a++)null!==s[a]&&(n=e.data(i+s[a]),n===t&&(n=""),e.css(s[a],n))},setMode:function(e,t){return"toggle"===t&&(t=e.is(":hidden")?"show":"hide"),t},getBaseline:function(e,t){var i,s;switch(e[0]){case "top":i=
                        0;break;case "middle":i=0.5;break;case "bottom":i=1;break;default:i=e[0]/t.height}switch(e[1]){case "left":s=0;break;case "center":s=0.5;break;case "right":s=1;break;default:s=e[1]/t.width}return{x:s,y:i}},createWrapper:function(t){if(t.parent().is(".ui-effects-wrapper"))return t.parent();var i={width:t.outerWidth(!0),height:t.outerHeight(!0),"float":t.css("float")},s=e("<div></div>").addClass("ui-effects-wrapper").css({fontSize:"100%",background:"transparent",border:"none",margin:0,padding:0}),n=
                    {width:t.width(),height:t.height()},a=document.activeElement;try{a.id}catch(o){a=document.body}return t.wrap(s),(t[0]===a||e.contains(t[0],a))&&e(a).focus(),s=t.parent(),"static"===t.css("position")?(s.css({position:"relative"}),t.css({position:"relative"})):(e.extend(i,{position:t.css("position"),zIndex:t.css("z-index")}),e.each(["top","left","bottom","right"],function(e,s){i[s]=t.css(s),isNaN(parseInt(i[s],10))&&(i[s]="auto")}),t.css({position:"relative",top:0,left:0,right:"auto",bottom:"auto"})),
                        t.css(n),s.css(i).show()},removeWrapper:function(t){var i=document.activeElement;return t.parent().is(".ui-effects-wrapper")&&(t.parent().replaceWith(t),(t[0]===i||e.contains(t[0],i))&&e(i).focus()),t},setTransition:function(t,i,s,n){return n=n||{},e.each(i,function(e,i){var a=t.cssUnit(i);a[0]>0&&(n[i]=a[0]*s+a[1])}),n}}),e.fn.extend({effect:function(){function t(t){function s(){e.isFunction(a)&&a.call(n[0]),e.isFunction(t)&&t()}var n=e(this),a=i.complete,r=i.mode;(n.is(":hidden")?"hide"===r:"show"===
                    r)?(n[r](),s()):o.call(n[0],i,s)}var i=s.apply(this,arguments),n=i.mode,a=i.queue,o=e.effects.effect[i.effect];return e.fx.off||!o?n?this[n](i.duration,i.complete):this.each(function(){i.complete&&i.complete.call(this)}):a===!1?this.each(t):this.queue(a||"fx",t)},show:function(e){return function(t){if(n(t))return e.apply(this,arguments);var i=s.apply(this,arguments);return i.mode="show",this.effect.call(this,i)}}(e.fn.show),hide:function(e){return function(t){if(n(t))return e.apply(this,arguments);
                        var i=s.apply(this,arguments);return i.mode="hide",this.effect.call(this,i)}}(e.fn.hide),toggle:function(e){return function(t){if(n(t)||"boolean"==typeof t)return e.apply(this,arguments);var i=s.apply(this,arguments);return i.mode="toggle",this.effect.call(this,i)}}(e.fn.toggle),cssUnit:function(t){var i=this.css(t),s=[];return e.each(["em","px","%","pt"],function(e,t){i.indexOf(t)>0&&(s=[parseFloat(i),t])}),s}})}(),function(){var t={};e.each(["Quad","Cubic","Quart","Quint","Expo"],function(e,i){t[i]=
                        function(t){return Math.pow(t,e+2)}}),e.extend(t,{Sine:function(e){return 1-Math.cos(e*Math.PI/2)},Circ:function(e){return 1-Math.sqrt(1-e*e)},Elastic:function(e){return 0===e||1===e?e:-Math.pow(2,8*(e-1))*Math.sin((80*(e-1)-7.5)*Math.PI/15)},Back:function(e){return e*e*(3*e-2)},Bounce:function(e){for(var t,i=4;((t=Math.pow(2,--i))-1)/11>e;);return 1/Math.pow(4,3-i)-7.5625*Math.pow((3*t-2)/22-e,2)}}),e.each(t,function(t,i){e.easing["easeIn"+t]=i,e.easing["easeOut"+t]=function(e){return 1-i(1-e)},
                        e.easing["easeInOut"+t]=function(e){return 0.5>e?i(2*e)/2:1-i(-2*e+2)/2}})}()})(jQuery);
                    (function(e){var t=/up|down|vertical/,i=/up|left|vertical|horizontal/;e.effects.effect.blind=function(s,n){var a,o,r,h=e(this),l=["position","top","bottom","left","right","height","width"],u=e.effects.setMode(h,s.mode||"hide"),c=s.direction||"up",d=t.test(c),p=d?"height":"width",f=d?"top":"left",m=i.test(c),g={},v="show"===u;h.parent().is(".ui-effects-wrapper")?e.effects.save(h.parent(),l):e.effects.save(h,l),h.show(),a=e.effects.createWrapper(h).css({overflow:"hidden"}),o=a[p](),r=parseFloat(a.css(f))||
                        0,g[p]=v?o:0,m||(h.css(d?"bottom":"right",0).css(d?"top":"left","auto").css({position:"absolute"}),g[f]=v?r:o+r),v&&(a.css(p,0),m||a.css(f,r+o)),a.animate(g,{duration:s.duration,easing:s.easing,queue:!1,complete:function(){"hide"===u&&h.hide(),e.effects.restore(h,l),e.effects.removeWrapper(h),n()}})}})(jQuery);
                    (function(e){e.effects.effect.bounce=function(t,i){var s,n,a,o=e(this),r=["position","top","bottom","left","right","height","width"],h=e.effects.setMode(o,t.mode||"effect"),l="hide"===h,u="show"===h,c=t.direction||"up",d=t.distance,p=t.times||5,f=2*p+(u||l?1:0),m=t.duration/f,g=t.easing,v="up"===c||"down"===c?"top":"left",_="up"===c||"left"===c,b=o.queue(),y=b.length;for((u||l)&&r.push("opacity"),e.effects.save(o,r),o.show(),e.effects.createWrapper(o),d||(d=o["top"===v?"outerHeight":"outerWidth"]()/
                        3),u&&(a={opacity:1},a[v]=0,o.css("opacity",0).css(v,_?2*-d:2*d).animate(a,m,g)),l&&(d/=Math.pow(2,p-1)),a={},a[v]=0,s=0;p>s;s++)n={},n[v]=(_?"-=":"+=")+d,o.animate(n,m,g).animate(a,m,g),d=l?2*d:d/2;l&&(n={opacity:0},n[v]=(_?"-=":"+=")+d,o.animate(n,m,g)),o.queue(function(){l&&o.hide(),e.effects.restore(o,r),e.effects.removeWrapper(o),i()}),y>1&&b.splice.apply(b,[1,0].concat(b.splice(y,f+1))),o.dequeue()}})(jQuery);
                    (function(e){e.effects.effect.clip=function(t,i){var s,n,a,o=e(this),r=["position","top","bottom","left","right","height","width"],h=e.effects.setMode(o,t.mode||"hide"),l="show"===h,u=t.direction||"vertical",c="vertical"===u,d=c?"height":"width",p=c?"top":"left",f={};e.effects.save(o,r),o.show(),s=e.effects.createWrapper(o).css({overflow:"hidden"}),n="IMG"===o[0].tagName?s:o,a=n[d](),l&&(n.css(d,0),n.css(p,a/2)),f[d]=l?a:0,f[p]=l?0:a/2,n.animate(f,{queue:!1,duration:t.duration,easing:t.easing,complete:function(){l||
                    o.hide(),e.effects.restore(o,r),e.effects.removeWrapper(o),i()}})}})(jQuery);
                    (function(e){e.effects.effect.drop=function(t,i){var s,n=e(this),a=["position","top","bottom","left","right","opacity","height","width"],o=e.effects.setMode(n,t.mode||"hide"),r="show"===o,h=t.direction||"left",l="up"===h||"down"===h?"top":"left",u="up"===h||"left"===h?"pos":"neg",c={opacity:r?1:0};e.effects.save(n,a),n.show(),e.effects.createWrapper(n),s=t.distance||n["top"===l?"outerHeight":"outerWidth"](!0)/2,r&&n.css("opacity",0).css(l,"pos"===u?-s:s),c[l]=(r?"pos"===u?"+=":"-=":"pos"===u?"-=":
                            "+=")+s,n.animate(c,{queue:!1,duration:t.duration,easing:t.easing,complete:function(){"hide"===o&&n.hide(),e.effects.restore(n,a),e.effects.removeWrapper(n),i()}})}})(jQuery);
                    (function(e){e.effects.effect.explode=function(t,i){function s(){b.push(this),b.length===c*d&&n()}function n(){p.css({visibility:"visible"}),e(b).remove(),m||p.hide(),i()}var a,o,r,h,l,u,c=t.pieces?Math.round(Math.sqrt(t.pieces)):3,d=c,p=e(this),f=e.effects.setMode(p,t.mode||"hide"),m="show"===f,g=p.show().css("visibility","hidden").offset(),v=Math.ceil(p.outerWidth()/d),_=Math.ceil(p.outerHeight()/c),b=[];for(a=0;c>a;a++)for(h=g.top+a*_,u=a-(c-1)/2,o=0;d>o;o++)r=g.left+o*v,l=o-(d-1)/2,p.clone().appendTo("body").wrap("<div></div>").css({position:"absolute",
                        visibility:"visible",left:-o*v,top:-a*_}).parent().addClass("ui-effects-explode").css({position:"absolute",overflow:"hidden",width:v,height:_,left:r+(m?l*v:0),top:h+(m?u*_:0),opacity:m?0:1}).animate({left:r+(m?0:l*v),top:h+(m?0:u*_),opacity:m?1:0},t.duration||500,t.easing,s)}})(jQuery);(function(e){e.effects.effect.fade=function(t,i){var s=e(this),n=e.effects.setMode(s,t.mode||"toggle");s.animate({opacity:n},{queue:!1,duration:t.duration,easing:t.easing,complete:i})}})(jQuery);
                    (function(e){e.effects.effect.fold=function(t,i){var s,n,a=e(this),o=["position","top","bottom","left","right","height","width"],r=e.effects.setMode(a,t.mode||"hide"),h="show"===r,l="hide"===r,u=t.size||15,c=/([0-9]+)%/.exec(u),d=!!t.horizFirst,p=h!==d,f=p?["width","height"]:["height","width"],m=t.duration/2,g={},v={};e.effects.save(a,o),a.show(),s=e.effects.createWrapper(a).css({overflow:"hidden"}),n=p?[s.width(),s.height()]:[s.height(),s.width()],c&&(u=parseInt(c[1],10)/100*n[l?0:1]),h&&s.css(d?
                    {height:0,width:u}:{height:u,width:0}),g[f[0]]=h?n[0]:u,v[f[1]]=h?n[1]:0,s.animate(g,m,t.easing).animate(v,m,t.easing,function(){l&&a.hide(),e.effects.restore(a,o),e.effects.removeWrapper(a),i()})}})(jQuery);
                    (function(e){e.effects.effect.highlight=function(t,i){var s=e(this),n=["backgroundImage","backgroundColor","opacity"],a=e.effects.setMode(s,t.mode||"show"),o={backgroundColor:s.css("backgroundColor")};"hide"===a&&(o.opacity=0),e.effects.save(s,n),s.show().css({backgroundImage:"none",backgroundColor:t.color||"#ffff99"}).animate(o,{queue:!1,duration:t.duration,easing:t.easing,complete:function(){"hide"===a&&s.hide(),e.effects.restore(s,n),i()}})}})(jQuery);
                    (function(e){e.effects.effect.pulsate=function(t,i){var s,n=e(this),a=e.effects.setMode(n,t.mode||"show"),o="show"===a,r="hide"===a,h=o||"hide"===a,l=2*(t.times||5)+(h?1:0),u=t.duration/l,c=0,d=n.queue(),p=d.length;for((o||!n.is(":visible"))&&(n.css("opacity",0).show(),c=1),s=1;l>s;s++)n.animate({opacity:c},u,t.easing),c=1-c;n.animate({opacity:c},u,t.easing),n.queue(function(){r&&n.hide(),i()}),p>1&&d.splice.apply(d,[1,0].concat(d.splice(p,l+1))),n.dequeue()}})(jQuery);
                    (function(e){e.effects.effect.puff=function(t,i){var s=e(this),n=e.effects.setMode(s,t.mode||"hide"),a="hide"===n,o=parseInt(t.percent,10)||150,r=o/100,h={height:s.height(),width:s.width(),outerHeight:s.outerHeight(),outerWidth:s.outerWidth()};e.extend(t,{effect:"scale",queue:!1,fade:!0,mode:n,complete:i,percent:a?o:100,from:a?h:{height:h.height*r,width:h.width*r,outerHeight:h.outerHeight*r,outerWidth:h.outerWidth*r}}),s.effect(t)},e.effects.effect.scale=function(t,i){var s=e(this),n=e.extend(!0,
                        {},t),a=e.effects.setMode(s,t.mode||"effect"),o=parseInt(t.percent,10)||(0===parseInt(t.percent,10)?0:"hide"===a?0:100),r=t.direction||"both",h=t.origin,l={height:s.height(),width:s.width(),outerHeight:s.outerHeight(),outerWidth:s.outerWidth()},u={y:"horizontal"!==r?o/100:1,x:"vertical"!==r?o/100:1};n.effect="size",n.queue=!1,n.complete=i,"effect"!==a&&(n.origin=h||["middle","center"],n.restore=!0),n.from=t.from||("show"===a?{height:0,width:0,outerHeight:0,outerWidth:0}:l),n.to={height:l.height*u.y,
                        width:l.width*u.x,outerHeight:l.outerHeight*u.y,outerWidth:l.outerWidth*u.x},n.fade&&("show"===a&&(n.from.opacity=0,n.to.opacity=1),"hide"===a&&(n.from.opacity=1,n.to.opacity=0)),s.effect(n)},e.effects.effect.size=function(t,i){var s,n,a,o=e(this),r=["position","top","bottom","left","right","width","height","overflow","opacity"],h=["position","top","bottom","left","right","overflow","opacity"],l=["width","height","overflow"],u=["fontSize"],c=["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],
                        d=["borderLeftWidth","borderRightWidth","paddingLeft","paddingRight"],p=e.effects.setMode(o,t.mode||"effect"),f=t.restore||"effect"!==p,m=t.scale||"both",g=t.origin||["middle","center"],v=o.css("position"),_=f?r:h,b={height:0,width:0,outerHeight:0,outerWidth:0};"show"===p&&o.show(),s={height:o.height(),width:o.width(),outerHeight:o.outerHeight(),outerWidth:o.outerWidth()},"toggle"===t.mode&&"show"===p?(o.from=t.to||b,o.to=t.from||s):(o.from=t.from||("show"===p?b:s),o.to=t.to||("hide"===p?b:s)),a=
                    {from:{y:o.from.height/s.height,x:o.from.width/s.width},to:{y:o.to.height/s.height,x:o.to.width/s.width}},("box"===m||"both"===m)&&(a.from.y!==a.to.y&&(_=_.concat(c),o.from=e.effects.setTransition(o,c,a.from.y,o.from),o.to=e.effects.setTransition(o,c,a.to.y,o.to)),a.from.x!==a.to.x&&(_=_.concat(d),o.from=e.effects.setTransition(o,d,a.from.x,o.from),o.to=e.effects.setTransition(o,d,a.to.x,o.to))),("content"===m||"both"===m)&&(a.from.y!==a.to.y&&(_=_.concat(u).concat(l),o.from=e.effects.setTransition(o,
                        u,a.from.y,o.from),o.to=e.effects.setTransition(o,u,a.to.y,o.to))),e.effects.save(o,_),o.show(),e.effects.createWrapper(o),o.css("overflow","hidden").css(o.from),g&&(n=e.effects.getBaseline(g,s),o.from.top=(s.outerHeight-o.outerHeight())*n.y,o.from.left=(s.outerWidth-o.outerWidth())*n.x,o.to.top=(s.outerHeight-o.to.outerHeight)*n.y,o.to.left=(s.outerWidth-o.to.outerWidth)*n.x),o.css(o.from),("content"===m||"both"===m)&&(c=c.concat(["marginTop","marginBottom"]).concat(u),d=d.concat(["marginLeft","marginRight"]),
                        l=r.concat(c).concat(d),o.find("*[width]").each(function(){var i=e(this),s={height:i.height(),width:i.width(),outerHeight:i.outerHeight(),outerWidth:i.outerWidth()};f&&e.effects.save(i,l),i.from={height:s.height*a.from.y,width:s.width*a.from.x,outerHeight:s.outerHeight*a.from.y,outerWidth:s.outerWidth*a.from.x},i.to={height:s.height*a.to.y,width:s.width*a.to.x,outerHeight:s.height*a.to.y,outerWidth:s.width*a.to.x},a.from.y!==a.to.y&&(i.from=e.effects.setTransition(i,c,a.from.y,i.from),i.to=e.effects.setTransition(i,
                        c,a.to.y,i.to)),a.from.x!==a.to.x&&(i.from=e.effects.setTransition(i,d,a.from.x,i.from),i.to=e.effects.setTransition(i,d,a.to.x,i.to)),i.css(i.from),i.animate(i.to,t.duration,t.easing,function(){f&&e.effects.restore(i,l)})})),o.animate(o.to,{queue:!1,duration:t.duration,easing:t.easing,complete:function(){0===o.to.opacity&&o.css("opacity",o.from.opacity),"hide"===p&&o.hide(),e.effects.restore(o,_),f||("static"===v?o.css({position:"relative",top:o.to.top,left:o.to.left}):e.each(["top","left"],function(e,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  t){o.css(t,function(t,i){var s=parseInt(i,10),n=e?o.to.left:o.to.top;return"auto"===i?n+"px":s+n+"px"})})),e.effects.removeWrapper(o),i()}})}})(jQuery);
                    (function(e){e.effects.effect.shake=function(t,i){var s,n=e(this),a=["position","top","bottom","left","right","height","width"],o=e.effects.setMode(n,t.mode||"effect"),r=t.direction||"left",h=t.distance||20,l=t.times||3,u=2*l+1,c=Math.round(t.duration/u),d="up"===r||"down"===r?"top":"left",p="up"===r||"left"===r,f={},m={},g={},v=n.queue(),_=v.length;for(e.effects.save(n,a),n.show(),e.effects.createWrapper(n),f[d]=(p?"-=":"+=")+h,m[d]=(p?"+=":"-=")+2*h,g[d]=(p?"-=":"+=")+2*h,n.animate(f,c,t.easing),
                                                                                                                                                                                                                                                                                                                                                                                            s=1;l>s;s++)n.animate(m,c,t.easing).animate(g,c,t.easing);n.animate(m,c,t.easing).animate(f,c/2,t.easing).queue(function(){"hide"===o&&n.hide(),e.effects.restore(n,a),e.effects.removeWrapper(n),i()}),_>1&&v.splice.apply(v,[1,0].concat(v.splice(_,u+1))),n.dequeue()}})(jQuery);
                    (function(e){e.effects.effect.slide=function(t,i){var s,n=e(this),a=["position","top","bottom","left","right","width","height"],o=e.effects.setMode(n,t.mode||"show"),r="show"===o,h=t.direction||"left",l="up"===h||"down"===h?"top":"left",u="up"===h||"left"===h,c={};e.effects.save(n,a),n.show(),s=t.distance||n["top"===l?"outerHeight":"outerWidth"](!0),e.effects.createWrapper(n).css({overflow:"hidden"}),r&&n.css(l,u?isNaN(s)?"-"+s:-s:s),c[l]=(r?u?"+=":"-=":u?"-=":"+=")+s,n.animate(c,{queue:!1,duration:t.duration,
                        easing:t.easing,complete:function(){"hide"===o&&n.hide(),e.effects.restore(n,a),e.effects.removeWrapper(n),i()}})}})(jQuery);
                    (function(e){e.effects.effect.transfer=function(t,i){var s=e(this),n=e(t.to),a="fixed"===n.css("position"),o=e("body"),r=a?o.scrollTop():0,h=a?o.scrollLeft():0,l=n.offset(),u={top:l.top-r,left:l.left-h,height:n.innerHeight(),width:n.innerWidth()},c=s.offset(),d=e("<div class='ui-effects-transfer'></div>").appendTo(document.body).addClass(t.className).css({top:c.top-r,left:c.left-h,height:s.innerHeight(),width:s.innerWidth(),position:a?"fixed":"absolute"}).animate(u,t.duration,t.easing,function(){d.remove(),
                        i()})}})(jQuery);
                    var punycode=new function Punycode(){this.utf16={decode:function(input){var output=[],i=0,len=input.length,value,extra;while(i<len){value=input.charCodeAt(i++);if((value&63488)===55296){extra=input.charCodeAt(i++);if((value&64512)!==55296||(extra&64512)!==56320)throw new RangeError("UTF-16(decode): Illegal UTF-16 sequence");value=((value&1023)<<10)+(extra&1023)+65536}output.push(value)}return output},encode:function(input){var output=[],i=0,len=input.length,value;while(i<len){value=input[i++];if((value&
                        63488)===55296)throw new RangeError("UTF-16(encode): Illegal UTF-16 value");if(value>65535){value-=65536;output.push(String.fromCharCode(value>>>10&1023|55296));value=56320|value&1023}output.push(String.fromCharCode(value))}return output.join("")}};var initial_n=128;var initial_bias=72;var delimiter="-";var base=36;var damp=700;var tmin=1;var tmax=26;var skew=38;var maxint=2147483647;function decode_digit(cp){return cp-48<10?cp-22:cp-65<26?cp-65:cp-97<26?cp-97:base}function encode_digit(d,flag){return d+
                        22+75*(d<26)-((flag!=0)<<5)}function adapt(delta,numpoints,firsttime){var k;delta=firsttime?Math.floor(delta/damp):delta>>1;delta+=Math.floor(delta/numpoints);for(k=0;delta>(base-tmin)*tmax>>1;k+=base)delta=Math.floor(delta/(base-tmin));return Math.floor(k+(base-tmin+1)*delta/(delta+skew))}function encode_basic(bcp,flag){bcp-=(bcp-97<26)<<5;return bcp+((!flag&&bcp-65<26)<<5)}this.decode=function(input,preserveCase){var output=[];var case_flags=[];var input_length=input.length;var n,out,i,bias,basic,
                        j,ic,oldi,w,k,digit,t,len;n=initial_n;i=0;bias=initial_bias;basic=input.lastIndexOf(delimiter);if(basic<0)basic=0;for(j=0;j<basic;++j){if(preserveCase)case_flags[output.length]=input.charCodeAt(j)-65<26;if(input.charCodeAt(j)>=128)throw new RangeError("Illegal input >= 0x80");output.push(input.charCodeAt(j))}for(ic=basic>0?basic+1:0;ic<input_length;){for(oldi=i,w=1,k=base;;k+=base){if(ic>=input_length)throw RangeError("punycode_bad_input(1)");digit=decode_digit(input.charCodeAt(ic++));if(digit>=base)throw RangeError("punycode_bad_input(2)");
                        if(digit>Math.floor((maxint-i)/w))throw RangeError("punycode_overflow(1)");i+=digit*w;t=k<=bias?tmin:k>=bias+tmax?tmax:k-bias;if(digit<t)break;if(w>Math.floor(maxint/(base-t)))throw RangeError("punycode_overflow(2)");w*=base-t}out=output.length+1;bias=adapt(i-oldi,out,oldi===0);if(Math.floor(i/out)>maxint-n)throw RangeError("punycode_overflow(3)");n+=Math.floor(i/out);i%=out;if(preserveCase)case_flags.splice(i,0,input.charCodeAt(ic-1)-65<26);output.splice(i,0,n);i++}if(preserveCase)for(i=0,len=output.length;i<
                    len;i++)if(case_flags[i])output[i]=String.fromCharCode(output[i]).toUpperCase().charCodeAt(0);return this.utf16.encode(output)};this.encode=function(input,preserveCase){var n,delta,h,b,bias,j,m,q,k,t,ijv,case_flags;if(preserveCase)case_flags=this.utf16.decode(input);input=this.utf16.decode(input.toLowerCase());var input_length=input.length;if(preserveCase)for(j=0;j<input_length;j++)case_flags[j]=input[j]!=case_flags[j];var output=[];n=initial_n;delta=0;bias=initial_bias;for(j=0;j<input_length;++j)if(input[j]<
                        128)output.push(String.fromCharCode(case_flags?encode_basic(input[j],case_flags[j]):input[j]));h=b=output.length;if(b>0)output.push(delimiter);while(h<input_length){for(m=maxint,j=0;j<input_length;++j){ijv=input[j];if(ijv>=n&&ijv<m)m=ijv}if(m-n>Math.floor((maxint-delta)/(h+1)))throw RangeError("punycode_overflow (1)");delta+=(m-n)*(h+1);n=m;for(j=0;j<input_length;++j){ijv=input[j];if(ijv<n)if(++delta>maxint)return Error("punycode_overflow(2)");if(ijv==n){for(q=delta,k=base;;k+=base){t=k<=bias?tmin:
                        k>=bias+tmax?tmax:k-bias;if(q<t)break;output.push(String.fromCharCode(encode_digit(t+(q-t)%(base-t),0)));q=Math.floor((q-t)/(base-t))}output.push(String.fromCharCode(encode_digit(q,preserveCase&&case_flags[j]?1:0)));bias=adapt(delta,h+1,h==b);delta=0;++h}}++delta,++n}return output.join("")};this.ToASCII=function(domain){var domain_array=domain.split(".");var out=[];for(var i=0;i<domain_array.length;++i){var s=domain_array[i];out.push(s.match(/[^A-Za-z0-9-]/)?"xn--"+punycode.encode(s):s)}return out.join(".")};
                        this.ToUnicode=function(domain){var domain_array=domain.split(".");var out=[];for(var i=0;i<domain_array.length;++i){var s=domain_array[i];out.push(s.match(/^xn--/)?punycode.decode(s.slice(4)):s)}return out.join(".")}};
                    (function($){$.fn.extend({radioButton:function(){this.defaults={wrapperClassName:"clearfix"};var defaults=this.defaults;return $(this).each(function(){if($(this).hasClass("ui-planeta"))return;var input=this;var div=$("<div></div>").addClass(defaults.wrapperClassName)[0];var radiobox=$("<span></span>").addClass("radiobox").attr("group-name",$(this).attr("name"))[0];$(div).append(radiobox);$(div).append($("<span></span>").addClass("radiobox-label").text($(this).parents("label").text()));var label=$(input).parents("label");
                        var el=label?label:$(input);el.after(div);var onRadioButtonChanged=function(event){if($(input).is(":checked")){$(input).closest(".row").find(".radiobox").each(function(){if($(this).attr("group-name")==$(input).attr("name"))$(this).removeClass("active")});$(radiobox).addClass("active")}else $(radiobox).removeClass("active")};$(input).change(onRadioButtonChanged);$(div).click(function(event){event.preventDefault();$(input).click()});onRadioButtonChanged();var elWidth=parseInt(el.css("width"))+5+"px";
                        $(div).css("width",elWidth);$(this).addClass("ui-planeta");el.hide()})},checkbox:function(){this.defaults={wrapperClassName:"clearfix",ignoreElementWidth:true};var defaults=this.defaults;return $(this).each(function(){if($(this).hasClass("ui-planeta"))return;var input=this;var div=$("<div></div>").addClass(defaults.wrapperClassName)[0];var checkbox=$("<span></span>").addClass("checkbox")[0];$(div).append(checkbox);var label=$("<span></span>").addClass("checkbox-label").html($(this).parents("label").html());
                        label.find("input").remove();$(div).append(label);label=$(input).parents("label");var el=label?label:$(input);el.after(div);var checkboxChange=function(event){if($(input).attr("checked"))$(checkbox).addClass("active");else $(checkbox).removeClass("active")};$(input).change(checkboxChange);$(div).click(function(event){if($(event.target).is("a"))return;event.preventDefault();if($(input).attr("checked"))$(input).attr("checked",false);else $(input).attr("checked",true);$(input).change()});checkboxChange();
                        if(!defaults.ignoreElementWidth)$(div).css("width",el.css("width"));$(this).addClass("ui-planeta");el.hide()})}})})($);
                    var AdguardSelector=function(OnElementSelected){this.iframeId="adguard-assistant-dialog";this.border_width=5;this.border_padding=2;this.b_top=null;this.b_left=null;this.b_right=null;this.b_bottom=null;this.selected=[];this.rejected=[];this.unbound=false;this.prediction_helper=new DomPredictionHelper(AdguardQuery,String);this.restricted_elements=AdguardQuery.map(["html","body","head","base"],function(selector){return AdguardQuery(selector).get(0)});this.path_output_field=null;this.select_mode="exact";
                        this.onElementSelected=OnElementSelected;this.placeHoldedElements=[];this.constantPlaceholderPrefix="adguard-placeholder"};AdguardSelector.prototype={};AdguardSelector.prototype.setup=function(){this.setupEventHandlers()};
                    AdguardSelector.prototype.makeBorders=function(origElem){this.removeBorders();this.setupBorders();if(!origElem)return;var pathToShow;if(origElem.parentNode)pathToShow=origElem.parentNode.tagName.toLowerCase()+" "+origElem.tagName.toLowerCase();else pathToShow=origElem.tagName.toLowerCase();var elem=AdguardQuery(origElem);var p=elem.offset();var top=p.top;var left=p.left;var width=elem.outerWidth();var height=elem.outerHeight();this.b_top.css("width",this.px(width+this.border_padding*2+this.border_width*
                        2)).css("top",this.px(top-this.border_width-this.border_padding)).css("left",this.px(left-this.border_padding-this.border_width));this.b_bottom.css("width",this.px(width+this.border_padding*2+this.border_width*2-5)).css("top",this.px(top+height+this.border_padding)).css("left",this.px(left-this.border_padding-this.border_width)).text(pathToShow);this.b_left.css("height",this.px(height+this.border_padding*2)).css("top",this.px(top-this.border_padding)).css("left",this.px(left-this.border_padding-this.border_width));
                        this.b_right.css("height",this.px(height+this.border_padding*2)).css("top",this.px(top-this.border_padding)).css("left",this.px(left+width+this.border_padding));this.b_right.get(0).target_elem=this.b_left.get(0).target_elem=this.b_top.get(0).target_elem=this.b_bottom.get(0).target_elem=origElem;this.showBorders()};AdguardSelector.prototype.px=function(p){return p+"px"};AdguardSelector.prototype.reset=function(element){this.b_top=null;this.makeBorders(element)};
                    AdguardSelector.prototype.showBorders=function(){this.b_top.show();this.b_bottom.show();this.b_left.show();this.b_right.show()};AdguardSelector.prototype.removeBorders=function(){if(this.b_top){this.b_top.hide();this.b_bottom.hide();this.b_left.hide();this.b_right.hide()}};
                    AdguardSelector.prototype.setupBorders=function(){if(!this.b_top){var width=this.border_width+"px";this.b_top=AdguardQuery("<div>").addClass("sg_border").css("height",width).hide().on("click",{"self":this},this.sgMousedown);this.b_bottom=AdguardQuery("<div>").addClass("sg_border").addClass("sg_bottom_border").css("height",this.px(this.border_width+6)).hide().bind("click",{"self":this},this.sgMousedown);this.b_left=AdguardQuery("<div>").addClass("sg_border").css("width",width).hide().on("click",{"self":this},
                        this.sgMousedown);this.b_right=AdguardQuery("<div>").addClass("sg_border").css("width",width).hide().on("click",{"self":this},this.sgMousedown);this.addBorderToDom()}};AdguardSelector.prototype.addBorderToDom=function(){document.body.appendChild(this.b_top.get(0));document.body.appendChild(this.b_bottom.get(0));document.body.appendChild(this.b_left.get(0));document.body.appendChild(this.b_right.get(0))};
                    AdguardSelector.prototype.removeBorderFromDom=function(){if(this.b_top){this.b_top.remove();this.b_bottom.remove();this.b_left.remove();this.b_right.remove()}};AdguardSelector.prototype.sgMouseover=function(e){var gadget=e.data.self;if(gadget.unbound)return true;if(this==document.body||this==document.body.parentNode)return false;var parent=gadget.firstSelectedOrSuggestedParent(this);if(parent!=null&&parent!=this)gadget.makeBorders(parent,true);else gadget.makeBorders(this);return false};
                    AdguardSelector.prototype.firstSelectedOrSuggestedParent=function(elem){var orig=elem;if(AdguardQuery(elem).hasClass("sg_suggested")||AdguardQuery(elem).hasClass("sg_selected"))return elem;while(elem.parentNode&&(elem=elem.parentNode))if(AdguardQuery.inArray(elem,this.restricted_elements)==-1)if(AdguardQuery(elem).hasClass("sg_suggested")||AdguardQuery(elem).hasClass("sg_selected"))return elem;return null};
                    AdguardSelector.prototype.sgMouseout=function(e){if(e.data.self.unbound)return true;if(this==document.body||this==document.body.parentNode)return false;e.data.self.removeBorders();return false};
                    AdguardSelector.prototype.sgMousedown=function(e){e.preventDefault();e.stopImmediatePropagation();var gadget=e.data.self;if(gadget.unbound)return true;var elem=this;var w_elem=AdguardQuery(elem);if(w_elem.hasClass("sg_border")){elem=elem.target_elem||elem;w_elem=AdguardQuery(elem)}if(elem==document.body||elem==document.body.parentNode)return;if(AdguardQuery(".sg_selected",this).get(0))gadget.blockClicksOn(elem);if(w_elem.hasClass("sg_selected")){w_elem.removeClass("sg_selected");gadget.selected.splice(AdguardQuery.inArray(elem,
                        gadget.selected),1)}else if(w_elem.hasClass("sg_rejected")){w_elem.removeClass("sg_rejected");gadget.rejected.splice(AdguardQuery.inArray(elem,gadget.rejected),1)}else if(w_elem.hasClass("sg_suggested")){w_elem.addClass("sg_rejected");gadget.rejected.push(elem)}else{if(gadget.select_mode=="exact"&&gadget.selected.length>0){AdguardQuery(".sg_selected").removeClass("sg_selected");gadget.selected=[]}gadget.selected.push(elem)}gadget.removeBorders();gadget.blockClicksOn(elem);w_elem.trigger("mouseover",
                        {"self":gadget});gadget.onElementSelected(gadget.getSelectorPath(elem),elem);return false};AdguardSelector.prototype.getSelectorPath=function(selectedElement){if(!selectedElement)return;var domainPrefix=this.prediction_helper.makeDomainPrefix();var selector=this.prediction_helper.makeCssNthChildFilter(selectedElement);var result=selector?domainPrefix+selector:"";return result};
                    AdguardSelector.prototype.setupEventHandlers=function(){this.makeIframeAndEmbededSelector();AdguardQuery("body *:not(.sg_ignore)").on("mouseover",{"self":this},this.sgMouseover);AdguardQuery("body *:not(.sg_ignore)").on("mouseout",{"self":this},this.sgMouseout);AdguardQuery("body *:not(.sg_ignore)").on("click",{"self":this},this.sgMousedown)};
                    AdguardSelector.prototype.deleteEventHandlers=function(){this.removePlaceholders();AdguardQuery("body *").off("mouseover",this.sgMouseover);AdguardQuery("body *").off("mouseout",this.sgMouseout);AdguardQuery("body *").off("click",this.sgMousedown)};
                    AdguardSelector.prototype.makeIframeAndEmbededSelector=function(){this.placeHoldedElements=AdguardQuery("iframe:not(.sg_ignore,:hidden),embed,object").filter(function(index){return AdguardQuery(this).css("visibility")!="hidden"});var elements=this.placeHoldedElements;for(var i=0;i<elements.length;i++){var current=elements[i];var placeHolder=this.makePlaceholderImage(current);var id=this.constantPlaceholderPrefix+i;placeHolder.setAttribute("id",id);AdguardQuery(current).replaceWith(placeHolder.outerHTML);
                        AdguardQuery("#"+id).on("click",{"self":this,"actualElement":current},this.placeholderClick)}};AdguardSelector.prototype.getHost=function getHost(url){if(!url)return"";var a=document.createElement("a");a.href=url;return a.hostname};
                    AdguardSelector.prototype.makePlaceholderImage=function(element){var jElement=AdguardQuery(element);var placeHolder=document.createElement("div");placeHolder.style.height=jElement.height()+"px";placeHolder.style.width=jElement.width()+"px";placeHolder.style.position=jElement.css("position");placeHolder.style.top=jElement.css("top");placeHolder.style.bottom=jElement.css("bottom");placeHolder.style.left=jElement.css("left");placeHolder.style.right=jElement.css("right");placeHolder.className+="adguard-placeholder";
                        var icon=document.createElement("div");icon.className+="adguard-placeholder-icon sg_ignore";var domain=document.createElement("div");domain.innerHTML=this.getHost(element.src);domain.className+="adguard-placeholder-domain sg_ignore";icon.appendChild(domain);placeHolder.appendChild(icon);return placeHolder};
                    AdguardSelector.prototype.removePlaceholders=function(){if(!this.placeHoldedElements)return;var elements=this.placeHoldedElements;for(var i=0;i<elements.length;i++){var current=elements[i];var id=this.constantPlaceholderPrefix+i;AdguardQuery("#"+id).replaceWith(AdguardQuery(current))}this.placeHoldedElements=null};
                    AdguardSelector.prototype.placeholderClick=function(e){e.preventDefault();e.stopPropagation();var gadget=e.data.self;var actualElement=e.data.actualElement;gadget.closeSelector();gadget.removePlaceholders();gadget.onElementSelected(gadget.getSelectorPath(actualElement),actualElement)};
                    AdguardSelector.prototype.blockClicksOn=function(elem){var elem=AdguardQuery(elem);var p=elem.offset();var block=AdguardQuery("<div>").css("position","absolute").css("z-index","9999999").css("width",this.px(elem.outerWidth())).css("height",this.px(elem.outerHeight())).css("top",this.px(p.top)).css("left",this.px(p.left)).css("background-color","");document.body.appendChild(block.get(0));setTimeout(function(){block.remove()},400);return false};
                    AdguardSelector.prototype.setPath=function(prediction){if(this.path_output_field!=null)if(prediction&&prediction.length>0)this.path_output_field.value=prediction;else this.path_output_field.value="No valid path found."};AdguardSelector.prototype.clearSelected=function(e){var self=e&&(e.data&&e.data.self)||this;self.selected=[];self.rejected=[];AdguardQuery(".sg_selected").removeClass("sg_selected");AdguardQuery(".sg_rejected").removeClass("sg_rejected");self.removeBorders();self.clearSuggested()};
                    AdguardSelector.prototype.clearEverything=function(e){var self=e&&(e.data&&e.data.self)||this;self.clearSelected();self.resetOutputs()};AdguardSelector.prototype.resetOutputs=function(){this.setPath()};AdguardSelector.prototype.clearSuggested=function(){AdguardQuery(".sg_suggested").removeClass("sg_suggested");if(this.clear_button)this.clear_button.attr("value","Clear")};AdguardSelector.prototype.removeInterface=function(){this.removeBorderFromDom()};
                    AdguardSelector.prototype.unbind=function(e){var self=e&&(e.data&&e.data.self)||this;self.unbound=true;self.removeInterface();self.clearSelected();self.deleteEventHandlers()};AdguardSelector.prototype.closeSelector=function(){var self=this;self.unbound=true;self.removeInterface();self.deleteEventHandlers()};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["ru"]={blockTextIfSliderHided:"\u0412 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0444\u0438\u043b\u044c\u0442\u0440 \u0431\u0443\u0434\u0435\u0442 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0430\u0432\u0438\u043b\u043e, \u0431\u043b\u043e\u043a\u0438\u0440\u0443\u044e\u0449\u0435\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442",previewStart:"<span>\u041f\u0440\u0435\u0434\u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440</span>",
                        previewEnd:"<span>\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u0442\u044c \u043f\u0440\u0435\u0434\u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440</span>",wotExcellent:"\u043e\u0442\u043b\u0438\u0447\u043d\u0430\u044f \u0440\u0435\u043f\u0443\u0442\u0430\u0446\u0438\u044f",wotGood:"\u0445\u043e\u0440\u043e\u0448\u0430\u044f \u0440\u0435\u043f\u0443\u0442\u0430\u0446\u0438\u044f ",wotUnsatisfactory:"\u043d\u0435\u0443\u0434\u043e\u0432\u043b\u0435\u0442\u0432\u043e\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0440\u0435\u043f\u0443\u0442\u0430\u0446\u0438\u044f",
                        wotPoor:"\u043f\u043b\u043e\u0445\u0430\u044f \u0440\u0435\u043f\u0443\u0442\u0430\u0446\u0438\u044f",wotBad:"\u043e\u0447\u0435\u043d\u044c \u043f\u043b\u043e\u0445\u0430\u044f \u0440\u0435\u043f\u0443\u0442\u0430\u0446\u0438\u044f",wotUnknown:"\u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0440\u0435\u043f\u0443\u0442\u0430\u0446\u0438\u044f",wotPrefix:"\u0423 \u0441\u0430\u0439\u0442\u0430 ",wotPostfix:" \u043f\u043e \u0434\u0430\u043d\u043d\u044b\u043c ",complaintWarning:"\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u0443 \u0436\u0430\u043b\u043e\u0431\u044b!",
                        complaintMinLengthWarning:"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0434\u0435\u0442\u0430\u043b\u044c\u043d\u043e \u043e\u043f\u0438\u0441\u0430\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443",dragHandleWithWot:'<div class="adg-head-h">'+'<span class="adg-domain">${domainName}</span>'+'<a target="_blank"><i id="WotIndication" class="adg-wot"></i></a>'+'<i id="ConfidenceIndication" class="adg-wot-confidence"></i></div>'+'<div class="adg-head-opt">'+'<a target="_blank"><img alt="" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACYAAAAOCAYAAABDwm71AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYxIDY0LjE0MDk0OSwgMjAxMC8xMi8wNy0xMDo1NzowMSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNS4xIFdpbmRvd3MiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6NjE1MDZGMzRBMUREMTFFMkE5MTRGMjJGQUQxNTNFNUYiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6NjE1MDZGMzVBMUREMTFFMkE5MTRGMjJGQUQxNTNFNUYiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo2MTUwNkYzMkExREQxMUUyQTkxNEYyMkZBRDE1M0U1RiIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo2MTUwNkYzM0ExREQxMUUyQTkxNEYyMkZBRDE1M0U1RiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pi24+OEAAAZ4SURBVHjahFVrbFTHFT4zc+fefXvXzzVgY0ixDdgQDLWhloEYXMDJQhWqtHVCQ5RUJY3aqmmrtii0zY+qkZqqtQh5KTStkzREsfMgFEogQLDNw8UEbLwkvGJ7Awbjx3oX733NvdO5a0xJ06hHGmlm7syZ73znO+ei8abtm8Awc4BgVVm7/iUUDMYRACCMgY/f8Jlne+bTRVXtwDkg5HwB0NsP11o93dVczKXi2Z10ee1uxnSw7BtTx/XhsqQ2GrI4N7K8U7pCnmkXhDOwhs59RTv510cQoba4xuF/mc0I8oUHlYWPNEqs/fB61npgpXMUybLubnhw6+Q548Tx5doff99I33hvLnK7NYENuGlQbevTz9g93bO5YYD09LaIAXr+wMix35yIfbj+zLVodkKPgwAGMnElijJLDq4q2/jrWYlrIdb2h19w2SWciABvBnnLHOciOByed9m16OFnsPKtBxqR1wc4IwPMfXu+yxnDk2fNvbs32BfPzzRaD9Y7a8cX6zpVaff3zkYeL9DFNbpeU1EZjTW3NnVu/f7+i3sFqBhQnASPpAKCeKBroG3dUx883trc+94mEpqewsQDQN2CBB8gJTAxqFfseSaGpKjALS7RqiUHcOGMS3zgs5nWJ2crzNMnl8gLK9tZrK+IHW+vB48HjJ0tm5S6NW85yMwP/tkAmg4olAXwy58r/ez0lne7m2FEHYSQywbOQiNM81+/mhiaboPqyg0KhogWaL569Nvyog3PRYpWv8JsJqv7tzTywTPzObdBrnqskRavaQbLpCB7x20sM4w93hRdvmIH13VBkYGN3Ts3ptO4Z9cDfCzuc5hhpzpr2cfR+bahU3a0LQLCGamPQPIOL3R88g8YTl2HoAtBZWHD7x5btr18S+Sl+U9Enl04NbBoV7RXhUQCQ44iw57hM2tGw+Uf0enVH4ISGBLMgDNwaGYXLVjcRotqDtIpFR2AKU+nTf56/WsCgIFkBVjHkbWsr7eQHdrXgBRlIqe6Toy9u+43O44ttS/HCkQwYC/9GgyOnoK+eAxcxIA54Zod9975wyfyg3lXvIpbLw6XRDdHntyQE8iNXRs2wdQIqGqsqDt2+B5RJQ4gIsThCERMDcUyUoJtbVJwgB3Rk+LSKJm3oJVbDER4uaknf9VsD1wpBokCYMyQyw3m/r0Pac81/hmJPeQXeszxQTzRB4ybQCWAsvy6vzsusXjLtm0wmAkZnlC8fNqCfYZlQEoVEMRb/fFP5zpV+kXjYGkJsE11ApjN7fQ2rVvdBJaVVrj9cfSroKkEzyk/pDz86OOiEoEn4tm891IZSBLYhF41MOtg1jgohAgwGNzUN+r4IQKZeAJU8YDJGHgV37BTcXa6SSBImckcLhYI/qsqb65tPQlcHRV8oIkjcs1du1Be+Bo4rMmyaAuCidq615X77n8W5YYvpz1TwaCuAV68+A0j0x8lNoKg4gXDMmEgca4irU3BlMFU8Cs+oESCgdHP5hBMQCIODxzCvinnEcHp+Zcad1J5s5/gzKwRuqTmXa6JPAvmUE7esLx85TtYli159T3b0/uOO4na3rX3vThmJPoQkiHL4wefHITO/p3fS2ojGbIkgyJ5RMQY/vXpkZWnYydXuoVWRawgmivckV12FAR4+AJjnzfMBTpnpNO56u5XBCucqymg1UtbcE7uYLo4IvduRxnBG1xVgZSUniTl86KZUt6rV5LXb/gFYwWBqTBujJT9reMnB45catnYM9BW//aJF7b8ac9vWxDmit9DgGMVZmSVHyrNKe80bon8y01Ct3VgemfFMTyr9JTd07VAvnvdyyjNKgdSUNgvLVvxpvF600N0xerXBM8wLTDjQjhY+bPOvlefz/VmOymCuDZa8f7ZbS+PpWy4MqiDaVHI9AsG3RoorsDQdyp+/CMJYUtlxv9lTPqc/CTKaPWyt01Nc4sqPc5vtnvHhbLum8+bB97/hlxb1zJ5vra44QXTNqWD55qeYoz5JHCBzigkVQaKSJ+HWiIBSZgSKji/fsHmjbOySrqN1Bik9WpponOPg9NgRSnS9O+T/0d3Erft25AhoCtW7SCzSk5gQji/7cctzS3/yPXTzY/ivPxY+o4DWIxVpQ9um51Xeaj1YvMPLlw/s8xUxwr9PuRzUd9wpjf7Qll+9VtVRZG/ZHrCw5OywbIbyLSqfZx6hpwywMGiiwgLjqjrFpR/CzAAplbr6RoBrz0AAAAASUVORK5CYII="/></a>'+
                        '<span class="adg-version">${version}</span></div>',dragHandleWithoutWot:'<div class="adg-head-h">'+'<span class="adg-domain">${domainName}</span></div>'+'<div class="adg-head-opt">'+'<a target="_blank" href="${href}">\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u043e \u0431\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u0438 \u044d\u0442\u043e\u0433\u043e \u0441\u0430\u0439\u0442\u0430</a>'+'<span class="adg-version">${version}</span></div>',"mainMenu":{toolTips:{WotIndication:"\u0418\u043d\u0434\u0438\u043a\u0430\u0442\u043e\u0440 \u0440\u0435\u043f\u0443\u0442\u0430\u0446\u0438\u0438 \u0441\u0430\u0439\u0442\u0430",
                            ConfidenceIndication:"\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u0443\u0432\u0435\u0440\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u0432 \u0440\u0435\u043f\u0443\u0442\u0430\u0446\u0438\u0438"},blockElementText:"\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c<br>\u044d\u043b\u0435\u043c\u0435\u043d\u0442",blockElementTextExtend:"\u0412\u044b \u0441\u043c\u043e\u0436\u0435\u0442\u0435 \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0438 \u0443\u0431\u0440\u0430\u0442\u044c \u043b\u044e\u0431\u043e\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043d\u0430 \u044d\u0442\u043e\u043c \u0441\u0430\u0439\u0442\u0435",
                            AddToExceptionsText:"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c<br>\u0432 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f",AddToExceptionsTextExtend:"Adguard \u043f\u0435\u0440\u0435\u0441\u0442\u0430\u043d\u0435\u0442 \u0444\u0438\u043b\u044c\u0442\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u043a\u043b\u0430\u043c\u0443 \u043d\u0430 \u044d\u0442\u043e\u043c \u0441\u0430\u0439\u0442\u0435, \u043f\u043e\u043a\u0430 \u0412\u044b \u043d\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0435\u0433\u043e \u0438\u0437 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439",
                            SendComplaintText:"\u041f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c\u0441\u044f<br>\u043d\u0430 \u044d\u0442\u043e\u0442 \u0441\u0430\u0439\u0442",AssistantSettingsText:"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430<br>\u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a\u0430",TemporaryExceptionText:"\u041d\u0435 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c<br>30 \u0441\u0435\u043a\u0443\u043d\u0434",UndoLastRuleText:"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c<br>\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435"},
                        "exceptionMenu":{NewExceptionText:"\u041d\u043e\u0432\u043e\u0435 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435",ExceptionClarificationText:"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u0430-\u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u044d\u0442\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b",ExceptionDisclaimerText:"\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0440\u0430\u0432\u0438\u043b \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u043f\u043e\u043c\u043e\u0436\u0435\u0442 \u0432\u044b\u0431\u043e\u0440\u043e\u0447\u043d\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0443 \u0441\u0442\u0440\u0430\u043d\u0438\u0446, \u0438\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0438\u043b\u0438 \u0441\u0430\u0439\u0442\u0430 \u0446\u0435\u043b\u0438\u043a\u043e\u043c.",
                            ScopeText:"\u041e\u0431\u043b\u0430\u0441\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f",OnlyThisPageText:'\u0422\u043e\u043b\u044c\u043a\u043e \u044d\u0442\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 <input id="onPage" type="radio" name="scope" class="radiobox">',EntireSiteText:'\u0412\u0435\u0441\u044c \u0441\u0430\u0439\u0442 <input type="radio" name="scope" class="radiobox" checked="true">',ExtendedSettings:"\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438...",
                            ExceptionParametrsText:"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f",DontUseHideRulesText:'\u041d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0441\u043e\u043a\u0440\u044b\u0442\u0438\u044f <input id="elemhide" type="checkbox" class="checkbox active" checked="true">',DontUseFiltrationRulesText:'\u041d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u0438 <input id="content" type="checkbox" class="checkbox active" checked="true">',
                            DontUseUriBlockRulesText:'\u041d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443 <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',DontUseAssistantText:'\u041d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a Adguard <input id="jsinject" type="checkbox" class="checkbox active" checked="true">',
                            AddExceptionButtonText:"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435"},"selectorMenu":{SelectElementText:"\u0412\u044b\u0431\u043e\u0440 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430",SelectElementExtendedText:"\u041a\u043b\u0438\u043a\u043d\u0438\u0442\u0435 \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u0438\u043b\u0438 ","cancel-select-mode":" \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u0435 \u0440\u0435\u0436\u0438\u043c \u0432\u044b\u0431\u043e\u0440\u0430"},
                        "detailedMenu":{BlockElementText:"\u0411\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430",BlockElementExplainText:"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u043e \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430",SliderExplainText:"\u041f\u0435\u0440\u0435\u043c\u0435\u0449\u0430\u0439\u0442\u0435 \u0431\u0435\u0433\u0443\u043d\u043e\u043a, \u0447\u0442\u043e\u0431\u044b \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440 \u0431\u043b\u043e\u043a\u0430, \u0434\u043b\u044f \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0431\u0443\u0434\u0435\u0442 \u0434\u0435\u0439\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u043e:",
                            SliderMaxText:"\u0411\u041e\u041b\u042c\u0428\u0415",SliderMinText:"\u041c\u0415\u041d\u042c\u0428\u0415",ExtendedSettingsText:"\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438...",RuleParametrsText:"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0440\u0430\u0432\u0438\u043b\u0430",ApplyRuleToAllSitesText:'\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u043e \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u0441\u0430\u0439\u0442\u043e\u0432<input id="oneDomainRadio" type="checkbox" class="checkbox">',
                            BlockByReferenceText:'\u0411\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435<input id="blockByUrl" type="checkbox" class="checkbox">',BlockText:"\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c",AnotherElementText:"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0434\u0440\u0443\u0433\u043e\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442",PreviewText:"\u041f\u0440\u0435\u0434\u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440",
                            BlockSimilarText:'\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u0445\u043e\u0436\u0438\u0435<input id="blockSimilar" type="checkbox" class="checkbox">'},"complaintMenu":{ComplaintText:"\u041f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u0441\u0430\u0439\u0442",ComplaintExtendedText:"\u041e\u043f\u0438\u0448\u0438\u0442\u0435, \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u0440\u0438\u0447\u0438\u043d\u0443 \u0436\u0430\u043b\u043e\u0431\u044b \u043d\u0430 \u044d\u0442\u043e\u0442 \u0441\u0430\u0439\u0442",
                            ComplainReasonText:"\u041f\u0440\u0438\u0447\u0438\u043d\u044b \u0436\u0430\u043b\u043e\u0431\u044b",PhishingSuspicionText:'\u041f\u043e\u0434\u043e\u0437\u0440\u0435\u043d\u0438\u0435 \u043d\u0430 \u0444\u0438\u0448\u0438\u043d\u0433<input id="phishing" type="radio" name="complaint" class="radiobox">',IncorrectViewText:'\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435<input id="wrongRender" type="radio" name="complaint" class="radiobox">',
                            AdSkippedText:'\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u0440\u0435\u043a\u043b\u0430\u043c\u0430<input id="adMissing" type="radio" name="complaint" class="radiobox">',AnotherText:'\u0414\u0440\u0443\u0433\u043e\u0435<input id="another" type="radio" name="complaint" class="radiobox">',CommentText:"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438",SendComplaintText:"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0436\u0430\u043b\u043e\u0431\u0443",CancelText:"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c"},
                        "settingsMenu":{SettingsText:"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438",AssistantViewSettingsText:"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a\u0430",VerticalOrientationText:"\u0412\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u044c\u043d\u0430\u044f \u043e\u0440\u0438\u0435\u043d\u0442\u0430\u0446\u0438\u044f",UpText:'\u0421\u0432\u0435\u0440\u0445\u0443<input id="onTop" type="radio" name="vertical" class="radiobox">',
                            DownText:'\u0421\u043d\u0438\u0437\u0443<input id="onBottom" type="radio" name="vertical" class="radiobox">',HorizontalOrientationText:"\u0413\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u043e\u0440\u0438\u0435\u043d\u0442\u0430\u0446\u0438\u044f",LeftText:'\u0421\u043b\u0435\u0432\u0430<input id="onLeft" type="radio" name="horizontal" class="radiobox">',RightText:'\u0421\u043f\u0440\u0430\u0432\u0430<input id="onRight" type="radio" name="horizontal" class="radiobox">',
                            BigText:'\u0411\u043e\u043b\u044c\u0448\u043e\u0439<input id="isBig" type="radio" name="size" class="radiobox">',SmallText:'\u041c\u0430\u043b\u0435\u043d\u044c\u043a\u0438\u0439<input id="isSmall" type="radio" name="size" class="radiobox">',IconSizeText:"\u0420\u0430\u0437\u043c\u0435\u0440 \u0438\u043a\u043e\u043d\u043a\u0438",SaveText:"\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c",CancelText:"\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c"},"alert":{welcomeHead:"\u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a Adguard \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d!",
                            welcomeMessage:"\u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a Adguard - \u044d\u0442\u043e \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0439 \u0431\u0440\u0430\u0443\u0437\u0435\u0440\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c, \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u044e\u0449\u0438\u0439 \u0443\u0431\u0440\u0430\u0442\u044c \u043d\u0435\u0436\u0435\u043b\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u043d\u0442\u0435\u043d\u0442 \u0441 \u043b\u044e\u0431\u043e\u0433\u043e \u0441\u0430\u0439\u0442\u0430. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435 \u0432\u043d\u0438\u043c\u0430\u043d\u0438\u0435 \u043d\u0430 \u0446\u0432\u0435\u0442 \u0438\u043a\u043e\u043d\u043a\u0438 \u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a\u0430 - \u043e\u043d \u0441\u0438\u0433\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u0435\u0442 \u043e \u0440\u0435\u043f\u0443\u0442\u0430\u0446\u0438\u0438 \u0441\u0430\u0439\u0442\u0430.",
                            welcomeLink:{text:"\u0423\u0437\u043d\u0430\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435",href:"http://adguard.com/tour.html"},wotAlertHead:"\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435, \u0431\u0443\u0434\u044c\u0442\u0435 \u043e\u0441\u0442\u043e\u0440\u043e\u0436\u043d\u044b!",wotAlertMessage:"\u0423 \u044d\u0442\u043e\u0433\u043e \u0441\u0430\u0439\u0442\u0430 \u043e\u0447\u0435\u043d\u044c \u043f\u043b\u043e\u0445\u0430\u044f \u0440\u0435\u043f\u0443\u0442\u0430\u0446\u0438\u044f \u043f\u043e \u0434\u0430\u043d\u043d\u044b\u043c Web Of Trust. \u0411\u0443\u0434\u044c\u0442\u0435 \u043e\u0441\u0442\u043e\u0440\u043e\u0436\u043d\u044b, \u043f\u043e\u0441\u0435\u0449\u0430\u044f \u044d\u0442\u043e\u0442 \u0441\u0430\u0439\u0442.",
                            wotAlertLink:{text:"\u0423\u0437\u043d\u0430\u0442\u044c \u043f\u043e\u0434\u0440\u043e\u0431\u043d\u0435\u0435"},wotAlertLinkIgnore:{text:"\u0418\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c"}}};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["en"]={"wotExcellent":"an excellent reputation","complaintWarning":"You must select a reason for your complaint!","selectorMenu":{"cancel-select-mode":"cancel selection mode","SelectElementText":"Selection mode","SelectElementExtendedText":"Click on any element on the page or "},"wotPostfix":" according to ","previewStart":"<span>Preview</span>","dragHandleWithoutWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span></div><div class="adg-head-opt"><a target="_blank" href="${href}">Open web site security report</a><span class="adg-version">${version}</span></div>',
                        "dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"a good reputation","alert":{"welcomeHead":"Welcome to Adguard Assistant!","welcomeLink":{"text":"More info","href":"http://adguard.com/tour.html"},"welcomeMessage":"Adguard Assistant is a special browser module of Adguard Web Filter. It allows you to remove any unwanted content from the website. Also the icon color signals you of the current website reputation."},"mainMenu":{"toolTips":{"ConfidenceIndication":"Reputation Confidence Level","WotIndication":"Site reputation indicator"},"SendComplaintText":"Submit<br>a complaint",
                            "blockElementTextExtend":"You can manually select and remove any page element (image, banner, etc) from this page or website","UndoLastRuleText":"Undo<br>last action<br>","AssistantSettingsText":"Change<br>settings<br>","AddToExceptionsTextExtend":"Adguard will stop filtering ads on this website until you remove it from the list of exceptions","AddToExceptionsText":"Add<br>Exception","TemporaryExceptionText":"Do not block<br>for 30 seconds<br>","blockElementText":"Block<br>element"},"blockTextIfSliderHided":"The filter will contain a rule that blocks the selected element",
                        "wotPrefix":"This site has ","wotUnsatisfactory":"an unsatisfactory reputation","wotPoor":"a poor reputation","wotUnknown":"an unknown reputation","detailedMenu":{"SliderMaxText":"LARGER","AnotherElementText":"Select another element","RuleParametrsText":"Rule parameters","BlockElementExplainText":"Element blocking rule setup","SliderMinText":"SMALLER","BlockText":"Block","ApplyRuleToAllSitesText":'Apply this rule to every web site<input id="oneDomainRadio" type="checkbox" class="checkbox">',"BlockByReferenceText":'Block element by URL<input id="blockByUrl" type="checkbox" class="checkbox">',
                            "SliderExplainText":"Use the slider to change the size of the element to be blocked by this rule:","PreviewText":"Preview","BlockSimilarText":'Block similar elements<input id="blockSimilar" type="checkbox" class="checkbox">',"BlockElementText":"Block element","ExtendedSettingsText":"Advanced settings..."},"previewEnd":"<span>Finish preview</span>","settingsMenu":{"AssistantViewSettingsText":"Adguard Assistant display settings","IconSizeText":"Icon size","UpText":'Up<input id="onTop" type="radio" name="vertical" class="radiobox">',
                            "CancelText":"Cancel","BigText":'Large<input id="isBig" type="radio" name="size" class="radiobox">',"LeftText":'Left<input id="onLeft" type="radio" name="horizontal" class="radiobox">',"RightText":'Right<input id="onRight" type="radio" name="horizontal" class="radiobox">',"VerticalOrientationText":"Vertical orientation","DownText":'Down<input id="onBottom" type="radio" name="vertical" class="radiobox">',"HorizontalOrientationText":"Horizontal orientation","SettingsText":"Assistant Settings","SmallText":'Small<input id="isSmall" type="radio" name="size" class="radiobox">',
                            "SaveText":"Save"},"complaintMenu":{"CommentText":"Comments","ComplaintExtendedText":"Please describe the reason for this complaint","AnotherText":'Other<input id="another" type="radio" name="complaint" class="radiobox">',"AdSkippedText":'Ad skipped<input id="adMissing" type="radio" name="complaint" class="radiobox">',"IncorrectViewText":'Website display distorted<input id="wrongRender" type="radio" name="complaint" class="radiobox">',"PhishingSuspicionText":'Phishing suspected<input id="phishing" type="radio" name="complaint" class="radiobox">',
                            "ComplainReasonText":"Reason","CancelText":"Cancel","SendComplaintText":"Submit","ComplaintText":"Submit a complaint"},"wotBad":"a bad reputation","exceptionMenu":{"EntireSiteText":'Entire site <input type="radio" name="scope" class="radiobox" checked="true">',"ExceptionClarificationText":"Exception settings for this page","ExceptionDisclaimerText":"Creating exceptions allows you to selectively unblock certain pages, page elements or entire websites.","OnlyThisPageText":'This page only<input id="onPage" type="radio" name="scope" class="radiobox">',
                            "NewExceptionText":"New exception","AddExceptionButtonText":"Add exception","ExtendedSettings":"Advanced settings...","DontUseFiltrationRulesText":'Disable content filtration rules <input id="content" type="checkbox" class="checkbox active" checked="true">',"ScopeText":"Exception rule scope","DontUseAssistantText":'Disable Adguard assistant <input id="jsinject" type="checkbox" class="checkbox active" checked="true">',"DontUseUriBlockRulesText":'Disable URL blocking rules <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',
                            "DontUseHideRulesText":'Disable element hiding rules <input id="elemhide" type="checkbox" class="checkbox active" checked="true">',"ExceptionParametrsText":"Exception rule properties"}};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["de"]={"wotExcellent":"einen exzellenten Ruf","complaintWarning":"Bitte w\u00e4hlen Sie eine Begr\u00fcndung f\u00fcr Ihre Beschwerde aus!","selectorMenu":{"cancel-select-mode":"Auswahlmodus beenden","SelectElementText":"Auswahlmodus","SelectElementExtendedText":"Klicken Sie auf ein beliebiges Element auf der Seite oder "},"wotPostfix":" laut ","previewStart":"<span>Vorschau</span>","dragHandleWithoutWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span></div><div class="adg-head-opt"><a target="_blank" href="${href}">Webseiten-Sicherheitsbericht \u00f6ffnen</a><span class="adg-version">${version}</span></div>',
                        "dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"einen guten Ruf","alert":{"welcomeHead":"Willkommen zum Adguard-Assistenten!","welcomeLink":{"text":"Mehr Informationen","href":"http://adguard.com/tour.html"},"welcomeMessage":"Der Adguard-Assistent ist ein besonderes Browsermodul des Adguard-Internetfilters. Dieses erlaubt Ihnen, unerw\u00fcnschten Inhalt von einer Webseite zu entfernen. Au\u00dferdem signalisiert Ihnen die Farbe des Symbols den aktuellen Ruf der Webseite."},"mainMenu":{"toolTips":{"ConfidenceIndication":"Vertrauenslevel des Rufs",
                            "WotIndication":"Seitenrufanzeige"},"SendComplaintText":"Eine Beschwerde<br>einreichen","blockElementTextExtend":"Sie k\u00f6nnen ein beliebiges Element (Bild, Banner, usw.) dieser Webseite durch Auswahl entfernen","UndoLastRuleText":"Letzte Aktion<br>widerrufen<br>","AssistantSettingsText":"Einstellungen<br>\u00e4ndern<br>","AddToExceptionsTextExtend":"Adguard wird Anzeigen auf dieser Webseite nicht mehr filtern, bis Sie die Webseite von den Ausnahmen entfernen","AddToExceptionsText":"Ausnahme<br>hinzuf\u00fcgen",
                            "TemporaryExceptionText":"F\u00fcr 30 Sekunden<br>nicht blockieren<br>","blockElementText":"Element<br>blockieren"},"blockTextIfSliderHided":"Der Filter wird eine Regel enthalten, welche das ausgew\u00e4hlte Element blockiert","wotPrefix":"Diese Seite hat ","wotUnsatisfactory":"einen ungen\u00fcgenden Ruf","wotPoor":"einen mangelhaften Ruf","wotUnknown":"einen unbekannter Ruf","detailedMenu":{"SliderMaxText":"GR\u00d6SSER","AnotherElementText":"Ein anderes Element ausw\u00e4hlen","RuleParametrsText":"Regelparameter",
                            "BlockElementExplainText":"Konfiguration der Elementsperrregel","SliderMinText":"KLEINER","BlockText":"Blockieren","ApplyRuleToAllSitesText":'Diese Regel auf allen Webseiten anwenden<input id="oneDomainRadio" type="checkbox" class="checkbox">',"BlockByReferenceText":'Element mittels URL blockieren<input id="blockByUrl" type="checkbox" class="checkbox">',"SliderExplainText":"\u00c4ndern Sie die Gr\u00f6\u00dfe des zu blockierenden Elements f\u00fcr diese Regel mit dem Schieberegler:","PreviewText":"Vorschau",
                            "BlockSimilarText":'\u00c4hnliche Elemente blockieren<input id="blockSimilar" type="checkbox" class="checkbox">',"BlockElementText":"Element blockieren","ExtendedSettingsText":"Erweiterte Einstellungen..."},"previewEnd":"<span>Vorschau beenden</span>","settingsMenu":{"AssistantViewSettingsText":"Adguard Assistent Darstellungsoptionen","IconSizeText":"Symbolgr\u00f6\u00dfe","UpText":'Oben<input id="onTop" type="radio" name="vertical" class="radiobox">',"CancelText":"Abbrechen","BigText":'Gro\u00df<input id="isBig" type="radio" name="size" class="radiobox">',
                            "LeftText":'Links<input id="onLeft" type="radio" name="horizontal" class="radiobox">',"RightText":'Rechts<input id="onRight" type="radio" name="horizontal" class="radiobox">',"VerticalOrientationText":"Vertikale Ausrichtung","DownText":'Unten<input id="onBottom" type="radio" name="vertical" class="radiobox">',"HorizontalOrientationText":"Horizontale Ausrichtung","SettingsText":"Assistenten-Einstellungen","SmallText":'Klein<input id="isSmall" type="radio" name="size" class="radiobox">',"SaveText":"Speichern"},
                        "complaintMenu":{"CommentText":"Kommentare","ComplaintExtendedText":"Beschreiben Sie bitte den Grund dieser Beschwerde","AnotherText":'Sonstiges<input id="another" type="radio" name="complaint" class="radiobox">',"AdSkippedText":'Anzeige nicht blockiert<input id="adMissing" type="radio" name="complaint" class="radiobox">',"IncorrectViewText":'Darstellungsfehler<input id="wrongRender" type="radio" name="complaint" class="radiobox">',"PhishingSuspicionText":'Phishing vermutet<input id="phishing" type="radio" name="complaint" class="radiobox">',
                            "ComplainReasonText":"Grund","CancelText":"Abbrechen","SendComplaintText":"Senden","ComplaintText":"Eine Beschwerde senden"},"wotBad":"einen schlechten Ruf","exceptionMenu":{"EntireSiteText":'Die gesamte Domain <input type="radio" name="scope" class="radiobox" checked="true">',"ExceptionClarificationText":"Ausnahme-Einstellungen f\u00fcr diese Seite","ExceptionDisclaimerText":"Das Erstellen von Ausnahmen erlaubt Ihnen, bestimmte Seiten, Seitenelemente oder ganze Webseiten nicht mehr zu blockieren.",
                            "OnlyThisPageText":'Nur diese Seite <input id="onPage" type="radio" name="scope" class="radiobox">',"NewExceptionText":"Neue Ausnahme","AddExceptionButtonText":"Ausnahme hinzuf\u00fcgen","ExtendedSettings":"Erweiterte Einstellungen...","DontUseFiltrationRulesText":'Inhaltsfilter-Regeln deaktivieren <input id="content" type="checkbox" class="checkbox active" checked="true">',"ScopeText":"Bereich der Ausnahmeregel","DontUseAssistantText":'Adguard-Assistent deaktivieren <input id="jsinject" type="checkbox" class="checkbox active" checked="true">',
                            "DontUseUriBlockRulesText":'URL-Blockier-Regeln deaktivieren <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',"DontUseHideRulesText":'Regeln zum Ausblenden von Elementen deaktivieren <input id="elemhide" type="checkbox" class="checkbox active" checked="true">',"ExceptionParametrsText":"Ausnahmeregel-Eigenschaften"}};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["pl"]={"wotExcellent":"znakomit\u0105 reputacj\u0119","complaintWarning":"Musisz wybra\u0107 typ problemu!","selectorMenu":{"cancel-select-mode":"anuluj tryb zaznaczania","SelectElementText":"Tryb zaznaczania","SelectElementExtendedText":"Kliknij na dowolny element strony lub "},"wotPostfix":" wed\u0142ug ","previewStart":"<span>Podgl\u0105d</span>","dragHandleWithoutWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span></div><div class="adg-head-opt"><a target="_blank" href="${href}">Otw\u00f3rz raport bezpiecze\u0144stwa strony internetowej</a><span class="adg-version">${version}</span></div>',
                        "dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"dobr\u0105 reputacj\u0119","alert":{"welcomeHead":"Asystent Adguarda - witamy!","welcomeLink":{"text":"Wi\u0119cej informacji","href":"http://adguard.com/tour.html"},"welcomeMessage":"Asystent Adguarda to specjalny modu\u0142 Adguarda filtruj\u0105cy sie\u0107. Dzia\u0142a bezpo\u015brednio w przegl\u0105darkach. Umo\u017cliwia Ci usuwanie ze stron internetowych dowolnej niechcianej zawarto\u015bci. Kolor ikony sygnalizuje reputacj\u0119 bie\u017c\u0105cej strony internetowej."},"mainMenu":{"toolTips":{"ConfidenceIndication":"Reputacja - poziom zaufania",
                            "WotIndication":"Wska\u017anik reputacji strony"},"SendComplaintText":"Zg\u0142o\u015b<br>problem","blockElementTextExtend":"Mo\u017cesz r\u0119cznie wybra\u0107 i usun\u0105\u0107 dowolny element strony internetowej (obrazek, baner, itd.)","UndoLastRuleText":"Cofnij<br>ostatni\u0105 akcj\u0119<br>","AssistantSettingsText":"Zmie\u0144<br>ustawienia<br>","AddToExceptionsTextExtend":"Adguard nie b\u0119dzie filtrowa\u0142 reklam na tej stronie internetowej dop\u00f3ki nie usuniesz jej z listy wyj\u0105tk\u00f3w",
                            "AddToExceptionsText":"Dodaj<br>wyj\u0105tek","TemporaryExceptionText":"Nie blokuj<br>przez 30 sekund<br>","blockElementText":"Zablokuj<br>element"},"blockTextIfSliderHided":"Filtr b\u0119dzie zawiera\u0142 regu\u0142\u0119 blokuj\u0105c\u0105 wybrany element","wotPrefix":"Ta strona ma ","wotUnsatisfactory":"niezadowalaj\u0105c\u0105 reputacj\u0119","wotPoor":"kiepsk\u0105 reputacj\u0119","wotUnknown":"nieznan\u0105 reputacj\u0119","detailedMenu":{"SliderMaxText":"WI\u0118KSZY","AnotherElementText":"Wybierz inny element",
                            "RuleParametrsText":"Parametry regu\u0142y","BlockElementExplainText":"Ustawianie regu\u0142y blokuj\u0105cej element","SliderMinText":"MNIEJSZY","BlockText":"Zablokuj","ApplyRuleToAllSitesText":'Zastosuj t\u0119 regu\u0142\u0119 dla wszystkich stron internetowych<input id="oneDomainRadio" type="checkbox" class="checkbox">',"BlockByReferenceText":'Zablokuj element poprzez URL<input id="blockByUrl" type="checkbox" class="checkbox">',"SliderExplainText":"U\u017cyj tego suwaka, aby zmieni\u0107 rozmiar elementu do zablokowania przez t\u0119 regu\u0142\u0119:",
                            "PreviewText":"Podgl\u0105d","BlockSimilarText":'Zablokuj podobne elementy<input id="blockSimilar" type="checkbox" class="checkbox">',"BlockElementText":"Zablokuj element","ExtendedSettingsText":"Ustawienia zaawansowane..."},"previewEnd":"<span>Zako\u0144cz podgl\u0105d</span>","settingsMenu":{"AssistantViewSettingsText":"Ustawienia wy\u015bwietlania Asystenta Adguarda","IconSizeText":"Rozmiar ikony","UpText":'Na g\u00f3rze<input id="onTop" type="radio" name="vertical" class="radiobox">',"CancelText":"Anuluj",
                            "BigText":'Du\u017cy<input id="isBig" type="radio" name="size" class="radiobox">',"LeftText":'Po lewej<input id="onLeft" type="radio" name="horizontal" class="radiobox">',"RightText":'Po prawej<input id="onRight" type="radio" name="horizontal" class="radiobox">',"VerticalOrientationText":"Orientacja pionowa","DownText":'Na dole<input id="onBottom" type="radio" name="vertical" class="radiobox">',"HorizontalOrientationText":"Orientacja pozioma","SettingsText":"Ustawienia Asystenta","SmallText":'Ma\u0142y<input id="isSmall" type="radio" name="size" class="radiobox">',
                            "SaveText":"Zapisz"},"complaintMenu":{"CommentText":"Uwagi","ComplaintExtendedText":"Prosz\u0119 opisa\u0107 pow\u00f3d zg\u0142oszenia","AnotherText":'Inny<input id="another" type="radio" name="complaint" class="radiobox">',"AdSkippedText":'Pomini\u0119to reklam\u0119<input id="adMissing" type="radio" name="complaint" class="radiobox">',"IncorrectViewText":'Zniekszta\u0142cony wygl\u0105d strony<input id="wrongRender" type="radio" name="complaint" class="radiobox">',"PhishingSuspicionText":'Podejrzenie phishingu<input id="phishing" type="radio" name="complaint" class="radiobox">',
                            "ComplainReasonText":"Pow\u00f3d","CancelText":"Anuluj","SendComplaintText":"Zg\u0142o\u015b","ComplaintText":"Zg\u0142o\u015b problem"},"wotBad":"z\u0142\u0105 reputacj\u0119","exceptionMenu":{"EntireSiteText":'Ca\u0142a strona <input type="radio" name="scope" class="radiobox" checked="true">',"ExceptionClarificationText":"Ustawienia wyj\u0105tku dla tej strony","ExceptionDisclaimerText":"Tworzenie wyj\u0105tk\u00f3w pozwala na selektywne odblokowanie niekt\u00f3rych stron, element\u00f3w stron lub ca\u0142ych stron internetowych.",
                            "OnlyThisPageText":'Tylko ta strona <input id="onPage" type="radio" name="scope" class="radiobox">',"NewExceptionText":"Nowy wyj\u0105tek","AddExceptionButtonText":"Dodaj wyj\u0105tek","ExtendedSettings":"Ustawienia zaawansowane...","DontUseFiltrationRulesText":'Wy\u0142\u0105cz regu\u0142y filtrowania tre\u015bci <input id="content" type="checkbox" class="checkbox active" checked="true">',"ScopeText":"Zakres regu\u0142y wyj\u0105tku","DontUseAssistantText":'Wy\u0142\u0105cz asystenta Adguarda <input id="jsinject" type="checkbox" class="checkbox active" checked="true">',
                            "DontUseUriBlockRulesText":'Wy\u0142\u0105cz regu\u0142y blokuj\u0105ce URL <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',"DontUseHideRulesText":'Wy\u0142\u0105cz regu\u0142y ukrywaj\u0105ce elementy <input id="elemhide" type="checkbox" class="checkbox active" checked="true">',"ExceptionParametrsText":"W\u0142a\u015bciwo\u015bci regu\u0142y wyj\u0105tku"}};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["sr"]={"wotExcellent":"Odli\u010dna reputacija","complaintWarning":"Morate izabrati razlog va\u0161e \u017ealbe!","selectorMenu":{"cancel-select-mode":"Otka\u017eite na\u010din odabira","SelectElementText":"Na\u010din odabira","SelectElementExtendedText":"Kliknite na bilo koji element na stranici ili "},"wotPostfix":" Prema ","previewStart":"<span>Pregled</span>","dragHandleWithoutWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span></div><div class="adg-head-opt"><a target="_blank" href="${href}">Otvori izve\u0161taj bezbednosti za sajt</a><span class="adg-version">${version}</span></div>',
                        "dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"Dobra reputacija","alert":{"welcomeHead":"Adguard-ov pomo\u0107nik vam \u017eeli dobrodo\u0161licu!","welcomeLink":{"text":"Vi\u0161e informacija","href":"http://adguard.com/tour.html"},"welcomeMessage":"Adguard-ov pomo\u0107nik je poseban podprogram preglednika za filtriranje sajtova. On \u0107e vam dozvoliti da uklonite bilo koji ne\u017eeljeni sadr\u017eaj sa sajta. Tako\u0111e, obojena ikonica signalizira trenutno reputaciju sajta."},"mainMenu":{"toolTips":{"ConfidenceIndication":"Nivo poverljivosti reputacije",
                            "WotIndication":"Indikator reputacije sajta"},"SendComplaintText":"Po\u0161alji<br>\u017ealbu","blockElementTextExtend":"Mo\u017eete ru\u010dno odabrati i ukloniti bilo koji element sa stranice kao \u0161to su slike, baneri ili bilo \u0161ta drugo.","UndoLastRuleText":"Opozovi<br>poslednju radnju<br>","AssistantSettingsText":"Promeni<br>postavke<br>","AddToExceptionsTextExtend":"Adguard \u0107e zaustaviti filtriranje reklama na ovom sajtu sve dok ga ne uklonite sa liste izuzetaka.","AddToExceptionsText":"Dodaj<br>izuzetak",
                            "TemporaryExceptionText":"Ne blokiraj <br>30 sekundi<br>","blockElementText":"Blokiraj<br>element"},"blockTextIfSliderHided":"Filter \u0107e sadr\u017eati pravilo koje \u0107e blokirati izabrani element.","wotPrefix":"Ovaj sajt ima ","wotUnsatisfactory":"Nezadovoljavaju\u0107a reputacija","wotPoor":"Slaba reputacija","wotUnknown":"Nepoznata reputacija","detailedMenu":{"SliderMaxText":"Ve\u0107e","AnotherElementText":"Izaberite drugi element","RuleParametrsText":"Parametri pravila","BlockElementExplainText":"Pode\u0161avanje pravila za blokiranje elementa",
                            "SliderMinText":"Manje","BlockText":"Blokiraj","ApplyRuleToAllSitesText":'Primeni ovo pravilo na sve sajtove<input id="oneDomainRadio" type="checkbox" class="checkbox">',"BlockByReferenceText":'Blokiraj elemente prema linku<input id="blockByUrl" type="checkbox" class="checkbox">',"SliderExplainText":"Koristite kliza\u010d kako bi ste podesili veli\u010dinu elementa koji blokirate ovim pravilom:","PreviewText":"Pregledaj","BlockSimilarText":'Blokiraj sli\u010dne elemente<input id="blockSimilar" type="checkbox" class="checkbox">',
                            "BlockElementText":"Blokiraj element","ExtendedSettingsText":"Napredna pode\u0161avanja..."},"previewEnd":"<span>Zavr\u0161i pregled</span>","settingsMenu":{"AssistantViewSettingsText":"Postavke prikazivanja Adguard-ovog pomo\u0107nika","IconSizeText":"Veli\u010dina ikonice","UpText":'Gore<input id="onTop" type="radio" name="vertical" class="radiobox">',"CancelText":"Otka\u017ei","BigText":'Veliko<input id="isBig" type="radio" name="size" class="radiobox">',"LeftText":'Levo<input id="onLeft" type="radio" name="horizontal" class="radiobox">',
                            "RightText":'Desno<input id="onRight" type="radio" name="horizontal" class="radiobox">',"VerticalOrientationText":"Vertikalna orijentacija","DownText":'Dole<input id="onBottom" type="radio" name="vertical" class="radiobox">',"HorizontalOrientationText":"Horizontalna orijentacija","SettingsText":"Postavke pomo\u0107nika","SmallText":'Malo<input id="isSmall" type="radio" name="size" class="radiobox">',"SaveText":"Sa\u010duvaj"},"complaintMenu":{"CommentText":"Komentari","ComplaintExtendedText":"Molimo vas da navedete razloge va\u0161e \u017ealbe.",
                            "AnotherText":'Drugo<input id="another" type="radio" name="complaint" class="radiobox">',"AdSkippedText":'Presko\u010dena reklama<input id="adMissing" type="radio" name="complaint" class="radiobox">',"IncorrectViewText":'Sajt se lo\u0161e prikazuje<input id="wrongRender" type="radio" name="complaint" class="radiobox">',"PhishingSuspicionText":'Sumnjam na fi\u0161ing<input id="phishing" type="radio" name="complaint" class="radiobox">',"ComplainReasonText":"Razlog","CancelText":"Otka\u017ei","SendComplaintText":"Po\u0161alji",
                            "ComplaintText":"Po\u0161alji \u017ealbu"},"wotBad":"Lo\u0161a reputacija","exceptionMenu":{"EntireSiteText":'\u010citav sajt <input type="radio" name="scope" class="radiobox" checked="true">',"ExceptionClarificationText":"Postavke izuzetka za ovu stranicu","ExceptionDisclaimerText":"Stvaranje izuzetaka vam omogu\u0107ava da selektivno deblokirate stranice, elemente na stranicama ili \u010ditave sajtove.","OnlyThisPageText":'Samo ova stranica<input id="onPage" type="radio" name="scope" class="radiobox">',
                            "NewExceptionText":"Novi izuzetak","AddExceptionButtonText":"Dodaj izuzetak","ExtendedSettings":"Napredna pode\u0161avanja...","DontUseFiltrationRulesText":'Isklju\u010di filtriranje sadr\u017eaja <input id="content" type="checkbox" class="checkbox active" checked="true">',"ScopeText":"Opseg izuzetka","DontUseAssistantText":'Isklju\u010di Adguard-ovog pomo\u0107nika <input id="jsinject" type="checkbox" class="checkbox active" checked="true">',"DontUseUriBlockRulesText":'Isklju\u010di blokiranje linkova <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',
                            "DontUseHideRulesText":'Isklju\u010di ili sakrij element <input id="elemhide" type="checkbox" class="checkbox active" checked="true">',"ExceptionParametrsText":"Svojstva izuzetka"}};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["zh"]={"wotExcellent":"\u53e3\u7891\u6781\u4f73","complaintWarning":"\u4f60\u5fc5\u987b\u63d0\u4f9b\u6295\u8bc9\u539f\u56e0\uff01","selectorMenu":{"cancel-select-mode":"\u53d6\u6d88\u9009\u62e9\u6a21\u5f0f","SelectElementText":"\u9009\u62e9\u6a21\u5f0f","SelectElementExtendedText":"\u70b9\u51fb\u9875\u9762\u4e0a\u7684\u4efb\u4f55\u5143\u7d20\u6216 "},"wotPostfix":" \u6839\u636e ","previewStart":"<span>\u9884\u89c8</span>","dragHandleWithoutWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span></div><div class="adg-head-opt"><a target="_blank" href="${href}">\u6253\u5f00\u7f51\u7ad9\u5b89\u5168\u6027\u62a5\u544a</a><span class="adg-version">${version}</span></div>',
                        "dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"\u53e3\u7891\u4e0d\u9519","alert":{"welcomeHead":"\u6b22\u8fce\u4f7f\u7528 Adguard \u52a9\u624b\uff01","welcomeLink":{"text":"\u4e86\u89e3\u66f4\u591a\u4fe1\u606f","href":"http://adguard.com/tour.html"},"welcomeMessage":"Adguard \u52a9\u624b\u662f Adguard \u5e7f\u544a\u8fc7\u6ee4\u5668\u7684\u7279\u6b8a\u6a21\u5757\u3002\u5b83\u5c06\u5e2e\u52a9\u4f60\u79fb\u9664\u7f51\u9875\u4e0a\u4efb\u4f55\u60a8\u4e0d\u5e0c\u671b\u663e\u793a\u7684\u5143\u7d20\u3002\u540c\u65f6\u80fd\u901a\u8fc7\u5176\u56fe\u6807\u989c\u8272\u6765\u5c55\u793a\u60a8\u6b63\u5728\u8bbf\u95ee\u7684\u7f51\u7ad9\u7684\u4fe1\u8a89\u7b49\u7ea7\u3002"},
                        "mainMenu":{"toolTips":{"ConfidenceIndication":"\u7f51\u7ad9\u4fe1\u8a89\u7b49\u7ea7","WotIndication":"\u7f51\u7ad9\u4fe1\u8a89\u7b49\u7ea7"},"SendComplaintText":"\u63d0\u4ea4<br>\u6295\u8bc9","blockElementTextExtend":"\u4f60\u53ef\u4ee5\u624b\u52a8\u9009\u62e9\u9875\u9762\u4e2d\u4f60\u60f3\u8981\u79fb\u9664\u7684\u4efb\u4f55\u5143\u7d20\uff08\u5e7f\u544a\u3001\u6761\u5e45\u7b49\u7b49\uff09","UndoLastRuleText":"\u64a4\u9500<br>\u4e0a\u4e00\u52a8\u4f5c<br>","AssistantSettingsText":"\u66f4\u6539<br>\u8bbe\u7f6e<br>",
                            "AddToExceptionsTextExtend":"Adguard \u5c06\u505c\u6b62\u5bf9\u5bf9\u6b64\u7f51\u7ad9\u7684\u5e7f\u544a\u62e6\u622a\u76f4\u5230\u60a8\u5c06\u5176\u79fb\u51fa\u4f8b\u5916\u5217\u8868","AddToExceptionsText":"\u589e\u52a0<br>\u4f8b\u5916","TemporaryExceptionText":"\u505c\u6b62\u5e7f\u544a\u62e6\u622a<br>30\u79d2<br>","blockElementText":"\u62e6\u622a<br>\u5143\u7d20"},"blockTextIfSliderHided":"\u8fc7\u6ee4\u5668\u5c06\u5305\u542b\u62e6\u622a\u6240\u9009\u5143\u7d20\u7684\u89c4\u5219","wotPrefix":"\u672c\u7ad9\u70b9 ",
                        "wotUnsatisfactory":"\u53e3\u7891\u4e0d\u5c3d\u4eba\u610f","wotPoor":"\u53e3\u7891\u4e0d\u4f73","wotUnknown":"\u8bc4\u4ef7\u672a\u77e5","detailedMenu":{"SliderMaxText":"\u8f83\u5927","AnotherElementText":"\u9009\u62e9\u5176\u5b83\u5143\u7d20","RuleParametrsText":"\u89c4\u5219\u53c2\u6570","BlockElementExplainText":"\u5143\u7d20\u62e6\u622a\u89c4\u5219\u8bbe\u7f6e","SliderMinText":"\u8f83\u5c0f","BlockText":"\u62e6\u622a","ApplyRuleToAllSitesText":'\u5e94\u7528\u6b64\u89c4\u5219\u5230\u5404\u7f51\u7ad9<input id="oneDomainRadio" type="checkbox" class="checkbox">',
                            "BlockByReferenceText":'\u7ecf\u7531 URL \u62e6\u622a\u5143\u7d20 <input id="blockByUrl" type="checkbox" class="checkbox">',"SliderExplainText":"\u4f7f\u7528\u6ed1\u5757\u66f4\u6539\u8981\u7531\u6b64\u89c4\u5219\u62e6\u622a\u7684\u5143\u7d20\u5c3a\u5bf8\uff1a","PreviewText":"\u9884\u89c8","BlockSimilarText":'\u62e6\u622a\u76f8\u4f3c\u5143\u7d20<input id="blockSimilar" type="checkbox" class="checkbox">',"BlockElementText":"\u62e6\u622a\u5143\u7d20","ExtendedSettingsText":"\u9ad8\u7ea7\u8bbe\u7f6e..."},
                        "previewEnd":"<span>\u5b8c\u6210\u9884\u89c8</span>","settingsMenu":{"AssistantViewSettingsText":"Adguard \u52a9\u624b\u663e\u793a\u8bbe\u7f6e","IconSizeText":"\u56fe\u6807\u5927\u5c0f","UpText":'\u5411\u4e0a<input id="onTop" type="radio" name="vertical" class="radiobox">',"CancelText":"\u53d6\u6d88","BigText":'\u66f4\u5927<input id="isBig" type="radio" name="size" class="radiobox">',"LeftText":'\u5411\u5de6<input id="onLeft" type="radio" name="horizontal" class="radiobox">',"RightText":'\u5411\u53f3<input id="onRight" type="radio" name="horizontal" class="radiobox">',
                            "VerticalOrientationText":"\u5782\u76f4\u65b9\u5411","DownText":'\u5411\u4e0b<input id="onBottom" type="radio" name="vertical" class="radiobox">',"HorizontalOrientationText":"\u6c34\u5e73\u65b9\u5411","SettingsText":"Adguard \u52a9\u624b\u8bbe\u7f6e","SmallText":'\u66f4\u5c0f<input id="isSmall" type="radio" name="size" class="radiobox">',"SaveText":"\u4fdd\u5b58"},"complaintMenu":{"CommentText":"\u8bc4\u8bba","ComplaintExtendedText":"\u8bf7\u9009\u62e9\u6b64\u6b21\u6295\u8bc9\u7684\u539f\u56e0","AnotherText":'\u5176\u4ed6<input id="another" type="radio" name="complaint" class="radiobox">',
                            "AdSkippedText":'\u5e7f\u544a\u672a\u62e6\u622a<input id="adMissing" type="radio" name="complaint" class="radiobox">',"IncorrectViewText":'\u7f51\u7ad9\u663e\u793a\u5f02\u5e38<input id="wrongRender" type="radio" name="complaint" class="radiobox">',"PhishingSuspicionText":'\u6d89\u5acc\u7f51\u7edc\u9493\u9c7c<input id="phishing" type="radio" name="complaint" class="radiobox">',"ComplainReasonText":"\u539f\u56e0","CancelText":"\u53d6\u6d88","SendComplaintText":"\u63d0\u4ea4","ComplaintText":"\u63d0\u4ea4\u6295\u8bc9"},
                        "wotBad":"\u53e3\u7891\u6781\u5dee","exceptionMenu":{"EntireSiteText":'\u6574\u4e2a\u7f51\u7ad9<input type="radio" name="scope" class="radiobox" checked="true">',"ExceptionClarificationText":"\u6b64\u9875\u9762\u7684\u4f8b\u5916\u8bbe\u7f6e","ExceptionDisclaimerText":"\u901a\u8fc7\u521b\u5efa\u4f8b\u5916\u8bbe\u7f6e\u60a8\u53ef\u4ee5\u6307\u5b9a\u67d0\u4e9b\u7f51\u9875\u3001\u9875\u9762\u5143\u7d20\u6216\u6574\u4e2a\u7f51\u7ad9\u4e0d\u53d7\u5e7f\u544a\u62e6\u622a\u5e72\u6270\u3002","OnlyThisPageText":'\u4ec5\u6b64\u9875\u9762<input id="onPage" type="radio" name="scope" class="radiobox">',
                            "NewExceptionText":"\u65b0\u589e\u4f8b\u5916","AddExceptionButtonText":"\u589e\u52a0\u4f8b\u5916","ExtendedSettings":"\u9ad8\u7ea7\u8bbe\u7f6e...","DontUseFiltrationRulesText":'\u505c\u7528\u5143\u7d20\u8fc7\u6ee4\u89c4\u5219 <input id="content" type="checkbox" class="checkbox active" checked="true">',"ScopeText":"\u4f8b\u5916\u89c4\u5219\u9002\u7528\u8303\u56f4","DontUseAssistantText":'\u505c\u7528 Adguard \u52a9\u624b <input id="jsinject" type="checkbox" class="checkbox active" checked="true">',
                            "DontUseUriBlockRulesText":'\u505c\u7528 URL \u8fc7\u6ee4\u89c4\u5219 <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',"DontUseHideRulesText":'\u505c\u7528\u5143\u7d20\u9690\u85cf\u89c4\u5219 <input id="elemhide" type="checkbox" class="checkbox active" checked="true">',"ExceptionParametrsText":"\u4f8b\u5916\u89c4\u5219\u5c5e\u6027"}};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["zh-tw"]={"wotExcellent":"\u4e0d\u932f\u7684\u4fe1\u8b7d\u8a55\u7b49","complaintWarning":"\u60a8\u5fc5\u9808\u9078\u64c7\u4e00\u500b\u4f4e\u8a55\u50f9\u7684\u539f\u56e0\uff01","selectorMenu":{"cancel-select-mode":"\u53d6\u6d88\u9078\u64c7\u6a21\u5f0f","SelectElementText":"\u9078\u64c7\u6a21\u5f0f","SelectElementExtendedText":"\u9ede\u9078\u7db2\u7ad9\u4e0a\u7684\u4efb\u4f55\u5143\u7d20\u6216 "},"wotPostfix":" \uff0c\u8a55\u7b49\u4f86\u6e90\u81ea ","previewStart":"<span>\u9810\u89bd</span>",
                        "dragHandleWithoutWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span></div><div class="adg-head-opt"><a target="_blank" href="${href}">\u958b\u555f\u7db2\u7ad9\u5b89\u5168\u6027\u5831\u544a</a><span class="adg-version">${version}</span></div>',"dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"\u826f\u597d\u7684\u4fe1\u8b7d\u8a55\u7b49","alert":{"welcomeHead":"\u6b61\u8fce\u4f7f\u7528 Adguard\u52a9\u624b\uff01","welcomeLink":{"text":"\u66f4\u591a\u8cc7\u8a0a","href":"http://adguard.com/tour.html"},"welcomeMessage":"Adguard\u52a9\u624b\u662f\u4e00\u500b\u7279\u5225\u7684 Adguard\u7db2\u9801\u904e\u6ffe\u700f\u89bd\u5668\u6a21\u7d44\uff0c\u5b83\u80fd\u5920\u8b93\u60a8\u79fb\u9664\u7db2\u7ad9\u4e0a\u4efb\u4f55\u4e0d\u60f3\u8981\u7684\u5167\u5bb9\uff0c\u4e5f\u53ef\u4ee5\u900f\u904e\u5716\u793a\u7684\u984f\u8272\u63d0\u9192\u60a8\u7db2\u7ad9\u7684\u4fe1\u8b7d\u8a55\u7b49\u3002"},
                        "mainMenu":{"toolTips":{"ConfidenceIndication":"\u4fe1\u8b7d\u53ef\u4fe1\u5ea6\u7b49\u7d1a","WotIndication":"\u7db2\u7ad9\u4fe1\u8b7d\u8a08\u6578"},"SendComplaintText":"\u9001\u51fa<br>\u4f4e\u8a55\u50f9","blockElementTextExtend":"\u60a8\u53ef\u4ee5\u5f9e\u6b64\u7db2\u7ad9\u4e0a\u624b\u52d5\u9078\u64c7\u9801\u9762\u4e0a\u7684\u5143\u7d20\uff08\u4f8b\u5982\u5716\u7247\u3001\u6a6b\u5e45\u7b49\uff09\u4f86\u79fb\u9664\u3002","UndoLastRuleText":"\u5fa9\u539f<br>\u4e0a\u6b21\u7684\u64cd\u4f5c<br>","AssistantSettingsText":"\u8b8a\u66f4<br>\u8a2d\u5b9a<br>",
                            "AddToExceptionsTextExtend":"Adguard\u5c07\u6703\u505c\u6b62\u904e\u616e\u6b64\u7db2\u7ad9\u7684\u5ee3\u544a\uff0c\u9664\u975e\u60a8\u5c07\u5b83\u5f9e\u4f8b\u5916\u4e2d\u79fb\u9664\u3002","AddToExceptionsText":"\u65b0\u589e<br>\u4f8b\u5916","TemporaryExceptionText":"\u66ab\u505c\u5c01\u9396<br>30\u79d2<br>","blockElementText":"\u963b\u64cb<br>\u5143\u7d20"},"blockTextIfSliderHided":"\u6b64\u904e\u6ffe\u898f\u5247\u5c07\u5305\u542b\u963b\u64cb\u9078\u53d6\u7684\u5143\u7d20","wotPrefix":"\u6b64\u7db2\u7ad9\u64c1\u6709 ",
                        "wotUnsatisfactory":"\u4e0d\u6eff\u610f\u7684\u4fe1\u8b7d\u8a55\u7b49","wotPoor":"\u5dee\u7684\u4fe1\u8b7d\u8a55\u7b49","wotUnknown":"\u672a\u77e5\u7684\u4fe1\u8b7d\u8a55\u7b49","detailedMenu":{"SliderMaxText":"\u8f03\u5927","AnotherElementText":"\u9078\u64c7\u5176\u4ed6\u5143\u7d20","RuleParametrsText":"\u898f\u5247\u53c3\u6578","BlockElementExplainText":"\u5143\u7d20\u963b\u64cb\u898f\u5247\u8a2d\u5b9a","SliderMinText":"\u8f03\u5c0f","BlockText":"\u963b\u64cb","ApplyRuleToAllSitesText":'\u61c9\u7528\u6b64\u898f\u5247\u81f3\u6bcf\u4e00\u500b\u7db2\u7ad9<input id="oneDomainRadio" type="checkbox" class="checkbox">',
                            "BlockByReferenceText":'\u4f9d\u64da\u7db2\u5740\u5c01\u9396\u5143\u7d20<input id="blockByUrl" type="checkbox" class="checkbox">',"SliderExplainText":"\u4f7f\u7528\u6ed1\u687f\u6539\u8b8a\u6b64\u898f\u5247\u8981\u963b\u64cb\u5143\u7d20\u7684\u5927\u5c0f\uff1a","PreviewText":"\u9810\u89bd","BlockSimilarText":'\u5c01\u9396\u76f8\u4f3c\u7684\u5143\u7d20<input id="blockSimilar" type="checkbox" class="checkbox">',"BlockElementText":"\u963b\u64cb\u5143\u7d20","ExtendedSettingsText":"\u9032\u968e\u8a2d\u5b9a..."},
                        "previewEnd":"<span>\u7d50\u675f\u9810\u89bd</span>","settingsMenu":{"AssistantViewSettingsText":"Adguard\u52a9\u624b\u986f\u793a\u8a2d\u5b9a","IconSizeText":"\u5716\u793a\u5c3a\u5bf8","UpText":'\u4e0a<input id="onTop" type="radio" name="vertical" class="radiobox">',"CancelText":"\u53d6\u6d88","BigText":'\u8f03\u5927<input id="isBig" type="radio" name="size" class="radiobox">',"LeftText":'\u5de6<input id="onLeft" type="radio" name="horizontal" class="radiobox">',"RightText":'\u53f3<input id="onRight" type="radio" name="horizontal" class="radiobox">',
                            "VerticalOrientationText":"\u5782\u76f4\u65b9\u5411","DownText":'\u4e0b<input id="onBottom" type="radio" name="vertical" class="radiobox">',"HorizontalOrientationText":"\u6c34\u5e73\u65b9\u5411","SettingsText":"\u52a9\u624b\u8a2d\u5b9a","SmallText":'\u8f03\u5c0f<input id="isSmall" type="radio" name="size" class="radiobox">',"SaveText":"\u5132\u5b58"},"complaintMenu":{"CommentText":"\u7559\u8a00","ComplaintExtendedText":"\u8acb\u63cf\u8ff0\u70ba\u4ec0\u9ebc\u9001\u51fa\u4f4e\u8a55\u50f9","AnotherText":'\u5176\u4ed6\u56e0\u7d20<input id="another" type="radio" name="complaint" class="radiobox">',
                            "AdSkippedText":'\u5ee3\u544a\u88ab\u7565\u904e\u800c\u672a\u904e\u6ffe<input id="adMissing" type="radio" name="complaint" class="radiobox">',"IncorrectViewText":'\u7db2\u7ad9\u986f\u793a\u6709\u8aa4\u6216\u906d\u7ac4\u6539<input id="wrongRender" type="radio" name="complaint" class="radiobox">',"PhishingSuspicionText":'\u53ef\u80fd\u6709\u7db2\u8def\u91e3\u9b5a<input id="phishing" type="radio" name="complaint" class="radiobox">',"ComplainReasonText":"\u539f\u56e0","CancelText":"\u53d6\u6d88","SendComplaintText":"\u9001\u51fa",
                            "ComplaintText":"\u9001\u51fa\u4f4e\u8a55\u50f9"},"wotBad":"\u975e\u5e38\u5dee\u7684\u4fe1\u8b7d\u8a55\u7b49","exceptionMenu":{"EntireSiteText":'\u6574\u500b\u7db2\u7ad9<input type="radio" name="scope" class="radiobox" checked="true">',"ExceptionClarificationText":"\u6b64\u9801\u9762\u7684\u4f8b\u5916\u8a2d\u5b9a","ExceptionDisclaimerText":"\u5efa\u7acb\u4f8b\u5916\u6e05\u55ae\u80fd\u8b93\u60a8\u9078\u64c7\u4e0d\u8981\u963b\u64cb\u7684\u9801\u9762\u3001\u5143\u7d20\u6216\u6574\u500b\u7db2\u7ad9\u3002",
                            "OnlyThisPageText":'\u50c5\u6b64\u9801\u9762<input id="onPage" type="radio" name="scope" class="radiobox">',"NewExceptionText":"\u65b0\u589e\u4f8b\u5916","AddExceptionButtonText":"\u65b0\u589e\u4f8b\u5916","ExtendedSettings":"\u9032\u968e\u8a2d\u5b9a...","DontUseFiltrationRulesText":'\u95dc\u9589\u5167\u5bb9\u904e\u6ffe\u898f\u5247<input id="content" type="checkbox" class="checkbox active" checked="true">',"ScopeText":"\u4f8b\u5916\u898f\u5247\u7bc4\u570d","DontUseAssistantText":'\u95dc\u9589 Adguard\u52a9\u624b<input id="jsinject" type="checkbox" class="checkbox active" checked="true">',
                            "DontUseUriBlockRulesText":'\u95dc\u9589\u7db2\u5740\u963b\u64cb\u898f\u5247<input id="urlblock" type="checkbox" class="checkbox active" checked="true">',"DontUseHideRulesText":'\u95dc\u9589\u5143\u7d20\u904e\u6ffe\u898f\u5247<input id="elemhide" type="checkbox" class="checkbox active" checked="true">',"ExceptionParametrsText":"\u4f8b\u5916\u898f\u5247\u529f\u80fd"}};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["it"]={"wotExcellent":"una reputazione eccellente","complaintWarning":"Devi selezionare una ragione per il tuo reclamo!","selectorMenu":{"cancel-select-mode":"modalit\u00e0 cancella selezione","SelectElementText":"Modo di selezione","SelectElementExtendedText":"Clicca su qualsiasi elemento nella pagina oppure "},"wotPostfix":" secondo a ","previewStart":"<span>Anteprima</span>","dragHandleWithoutWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span></div><div class="adg-head-opt"><a target="_blank" href="${href}">Apri il rapporto sulla sicurezza del sito internet</a><span class="adg-version">${version}</span></div>',
                        "dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"una buona reputazione","alert":{"welcomeHead":"Benvenuto nell'Assistente di Adguard!","welcomeLink":{"text":"Maggiori informazioni","href":"http://adguard.com/tour.html"},"welcomeMessage":"L'Assistente di Adguard \u00e8 uno speciale modulo del browser del Filtro Internet di Adguard. Ti permette di rimuovere qualsiasi contenuto indesiderato dal sito internet. In pi\u00f9 l'icona colorata ti segnala riguardo alla corrente reputazione del sito."},"mainMenu":{"toolTips":{"ConfidenceIndication":"Livello di Confidenza della Reputazione",
                            "WotIndication":"Indicatore della reputazione del sito"},"SendComplaintText":"Invia<br> un reclamo","blockElementTextExtend":"Puoi selezionare manualmente e rimuovere qualsiasi elemento (immagine, banner, ecc.) da questa pagina o sito internet","UndoLastRuleText":"Annulla<br>l'ultima azione<br>","AssistantSettingsText":"Cambia<br>impostazioni<br>","AddToExceptionsTextExtend":"Adguard fermer\u00e0 il filtraggio degli annunci su questo sito internet finch\u00e9 non lo rimuoverai dalla lista delle eccezioni",
                            "AddToExceptionsText":"Aggiungi<br>Eccezione","TemporaryExceptionText":"Non bloccare<br>per 30 secondi<br>","blockElementText":"Blocca<br>elemento"},"blockTextIfSliderHided":"Il filtro conterr\u00e0 una regola che blocca l'elemento selezionato","wotPrefix":"Questo sito ha ","wotUnsatisfactory":"una reputazione non soddisfacente","wotPoor":"una scarsa reputazione","wotUnknown":"una reputazione sconosciuta","detailedMenu":{"SliderMaxText":"GRANDE","AnotherElementText":"Seleziona un altro elemento",
                            "RuleParametrsText":"Parametri della regola","BlockElementExplainText":"Impostazione della regola elemento di blocco","SliderMinText":"PICCOLO","BlockText":"Blocca","ApplyRuleToAllSitesText":'Applica questa regola ad ogni sito internet<input id="oneDomainRadio" type="checkbox" class="checkbox">',"BlockByReferenceText":'Blocca elemento dall\'URL<input id="blockByUrl" type="checkbox" class="checkbox">',"SliderExplainText":"Usa la barra per cambiare la grandezza dell'elemento da bloccare tramite questa regola:",
                            "PreviewText":"Anteprima","BlockSimilarText":'Blocca elementi simili<input id="blockSimilar" type="checkbox" class="checkbox">',"BlockElementText":"Blocca elemento","ExtendedSettingsText":"Impostazioni avanzate..."},"previewEnd":"<span>Termina anteprima</span>","settingsMenu":{"AssistantViewSettingsText":"Impostazioni di visualizzazione Assistente Adguard","IconSizeText":"Grandezza dell'icona","UpText":'Sopra<input id="onTop" type="radio" name="vertical" class="radiobox">',"CancelText":"Annulla",
                            "BigText":'Largo<input id="isBig" type="radio" name="size" class="radiobox">',"LeftText":'Sinistra<input id="onLeft" type="radio" name="horizontal" class="radiobox">',"RightText":'Destra<input id="onRight" type="radio" name="horizontal" class="radiobox">',"VerticalOrientationText":"Orientamento verticale","DownText":'Sotto<input id="onBottom" type="radio" name="vertical" class="radiobox">',"HorizontalOrientationText":"Orientamento orizzontale","SettingsText":"Impostazioni Assistente","SmallText":'Piccolo<input id="isSmall" type="radio" name="size" class="radiobox">',
                            "SaveText":"Salva"},"complaintMenu":{"CommentText":"Commenti","ComplaintExtendedText":"Per favore descrivi la ragione di questo reclamo","AnotherText":'Altro<input id="another" type="radio" name="complaint" class="radiobox">',"AdSkippedText":'Annuncio saltato<input id="adMissing" type="radio" name="complaint" class="radiobox">',"IncorrectViewText":'Visualizzazione sito web distorto<input id="wrongRender" type="radio" name="complaint" class="radiobox">',"PhishingSuspicionText":'Sospetto phishing<input id="phishing" type="radio" name="complaint" class="radiobox">',
                            "ComplainReasonText":"Ragione","CancelText":"Annulla","SendComplaintText":"Invia","ComplaintText":"Invia un reclamo"},"wotBad":"una pessima reputazione","exceptionMenu":{"EntireSiteText":'Sito intero <input type="radio" name="scope" class="radiobox" checked="true">',"ExceptionClarificationText":"Impostazioni eccezione per questa pagina","ExceptionDisclaimerText":"Creare eccezioni ti permette di sbloccare selettivamente certe pagine, elementi della pagina o interi siti internet.","OnlyThisPageText":'Solo questa pagina<input id="onPage" type="radio" name="scope" class="radiobox">',
                            "NewExceptionText":"Nuova eccezione","AddExceptionButtonText":"Aggiungi eccezione","ExtendedSettings":"Impostazioni avanzate...","DontUseFiltrationRulesText":'Disabilita regole di filtraggio del contenuto <input id="content" type="checkbox" class="checkbox active" checked="true">',"ScopeText":"Ambito della regola di eccezione","DontUseAssistantText":'Disabilita assistente Adguard <input id="jsinject" type="checkbox" class="checkbox active" checked="true">',"DontUseUriBlockRulesText":'Disabilita regole di bloccaggio URL <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',
                            "DontUseHideRulesText":'Disabilita regole di nascondo elemento <input id="elemhide" type="checkbox" class="checkbox active" checked="true">',"ExceptionParametrsText":"Propriet\u00e0 della regola di eccezione"}};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["ko"]={"wotExcellent":"\ud6cc\ub96d\ud568,","complaintWarning":"\ubd88\ub9cc \uc0ac\ud56d\uc758 \uc774\uc720\ub97c \uc120\ud0dd\ud558\uc154\uc57c \ud569\ub2c8\ub2e4.","selectorMenu":{"cancel-select-mode":"\uc120\ud0dd\ubaa8\ub4dc \ucde8\uc18c","SelectElementText":"\uc120\ud0dd \ubaa8\ub4dc","SelectElementExtendedText":"\ud398\uc774\uc9c0\uc758 \ud56d\ubaa9 \uc120\ud0dd \ub610\ub294"},"wotPostfix":" \uc790\ub8cc \uc81c\uacf5 ","previewStart":"<span>\ubbf8\ub9ac\ubcf4\uae30</span>","dragHandleWithoutWot":'{<div class="adg-head-h">}{<span class="adg-domain">}${domainName}{</span>}{</div>}{<div class="adg-head-opt">}{<a href="link_5">\uc6f9\uc0ac\uc774\ud2b8 \ubcf4\uc548 \ubcf4\uace0\uc11c \uc5f4\uae30{</a>}{<div class="adg-version">}${version}{</div>}{</div>}',
                        "dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"\uc88b\uc74c,","alert":{"welcomeHead":"Adguard \ub3c4\uc6b0\ubbf8 \uc0ac\uc6a9\uc744 \ud658\uc601\ud569\ub2c8\ub2e4!","welcomeLink":{"text":"\ub354 \uc54c\uc544\ubcf4\uae30","href":"http://adguard.com/tour.html"},"welcomeMessage":"Adguard \ub3c4\uc6b0\ubbf8\ub294 Adguard \uc6f9 \ud544\ud130\uc758 \ud2b9\ubcc4\ud55c \ube0c\ub77c\uc6b0\uc800 \ubaa8\ub4c8\uc785\ub2c8\ub2e4. \ub3c4\uc6b0\ubbf8\ub97c \ud1b5\ud574 \uc6f9\uc0ac\uc774\ud2b8\uc5d0\uc11c \uc6d0\ud558\uc9c0 \uc54a\ub294 \uc694\uc18c\ub97c \uc9c0\uc6b0\uc2ed\uc2dc\uc624. \ub610 \uc544\uc774\ucf58 \uc0c9\uc744 \ud1b5\ud574 \ud604\uc7ac \uc6f9\uc0ac\uc774\ud2b8\uc758 \ud3c9\ud310\uc744 \ud655\uc778\ud558\uc2ed\uc2dc\uc624."},
                        "mainMenu":{"toolTips":{"ConfidenceIndication":"\ud3c9\ud310\uc744 \uc5bc\ub9c8\ub098 \uc2e0\ub8b0\ud560 \uc218 \uc788\ub294\uc9c0\ub97c \ub098\ud0c0\ub0c5\ub2c8\ub2e4.","WotIndication":"\ud604\uc7ac \uc0ac\uc774\ud2b8\uc758 \ud3c9\ud310\uc744 \ub098\ud0c0\ub0c5\ub2c8\ub2e4."},"SendComplaintText":"\ubd88\ub9cc<br>\uc804\uc1a1","blockElementTextExtend":"\ud604\uc7ac \ud398\uc774\uc9c0\uc5d0\uc11c \ucc28\ub2e8\ud558\uace0\uc790 \ud558\ub294 \uc774\ubbf8\uc9c0, \ubc30\ub108 \ub4f1\uc744 \ub9c8\uc6b0\uc2a4\ub85c \ud074\ub9ad\ud558\uc5ec \uc120\ud0dd\ud558\uc138\uc694.",
                            "UndoLastRuleText":"\ub9c8\uc9c0\ub9c9 \uc791\uc5c5<br>\ub418\ub3cc\ub9ac\uae30<br>","AssistantSettingsText":"\uc124\uc815<br>\ubcc0\uacbd<br>","AddToExceptionsTextExtend":"\uc774 \uc0ac\uc774\ud2b8\uc758 \uad11\uace0\ub97c \ud544\ud130\ub9c1\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uadc0\ud558\uac00 \uc608\uc678 \ubaa9\ub85d\uc5d0\uc11c \uc774 \uc0ac\uc774\ud2b8\ub97c \uc81c\uac70\ud560 \ub54c\uae4c\uc9c0 \uc9c0\uc18d\ub429\ub2c8\ub2e4.","AddToExceptionsText":"\uc608\uc678<br>\ucd94\uac00","TemporaryExceptionText":"30\ucd08 \ub3d9\uc548<br>\ucc28\ub2e8 \uc77c\uc2dc\uc815\uc9c0<br>",
                            "blockElementText":"\uc694\uc18c<br>\ucc28\ub2e8"},"blockTextIfSliderHided":"\uc120\ud0dd\ub41c \uc694\uc18c\ub97c \ucc28\ub2e8\ud558\uae30 \uc704\ud55c \uaddc\uce59\uc774 \ub098\ud0c0\ub0a9\ub2c8\ub2e4","wotPrefix":"\uc774 \uc0ac\uc774\ud2b8\uc758 \ud3c9\ud310: ","wotUnsatisfactory":"\uc88b\uc9c0 \uc54a\uc74c,","wotPoor":"\ub098\uc068,","wotUnknown":"\uc54c \uc218 \uc5c6\uc74c,","detailedMenu":{"SliderMaxText":"\ud06c\uac8c","AnotherElementText":"\ub2e4\ub978 \uc694\uc18c \uc120\ud0dd","RuleParametrsText":"\uaddc\uce59 \uc635\uc158",
                            "BlockElementExplainText":"\uc694\uc18c \ucc28\ub2e8 \uaddc\uce59 \uc124\uc815","SliderMinText":"\uc791\uac8c","BlockText":"\ucc28\ub2e8","ApplyRuleToAllSitesText":'\uc774 \uaddc\uce59\uc744 \ubaa8\ub4e0 \uc6f9\uc0ac\uc774\ud2b8\uc5d0 \uc801\uc6a9<input id="oneDomainRadio" type="checkbox" class="checkbox">',"BlockByReferenceText":'\ucee8\ud150\uce20 \uc8fc\uc18c\ub85c \ucc28\ub2e8<input id="blockByUrl" type="checkbox" class="checkbox">',"SliderExplainText":"\uc2ac\ub77c\uc774\ub354\ub85c \ucc28\ub2e8\ud560 \uc694\uc18c\uc758 \ubc94\uc704\ub97c \uc9c0\uc815\ud558\uc138\uc694.",
                            "PreviewText":"\ubbf8\ub9ac\ubcf4\uae30","BlockSimilarText":'\uc720\uc0ac\ud55c \uc694\uc18c<input id="blockSimilar" type="checkbox" class="checkbox">',"BlockElementText":"\ud398\uc774\uc9c0 \uc694\uc18c \ucc28\ub2e8","ExtendedSettingsText":"\uace0\uae09 \uc124\uc815..."},"previewEnd":"<span>\ubbf8\ub9ac\ubcf4\uae30 \uc885\ub8cc</span>","settingsMenu":{"AssistantViewSettingsText":"\ub3c4\uc6b0\ubbf8 \ub514\uc2a4\ud50c\ub808\uc774 \uc124\uc815","IconSizeText":"\uc544\uc774\ucf58 \ud06c\uae30","UpText":'\uc0c1\ub2e8<input id="onTop" type="radio" name="vertical" class="radiobox">',
                            "CancelText":"\ucde8\uc18c","BigText":'\ud06c\uac8c<input id="isBig" type="radio" name="size" class="radiobox">',"LeftText":'\uc67c\ucabd<input id="onLeft" type="radio" name="horizontal" class="radiobox">',"RightText":'\uc624\ub978\ucabd<input id="onRight" type="radio" name="horizontal" class="radiobox">',"VerticalOrientationText":"\uc138\ub85c \uc704\uce58","DownText":'\ud558\ub2e8<input id="onBottom" type="radio" name="vertical" class="radiobox">',"HorizontalOrientationText":"\uac00\ub85c \uc704\uce58",
                            "SettingsText":"\ub3c4\uc6b0\ubbf8 \uc124\uc815","SmallText":'\uc791\uac8c<input id="isSmall" type="radio" name="size" class="radiobox">',"SaveText":"\uc800\uc7a5"},"complaintMenu":{"CommentText":"\ucd94\uac00 \uc124\uba85","ComplaintExtendedText":"\ud604\uc7ac \uc0ac\uc774\ud2b8\uc5d0 \ub300\ud55c \ubd88\ub9cc \uc0ac\ud56d\uc744 \uc124\uba85\ud574\uc8fc\uc138\uc694.","AnotherText":'\uae30\ud0c0<input id="another" type="radio" name="complaint" class="radiobox">',"AdSkippedText":'\uad11\uace0\uac00 \ucc28\ub2e8\ub418\uc9c0 \uc54a\uc74c<input id="adMissing" type="radio" name="complaint" class="radiobox">',
                            "IncorrectViewText":'\uc0ac\uc774\ud2b8\uac00 \uc65c\uace1\ub418\uc5b4 \ud45c\uc2dc\ub428<input id="wrongRender" type="radio" name="complaint" class="radiobox">',"PhishingSuspicionText":'\ud53c\uc2f1 \uc0ac\uc774\ud2b8\ub85c \ucd94\uc815\ub428<input id="phishing" type="radio" name="complaint" class="radiobox">',"ComplainReasonText":"\uc6d0\uc778","CancelText":"\ucde8\uc18c","SendComplaintText":"\uc804\uc1a1","ComplaintText":"\ubd88\ub9cc \uc804\uc1a1"},"wotBad":"\ub9e4\uc6b0 \ub098\uc068,","exceptionMenu":{"EntireSiteText":'\uc804\uccb4 \ub3c4\uba54\uc778<input type="radio" name="scope" class="radiobox" checked="true">',
                            "ExceptionClarificationText":"\uc774 \ud398\uc774\uc9c0\uc758 \uc608\uc678 \uc124\uc815","ExceptionDisclaimerText":"\uc608\uc678\ub97c \uc0dd\uc131\ud558\uba74 \uc708\ud558\ub294 \ud398\uc774\uc9c0, \ud56d\ubaa9 \ub610\ub294 \uc804\uccb4 \ub3c4\uba54\uc778\uc744 \ucc28\ub2e8 \ud574\uc81c \ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.","OnlyThisPageText":'\ud604\uc7ac \ud398\uc774\uc9c0\ub9cc<input id="onPage" type="radio" name="scope" class="radiobox">',"NewExceptionText":"\uc0c8 \uc608\uc678 \uc0ac\uc774\ud2b8",
                            "AddExceptionButtonText":"\uc608\uc678 \ucd94\uac00","ExtendedSettings":"\uace0\uae09 \uc124\uc815","DontUseFiltrationRulesText":'\ub0b4\uc6a9 \ud544\ud130\ub9c1 \ud574\uc81c <input id="content" type="checkbox" class="checkbox active" checked="true">',"ScopeText":"\uc608\uc678 \uaddc\uce59 \ubc94\uc704","DontUseAssistantText":'Adguard \ub3c4\uc6b0\ubbf8 \ube44\ud65c\uc131\ud654<input id="jsinject" type="checkbox" class="checkbox active" checked="true">',"DontUseUriBlockRulesText":'URL \uae30\ubc18 \ucc28\ub2e8 \ud574\uc81c <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',
                            "DontUseHideRulesText":'\uc694\uc18c \uc228\uae40 \ud574\uc81c <input id="elemhide" type="checkbox" class="checkbox active" checked="true">',"ExceptionParametrsText":"\uc608\uc678 \uaddc\uce59 \uc124\uc815"}};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["vi"]={"wotExcellent":"danh ti\u1ebfng r\u1ea5t t\u1ed1t","complaintWarning":"B\u1ea1n ph\u1ea3i ch\u1ecdn m\u1ed9t l\u00fd do cho ph\u00e0n n\u00e0n!","selectorMenu":{"cancel-select-mode":"hu\u1ef7 b\u1ecf ch\u1ebf \u0111\u1ed9 l\u1ef1a ch\u1ecdn","SelectElementText":"Ch\u1ebf \u0111\u1ed9 l\u1ef1a ch\u1ecdn","SelectElementExtendedText":"B\u1ea5m v\u00e0o y\u1ebfu t\u1ed1 b\u1ea5t k\u1ef3 tr\u00ean trang ho\u1eb7c "},"wotPostfix":" theo ","previewStart":"<span>Xem tr\u01b0\u1edbc</span>",
                        "dragHandleWithoutWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span></div><div class="adg-head-opt"><a target="_blank" href="${href}">M\u1edf b\u00e1o c\u00e1o b\u1ea3o m\u1eadt website</a><span class="adg-version">${version}</span></div>',"dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"danh ti\u1ebfng t\u1ed1t","alert":{"welcomeHead":"Ch\u00e0o m\u1eebng b\u1ea1n \u0111\u1ebfn v\u1edbi Adguard Assistant","welcomeLink":{"text":"Th\u00f4ng tin th\u00eam","href":"http://adguard.com/tour.html"},"welcomeMessage":"Adguard Assistant l\u00e0 m\u1ed9t m\u00f4-\u0111un tr\u00ecnh duy\u1ec7t \u0111\u1eb7c bi\u1ec7t c\u1ee7a B\u1ed9 l\u1ecdc Web c\u1ee7a Adguard. N\u00f3 cho ph\u00e9p b\u1ea1n lo\u1ea1i b\u1ecf nh\u1eefng n\u1ed9i dung kh\u00f4ng mong mu\u1ed1n b\u1ea5t k\u1ef3 kh\u1ecfi website. N\u00f3 c\u0169ng c\u00f3 bi\u1ec3u t\u01b0\u1ee3ng cho b\u1ea1n bi\u1ebft danh ti\u1ebfng c\u1ee7a website \u0111ang truy c\u1eadp."},
                        "mainMenu":{"toolTips":{"ConfidenceIndication":"M\u1ee9c \u0111\u1ed9 tin c\u1eady","WotIndication":"X\u00e1c \u0111\u1ecbnh danh ti\u1ebfng trang"},"SendComplaintText":"G\u1eedi<br>ph\u00e0n n\u00e0n","blockElementTextExtend":"B\u1ea1n c\u00f3 th\u1ec3 t\u1ef1 ch\u1ecdn v\u00e0 lo\u1ea1i b\u1ecf y\u1ebfu t\u1ed1 b\u1ea5t k\u1ef3 (h\u00ecnh \u1ea3nh, b\u1ea3ng qu\u1ea3ng c\u00e1o...) kh\u1ecfi trang ho\u1eb7c website n\u00e0y","UndoLastRuleText":"Ph\u1ee5c h\u1ed3i<br>thao t\u00e1c g\u1ea7n nh\u1ea5t<br>",
                            "AssistantSettingsText":"Thay \u0111\u1ed5i<br>c\u00e0i \u0111\u1eb7t<br>","AddToExceptionsTextExtend":"Adguard s\u1ebd d\u1eebng l\u1ecdc qu\u1ea3ng c\u00e1o tr\u00ean trang n\u00e0y cho \u0111\u1ebfn khi b\u1ea1n xo\u00e1 n\u00f3 kh\u1ecfi danh s\u00e1ch lo\u1ea1i tr\u1eeb","AddToExceptionsText":"Th\u00eam<br>Lo\u1ea1i tr\u1eeb","TemporaryExceptionText":"Kh\u00f4ng ch\u1eb7n<br>trong 30 gi\u00e2y<br>","blockElementText":"Ch\u1eb7n<br>y\u1ebfu t\u1ed1"},"blockTextIfSliderHided":"B\u1ed9 l\u1ecdc s\u1ebd bao g\u1ed3m m\u1ed9t quy t\u1eafc ch\u1eb7n y\u1ebfu t\u1ed1 \u0111\u00e3 ch\u1ecdn",
                        "wotPrefix":"Trang n\u00e0y c\u00f3 ","wotUnsatisfactory":"danh ti\u1ebfng kh\u00f4ng \u0111\u1ea1t y\u00eau c\u1ea7u","wotPoor":"danh ti\u1ebfng th\u1ea5p","wotUnknown":"danh ti\u1ebfng ch\u01b0a r\u00f5","detailedMenu":{"SliderMaxText":"L\u1edaN H\u01a0N","AnotherElementText":"Ch\u1ecdn y\u1ebfu t\u1ed1 kh\u00e1c","RuleParametrsText":"Th\u00f4ng s\u1ed1 quy t\u1eafc","BlockElementExplainText":"C\u00e0i \u0111\u1eb7t quy t\u1eafc ch\u1eb7n y\u1ebfu t\u1ed1","SliderMinText":"NH\u1ece H\u01a0N","BlockText":"Ch\u1eb7n",
                            "ApplyRuleToAllSitesText":'\u00c1p d\u1ee5ng quy t\u1eafc n\u00e0y cho m\u1ecdi website<input id="oneDomainRadio" type="checkbox" class="checkbox">',"BlockByReferenceText":'Ch\u1eb7n y\u1ebfu t\u1ed1 theo URL<input id="blockByUrl" type="checkbox" class="checkbox">',"SliderExplainText":"D\u00f9ng thanh tr\u01b0\u1ee3t \u0111\u1ec3 thay \u0111\u1ed5i k\u00edch c\u1ee1 y\u1ebfu t\u1ed1 b\u1ecb ch\u1eb7n theo quy t\u1eafc n\u00e0y:","PreviewText":"Xem tr\u01b0\u1edbc","BlockSimilarText":'Ch\u1eb7n c\u00e1c y\u1ebfu t\u1ed1 t\u01b0\u01a1ng t\u1ef1<input id="blockSimilar" type="checkbox" class="checkbox">',
                            "BlockElementText":"Ch\u1eb7n y\u1ebfu t\u1ed1","ExtendedSettingsText":"C\u00e0i \u0111\u1eb7t n\u00e2ng cao..."},"previewEnd":"<span>K\u1ebft th\u00fac xem tr\u01b0\u1edbc</span>","settingsMenu":{"AssistantViewSettingsText":"C\u00e0i \u0111\u1eb7t hi\u1ec3n th\u1ecb Adguard Assistant","IconSizeText":"K\u00edch th\u01b0\u1edbc bi\u1ec3u t\u01b0\u1ee3ng","UpText":'Tr\u00ean<input id="onTop" type="radio" name="vertical" class="radiobox">',"CancelText":"Hu\u1ef7","BigText":'L\u1edbn<input id="isBig" type="radio" name="size" class="radiobox">',
                            "LeftText":'Tr\u00e1i<input id="onLeft" type="radio" name="horizontal" class="radiobox">',"RightText":'Ph\u1ea3i<input id="onRight" type="radio" name="horizontal" class="radiobox">',"VerticalOrientationText":"H\u01b0\u1edbng th\u1eb3ng \u0111\u1ee9ng","DownText":'D\u01b0\u1edbi<input id="onBottom" type="radio" name="vertical" class="radiobox">',"HorizontalOrientationText":"H\u01b0\u1edbng n\u1eb1m ngang","SettingsText":"C\u00e0i \u0111\u1eb7t Assistant","SmallText":'Nh\u1ecf<input id="isSmall" type="radio" name="size" class="radiobox">',
                            "SaveText":"L\u01b0u"},"complaintMenu":{"CommentText":"B\u00ecnh lu\u1eadn","ComplaintExtendedText":"H\u00e3y m\u00f4 t\u1ea3 l\u00fd do c\u1ee7a ph\u00e0n n\u00e0n n\u00e0y","AnotherText":'Kh\u00e1c<input id="another" type="radio" name="complaint" class="radiobox">',"AdSkippedText":'Qu\u1ea3ng c\u00e1o b\u1ecb b\u1ecf s\u00f3t<input id="adMissing" type="radio" name="complaint" class="radiobox">',"IncorrectViewText":'Website bi\u1ebfn d\u1ea1ng<input id="wrongRender" type="radio" name="complaint" class="radiobox">',
                            "PhishingSuspicionText":'Nghi ng\u1edd c\u00f3 l\u1eeba \u0111\u1ea3o<input id="phishing" type="radio" name="complaint" class="radiobox">',"ComplainReasonText":"L\u00fd do","CancelText":"Hu\u1ef7","SendComplaintText":"B\u00ecnh lu\u1eadn","ComplaintText":"G\u1eedi ph\u00e0n n\u00e0n"},"wotBad":"danh ti\u1ebfng x\u1ea5u","exceptionMenu":{"EntireSiteText":'To\u00e0n b\u1ed9 website <input type="radio" name="scope" class="radiobox" checked="true">',"ExceptionClarificationText":"C\u00e0i \u0111\u1eb7t lo\u1ea1i tr\u1eeb cho trang n\u00e0y",
                            "ExceptionDisclaimerText":"T\u1ea1o lo\u1ea1i tr\u1eeb cho ph\u00e9p b\u1ea1n ch\u1ecdn b\u1ecf ch\u1eb7n m\u1ed9t s\u1ed1 trang nh\u1ea5t \u0111\u1ecbnh, y\u1ebfu t\u1ed1 c\u1ee7a trang ho\u1eb7c c\u1ea3 website.","OnlyThisPageText":'Ch\u1ec9 trang n\u00e0y <input id="onPage" type="radio" name="scope" class="radiobox">',"NewExceptionText":"Lo\u1ea1i tr\u1eeb m\u1edbi","AddExceptionButtonText":"Th\u00eam lo\u1ea1i tr\u1eeb","ExtendedSettings":"C\u00e0i \u0111\u1eb7t n\u00e2ng cao...","DontUseFiltrationRulesText":'V\u00f4 hi\u1ec7u quy t\u1eafc l\u1ecdc n\u1ed9i dung <input id="content" type="checkbox" class="checkbox active" checked="true">',
                            "ScopeText":"Ph\u1ea1m vi quy t\u1eafc lo\u1ea1i tr\u1eeb","DontUseAssistantText":'V\u00f4 hi\u1ec7u Adguard Assistant <input id="jsinject" type="checkbox" class="checkbox active" checked="true">',"DontUseUriBlockRulesText":'V\u00f4 hi\u1ec7u quy t\u1eafc ch\u1eb7n URL <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',"DontUseHideRulesText":'V\u00f4 hi\u1ec7u quy t\u1eafc \u1ea9n y\u1ebfu t\u1ed1 <input id="elemhide" type="checkbox" class="checkbox active" checked="true">',
                            "ExceptionParametrsText":"Thu\u1ed9c t\u00ednh quy t\u1eafc lo\u1ea1i tr\u1eeb"}};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["sk"]={"wotExcellent":"vynikaj\u00facu reput\u00e1ciu","complaintWarning":"Mus\u00edte zvoli\u0165 d\u00f4vod pre podanie s\u0165a\u017enosti!","selectorMenu":{"cancel-select-mode":"zru\u0161te re\u017eim vo\u013eby","SelectElementText":"Re\u017eim vo\u013eby","SelectElementExtendedText":"Kliknite na \u013eubovo\u013en\u00fd prvok na tejto str\u00e1nke alebo "},"wotPostfix":" pod\u013ea ","previewStart":"<span>Prehliadka</span>","dragHandleWithoutWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span></div><div class="adg-head-opt"><a target="_blank" href="${href}">Otvori\u0165 bezpe\u010dnostn\u00fd z\u00e1znam o webovej str\u00e1nke</a><span class="adg-version">${version}</span></div>',
                        "dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"dobr\u00fa reput\u00e1ciu","alert":{"welcomeHead":"Vitajte v Adguard Assistant!","welcomeLink":{"text":"\u010eal\u0161ie inform\u00e1cie","href":"http://adguard.com/tour.html"},"welcomeMessage":"Adguard Assistant je \u0161peci\u00e1lny prehliadac\u00ed modul Adguard Web Filter. Umo\u017e\u0148uje V\u00e1m odstr\u00e1ni\u0165 ne\u017eiaduci obsah z webovej str\u00e1nky. Farba ikony V\u00e1m navy\u0161e signalizuje reput\u00e1ciu aktu\u00e1lnej webovej str\u00e1nky."},"mainMenu":{"toolTips":{"ConfidenceIndication":"\u00darove\u0148 d\u00f4veryhodnosti reput\u00e1cie",
                            "WotIndication":"Indik\u00e1tor reput\u00e1cie str\u00e1nky"},"SendComplaintText":"Poda\u0165<br>s\u0165a\u017enos\u0165","blockElementTextExtend":"M\u00f4\u017eete ru\u010dne zvoli\u0165 a odstr\u00e1ni\u0165 \u013eubovo\u013en\u00e9 prvky tejto str\u00e1nky (obr\u00e1zky, bannery at\u010f.)","UndoLastRuleText":"Zru\u0161i\u0165<br>posledn\u00fa akciu<br>","AssistantSettingsText":"Zmeni\u0165<br>nastavenia<br>","AddToExceptionsTextExtend":"Adguard zastav\u00ed filtrovanie rekl\u00e1m na tejto str\u00e1nke, pok\u00fdm ju neodstr\u00e1nite zo zoznamu v\u00fdnimiek",
                            "AddToExceptionsText":"Prida\u0165<br>V\u00fdnimku","TemporaryExceptionText":"Neblokova\u0165<br>po\u010das 30 sek\u00fand<br>","blockElementText":"Blokova\u0165<br>prvok"},"blockTextIfSliderHided":"Tento filter bude obsahova\u0165 pravidlo, ktor\u00e9 blokuje zvolen\u00e9 prvky","wotPrefix":"T\u00e1to str\u00e1nka m\u00e1 ","wotUnsatisfactory":"neuspokojiv\u00fa reput\u00e1ciu","wotPoor":"slab\u00fa reput\u00e1ciu","wotUnknown":"nezn\u00e1mu reput\u00e1ciu","detailedMenu":{"SliderMaxText":"V\u00e4\u010d\u0161\u00ed",
                            "AnotherElementText":"Zvoli\u0165 in\u00fd prvok","RuleParametrsText":"Parametre pravidla","BlockElementExplainText":"Nastavenie pravidla blokovania prvku","SliderMinText":"Men\u0161\u00ed","BlockText":"Blokova\u0165","ApplyRuleToAllSitesText":'Aplikova\u0165 toto pravidlo na v\u0161etky str\u00e1nky<input id="oneDomainRadio" type="checkbox" class="checkbox">',"BlockByReferenceText":'Blokovanie prvku pod\u013ea URL<input id="blockByUrl" type="checkbox" class="checkbox">',"SliderExplainText":"Pou\u017eite posuvn\u00edk pre zmenu ve\u013ekosti prvku, ktor\u00fd m\u00e1 by\u0165 blokovan\u00fd t\u00fdmto pravidlom:",
                            "PreviewText":"Prehliadka","BlockSimilarText":'Blokova\u0165 podobn\u00e9 prvky<input id="blockSimilar" type="checkbox" class="checkbox">',"BlockElementText":"Blokova\u0165 prvok","ExtendedSettingsText":"Pokro\u010dil\u00e9 nastavenia..."},"previewEnd":"<span>Ukon\u010denie prehliadky</span>","settingsMenu":{"AssistantViewSettingsText":"Nastavenia zobrazenia Adguard Assistant","IconSizeText":"Ve\u013ekos\u0165 ikon","UpText":'Hore<input id="onTop" type="radio" name="vertical" class="radiobox">',"CancelText":"Zru\u0161i\u0165",
                            "BigText":'Ve\u013ek\u00e9<input id="isBig" type="radio" name="size" class="radiobox">',"LeftText":'V\u013eavo<input id="onLeft" type="radio" name="horizontal" class="radiobox">',"RightText":'Vpravo<input id="onRight" type="radio" name="horizontal" class="radiobox">',"VerticalOrientationText":"Vertik\u00e1lna orient\u00e1cia","DownText":'Dole<input id="onBottom" type="radio" name="vertical" class="radiobox">',"HorizontalOrientationText":"Horizont\u00e1lna orient\u00e1cia","SettingsText":"Nastavenia Adguard Assistant",
                            "SmallText":'Mal\u00e9<input id="isSmall" type="radio" name="size" class="radiobox">',"SaveText":"Ulo\u017ei\u0165"},"complaintMenu":{"CommentText":"Koment\u00e1re","ComplaintExtendedText":"Pros\u00edm vysvetlite d\u00f4vod pre t\u00fato s\u0165a\u017enos\u0165","AnotherText":'In\u00fd<input id="another" type="radio" name="complaint" class="radiobox">',"AdSkippedText":'Neodstr\u00e1nen\u00e1 reklama<input id="adMissing" type="radio" name="complaint" class="radiobox">',"IncorrectViewText":'Zobrazenie str\u00e1nky je skreslen\u00e9<input id="wrongRender" type="radio" name="complaint" class="radiobox">',
                            "PhishingSuspicionText":'Podozrenie na pokus o kr\u00e1de\u017e identity<input id="phishing" type="radio" name="complaint" class="radiobox">',"ComplainReasonText":"D\u00f4vod","CancelText":"Zru\u0161i\u0165","SendComplaintText":"Poda\u0165","ComplaintText":"Poda\u0165 s\u0165a\u017enos\u0165"},"wotBad":"zl\u00fa reput\u00e1ciu","exceptionMenu":{"EntireSiteText":'Cel\u00fd server <input type="radio" name="scope" class="radiobox" checked="true">',"ExceptionClarificationText":"Nastavenia v\u00fdnimiek pre t\u00fato str\u00e1nku",
                            "ExceptionDisclaimerText":"Vytvorenie v\u00fdnimiek V\u00e1m umo\u017e\u0148uje selekt\u00edvne odblokova\u0165 ur\u010dit\u00e9 str\u00e1nky, prvky str\u00e1nok alebo cel\u00e9 servery.","OnlyThisPageText":'Len pre t\u00fato str\u00e1nku<input id="onPage" type="radio" name="scope" class="radiobox">',"NewExceptionText":"Nov\u00e1 v\u00fdnimka","AddExceptionButtonText":"Prida\u0165 v\u00fdnimku","ExtendedSettings":"Pokro\u010dil\u00e9 nastavenia...","DontUseFiltrationRulesText":'Vypn\u00fa\u0165 pravidl\u00e1 filtr\u00e1cie obsahu <input id="content" type="checkbox" class="checkbox active" checked="true">',
                            "ScopeText":"Preh\u013ead pravidla pre uplat\u0148ovanie v\u00fdnimiek","DontUseAssistantText":'Vypn\u00fa\u0165 Adguard assistant <input id="jsinject" type="checkbox" class="checkbox active" checked="true">',"DontUseUriBlockRulesText":'Vypn\u00fa\u0165 pravidl\u00e1 blokovania URL <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',"DontUseHideRulesText":'Vypn\u00fa\u0165 pravidl\u00e1 skr\u00fdvania prvkov <input id="elemhide" type="checkbox" class="checkbox active" checked="true">',
                            "ExceptionParametrsText":"Vlastnosti pravidla pre uplat\u0148ovanie v\u00fdnimiek"}};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["pt"]={"wotExcellent":"uma excelente reputa\u00e7\u00e3o","complaintWarning":"Voc\u00ea tem que selecionar uma raz\u00e3o da sua den\u00fancia!","selectorMenu":{"cancel-select-mode":"Sair do modo de sele\u00e7\u00e3o","SelectElementText":"Modo de sele\u00e7\u00e3o","SelectElementExtendedText":"Clique em qualquer elemento na p\u00e1gina ou "},"wotPostfix":" de acordo com ","previewStart":"<span>Visualiza\u00e7\u00e3o</span>","dragHandleWithoutWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span></div><div class="adg-head-opt"><a target="_blank" href="${href}">Abrir relat\u00f3rio de seguran\u00e7a do site</a><span class="adg-version">${version}</span></div>',
                        "dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"uma boa reputa\u00e7\u00e3o","alert":{"welcomeHead":"Bem-vindo ao Assistente do Adguard","welcomeLink":{"text":"Mais informa\u00e7\u00e3o","href":"http://adguard.com/tour.html"},"welcomeMessage":"O Assistente do Adguard \u00e9 um m\u00f3dulo especial do Adguard Filtro da Web. Ele permite voc\u00ea remover qualquer conte\u00fado indesejado do site. Tamb\u00e9m a cor do \u00edcone sinaliza voc\u00ea da reputa\u00e7\u00e3o do site atual."},"mainMenu":{"toolTips":{"ConfidenceIndication":"Reputa\u00e7\u00e3o N\u00edvel de Confian\u00e7a",
                            "WotIndication":"Indicador de reputa\u00e7\u00e3o do site"},"SendComplaintText":"Enviar<br>uma den\u00fancia","blockElementTextExtend":"Voc\u00ea pode selecionar manualmente e remover qualquer elemento da p\u00e1gina (imagem, banner, etc) desta p\u00e1gina ou site","UndoLastRuleText":"Desfazer<br>ultima a\u00e7\u00e3o<br>","AssistantSettingsText":"Alterar<br>configura\u00e7\u00f5es<br>","AddToExceptionsTextExtend":"Adguard vai parar de filtrar an\u00fancios neste site at\u00e9 voc\u00ea remov\u00ea-lo da lista de exce\u00e7\u00f5es",
                            "AddToExceptionsText":"Add<br>Exce\u00e7\u00e3o","TemporaryExceptionText":"N\u00e3o bloquear<br>por 30 segundos<br>","blockElementText":"Bloquear<br>elemento"},"blockTextIfSliderHided":"O filtro ir\u00e1 conter uma regra que bloqueia o elemento selecionado","wotPrefix":"Este site tem ","wotUnsatisfactory":"uma reputa\u00e7\u00e3o insatisfat\u00f3ria","wotPoor":"uma m\u00e1 reputa\u00e7\u00e3o","wotUnknown":"uma reputa\u00e7\u00e3o desconhecida","detailedMenu":{"SliderMaxText":"MAIOR","AnotherElementText":"Selecionar outro elemento",
                            "RuleParametrsText":"Regras de par\u00e2metros","BlockElementExplainText":"Configura\u00e7\u00e3o de bloqueio de elemento","SliderMinText":"MENOR","BlockText":"Bloquear","ApplyRuleToAllSitesText":'Aplicar essa regra para qualquer web site<input id="oneDomainRadio" type="checkbox" class="checkbox">',"BlockByReferenceText":'Bloquear elementos pela url<input id="blockByUrl" type="checkbox" class="checkbox">',"SliderExplainText":"Use o controle deslizante para alterar o tamanho do elemento a ser bloqueado por esta regra:",
                            "PreviewText":"Visualiza\u00e7\u00e3o","BlockSimilarText":'Bloquear elementos similares <input id="blockSimilar" type="checkbox" class="checkbox">',"BlockElementText":"Bloquear elemento","ExtendedSettingsText":"Configura\u00e7\u00f5es avan\u00e7adas..."},"previewEnd":"<span>Finalizar visualiza\u00e7\u00e3o</span>","settingsMenu":{"AssistantViewSettingsText":"Adguard assistente de configura\u00e7\u00f5es de exibi\u00e7\u00e3o","IconSizeText":"Tamanho do \u00cdcone","UpText":'Acima<input id="onTop" type="radio" name="vertical" class="radiobox">',
                            "CancelText":"Cancelar","BigText":'Grande<input id="isBig" type="radio" name="size" class="radiobox">',"LeftText":'Esquerda<input id="onLeft" type="radio" name="horizontal" class="radiobox">',"RightText":'Direita<input id="onRight" type="radio" name="horizontal" class="radiobox">',"VerticalOrientationText":"Orienta\u00e7\u00e3o vertical","DownText":'Abaixo<input id="onBottom" type="radio" name="vertical" class="radiobox">',"HorizontalOrientationText":"Orienta\u00e7\u00e3o horizontal","SettingsText":"Assistente de Configura\u00e7\u00f5es",
                            "SmallText":'Pequeno<input id="isSmall" type="radio" name="size" class="radiobox">',"SaveText":"Salvar"},"complaintMenu":{"CommentText":"Coment\u00e1rios","ComplaintExtendedText":"Por favor, descreva a raz\u00e3o para essa den\u00fancia","AnotherText":'Outro<input id="another" type="radio" name="complaint" class="radiobox">',"AdSkippedText":'An\u00fancio ignorado<input id="adMissing" type="radio" name="complaint" class="radiobox">',"IncorrectViewText":'Exibi\u00e7\u00e3o do site distorcida<input id="wrongRender" type="radio" name="complaint" class="radiobox">',
                            "PhishingSuspicionText":'Suspeito de Phishing<input id="phishing" type="radio" name="complaint" class="radiobox">',"ComplainReasonText":"Raz\u00e3o","CancelText":"Cancelar","SendComplaintText":"Enviar","ComplaintText":"Enviar uma den\u00fancia"},"wotBad":"uma p\u00e9ssima reputa\u00e7\u00e3o","exceptionMenu":{"EntireSiteText":'Site inteiro <input type="radio" name="scope" class="radiobox" checked="true">',"ExceptionClarificationText":"Configura\u00e7\u00f5es de exce\u00e7\u00e3o para esta p\u00e1gina",
                            "ExceptionDisclaimerText":"Cria\u00e7\u00e3o de exce\u00e7\u00f5es permite voc\u00ea desbloquear seletivamente certas p\u00e1ginas, elementos de p\u00e1gina ou sites inteiros.","OnlyThisPageText":'Somente nesta p\u00e1gina<input id="onPage" type="radio" name="scope" class="radiobox">',"NewExceptionText":"Nova exce\u00e7\u00e3o","AddExceptionButtonText":"Add exce\u00e7\u00e3o","ExtendedSettings":"Configura\u00e7\u00f5es avan\u00e7adas...","DontUseFiltrationRulesText":'Desativar regras de filtragem de conte\u00fado <input id="content" type="checkbox" class="checkbox active" checked="true">',
                            "ScopeText":"Alcance da regra de exce\u00e7\u00e3o","DontUseAssistantText":'Desativar assistente do Adguard <input id="jsinject" type="checkbox" class="checkbox active" checked="true">',"DontUseUriBlockRulesText":'Desativar regras de bloqueio de URL <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',"DontUseHideRulesText":'Desativar regras de ocultar elemento <input id="elemhide" type="checkbox" class="checkbox active" checked="true">',"ExceptionParametrsText":"Propriedades de regra de exce\u00e7\u00e3o"}};
                    var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["hu"]={"wotExcellent":"kit\u0171n\u0151 a h\u00edrneve","complaintWarning":"Musz\u00e1j kiv\u00e1lasztania a panasz ok\u00e1t!","selectorMenu":{"cancel-select-mode":"v\u00e1laszt\u00e1si m\u00f3d visszavon\u00e1sa","SelectElementText":"V\u00e1laszt\u00e1si m\u00f3d","SelectElementExtendedText":"Kattintson b\u00e1rmely elemre az oldalon vagy "},"wotPostfix":".Forr\u00e1s: ","previewStart":"<span>El\u0151n\u00e9zet</span>","dragHandleWithoutWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span></div><div class="adg-head-opt"><a target="_blank" href="${href}">Oldal biztons\u00e1gi jelent\u00e9s\u00e9nek megnyit\u00e1sa</a><span class="adg-version">${version}</span></div>',
                        "dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"j\u00f3 a h\u00edrneve","alert":{"welcomeHead":"K\u00f6sz\u00f6nt\u00f6m az Adguard Seg\u00e9dben!","welcomeLink":{"text":"Tov\u00e1bbi inform\u00e1ci\u00f3k","href":"http://adguard.com/tour.html"},"welcomeMessage":"Adguard Seg\u00e9d egy speci\u00e1lis b\u00f6ng\u00e9sz\u0151 modulja az Adguard Websz\u0171r\u0151j\u00e9nek. Elt\u00e1vol\u00edtja a nem k\u00edv\u00e1nt tartalmakat az oldalr\u00f3l \u00e9s az ikonja jelzi a jelenlegi oldal meg\u00edt\u00e9l\u00e9s\u00e9t."},"mainMenu":{"toolTips":{"ConfidenceIndication":"H\u00edrn\u00e9v Bizalom Szint",
                            "WotIndication":"Oldal h\u00edrn\u00e9v mutat\u00f3ja"},"SendComplaintText":"K\u00e9relem<br>beny\u00fajt\u00e1sa","blockElementTextExtend":"Manu\u00e1lisan ki tud v\u00e1lasztani egy nem k\u00edv\u00e1nt elemet(k\u00e9p, fejl\u00e9c, stb.) ezen a weboldalon","UndoLastRuleText":"El\u0151z\u0151 m\u0171velet<br>visszavon\u00e1sa<br>","AssistantSettingsText":"Be\u00e1ll\u00edt\u00e1sok<br>v\u00e1ltoztat\u00e1sa<br>","AddToExceptionsTextExtend":"Adguard nem fogja sz\u0171rni a rekl\u00e1mokat ezen az oldalon am\u00edg el nem t\u00e1vol\u00edtja a kiv\u00e9telek k\u00f6z\u00fcl",
                            "AddToExceptionsText":"Kiv\u00e9tel<br>hozz\u00e1ad\u00e1sa","TemporaryExceptionText":"Ne sz\u0171rj\u00f6n<br>30 m\u00e1sodpercig<br>","blockElementText":"Elem<br>tilt\u00e1sa"},"blockTextIfSliderHided":"A sz\u0171r\u0151 tartalmazni fog egy szab\u00e1lyt ami tiltani fogja a kiv\u00e1lasztott elemet","wotPrefix":"Ennek az oldalnak ","wotUnsatisfactory":"nem kiel\u00e9g\u00edt\u0151 a h\u00edrneve","wotPoor":"k\u00e9tes a h\u00edrneve","wotUnknown":"ismeretlen a h\u00edrneve","detailedMenu":{"SliderMaxText":"NAGYOBB",
                            "AnotherElementText":"V\u00e1lasszon egy m\u00e1sik elemet","RuleParametrsText":"Szab\u00e1ly param\u00e9terek","BlockElementExplainText":"Elem tilt\u00e1si szab\u00e1ly\u00e1nak be\u00e1ll\u00edt\u00e1sa","SliderMinText":"KISEBB","BlockText":"Tilt\u00e1s","ApplyRuleToAllSitesText":'Haszn\u00e1lja ezt a szab\u00e1lyt minden weboldalhoz<input id="oneDomainRadio" type="checkbox" class="checkbox">',"BlockByReferenceText":'URL szerint tiltja<input id="blockByUrl" type="checkbox" class="checkbox">',"SliderExplainText":"Haszn\u00e1lja a cs\u00faszk\u00e1t, hogy megv\u00e1ltoztassa tiltott elem nagys\u00e1g\u00e1t ezen szab\u00e1ly szerint",
                            "PreviewText":"El\u0151n\u00e9zet","BlockSimilarText":'Hasonl\u00f3 elemek tilt\u00e1sa<input id="blockSimilar" type="checkbox" class="checkbox">',"BlockElementText":"Elem letilt\u00e1sa","ExtendedSettingsText":"Speci\u00e1lis be\u00e1ll\u00edt\u00e1sok..."},"previewEnd":"<span>El\u0151n\u00e9zet befejez\u00e9se</span>","settingsMenu":{"AssistantViewSettingsText":"Adguard Seg\u00e9d megjelen\u00edt\u00e9si be\u00e1ll\u00edt\u00e1sok","IconSizeText":"Ikon m\u00e9ret","UpText":'Fent<input id="onTop" type="radio" name="vertical" class="radiobox">',
                            "CancelText":"M\u00e9gsem","BigText":'Nagy<input id="isBig" type="radio" name="size" class="radiobox">',"LeftText":'Ball<input id="onLeft" type="radio" name="horizontal" class="radiobox">',"RightText":'Jobb<input id="onRight" type="radio" name="horizontal" class="radiobox">',"VerticalOrientationText":"F\u00fcgg\u0151leges elhelyez\u00e9s","DownText":'Lent<input id="onBottom" type="radio" name="vertical" class="radiobox">',"HorizontalOrientationText":"V\u00edzszintes elhelyez\u00e9s","SettingsText":"Seg\u00e9d Be\u00e1ll\u00edt\u00e1sai",
                            "SmallText":'Kicsi<input id="isSmall" type="radio" name="size" class="radiobox">',"SaveText":"Ment\u00e9s"},"complaintMenu":{"CommentText":"Megjegyz\u00e9sek","ComplaintExtendedText":"K\u00e9rem \u00edrja le a panasz ok\u00e1t","AnotherText":'M\u00e1s<input id="another" type="radio" name="complaint" class="radiobox">',"AdSkippedText":'Hirdet\u00e9s kihagyva<input id="adMissing" type="radio" name="complaint" class="radiobox">',"IncorrectViewText":'Az oldal torzult<input id="wrongRender" type="radio" name="complaint" class="radiobox">',
                            "PhishingSuspicionText":'Adathal\u00e1szat sejt\u00e9se<input id="phishing" type="radio" name="complaint" class="radiobox">',"ComplainReasonText":"Ok","CancelText":"M\u00e9gsem","SendComplaintText":"Elk\u00fcld","ComplaintText":"Panasz bek\u00fcld\u00e9se"},"wotBad":"rossz a h\u00edrneve","exceptionMenu":{"EntireSiteText":'Az eg\u00e9sz weboldal<input type="radio" name="scope" class="radiobox" checked="true">',"ExceptionClarificationText":"Kiv\u00e9tel be\u00e1ll\u00edt\u00e1sok ehhez az oldalhoz",
                            "ExceptionDisclaimerText":"Kiv\u00e9telek l\u00e9trehoz\u00e1sa ami enged\u00e9lyezhet bizonyos oldalakat vagy a teljes oldalt is.","OnlyThisPageText":'Csak ez az oldal<input id="onPage" type="radio" name="scope" class="radiobox">',"NewExceptionText":"\u00daj kiv\u00e9tel","AddExceptionButtonText":"Kiv\u00e9tel hozz\u00e1ad\u00e1sa","ExtendedSettings":"Speci\u00e1lis be\u00e1ll\u00edt\u00e1sok...","DontUseFiltrationRulesText":'Tartalom sz\u0171r\u0151 szab\u00e1lyok kikapcsol\u00e1sa <input id="content" type="checkbox" class="checkbox active" checked="true">',
                            "ScopeText":"Kiv\u00e9tel szab\u00e1ly hat\u00e1sk\u00f6re","DontUseAssistantText":'Adguard seg\u00edt\u0151 kikapcsol\u00e1sa <input id="jsinject" type="checkbox" class="checkbox active" checked="true">',"DontUseUriBlockRulesText":'URL tilt\u00f3 szab\u00e1lyok kikapcsol\u00e1sa <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',"DontUseHideRulesText":'Elem elrejt\u0151 szab\u00e1lyok kikapcsol\u00e1sa <input id="elemhide" type="checkbox" class="checkbox active" checked="true">',
                            "ExceptionParametrsText":"Kiv\u00e9tel szab\u00e1ly tulajdons\u00e1gai"}};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["id"]={"wotExcellent":"reputasi sangat baik","complaintWarning":"Anda harus memilih alasan untuk keluhan Anda!","selectorMenu":{"cancel-select-mode":"batalkan mode seleksi","SelectElementText":"Mode seleksi","SelectElementExtendedText":"Klik pada elemen apapun pada laman atau "},"wotPostfix":" berdasar pada ","previewStart":"<span>Pratinjau</span>","dragHandleWithoutWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span></div><div class="adg-head-opt"><a target="_blank" href="${href}">Buka laporan keamanan situs</a><span class="adg-version">${version}</span></div>',
                        "dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"reputasi baik","alert":{"welcomeHead":"Selamat datang di Asisten Adguard","welcomeLink":{"text":"Info lainnya","href":"http://adguard.com/tour.html"},"welcomeMessage":"Asisten Adguard adalah modul peramban khusus dari Penyaring Situs Adguard. Hal ini memungkinkan Anda untuk menghapus konten yang tidak diinginkan dari situs. Juga warna ikon akan menjelaskan Anda reputasi situs saat ini."},"mainMenu":{"toolTips":{"ConfidenceIndication":"Level Kepercayaan Reputasi","WotIndication":"Indikator reputasi situs"},
                            "SendComplaintText":"Kirim<br>keluhan","blockElementTextExtend":"Anda dapat secara manual memilih dan membuang elemen halaman (gambar, baner, dll) dari halaman ini atau situs","UndoLastRuleText":"Urungkan<br>tindakan terakhir<br>","AssistantSettingsText":"Ubah<br>pengaturan<br>","AddToExceptionsTextExtend":"Adguard akan berhenti menyaring iklan di situs ini sampai Anda menghapusnya dari daftar pengecualian","AddToExceptionsText":"Tambah<br>Pengecualian","TemporaryExceptionText":"Jangan blok <br>selama 30 detik<br>",
                            "blockElementText":"Blok<br>elemen"},"blockTextIfSliderHided":"Penyaring akan berisi aturan yang akan memblok elemen terpilih","wotPrefix":"Situs ini memiliki ","wotUnsatisfactory":"reputasi tidak memuaskan","wotPoor":"reputasi jelek","wotUnknown":"reputasi tak dikenal","detailedMenu":{"SliderMaxText":"BESAR","AnotherElementText":"Pilih elemen lainnya","RuleParametrsText":"Parameter aturan","BlockElementExplainText":"Setelan aturan memblok elemen","SliderMinText":"KECIL","BlockText":"Blok","ApplyRuleToAllSitesText":'Terapkan aturan ini pada semua situs<input id="oneDomainRadio" type="checkbox" class="checkbox">',
                            "BlockByReferenceText":'Blok elemen oleh URL<input id="blockByUrl" type="checkbox" class="checkbox">',"SliderExplainText":"Gunakan penggeser untuk mengubah ukuran elemen yang akan diblok dengan aturan ini:","PreviewText":"Pratinjau","BlockSimilarText":'Blok elemen yang mirip<input id="blockSimilar" type="checkbox" class="checkbox">',"BlockElementText":"Blok elemen","ExtendedSettingsText":"Pengaturan lanjutan..."},"previewEnd":"<span>Selesai pratinjau</span>","settingsMenu":{"AssistantViewSettingsText":"Pengaturan tampilan Asisten Adguard",
                            "IconSizeText":"Ukuran ikon","UpText":'Atas<input id="onTop" type="radio" name="vertical" class="radiobox">',"CancelText":"Batal","BigText":'Besar<input id="isBig" type="radio" name="size" class="radiobox">',"LeftText":'Kiri<input id="onLeft" type="radio" name="horizontal" class="radiobox">',"RightText":'Kanan<input id="onRight" type="radio" name="horizontal" class="radiobox">',"VerticalOrientationText":"Orientasi tegak","DownText":'Bawah<input id="onBottom" type="radio" name="vertical" class="radiobox">',
                            "HorizontalOrientationText":"Orientasi tidur","SettingsText":"Pengaturan Asisten","SmallText":'Kecil<input id="isSmall" type="radio" name="size" class="radiobox">',"SaveText":"Simpan"},"complaintMenu":{"CommentText":"Komentar","ComplaintExtendedText":"Jelaskan alasan untuk keluhan ini","AnotherText":'Lainnya<input id="another" type="radio" name="complaint" class="radiobox">',"AdSkippedText":'Iklan diloncati<input id="adMissing" type="radio" name="complaint" class="radiobox">',"IncorrectViewText":'Tampilan situs terdistorsi<input id="wrongRender" type="radio" name="complaint" class="radiobox">',
                            "PhishingSuspicionText":'Dicurigai phishing<input id="phishing" type="radio" name="complaint" class="radiobox">',"ComplainReasonText":"Alasan","CancelText":"Batal","SendComplaintText":"Kirim","ComplaintText":"Kirim keluhan"},"wotBad":"reputasi bahaya","exceptionMenu":{"EntireSiteText":'Seluruh situs <input type="radio" name="scope" class="radiobox" checked="true">',"ExceptionClarificationText":"Pengaturan pengecualian halaman ini","ExceptionDisclaimerText":"Membuat pengecualian memungkinkan Anda untuk selektif tidak memblokir halaman tertentu, elemen halaman atau seluruh situs.",
                            "OnlyThisPageText":'Halaman ini  hanya<input id="onPage" type="radio" name="scope" class="radiobox">',"NewExceptionText":"Pengecualian baru","AddExceptionButtonText":"Tambah pengecualian","ExtendedSettings":"Pengaturan lanjutan...","DontUseFiltrationRulesText":'Nonaktifkan aturan penyaringan konten <input id="content" type="checkbox" class="checkbox active" checked="true">',"ScopeText":"Lingkup aturan pengecualian","DontUseAssistantText":'Nonaktifkan Asisten Adguard <input id="jsinject" type="checkbox" class="checkbox active" checked="true">',
                            "DontUseUriBlockRulesText":'Nonaktifkan aturan memblok URL <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',"DontUseHideRulesText":'Nonaktifkan aturan sembunyikan elemen<input id="elemhide" type="checkbox" class="checkbox active" checked="true">',"ExceptionParametrsText":"Properti aturan pengecualian"}};var localizations=typeof localizations=="undefined"?{}:localizations;
                    localizations["es"]={"wotExcellent":"Una excelente reputaci\u00f3n","complaintWarning":"Debe seleccionar una raz\u00f3n para su reclamaci\u00f3n.","selectorMenu":{"cancel-select-mode":"Cancelar modo selecci\u00f3n","SelectElementText":"Seleccionar modo","SelectElementExtendedText":"Haga clic en cualquier elemento de la p\u00e1gina o"},"wotPostfix":"de acuerdo a","previewStart":"<span>Previo</span>","dragHandleWithoutWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span></div><div class="adg-head-opt"><a target="_blank" href="${href}">Abrir informe de seguridad sobre la web</a><span class="adg-version">${version}</span></div>',
                        "dragHandleWithWot":'<div class="adg-head-h"><span class="adg-domain">${domainName}</span><a target="_blank"><i id="WotIndication" class="adg-wot"></i></a><i id="ConfidenceIndication" class="adg-wot-confidence"></i></div><div class="adg-head-opt"><a target="_blank"><img alt="" src="data:image/png;base64,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"/></a><span class="adg-version">${version}</span></div>',
                        "wotGood":"Una buena reputaci\u00f3n","alert":{"welcomeHead":"Bienvenido al Asistente de Adguard!","welcomeLink":{"text":"M\u00e1s informaci\u00f3n","href":"http://adguard.com/tour.html"},"welcomeMessage":"Adguard Asistencia es un listado especial de Adguard Web m\u00f3dulo de filtro. Le permite eliminar cualquier contenido no deseado desde el sitio web. Tambi\u00e9n el color del icono de se\u00f1ales del sitio web actual de su reputaci\u00f3n."},"mainMenu":{"toolTips":{"ConfidenceIndication":"Reputaci\u00f3n nivel de Confianza",
                            "WotIndication":"Reputaci\u00f3n del sitio"},"SendComplaintText":"Reportar<br>una denuncia","blockElementTextExtend":"Puede seleccionar manualmente y eliminar cualquier elemento de la p\u00e1gina (imagen, publicidad, etc) desde esta p\u00e1gina o sitio web","UndoLastRuleText":"Deshacer<br>\u00faltima acci\u00f3n<br>","AssistantSettingsText":"Cambiar<br>configuraci\u00f3n<br>","AddToExceptionsTextExtend":"Adguard, dejar de filtrar los anuncios que aparecen en este sitio web hasta que se elimine de la lista de excepciones",
                            "AddToExceptionsText":"A\u00f1adir<br>Excepci\u00f3n","TemporaryExceptionText":"No bloquear<br>por 30 segundos<br>","blockElementText":"Bloquear<br>elemento"},"blockTextIfSliderHided":"El filtro contiene una regla que bloquea el elemento seleccionado","wotPrefix":"Este sitio tiene","wotUnsatisfactory":"Muy mala reputaci\u00f3n","wotPoor":"Una mala reputaci\u00f3n","wotUnknown":"Una desconocida reputaci\u00f3n","detailedMenu":{"SliderMaxText":"AMPLIO","AnotherElementText":"Seleccionar otro elemento",
                            "RuleParametrsText":"Par\u00e1metros de la regla","BlockElementExplainText":"Regla de bloqueo de configuraci\u00f3n","SliderMinText":"BAJO","BlockText":"Bloquear","ApplyRuleToAllSitesText":'Aplicar esta regla a todos los sitios web<input id="oneDomainRadio" type="checkbox" class="checkbox">',"BlockByReferenceText":'Bloquear elemento por URL<input id="blockByUrl" type="checkbox" class="checkbox">',"SliderExplainText":"Utilice el control deslizante para cambiar el tama\u00f1o del elemento que se va a ser bloqueado por esta regla:",
                            "PreviewText":"Previo","BlockSimilarText":'Bloquear elemento similar<input id="blockSimilar" type="checkbox" class="checkbox">',"BlockElementText":"Bloquear ahora!","ExtendedSettingsText":"Configuraci\u00f3n avanzada..."},"previewEnd":"<span>Finalizar previo</span>","settingsMenu":{"AssistantViewSettingsText":"Adguard Asistente de configuraci\u00f3n","IconSizeText":"Tama\u00f1o del icono","UpText":'Subir<input id="onTop" type="radio" name="vertical" class="radiobox">',"CancelText":"Cancelar","BigText":'Amplio<input id="isBig" type="radio" name="size" class="radiobox">',
                            "LeftText":'Izquierda<input id="onLeft" type="radio" name="horizontal" class="radiobox">',"RightText":'Derecha<input id="onRight" type="radio" name="horizontal" class="radiobox">',"VerticalOrientationText":"Orientaci\u00f3n vertical","DownText":'Bajar<input id="onBottom" type="radio" name="vertical" class="radiobox">',"HorizontalOrientationText":"Orientaci\u00f3n horizontal","SettingsText":"Configurar asistencia","SmallText":'Peque\u00f1o<input id="isSmall" type="radio" name="size" class="radiobox">',
                            "SaveText":"Guardar"},"complaintMenu":{"CommentText":"Comentarios","ComplaintExtendedText":"S\u00edrvase describir el motivo de su denuncia","AnotherText":'Otro<input id="another" type="radio" name="complaint" class="radiobox">',"AdSkippedText":'Publicidad ignorar<input id="adMissing" type="radio" name="complaint" class="radiobox">',"IncorrectViewText":'Pagina web distorsionado<input id="wrongRender" type="radio" name="complaint" class="radiobox">',"PhishingSuspicionText":'Actividad sospechosa<input id="phishing" type="radio" name="complaint" class="radiobox">',
                            "ComplainReasonText":"Raz\u00f3n","CancelText":"Cancelar","SendComplaintText":"Enviar","ComplaintText":"Enviar una denuncia"},"wotBad":"Una reputaci\u00f3n muy baja","exceptionMenu":{"EntireSiteText":'Todo el sitio <input type="radio" name="scope" class="radiobox" checked="true">',"ExceptionClarificationText":"Configurar una excepci\u00f3n para esta p\u00e1gina","ExceptionDisclaimerText":"Creaci\u00f3n de excepciones permite desbloquear de forma selectiva ciertas p\u00e1ginas, elementos de la p\u00e1gina o p\u00e1ginas enteras.",
                            "OnlyThisPageText":'Esta p\u00e1gina s\u00f3lo<input id="onPage" type="radio" name="scope" class="radiobox">',"NewExceptionText":"Nueva excepci\u00f3n","AddExceptionButtonText":"A\u00f1adir excepci\u00f3n","ExtendedSettings":"Configuraci\u00f3n avanzada...","DontUseFiltrationRulesText":'Desactivar regla de filtro <input id="content" type="checkbox" class="checkbox active" checked="true">              ',"ScopeText":"Regla de excepci\u00f3n","DontUseAssistantText":'Desactivar asistencia de Adguard <input id="jsinject" type="checkbox" class="checkbox active" checked="true">',
                            "DontUseUriBlockRulesText":'Desactivar regla de bloqueo URL <input id="urlblock" type="checkbox" class="checkbox active" checked="true">',"DontUseHideRulesText":'Desactivar elemento en regla oculta <input id="elemhide" type="checkbox" class="checkbox active" checked="true">',"ExceptionParametrsText":"Propiedades de la regla excepci\u00f3n"}};
                    function diff_match_patch(){this.Diff_Timeout=1;this.Diff_EditCost=4;this.Diff_DualThreshold=32;this.Match_Balance=0.5;this.Match_Threshold=0.5;this.Match_MinLength=100;this.Match_MaxLength=1E3;this.Patch_Margin=4;function getMaxBits(){var a=0;var b=1;var c=2;while(b!=c){a++;b=c;c=c<<1}return a}this.Match_MaxBits=getMaxBits()}var DIFF_DELETE=-1;var DIFF_INSERT=1;var DIFF_EQUAL=0;
                    diff_match_patch.prototype.diff_main=function(a,b,c){if(a==b)return[[DIFF_EQUAL,a]];if(typeof c=="undefined")c=true;var d=c;var e=this.diff_commonPrefix(a,b);var f=a.substring(0,e);a=a.substring(e);b=b.substring(e);e=this.diff_commonSuffix(a,b);var g=a.substring(a.length-e);a=a.substring(0,a.length-e);b=b.substring(0,b.length-e);var h=this.diff_compute(a,b,d);if(f)h.unshift([DIFF_EQUAL,f]);if(g)h.push([DIFF_EQUAL,g]);this.diff_cleanupMerge(h);return h};
                    diff_match_patch.prototype.diff_compute=function(b,c,d){var e;if(!b)return[[DIFF_INSERT,c]];if(!c)return[[DIFF_DELETE,b]];var f=b.length>c.length?b:c;var g=b.length>c.length?c:b;var i=f.indexOf(g);if(i!=-1){e=[[DIFF_INSERT,f.substring(0,i)],[DIFF_EQUAL,g],[DIFF_INSERT,f.substring(i+g.length)]];if(b.length>c.length)e[0][0]=e[2][0]=DIFF_DELETE;return e}f=g=null;var h=this.diff_halfMatch(b,c);if(h){var k=h[0];var l=h[1];var m=h[2];var n=h[3];var o=h[4];var p=this.diff_main(k,m,d);var q=this.diff_main(l,
                        n,d);return p.concat([[DIFF_EQUAL,o]],q)}if(d&&(b.length<100||c.length<100))d=false;var r;if(d){var a=this.diff_linesToChars(b,c);b=a[0];c=a[1];r=a[2]}e=this.diff_map(b,c);if(!e)e=[[DIFF_DELETE,b],[DIFF_INSERT,c]];if(d){this.diff_charsToLines(e,r);this.diff_cleanupSemantic(e);e.push([DIFF_EQUAL,""]);var s=0;var t=0;var u=0;var v="";var w="";while(s<e.length){switch(e[s][0]){case DIFF_INSERT:u++;w+=e[s][1];break;case DIFF_DELETE:t++;v+=e[s][1];break;case DIFF_EQUAL:if(t>=1&&u>=1){var a=this.diff_main(v,
                        w,false);e.splice(s-t-u,t+u);s=s-t-u;for(var j=a.length-1;j>=0;j--)e.splice(s,0,a[j]);s=s+a.length}u=0;t=0;v="";w="";break}s++}e.pop()}return e};
                    diff_match_patch.prototype.diff_linesToChars=function(g,h){var i=[];var j={};i[0]="";function diff_linesToCharsMunge(a){var b="";var c=0;var d=-1;var e=i.length;while(d<a.length-1){d=a.indexOf("\n",c);if(d==-1)d=a.length-1;var f=a.substring(c,d+1);c=d+1;if(j.hasOwnProperty?j.hasOwnProperty(f):j[f]!==undefined)b+=String.fromCharCode(j[f]);else{b+=String.fromCharCode(e);j[f]=e;i[e++]=f}}return b}var k=diff_linesToCharsMunge(g);var l=diff_linesToCharsMunge(h);return[k,l,i]};
                    diff_match_patch.prototype.diff_charsToLines=function(a,b){for(var x=0;x<a.length;x++){var c=a[x][1];var d=[];for(var y=0;y<c.length;y++)d[y]=b[c.charCodeAt(y)];a[x][1]=d.join("")}};
                    diff_match_patch.prototype.diff_map=function(b,c){var e=(new Date).getTime()+this.Diff_Timeout*1E3;var f=b.length+c.length-1;var g=this.Diff_DualThreshold*2<f;var h=[];var i=[];var j={};var l={};j[1]=0;l[1]=0;var x,y;var m;var n={};var o=false;var hasOwnProperty=!!n.hasOwnProperty;var p=(b.length+c.length)%2;for(var d=0;d<f;d++){if(this.Diff_Timeout>0&&(new Date).getTime()>e)return null;h[d]={};for(var k=-d;k<=d;k+=2){if(k==-d||k!=d&&j[k-1]<j[k+1])x=j[k+1];else x=j[k-1]+1;y=x-k;if(g){m=x+","+y;if(p&&
                        (hasOwnProperty?n.hasOwnProperty(m):n[m]!==undefined))o=true;if(!p)n[m]=d}while(!o&&(x<b.length&&(y<c.length&&b.charAt(x)==c.charAt(y)))){x++;y++;if(g){m=x+","+y;if(p&&(hasOwnProperty?n.hasOwnProperty(m):n[m]!==undefined))o=true;if(!p)n[m]=d}}j[k]=x;h[d][x+","+y]=true;if(x==b.length&&y==c.length)return this.diff_path1(h,b,c);else if(o){i=i.slice(0,n[m]+1);var a=this.diff_path1(h,b.substring(0,x),c.substring(0,y));return a.concat(this.diff_path2(i,b.substring(x),c.substring(y)))}}if(g){i[d]={};for(var k=
                        -d;k<=d;k+=2){if(k==-d||k!=d&&l[k-1]<l[k+1])x=l[k+1];else x=l[k-1]+1;y=x-k;m=b.length-x+","+(c.length-y);if(!p&&(hasOwnProperty?n.hasOwnProperty(m):n[m]!==undefined))o=true;if(p)n[m]=d;while(!o&&(x<b.length&&(y<c.length&&b.charAt(b.length-x-1)==c.charAt(c.length-y-1)))){x++;y++;m=b.length-x+","+(c.length-y);if(!p&&(hasOwnProperty?n.hasOwnProperty(m):n[m]!==undefined))o=true;if(p)n[m]=d}l[k]=x;i[d][x+","+y]=true;if(o){h=h.slice(0,n[m]+1);var a=this.diff_path1(h,b.substring(0,b.length-x),c.substring(0,
                        c.length-y));return a.concat(this.diff_path2(i,b.substring(b.length-x),c.substring(c.length-y)))}}}}return null};
                    diff_match_patch.prototype.diff_path1=function(a,b,c){var e=[];var x=b.length;var y=c.length;var f=null;for(var d=a.length-2;d>=0;d--)while(1)if(a[d].hasOwnProperty?a[d].hasOwnProperty(x-1+","+y):a[d][x-1+","+y]!==undefined){x--;if(f===DIFF_DELETE)e[0][1]=b.charAt(x)+e[0][1];else e.unshift([DIFF_DELETE,b.charAt(x)]);f=DIFF_DELETE;break}else if(a[d].hasOwnProperty?a[d].hasOwnProperty(x+","+(y-1)):a[d][x+","+(y-1)]!==undefined){y--;if(f===DIFF_INSERT)e[0][1]=c.charAt(y)+e[0][1];else e.unshift([DIFF_INSERT,
                        c.charAt(y)]);f=DIFF_INSERT;break}else{x--;y--;if(f===DIFF_EQUAL)e[0][1]=b.charAt(x)+e[0][1];else e.unshift([DIFF_EQUAL,b.charAt(x)]);f=DIFF_EQUAL}return e};
                    diff_match_patch.prototype.diff_path2=function(a,b,c){var e=[];var f=0;var x=b.length;var y=c.length;var g=null;for(var d=a.length-2;d>=0;d--)while(1)if(a[d].hasOwnProperty?a[d].hasOwnProperty(x-1+","+y):a[d][x-1+","+y]!==undefined){x--;if(g===DIFF_DELETE)e[f-1][1]+=b.charAt(b.length-x-1);else e[f++]=[DIFF_DELETE,b.charAt(b.length-x-1)];g=DIFF_DELETE;break}else if(a[d].hasOwnProperty?a[d].hasOwnProperty(x+","+(y-1)):a[d][x+","+(y-1)]!==undefined){y--;if(g===DIFF_INSERT)e[f-1][1]+=c.charAt(c.length-
                        y-1);else e[f++]=[DIFF_INSERT,c.charAt(c.length-y-1)];g=DIFF_INSERT;break}else{x--;y--;if(g===DIFF_EQUAL)e[f-1][1]+=b.charAt(b.length-x-1);else e[f++]=[DIFF_EQUAL,b.charAt(b.length-x-1)];g=DIFF_EQUAL}return e};diff_match_patch.prototype.diff_commonPrefix=function(a,b){if(!a||(!b||a.charCodeAt(0)!==b.charCodeAt(0)))return 0;var c=0;var d=Math.min(a.length,b.length);var e=d;var f=0;while(c<e){if(a.substring(f,e)==b.substring(f,e)){c=e;f=c}else d=e;e=Math.floor((d-c)/2+c)}return e};
                    diff_match_patch.prototype.diff_commonSuffix=function(a,b){if(!a||(!b||a.charCodeAt(a.length-1)!==b.charCodeAt(b.length-1)))return 0;var c=0;var d=Math.min(a.length,b.length);var e=d;var f=0;while(c<e){if(a.substring(a.length-e,a.length-f)==b.substring(b.length-e,b.length-f)){c=e;f=c}else d=e;e=Math.floor((d-c)/2+c)}return e};
                    diff_match_patch.prototype.diff_halfMatch=function(h,k){var l=h.length>k.length?h:k;var m=h.length>k.length?k:h;if(l.length<10||m.length<1)return null;var n=this;function diff_halfMatchI(a,b,i){var c=a.substring(i,i+Math.floor(a.length/4));var j=-1;var d="";var e,best_longtext_b,best_shorttext_a,best_shorttext_b;while((j=b.indexOf(c,j+1))!=-1){var f=n.diff_commonPrefix(a.substring(i),b.substring(j));var g=n.diff_commonSuffix(a.substring(0,i),b.substring(0,j));if(d.length<g+f){d=b.substring(j-g,j)+
                        b.substring(j,j+f);e=a.substring(0,i-g);best_longtext_b=a.substring(i+f);best_shorttext_a=b.substring(0,j-g);best_shorttext_b=b.substring(j+f)}}if(d.length>=a.length/2)return[e,best_longtext_b,best_shorttext_a,best_shorttext_b,d];else return null}var o=diff_halfMatchI(l,m,Math.ceil(l.length/4));var p=diff_halfMatchI(l,m,Math.ceil(l.length/2));var q;if(!o&&!p)return null;else if(!p)q=o;else if(!o)q=p;else q=o[4].length>p[4].length?o:p;var r,text1_b,text2_a,text2_b;if(h.length>k.length){r=q[0];text1_b=
                        q[1];text2_a=q[2];text2_b=q[3]}else{text2_a=q[0];text2_b=q[1];r=q[2];text1_b=q[3]}var s=q[4];return[r,text1_b,text2_a,text2_b,s]};
                    diff_match_patch.prototype.diff_cleanupSemantic=function(a){var b=false;var c=[];var d=0;var e=null;var f=0;var g=0;var h=0;while(f<a.length){if(a[f][0]==DIFF_EQUAL){c[d++]=f;g=h;h=0;e=a[f][1]}else{h+=a[f][1].length;if(e!==null&&(e.length<=g&&e.length<=h)){a.splice(c[d-1],0,[DIFF_DELETE,e]);a[c[d-1]+1][0]=DIFF_INSERT;d--;d--;f=d>0?c[d-1]:-1;g=0;h=0;e=null;b=true}}f++}if(b)this.diff_cleanupMerge(a);this.diff_cleanupSemanticLossless(a)};
                    diff_match_patch.prototype.diff_cleanupSemanticLossless=function(d){var e=/[^a-zA-Z0-9]/;var f=/\s/;var g=/[\r\n]/;var h=/\n\r?\n$/;var i=/^\r?\n\r?\n/;function diff_cleanupSemanticScore(a,b){if(!a||!b)return 5;var c=0;if(a.charAt(a.length-1).match(e)||b.charAt(0).match(e)){c++;if(a.charAt(a.length-1).match(f)||b.charAt(0).match(f)){c++;if(a.charAt(a.length-1).match(g)||b.charAt(0).match(g)){c++;if(a.match(h)||b.match(i))c++}}}return c}var j=1;while(j<d.length-1){if(d[j-1][0]==DIFF_EQUAL&&d[j+1][0]==
                        DIFF_EQUAL){var k=d[j-1][1];var l=d[j][1];var m=d[j+1][1];var n=this.diff_commonSuffix(k,l);if(n){var o=l.substring(l.length-n);k=k.substring(0,k.length-n);l=o+l.substring(0,l.length-n);m=o+m}var p=k;var q=l;var r=m;var s=diff_cleanupSemanticScore(k,l)+diff_cleanupSemanticScore(l,m);while(l.charAt(0)===m.charAt(0)){k+=l.charAt(0);l=l.substring(1)+m.charAt(0);m=m.substring(1);var t=diff_cleanupSemanticScore(k,l)+diff_cleanupSemanticScore(l,m);if(t>=s){s=t;p=k;q=l;r=m}}if(d[j-1][1]!=p){if(p)d[j-1][1]=
                        p;else{d.splice(j-1,1);j--}d[j][1]=q;if(r)d[j+1][1]=r;else{d.splice(j+1,1);j--}}}j++}};
                    diff_match_patch.prototype.diff_cleanupEfficiency=function(a){var b=false;var c=[];var d=0;var e="";var f=0;var g=false;var h=false;var i=false;var j=false;while(f<a.length){if(a[f][0]==DIFF_EQUAL){if(a[f][1].length<this.Diff_EditCost&&(i||j)){c[d++]=f;g=i;h=j;e=a[f][1]}else{d=0;e=""}i=j=false}else{if(a[f][0]==DIFF_DELETE)j=true;else i=true;if(e&&(g&&(h&&(i&&j))||e.length<this.Diff_EditCost/2&&g+h+i+j==3)){a.splice(c[d-1],0,[DIFF_DELETE,e]);a[c[d-1]+1][0]=DIFF_INSERT;d--;e="";if(g&&h){i=j=true;d=
                        0}else{d--;f=d>0?c[d-1]:-1;i=j=false}b=true}}f++}if(b)this.diff_cleanupMerge(a)};
                    diff_match_patch.prototype.diff_cleanupMerge=function(a){a.push([DIFF_EQUAL,""]);var b=0;var c=0;var d=0;var e="";var f="";var g;while(b<a.length)switch(a[b][0]){case DIFF_INSERT:d++;f+=a[b][1];b++;break;case DIFF_DELETE:c++;e+=a[b][1];b++;break;case DIFF_EQUAL:if(c!==0||d!==0){if(c!==0&&d!==0){g=this.diff_commonPrefix(f,e);if(g!==0){if(b-c-d>0&&a[b-c-d-1][0]==DIFF_EQUAL)a[b-c-d-1][1]+=f.substring(0,g);else{a.splice(0,0,[DIFF_EQUAL,f.substring(0,g)]);b++}f=f.substring(g);e=e.substring(g)}g=this.diff_commonSuffix(f,
                        e);if(g!==0){a[b][1]=f.substring(f.length-g)+a[b][1];f=f.substring(0,f.length-g);e=e.substring(0,e.length-g)}}if(c===0)a.splice(b-c-d,c+d,[DIFF_INSERT,f]);else if(d===0)a.splice(b-c-d,c+d,[DIFF_DELETE,e]);else a.splice(b-c-d,c+d,[DIFF_DELETE,e],[DIFF_INSERT,f]);b=b-c-d+(c?1:0)+(d?1:0)+1}else if(b!==0&&a[b-1][0]==DIFF_EQUAL){a[b-1][1]+=a[b][1];a.splice(b,1)}else b++;d=0;c=0;e="";f="";break}if(a[a.length-1][1]==="")a.pop();var h=false;b=1;while(b<a.length-1){if(a[b-1][0]==DIFF_EQUAL&&a[b+1][0]==DIFF_EQUAL)if(a[b][1].substring(a[b][1].length-
                            a[b-1][1].length)==a[b-1][1]){a[b][1]=a[b-1][1]+a[b][1].substring(0,a[b][1].length-a[b-1][1].length);a[b+1][1]=a[b-1][1]+a[b+1][1];a.splice(b-1,1);h=true}else if(a[b][1].substring(0,a[b+1][1].length)==a[b+1][1]){a[b-1][1]+=a[b+1][1];a[b][1]=a[b][1].substring(a[b+1][1].length)+a[b+1][1];a.splice(b+1,1);h=true}b++}if(h)this.diff_cleanupMerge(a)};
                    diff_match_patch.prototype.diff_xIndex=function(a,b){var c=0;var d=0;var e=0;var f=0;var x;for(x=0;x<a.length;x++){if(a[x][0]!==DIFF_INSERT)c+=a[x][1].length;if(a[x][0]!==DIFF_DELETE)d+=a[x][1].length;if(c>b)break;e=c;f=d}if(a.length!=x&&a[x][0]===DIFF_DELETE)return f;return f+(b-e)};
                    diff_match_patch.prototype.diff_prettyHtml=function(a){var b=[];var i=0;for(var x=0;x<a.length;x++){var c=a[x][0];var d=a[x][1];var e=d.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\n/g,"&para;<BR>");switch(c){case DIFF_INSERT:b[x]='<INS STYLE="background:#E6FFE6;" TITLE="i='+i+'">'+e+"</INS>";break;case DIFF_DELETE:b[x]='<DEL STYLE="background:#FFE6E6;" TITLE="i='+i+'">'+e+"</DEL>";break;case DIFF_EQUAL:b[x]='<SPAN TITLE="i='+i+'">'+e+"</SPAN>";break}if(c!==DIFF_DELETE)i+=
                        d.length}return b.join("")};diff_match_patch.prototype.diff_text1=function(a){var b=[];for(var x=0;x<a.length;x++)if(a[x][0]!==DIFF_INSERT)b[x]=a[x][1];return b.join("")};diff_match_patch.prototype.diff_text2=function(a){var b=[];for(var x=0;x<a.length;x++)if(a[x][0]!==DIFF_DELETE)b[x]=a[x][1];return b.join("")};
                    diff_match_patch.prototype.diff_toDelta=function(a){var b=[];for(var x=0;x<a.length;x++)switch(a[x][0]){case DIFF_INSERT:b[x]="+"+encodeURI(a[x][1]);break;case DIFF_DELETE:b[x]="-"+a[x][1].length;break;case DIFF_EQUAL:b[x]="="+a[x][1].length;break}return b.join("\t").replace(/\0/g,"%00").replace(/%20/g," ")};
                    diff_match_patch.prototype.diff_fromDelta=function(a,b){var c=[];var d=0;var e=0;b=b.replace(/%00/g,"\x00");var f=b.split(/\t/g);for(var x=0;x<f.length;x++){var g=f[x].substring(1);switch(f[x].charAt(0)){case "+":try{c[d++]=[DIFF_INSERT,decodeURI(g)]}catch(ex){throw new Error("Illegal escape in diff_fromDelta: "+g);}break;case "-":case "=":var n=parseInt(g,10);if(isNaN(n)||n<0)throw new Error("Invalid number in diff_fromDelta: "+g);var h=a.substring(e,e+=n);if(f[x].charAt(0)=="=")c[d++]=[DIFF_EQUAL,
                        h];else c[d++]=[DIFF_DELETE,h];break;default:if(f[x])throw new Error("Invalid diff operation in diff_fromDelta: "+f[x]);}}if(e!=a.length)throw new Error("Delta length ("+e+") does not equal source text length ("+a.length+").");return c};diff_match_patch.prototype.match_main=function(a,b,c){c=Math.max(0,Math.min(c,a.length-b.length));if(a==b)return 0;else if(a.length===0)return null;else if(a.substring(c,c+b.length)==b)return c;else return this.match_bitap(a,b,c)};
                    diff_match_patch.prototype.match_bitap=function(a,b,c){if(b.length>this.Match_MaxBits)throw new Error("Pattern too long for this browser.");var s=this.match_alphabet(b);var f=a.length;f=Math.max(f,this.Match_MinLength);f=Math.min(f,this.Match_MaxLength);var g=this;function match_bitapScore(e,x){var d=Math.abs(c-x);return e/b.length/g.Match_Balance+d/f/(1-g.Match_Balance)}var h=this.Match_Threshold;var i=a.indexOf(b,c);if(i!=-1)h=Math.min(match_bitapScore(0,i),h);i=a.lastIndexOf(b,c+b.length);if(i!=
                        -1)h=Math.min(match_bitapScore(0,i),h);var k=1<<b.length-1;i=null;var l,bin_mid;var m=Math.max(c+c,a.length);var n;for(var d=0;d<b.length;d++){var o=Array(a.length);l=c;bin_mid=m;while(l<bin_mid){if(match_bitapScore(d,bin_mid)<h)l=bin_mid;else m=bin_mid;bin_mid=Math.floor((m-l)/2+l)}m=bin_mid;var p=Math.max(0,c-(bin_mid-c)-1);var q=Math.min(a.length-1,b.length+bin_mid);if(a.charAt(q)==b.charAt(b.length-1))o[q]=(1<<d+1)-1;else o[q]=(1<<d)-1;for(var j=q-1;j>=p;j--){if(d===0)o[j]=(o[j+1]<<1|1)&s[a.charAt(j)];
                    else o[j]=(o[j+1]<<1|1)&s[a.charAt(j)]|(n[j+1]<<1|1)|(n[j]<<1|1)|n[j+1];if(o[j]&k){var r=match_bitapScore(d,j);if(r<=h){h=r;i=j;if(j>c)p=Math.max(0,c-(j-c));else break}}}if(match_bitapScore(d+1,c)>h)break;n=o}return i};diff_match_patch.prototype.match_alphabet=function(a){var s={};for(var i=0;i<a.length;i++)s[a.charAt(i)]=0;for(var i=0;i<a.length;i++)s[a.charAt(i)]|=1<<a.length-i-1;return s};
                    diff_match_patch.prototype.patch_addContext=function(a,b){var c=b.substring(a.start2,a.start2+a.length1);var d=0;while(b.indexOf(c)!=b.lastIndexOf(c)&&c.length<this.Match_MaxBits-this.Patch_Margin-this.Patch_Margin){d+=this.Patch_Margin;c=b.substring(a.start2-d,a.start2+a.length1+d)}d+=this.Patch_Margin;var e=b.substring(a.start2-d,a.start2);if(e!=="")a.diffs.unshift([DIFF_EQUAL,e]);var f=b.substring(a.start2+a.length1,a.start2+a.length1+d);if(f!=="")a.diffs.push([DIFF_EQUAL,f]);a.start1-=e.length;
                        a.start2-=e.length;a.length1+=e.length+f.length;a.length2+=e.length+f.length};
                    diff_match_patch.prototype.patch_make=function(a,b,c){var d,text2,diffs;if(typeof b=="undefined"){diffs=a;d=this.diff_text1(diffs);text2=""}else{d=a;text2=b;if(typeof c!="undefined")diffs=c;else{diffs=this.diff_main(d,text2,true);if(diffs.length>2){this.diff_cleanupSemantic(diffs);this.diff_cleanupEfficiency(diffs)}}}if(diffs.length===0)return[];var e=[];var f=new patch_obj;var g=0;var h=0;var i=0;var j=d;var k=d;for(var x=0;x<diffs.length;x++){var l=diffs[x][0];var m=diffs[x][1];if(!g&&l!==DIFF_EQUAL){f.start1=
                        h;f.start2=i}switch(l){case DIFF_INSERT:f.diffs[g++]=diffs[x];f.length2+=m.length;k=k.substring(0,i)+m+k.substring(i);break;case DIFF_DELETE:f.length1+=m.length;f.diffs[g++]=diffs[x];k=k.substring(0,i)+k.substring(i+m.length);break;case DIFF_EQUAL:if(m.length<=2*this.Patch_Margin&&(g&&diffs.length!=x+1)){f.diffs[g++]=diffs[x];f.length1+=m.length;f.length2+=m.length}else if(m.length>=2*this.Patch_Margin)if(g){this.patch_addContext(f,j);e.push(f);f=new patch_obj;g=0;j=k}break}if(l!==DIFF_INSERT)h+=
                        m.length;if(l!==DIFF_DELETE)i+=m.length}if(g){this.patch_addContext(f,j);e.push(f)}return e};
                    diff_match_patch.prototype.patch_apply=function(a,b){if(a.length==0)return[b,[]];var c=[];for(var x=0;x<a.length;x++){var d=a[x];var e=new patch_obj;e.diffs=d.diffs.slice();e.start1=d.start1;e.start2=d.start2;e.length1=d.length1;e.length2=d.length2;c[x]=e}a=c;var f=this.patch_addPadding(a);b=f+b+f;this.patch_splitMax(a);var g=0;var h=[];for(var x=0;x<a.length;x++){var i=a[x].start2+g;var j=this.diff_text1(a[x].diffs);var k=this.match_main(b,j,i);if(k===null)h[x]=false;else{h[x]=true;g=k-i;var l=b.substring(k,
                        k+j.length);if(j==l)b=b.substring(0,k)+this.diff_text2(a[x].diffs)+b.substring(k+j.length);else{var m=this.diff_main(j,l,false);this.diff_cleanupSemanticLossless(m);var n=0;var o;for(var y=0;y<a[x].diffs.length;y++){var p=a[x].diffs[y];if(p[0]!==DIFF_EQUAL)o=this.diff_xIndex(m,n);if(p[0]===DIFF_INSERT)b=b.substring(0,k+o)+p[1]+b.substring(k+o);else if(p[0]===DIFF_DELETE)b=b.substring(0,k+o)+b.substring(k+this.diff_xIndex(m,n+p[1].length));if(p[0]!==DIFF_DELETE)n+=p[1].length}}}}b=b.substring(f.length,
                        b.length-f.length);return[b,h]};
                    diff_match_patch.prototype.patch_addPadding=function(a){var b="";for(var x=0;x<this.Patch_Margin;x++)b+=String.fromCharCode(x);for(var x=0;x<a.length;x++){a[x].start1+=b.length;a[x].start2+=b.length}var c=a[0];var d=c.diffs;if(d.length==0||d[0][0]!=DIFF_EQUAL){d.unshift([DIFF_EQUAL,b]);c.start1-=b.length;c.start2-=b.length;c.length1+=b.length;c.length2+=b.length}else if(b.length>d[0][1].length){var e=b.length-d[0][1].length;d[0][1]=b.substring(d[0][1].length)+d[0][1];c.start1-=e;c.start2-=e;c.length1+=
                        e;c.length2+=e}c=a[a.length-1];d=c.diffs;if(d.length==0||d[d.length-1][0]!=DIFF_EQUAL){d.push([DIFF_EQUAL,b]);c.length1+=b.length;c.length2+=b.length}else if(b.length>d[d.length-1][1].length){var e=b.length-d[d.length-1][1].length;d[d.length-1][1]+=b.substring(0,e);c.length1+=e;c.length2+=e}return b};
                    diff_match_patch.prototype.patch_splitMax=function(a){for(var x=0;x<a.length;x++)if(a[x].length1>this.Match_MaxBits){var b=a[x];a.splice(x,1);var c=this.Match_MaxBits;var d=b.start1;var e=b.start2;var f="";while(b.diffs.length!==0){var g=new patch_obj;var h=true;g.start1=d-f.length;g.start2=e-f.length;if(f!==""){g.length1=g.length2=f.length;g.diffs.push([DIFF_EQUAL,f])}while(b.diffs.length!==0&&g.length1<c-this.Patch_Margin){var i=b.diffs[0][0];var j=b.diffs[0][1];if(i===DIFF_INSERT){g.length2+=j.length;
                        e+=j.length;g.diffs.push(b.diffs.shift());h=false}else{j=j.substring(0,c-g.length1-this.Patch_Margin);g.length1+=j.length;d+=j.length;if(i===DIFF_EQUAL){g.length2+=j.length;e+=j.length}else h=false;g.diffs.push([i,j]);if(j==b.diffs[0][1])b.diffs.shift();else b.diffs[0][1]=b.diffs[0][1].substring(j.length)}}f=this.diff_text2(g.diffs);f=f.substring(f.length-this.Patch_Margin);var k=this.diff_text1(b.diffs).substring(0,this.Patch_Margin);if(k!==""){g.length1+=k.length;g.length2+=k.length;if(g.diffs.length!==
                        0&&g.diffs[g.diffs.length-1][0]===DIFF_EQUAL)g.diffs[g.diffs.length-1][1]+=k;else g.diffs.push([DIFF_EQUAL,k])}if(!h)a.splice(x++,0,g)}}};diff_match_patch.prototype.patch_toText=function(a){var b=[];for(var x=0;x<a.length;x++)b[x]=a[x];return b.join("")};
                    diff_match_patch.prototype.patch_fromText=function(a){var b=[];if(!a)return b;a=a.replace(/%00/g,"\x00");var c=a.split("\n");var d=0;while(d<c.length){var m=c[d].match(/^@@ -(\d+),?(\d*) \+(\d+),?(\d*) @@$/);if(!m)throw new Error("Invalid patch string: "+c[d]);var e=new patch_obj;b.push(e);e.start1=parseInt(m[1],10);if(m[2]===""){e.start1--;e.length1=1}else if(m[2]=="0")e.length1=0;else{e.start1--;e.length1=parseInt(m[2],10)}e.start2=parseInt(m[3],10);if(m[4]===""){e.start2--;e.length2=1}else if(m[4]==
                        "0")e.length2=0;else{e.start2--;e.length2=parseInt(m[4],10)}d++;while(d<c.length){var f=c[d].charAt(0);try{var g=decodeURI(c[d].substring(1))}catch(ex){throw new Error("Illegal escape in patch_fromText: "+g);}if(f=="-")e.diffs.push([DIFF_DELETE,g]);else if(f=="+")e.diffs.push([DIFF_INSERT,g]);else if(f==" ")e.diffs.push([DIFF_EQUAL,g]);else if(f=="@")break;else if(f==="");else throw new Error('Invalid patch mode "'+f+'" in: '+g);d++}}return b};
                    function patch_obj(){this.diffs=[];this.start1=null;this.start2=null;this.length1=0;this.length2=0}
                    patch_obj.prototype.toString=function(){var a,coords2;if(this.length1===0)a=this.start1+",0";else if(this.length1==1)a=this.start1+1;else a=this.start1+1+","+this.length1;if(this.length2===0)coords2=this.start2+",0";else if(this.length2==1)coords2=this.start2+1;else coords2=this.start2+1+","+this.length2;var b=["@@ -"+a+" +"+coords2+" @@\n"];var c;for(var x=0;x<this.diffs.length;x++){switch(this.diffs[x][0]){case DIFF_INSERT:c="+";break;case DIFF_DELETE:c="-";break;case DIFF_EQUAL:c=" ";break}b[x+
                    1]=c+encodeURI(this.diffs[x][1])+"\n"}return b.join("").replace(/\0/g,"%00").replace(/%20/g," ")};
                    var DomPredictionHelper=function(AdguardQuery,String){var recursiveNodes=function(e){var n;if(e.nodeName&&(e.parentNode&&e!=document.body))n=recursiveNodes(e.parentNode);else n=[];n.push(e);return n};var escapeCssNames=function(name){if(name)try{return name.replace(/\s*sg_\w+\s*/g,"").replace(/\\/g,"\\\\").replace(/\./g,"\\.").replace(/#/g,"\\#").replace(/\>/g,"\\>").replace(/\,/g,"\\,").replace(/\:/g,"\\:")}catch(e){return""}else return""};var childElemNumber=function(elem){var count=0;while(elem.previousSibling&&
                    (elem=elem.previousSibling))if(elem.nodeType==1)count++;return count};var pathOf=function(elem){var nodes=recursiveNodes(elem);var self=this;var path="";for(var i=0;i<nodes.length;i++){var e=nodes[i];if(e){path+=e.nodeName.toLowerCase();var escaped=e.id&&escapeCssNames(new String(e.id));if(escaped&&escaped.length>0)path+="#"+escaped;if(e.className)AdguardQuery.each(e.className.split(/ /),function(){var escaped=escapeCssNames(this);if(this&&escaped.length>0)path+="."+escaped});path+=":nth-child("+
                        (childElemNumber(e)+1)+")";path+=" "}}if(path.charAt(path.length-1)==" ")path=path.substring(0,path.length-1);return path};var commonCss=function(array){try{var dmp=new diff_match_patch}catch(e){throw"Please include the diff_match_patch library.";}if(typeof array=="undefined"||array.length==0)return"";var existing_tokens={};var encoded_css_array=encodeCssForDiff(array,existing_tokens);var collective_common=encoded_css_array.pop();AdguardQuery.each(encoded_css_array,function(e){var diff=dmp.diff_main(collective_common,
                        this);collective_common="";AdguardQuery.each(diff,function(){if(this[0]==0)collective_common+=this[1]})});return decodeCss(collective_common,existing_tokens)};var tokenizeCss=function(css_string){var skip=false;var word="";var tokens=[];var css_string=css_string.replace(/,/," , ").replace(/\s+/g," ");var length=css_string.length;var c="";for(var i=0;i<length;i++){c=css_string[i];if(skip)skip=false;else if(c=="\\")skip=true;else if(c=="."||(c==" "||(c=="#"||(c==">"||(c==":"||c==","))))){if(word.length>
                        0)tokens.push(word);word=""}word+=c;if(c==" "||c==","){tokens.push(word);word=""}}if(word.length>0)tokens.push(word);return tokens};var decodeCss=function(string,existing_tokens){var inverted=invertObject(existing_tokens);var out="";AdguardQuery.each(string.split(""),function(){out+=inverted[this]});return cleanCss(out)};var encodeCssForDiff=function(strings,existing_tokens){var codepoint=50;var self=this;var strings_out=[];AdguardQuery.each(strings,function(){var out=new String;AdguardQuery.each(tokenizeCss(this),
                        function(){if(!existing_tokens[this])existing_tokens[this]=String.fromCharCode(codepoint++);out+=existing_tokens[this]});strings_out.push(out)});return strings_out};var simplifyCss=function(css,selected_paths,rejected_paths){var self=this;var parts=tokenizeCss(css);var best_so_far="";if(selectorGets("all",selected_paths,css)&&selectorGets("none",rejected_paths,css))best_so_far=css;for(var pass=0;pass<4;pass++)for(var part=0;part<parts.length;part++){var first=parts[part].substring(0,1);if(wouldLeaveFreeFloatingNthChild(parts,
                            part))continue;if(pass==0&&first==":"||(pass==1&&(first!=":"&&(first!="."&&(first!="#"&&first!=" ")))||(pass==2&&first=="."||pass==3&&first=="#"))){var tmp=parts[part];parts[part]="";var selector=cleanCss(parts.join(""));if(selector==""){parts[part]=tmp;continue}if(selectorGets("all",selected_paths,selector)&&selectorGets("none",rejected_paths,selector))best_so_far=selector;else parts[part]=tmp}}return cleanCss(best_so_far)};var wouldLeaveFreeFloatingNthChild=function(parts,part){return part-1>=0&&
                        parts[part-1].substring(0,1)==":"&&((part-2<0||parts[part-2]==" ")&&(part+1>=parts.length||parts[part+1]==" "))||part+1<parts.length&&parts[part+1].substring(0,1)==":"&&((part+2>=parts.length||parts[part+2]==" ")&&(part-1<0||parts[part-1]==" "))};var cleanCss=function(css){return css.replace(/\>/," > ").replace(/,/," , ").replace(/\s+/g," ").replace(/^\s+|\s+$/g,"").replace(/,$/,"")};var getPathsFor=function(arr){var out=[];AdguardQuery.each(arr,function(){if(this&&this.nodeName)out.push(pathOf(this))});
                        return out};this.predictCss=function(s,r){var self=this;if(s.length==0)return"";var selected_paths=getPathsFor(s);var rejected_paths=getPathsFor(r);var css=commonCss(selected_paths);var simplest=simplifyCss(css,selected_paths,rejected_paths);if(simplest.length>0)return simplest;var union="";AdguardQuery.each(s,function(){union=pathOf(this)+", "+union});union=cleanCss(union);return simplifyCss(union,selected_paths,rejected_paths)};var fragmentSelector=function(selector){var self=this;var out=[];AdguardQuery.each(selector.split(/\,/),
                        function(){var out2=[];AdguardQuery.each(cleanCss(this).split(/\s+/),function(){out2.push(tokenizeCss(this))});out.push(out2)});return out};var selectorBlockMatchesSelectorBlock=function(selector_block1,selector_block2){for(var j=0;j<selector_block1.length;j++)if(AdguardQuery.inArray(selector_block1[j],selector_block2)==-1)return false;return true};var selectorGets=function(type,list,the_selector){var self=this;var result=true;if(list.length==0&&type=="all")return false;if(list.length==0&&type=="none")return true;
                        var selectors=fragmentSelector(the_selector);var cleaned_list=[];AdguardQuery.each(list,function(){cleaned_list.push(fragmentSelector(this)[0])});AdguardQuery.each(selectors,function(){if(!result)return;var selector=this;AdguardQuery.each(cleaned_list,function(pos){if(!result||this=="")return;if(_selectorGets(this,selector)){if(type=="none")result=false;cleaned_list[pos]=""}})});if(type=="all"&&cleaned_list.join("").length>0)result=false;return result};var _selectorGets=function(candidate_as_blocks,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            selector_as_blocks){var cannot_match=false;var position=candidate_as_blocks.length-1;for(var i=selector_as_blocks.length-1;i>-1;i--){if(cannot_match)break;if(i==selector_as_blocks.length-1){if(!selectorBlockMatchesSelectorBlock(selector_as_blocks[i],candidate_as_blocks[position]))cannot_match=true;position--}else{var found=false;while(position>-1&&!found){found=selectorBlockMatchesSelectorBlock(selector_as_blocks[i],candidate_as_blocks[position]);position--}if(!found)cannot_match=true}}return!cannot_match};
                        var invertObject=function(object){var new_object={};AdguardQuery.each(object,function(key,value){new_object[value]=key});return new_object};this.cssToXPath=function(css_string){var tokens=tokenizeCss(css_string);if(tokens[0]&&tokens[0]==" ")tokens.splice(0,1);if(tokens[tokens.length-1]&&tokens[tokens.length-1]==" ")tokens.splice(tokens.length-1,1);var css_block=[];var out="";for(var i=0;i<tokens.length;i++)if(tokens[i]==" "){out+=cssToXPathBlockHelper(css_block);css_block=[]}else css_block.push(tokens[i]);
                            return out+cssToXPathBlockHelper(css_block)};this.makeDomainPrefix=function(){var result;if(isScopeOne())result=this.croppedDomain+this.domainRule;else result="##";return result};var isScopeOne=function(){var scope=AdguardQuery("#"+this.iframeId).contents().find("#oneDomainRadio").get(0);if(scope)return scope.checked;else return null};var getNodeName=function(element){return element&&element.nodeName?element.nodeName.toUpperCase():""};var isNullOrWhitespace=function(input){if(typeof input==="undefined"||
                            input==null)return true;return input.replace(/\s/g,"").length<1};this.makeCssNthChildFilter=function(element){var path=[];var el=element;while(el.parentNode){var nodeName=getNodeName(el);if(nodeName=="BODY")break;if(el.id&&!isNullOrWhitespace(el.id)){var id=el.id.split(":").join("\\:");if(el.id.indexOf(".")>-1)path.unshift('[id="'+id+'"]');else path.unshift("#"+id);break}else{var c=1;for(var e=el;e.previousSibling;e=e.previousSibling)if(e.previousSibling.nodeType===1)c++;var cldCount=0;for(var i=
                            0;el.parentNode&&i<el.parentNode.childNodes.length;i++)cldCount+=el.parentNode.childNodes[i].nodeType==1?1:0;var ch;if(cldCount==0||cldCount==1)ch="";else if(c==1)ch=!AdguardQuery.browser.msie?":first-child":AdguardQuery.browser.version>=7?":first-child":"";else if(c==cldCount)ch=!AdguardQuery.browser.msie?":last-child":AdguardQuery.browser.version>=9?":last-child":"";else ch=!AdguardQuery.browser.msie?":nth-child("+c+")":AdguardQuery.browser.version>=9?":nth-child("+c+")":"";var className=el.className;
                            if(className)if(className.indexOf(".")>-1)path.unshift('[class="'+className+'"]');else{className=className.trim().replace(/ +(?= )/g,"");path.unshift(el.tagName+(className?"."+className.replace(/\s/g,"."):"")+ch)}else path.unshift(el.tagName+ch);el=el.parentNode}}return path.join(" > ")};var getClass=function(element){if(!element)return"";return element.getAttribute("class")?element.getAttribute("class"):element.getAttribute("className")};var trim=function(s){var trimLeft=/^\s+/;var trimRight=/\s+$/;
                            var rnotwhite=/\S/;if(rnotwhite.test("\u00a0")){trimLeft=/^[\s\xA0]+/;trimRight=/[\s\xA0]+$/}return s==null?"":s.toString().replace(trimLeft,"").replace(trimRight,"")};var cssToXPathBlockHelper=function(css_block){if(css_block.length==0)return"//";var out="//";var first=css_block[0].substring(0,1);if(first==",")return" | ";if(AdguardQuery.inArray(first,[":","#","."])!=-1)out+="*";var expressions=[];var re=null;for(var i=0;i<css_block.length;i++){var current=css_block[i];first=current.substring(0,
                            1);var rest=current.substring(1);if(first==":"){if(re=rest.match(/^nth-child\((\d+)\)$/))expressions.push("(((count(preceding-sibling::*) + 1) = "+re[1]+") and parent::*)")}else if(first==".")expressions.push('contains(concat( " ", @class, " " ), concat( " ", "'+rest+'", " " ))');else if(first=="#")expressions.push('(@id = "'+rest+'")');else if(first==",");else out+=current}if(expressions.length>0)out+="[";for(var i=0;i<expressions.length;i++){out+=expressions[i];if(i<expressions.length-1)out+=" and "}if(expressions.length>
                            0)out+="]";return out}};
                    var Adguard=function(options){var self=this;var settings={doctype:"<!DOCTYPE>",iframeId:"adguard-assistant-dialog",path:null,selectedElement:null,lastPreview:null,browser:options.browser,cssRuleIndex:null,apiurl:options.apiurl,apiType:"/api",apiAddRule:"type=add&rule=",apiComplaint:"type=complaint",displayDetails:true,urlBlockAttributes:["src","href","data"],thirdParty:"third-party",matchCase:"match-case",noreferrer:"noreferrer",exceptionRulePrefix:"@@||",exceptionAttributes:["elemhide","content",
                        "urlblock","jsinject"],predictionHelper:null,urlInfo:null,croppedDomain:null,domainRule:"##",urlBlockPath:null,removeLastRuleUrl:"type=remove",notBlockUrl:"type=notblock&rule=",settingsUrl:"type=settings",wotRatingText:null,wotConfidence:null,wotUrlScorecardPrefix:"http://adguard.com/wot-scorecard.html?domain=",wotUrl:"http://adguard.com/wot.html",adguardStrings:null};var Constants={domainDetailsUrl:"http://adguard.com/site.html?domain=",phishing:"PHISHING",wrongRender:"FALSE_POSITIVE",adMissing:"MISSED_ADS",
                        another:"CUSTOM",minComplaintMessageLength:8,maxComplaintCommentLength:500,rulesHistoryStorage:"__ag_history",iframe:{baseWidth:610,mainMenuHeight:410,exceptionMenuHeight:300,exceptionExtendedMenuHeight:525,complaintWindowHeight:410,settingsWindowHeight:415,extendDetailedSettingsHeight:455,detailedMenuHeight:270,selectorMenuHeight:115}};var popFromHistory=function(){try{var history=localStorage.getItem(Constants.rulesHistoryStorage);if(history)history=JSON.parse(history);else history=[];var rule=
                        history.pop();localStorage.setItem(Constants.rulesHistoryStorage,JSON.stringify(history));return rule}catch(ex){GM_log(ex)}};var pushToHistory=function(rule){try{if(!rule)return;var history=localStorage.getItem(Constants.rulesHistoryStorage);if(history)history=JSON.parse(history);else history=[];history.push(rule);localStorage.setItem(Constants.rulesHistoryStorage,JSON.stringify(history))}catch(ex){GM_log(ex)}};var getLocale=function(language){var localization=localizations[language];if(localization)return localization;
                        if(language.indexOf("-")>0)language=language.split("-")[0];localization=localizations[language]||localizations.en;return localization};var getStrings=function(){if(settings.adguardStrings)return settings.adguardStrings;else{settings.adguardStrings=getLocale(options.locale);return settings.adguardStrings}};var utils={getHostWithProtocol:function(){var hostname=document.location.hostname;var protocol=document.location.protocol;return protocol+"//"+hostname},getAllChilds:function(element){var childArray=
                        [];var child=element;while(child=utils.getChildren(child))childArray.push(child);return childArray},getChildren:function(element){var childs=element.childNodes;if(childs){var count=0;var child;var i;for(i=0;i<childs.length;i++)if(childs[i].nodeType==1){child=childs[i];count++}}return count==1?child:null},getParentsLevel:function(element){var parent=element;var parentArr=[];while((parent=parent.parentNode)&&utils.getNodeName(parent)!="BODY")parentArr.push(parent);return parentArr},getNodeName:function(element){return element&&
                    element.nodeName?element.nodeName.toUpperCase():""},getUrl:function(url){var pattern="^(([^:/\\?#]+):)?(//(([^:/\\?#]*)(?::([^/\\?#]*))?))?([^\\?#]*)(\\?([^#]*))?(#(.*))?$";var rx=new RegExp(pattern);var parts=rx.exec(url);return{host:parts[4]||"",path:parts[7]||""}},cropDomain:function(domain){return domain.replace("www.","")},isScopeOne:function(){var scope=findByIdInIframe("#oneDomainRadio").get(0);if(scope)return scope.checked;else return null},makeDomainPrefix:function(inverse){var result;var isOneDomain=
                        utils.isScopeOne();if(inverse&&inverse=="true")isOneDomain=!isOneDomain;if(isOneDomain)result=getCroppedDomain()+settings.domainRule;else result="##";return result}};var getCroppedDomain=function(){if(!settings.croppedDomain){var croppedDomain=utils.cropDomain(getUrlInfo().host);croppedDomain=croppedDomain.split(":")[0];settings.croppedDomain=croppedDomain}return settings.croppedDomain};var getUrlInfo=function(){if(!settings.urlInfo)settings.urlInfo=utils.getUrl(document.location);return settings.urlInfo};
                        var log=function(message){try{if(console&&console.log)console.log(message)}catch(ex){}};var getIframeDocument=function(iframe){var iframe=AdguardQuery(iframe).get(0);if(iframe.contentDocument)return iframe.contentDocument;if(iframe.contentWindow)return iframe.contentWindow.document;return iframe.document};var makeDraggable=function(iframe,handle){var getEventPosition=function(e){var pos={};pos.x=0;pos.y=0;if(!e)e=window.event;pos.x=e.screenX;pos.y=e.screenY;return pos};var iframeDocument=getIframeDocument(iframe);
                            var iframeJ=findIframe();var dragHandle=findByIdInIframe("#drag-handle");var handle=iframe.contents().find(handle);handle.mousedown(function(e){if(e.target.nodeName=="IMG"||e.target.nodeName=="A")return;iframe.data("dragging",true);var eventPosition=getEventPosition(e);offset.x=iframeJ.offset().left-AdguardQuery(window).scrollLeft()+dragHandle.position().left-eventPosition.x;offset.y=iframeJ.offset().top-AdguardQuery(window).scrollTop()+dragHandle.position().top-eventPosition.y});var offset={};AdguardQuery(iframeDocument).mouseup(function(){iframe.data("dragging",
                                false)});var drag=function(x,y){var newPositionX=x;var newPositionY=y;if(newPositionX<0)newPositionX=0;if(newPositionY<0)newPositionY=0;iframeJ.css({left:newPositionX+"px",top:newPositionY+"px"})};AdguardQuery(iframeDocument).mousemove(function(e){if(iframe.data("dragging")){var eventPosition=getEventPosition(e);drag(eventPosition.x+offset.x,eventPosition.y+offset.y)}})};var getViewport=function(){var viewPortWidth;var viewPortHeight;if(typeof window.innerWidth!="undefined")viewPortWidth=window.innerWidth,
                            viewPortHeight=window.innerHeight;else if(typeof document.documentElement!="undefined"&&(typeof document.documentElement.clientWidth!="undefined"&&document.documentElement.clientWidth!=0))viewPortWidth=document.documentElement.clientWidth,viewPortHeight=document.documentElement.clientHeight;else viewPortWidth=document.getElementsByTagName("body")[0].clientWidth,viewPortHeight=document.getElementsByTagName("body")[0].clientHeight;return[viewPortWidth,viewPortHeight]};var getPositionsForIframe=function(offset,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      viewPort,height,width){var positions={left:0,top:0};var fixedSupported=options.browser.isPositionFixedSupported();if(fixedSupported){if(options.buttonPositionTop)positions.top=0+offset;else{var viewHeight=viewPort[1];positions.top=viewHeight-height-offset}if(options.buttonPositionLeft)positions.left=0+offset;else{var viewWidth=viewPort[0];positions.left=viewWidth-width-offset}}else{if(options.buttonPositionLeft)positions.left=0+offset;else positions.left=document.documentElement.scrollLeft+document.documentElement.clientWidth-
                            width-offset;if(options.buttonPositionTop)positions.top=0+offset;else positions.top=document.documentElement.scrollTop+document.documentElement.clientHeight-height-offset}return positions};var iframeLoaded=false;var createIframe=function(width,height,success){settings.initIframeSize=null;var fixedSupported=options.browser.isPositionFixedSupported();var viewPort=getViewport();var constOffset=25;var positions=getPositionsForIframe(constOffset,viewPort,height,width);var top=positions.top;if(top<0)top=
                            height/4;var position=fixedSupported?"fixed":"absolute";var left=positions.left;var cssStyle={width:width,height:height,position:position,left:left,clip:"auto"};cssStyle.top=top;var onLoadIframe=function(){if(iframeLoaded)success(iframe);else setTimeout(onLoadIframe,50)};var iframe=AdguardQuery('<iframe />"').attr({id:settings.iframeId,"class":"sg_ignore adg-view-important",frameBorder:0,allowTransparency:"true"}).css(cssStyle).appendTo("body").load(onLoadIframe);if(AdguardQuery.browser.msie){var iframeSrc=
                            "javascript:'<script>document.write(\\'<script>document.domain=\\\""+document.domain+"\\\";<\\\\/script>\\');document.close();\x3c/script>'";iframe.get(0).src=iframeSrc}if(!fixedSupported){AdguardQuery(window).scroll(function(){ieTenIframeFix(constOffset,height,width)});AdguardQuery(window).resize(function(){ieTenIframeFix(constOffset,height,width)})}writeIframe();return iframe};var writeIframe=function(){try{var doc=findIframe().get(0).contentWindow.document;var scriptNonce="";if(options.getScriptNonce()!=
                            null)scriptNonce=' nonce="'+options.getScriptNonce()+'" ';var styleNonce="";if(options.getStyleNonce()!=null)styleNonce=' nonce="'+options.getStyleNonce()+'" ';doc.open();doc.write("<head>");doc.write("<style"+styleNonce+' type="text/css">'+GM_getResourceText("dialog.css")+"</style>");doc.write("<style"+styleNonce+' type="text/css">'+GM_getResourceText("jquery-ui.css")+"</style>");doc.write("<script"+scriptNonce+">"+GM_getResourceText("jquery.js")+"\x3c/script>");doc.write("<script"+scriptNonce+">"+
                            GM_getResourceText("jquery-ui.js")+"\x3c/script>");doc.write("</head>");doc.write("<body></body>");doc.close();iframeLoaded=true}catch(ex){if(AdguardQuery.browser.msie)setTimeout(writeIframe,50)}};var ieTenIframeFix=function(constOffset,height,width){var elem=document.documentElement;var iframeTop=elem.scrollTop+elem.clientHeight-constOffset-height+"px";var iframeLeft=elem.scrollLeft+elem.clientWidth-constOffset-width+"px";findIframe().css({top:iframeTop,left:iframeLeft})};var findIframe=function(iframeId){if(iframeId)return AdguardQuery("#"+
                            iframeId);else return AdguardQuery("#"+settings.iframeId)};var findByIdInIframe=function(selector){return findIframe().contents().find(selector)};var iframeHandler=function(event){if(event.data==="Done"){if(!settings.dialogDef)return;settings.dialogDef.resolve()}};if(window.addEventListener)addEventListener("message",iframeHandler,false);else attachEvent("onmessage",iframeHandler);var runCallbacks=function(iframe,beforeUnhide,afterUnhide){if(beforeUnhide)beforeUnhide(iframe);makeDraggable(iframe,
                            "#drag-handle");findByIdInIframe("body").removeClass("adg-hide");if(afterUnhide)afterUnhide(iframe)};var setCloseEvent=function(isSelectorMenu){if(isSelectorMenu){if(!options.needSetCloseEvent)return;document.onclick=null}else{if(!options.needSetCloseEvent||document.onclick!=null)return;document.onclick=function(){closeAssistant()}}};var showDialog=function(content,width,height,beforeUnhide,afterUnhide,isSelectorMenu){var appendContent=function(iframe){try{findIframe().get(0).contentWindow.document.someProp;
                            appendContentToIframe(iframe,content)}catch(ex){document.domain=document.domain;settings.dialogDef=AdguardQuery.Deferred();settings.dialogDef.done(function(){appendContentToIframe(iframe,content);runCallbacks(iframe,beforeUnhide,afterUnhide)});findIframe().get(0).contentWindow.postMessage(document.domain,location.protocol+"//"+location.hostname+(location.port=="80"?"":":"+location.port));return}runCallbacks(iframe,beforeUnhide,afterUnhide)};setCloseEvent(isSelectorMenu);var existIframe=findIframe();
                            if(existIframe.size()>0){iframe=existIframe;changeCurrentIframe(width,height,existIframe);appendContent(iframe);return}var iframe;iframe=createIframe(width,height,appendContent)};var changeCurrentIframe=function(width,height,existIframe){existIframe.css({width:width,height:height})};var appendContentToIframe=function(iframe,content){iframe.contents().find("body").children().remove();iframe.contents().find("body").append(content);findByIdInIframe("body").addClass("adg-hide")};var bindClicks=function(iframe,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    events){AdguardQuery.each(events,function(key,value){iframe.contents().find(key).click(value)})};var onSelectElementClicked=function(e){try{e.preventDefault();settings.initIframeSize=null;var loaded=showSelectorMenu();loaded.done(function(){localizeMenu("selectorMenu");removePreview();startSelector()})}catch(ex){log(ex)}};var onAddToExceptionsClicked=function(e){try{e.preventDefault();var loaded=createExceptionWindow();loaded.done(function(){updateExceptionRuleBlock()})}catch(ex){log(ex)}};var makeRadioButtonsAndCheckBoxes=
                            function(){findByIdInIframe(".radiobox").radioButton();findByIdInIframe(".checkbox").checkbox()};var makeToolTip=function(selector){var iframeQuery=findIframe().get(0).contentWindow.$;var elem=iframeQuery(selector);elem.tooltip({position:{my:"center bottom-20",at:"center top",using:function(position,feedback){iframeQuery(this).css(position);iframeQuery("<div>").addClass("arrow").addClass(feedback.vertical).addClass(feedback.horizontal).appendTo(this)}}})};var onSendComplaintClicked=function(e){e.preventDefault();
                            try{e.preventDefault();var loaded=createComplaintWindow();loaded.done(function(){})}catch(ex){log(ex)}};var onAssistantSettingsClicked=function(e){e.preventDefault();showAssistantSettings()};var onAddToExceptionsTemporaryClicked=function(e){e.preventDefault();makeTemporaryException()};var onUndoLastRuleClicked=function(e){e.preventDefault();undoLastRule()};var onCloseButtonClicked=function(e){try{e.preventDefault();closeAssistant()}catch(ex){log(ex)}};var onCancelSelectModeClicked=function(e){try{e.preventDefault();
                            removePreview();cancelSelectMode();removeSimilarElementsSelection();showMenu()}catch(ex){log(ex)}};var onCloseSubMenu=function(){try{showMenu()}catch(ex){log(ex)}};var cancelSelectMode=function(){if(self.selector)self.selector.unbind()};var onElementSelected=function(path,element){settings.selectedElement=element;settings.path=path;self.selector.closeSelector();showHidingRuleWindow(settings.path,element,haveUrlBlockParameter(element),haveClass(element))};var undoLastRule=function(){var rule=popFromHistory();
                            if(rule)ADG_removeRule(rule);reloadPageBypassCache()};var makeTemporaryException=function(){ADG_temporaryDontBlock();reloadPageBypassCache()};var showAssistantSettings=function(){try{createSettingsWindow()}catch(ex){log(ex)}};var makeDefaultSettings=function(){var isLeft=options.buttonPositionLeft;var isTop=options.buttonPositionTop;var isLargeIcon=options.largeIcon;isLeft?findByIdInIframe("#onLeft").attr("checked","true"):findByIdInIframe("#onRight").attr("checked","true");isTop?findByIdInIframe("#onTop").attr("checked",
                            "true"):findByIdInIframe("#onBottom").attr("checked","true");isLargeIcon?findByIdInIframe("#isBig").attr("checked","true"):findByIdInIframe("#isSmall").attr("checked","true")};var closeAssistant=function(){cancelSelectMode();findIframe().remove();options.adguardButton.init(true)};var startSelector=function(){if(self.selector)self.selector.clearEverything();self.selector=new AdguardSelector(onElementSelected);self.selector.setup()};var haveUrlBlockParameter=function(element){var value=getUrlBlockAttribute(element);
                            return value&&value!=""};var haveClass=function(element){return element.className!=""};var setPath=function(path){findByIdInIframe("#filter-rule").val(path)};var getAttribute=function(element,attr){try{return settings.browser.msie?element.getAttribute(attr=="class"?"className":attr,2):element.getAttribute(attr)}catch(ex){return null}};var onAcceptExceptionRule=function(){ADG_addRule(settings.path);reloadPageBypassCache()};var makeSitePrefix=function(){var isPage=findByIdInIframe("#onPage").is(":checked");
                            var domain=getCroppedDomain();var path=getUrlInfo().path;if(path=="/")path="/|";var result=settings.exceptionRulePrefix+domain;return result+(isPage?path:"")+"$"};var updateExceptionRuleBlock=function(){var prefix=makeSitePrefix();var filter=makeExceptionFilter().join("");var value=filter?prefix+filter:"";findByIdInIframe("#filter-rule").val(value);settings.path=value};var makeExceptionFilter=function(){var iframe=findIframe().contents();var params=settings.exceptionAttributes;var result=verifyCheckboxes(iframe,
                            params,null);if(result&&result.length==params.length)result=["document"];return result};var verifyCheckboxes=function(iframe,params,values){var j=0;var i;var result=[];for(i=0;i<params.length;i++){var param=params[i];if(values)var value=values[i];var label=iframe.find("#"+param);if(label.is(":checked")){result.push((j>0?",":"")+(value?value:param));j++}}return result};var makeUrlBlockFilter=function(){var iframe=findIframe().contents();var needMakeUrlBlock=iframe.find("#blockByUrl").is(":checked");
                            if(!needMakeUrlBlock)return false;var urlMask=getUrlBlockAttribute(settings.selectedElement);if(!urlMask||urlMask=="")return false;var blockUrl=urlMask.replace(/^http:\/\/(www\.)?/,"||");var value;if(!iframe.find("#oneDomainRadio").is(":checked"))value="domain="+getCroppedDomain();var result=value;var filterRule=iframe.find("#filter-rule");filterRule.val(result?blockUrl+"$"+result:blockUrl);settings.urlBlockPath=filterRule.val();return true};var makeWotInfo=function(){var strings=getStrings();var headerInfo=
                            findByIdInIframe("#header-info");if(!options.wotData){headerInfo.replaceWith(strings.dragHandleWithoutWot.replace("${version}",AdguardSettings.version).replace("${domainName}",options.hostNameUnicode).replace("${href}",Constants.domainDetailsUrl+options.hostNameUnicode));return}headerInfo.replaceWith(strings.dragHandleWithWot.replace("${version}",AdguardSettings.version).replace("${domainName}",options.hostNameUnicode));findByIdInIframe(".adg-wot").addClass(getWotClassAndSetWotRating());findByIdInIframe(".adg-wot-confidence").addClass(getWotClassAndSetWotConfidence());
                            var wotUrl=settings.wotUrlScorecardPrefix+document.location.host;findByIdInIframe(".adg-head-opt > a").attr("href",settings.wotUrl);findByIdInIframe(".adg-head-h > a").attr("href",wotUrl);var wotRating=findByIdInIframe(".adg-head-opt");var wotInnerHtml=wotRating.html();findByIdInIframe(".adg-head-opt").html("<span>"+strings.wotPrefix+options.wotRatingText+strings.wotPostfix+"</span>"+wotInnerHtml)};var localize=function(menuName){var strings=getStrings();for(element in strings[menuName]){var value=
                            strings[menuName][element];if(!value)continue;findByIdInIframe("#"+element).html(value)}};var localizeToolTips=function(menuName){var strings=getStrings();if(!strings[menuName])return;for(element in strings[menuName]["toolTips"]){var value=strings[menuName]["toolTips"][element];if(!value)continue;findByIdInIframe("#"+element).attr("title",value)}};var localizeMenu=function(menuName){localize(menuName);localizeToolTips(menuName)};var showMenu=function(){var model={domainName:(options.hostNameUnicode||
                        "localhost").replace("www.",""),version:options.version};var menuName="mainMenu";var template=AdguardQuery("#adguard-menu-template").template();var content=AdguardQuery.tmpl(template,model);showDialog(content,Constants.iframe.baseWidth,Constants.iframe.mainMenuHeight,function(iframe){bindClicks(iframe,{"#close-button":onCloseButtonClicked,"#select-element":onSelectElementClicked,"#add-to-exceptions":onAddToExceptionsClicked,"#send-complaint":onSendComplaintClicked,"#assistant-settings":onAssistantSettingsClicked,
                            "#add-to-exceptions-temporary":onAddToExceptionsTemporaryClicked,"#undo-last-rule":onUndoLastRuleClicked});makeWotInfo();localizeMenu(menuName);if(options.wotData&&options.wotData.reputation!=0)makeToolTip("[title]")},function(){if(options.browser.isIE&&options.browser.version<=8)findByIdInIframe(".adg-container").css({width:532})})};var createExceptionWindow=function(){var model={domainName:document.location.hostname||"localhost"};var d=AdguardQuery.Deferred();var template=AdguardQuery("#adguard-exception-menu").template();
                            var content=AdguardQuery.tmpl(template,model);showDialog(content,Constants.iframe.baseWidth,Constants.iframe.exceptionMenuHeight,function(iframe){localizeMenu("exceptionMenu");bindClicks(iframe,{".adg-close":onCloseSubMenu,"#adv-settings":updateExceptionRuleBlock,".adg-form-block":updateExceptionRuleBlock,"#addException":onAcceptExceptionRule,"#ExtendedSettings":onExtendExceptionSettings});d.resolve()},function(){makeRadioButtonsAndCheckBoxes()});return d};var createComplaintWindow=function(){var model=
                        {domainName:document.location.hostname||"localhost"};var d=AdguardQuery.Deferred();var template=AdguardQuery("#adguard-complaint-menu").template();var content=AdguardQuery.tmpl(template,model);showDialog(content,Constants.iframe.baseWidth,Constants.iframe.complaintWindowHeight,function(iframe){localizeMenu("complaintMenu");bindClicks(iframe,{"#adg-cancel":onCloseSubMenu,".adg-close":onCloseSubMenu,".btn-red":onComplaintSubmited});d.resolve()},function(){makeRadioButtonsAndCheckBoxes()});return d};
                        var createSettingsWindow=function(){var model={domainName:document.location.hostname||"localhost"};var template=AdguardQuery("#adguard-settings-menu").template();var content=AdguardQuery.tmpl(template,model);showDialog(content,Constants.iframe.baseWidth,Constants.iframe.settingsWindowHeight,function(iframe){localizeMenu("settingsMenu");bindClicks(iframe,{"#adg-cancel":onCloseSubMenu,".adg-close":onCloseSubMenu,"#adg-save":onSaveSettings})},function(){makeDefaultSettings();makeRadioButtonsAndCheckBoxes()})};
                        var showDetailedMenu=function(){var model={domainName:document.location.hostname||"localhost"};var d=AdguardQuery.Deferred();var template=AdguardQuery("#adguard-detailed-menu").template();var content=AdguardQuery.tmpl(template,model);showDialog(content,Constants.iframe.baseWidth,Constants.iframe.detailedMenuHeight,function(iframe){localizeMenu("detailedMenu");makeRadioButtonsAndCheckBoxes();bindClicks(iframe,{"#close-button":onCancelSelectModeClicked,".adg-close":onCancelSelectModeClicked,"#block-by-url-p":onBlockByUrl,
                            "#block-similar-p":onBlockSimilar,"#adv-settings > p .clearfix":onScopeChange,"#adg-cancel":onSelectElementClicked,"#adg-preview":onRulePreview,"#adg-accept":onRuleAccept,"#ExtendedSettingsText":onExtendDetailedSettings});d.resolve("")},function(){findByIdInIframe(".adg-container").css({width:532})});return d};var showSelectorMenu=function(){var model={};var template=AdguardQuery("#adguard-selector-menu").template();var content=AdguardQuery.tmpl(template,model);var d=AdguardQuery.Deferred();showDialog(content,
                            Constants.iframe.baseWidth,Constants.iframe.selectorMenuHeight,function(iframe){bindClicks(iframe,{"#cancel-select-mode":onCancelSelectModeClicked,".adg-close":onCancelSelectModeClicked});d.resolve("")},null,true);return d};var showHidingRuleWindow=function(path,element,urlBlock,blockSimilar){var loaded=showDetailedMenu();loaded.done(function(){createSlider(element);self.selector.reset(element);setPath(path);onScopeChange();setScopeOneDomainText();if(urlBlock)findByIdInIframe("#block-by-url-p").show();
                            if(blockSimilar)findByIdInIframe("#block-similar-p").show()})};var resizeIframe=function(width,height){var iframe=findIframe().get(0);if(!settings.initIframeSize)settings.initIframeSize={width:iframe.style.width,height:iframe.style.height};else{iframe.style.height=settings.initIframeSize.height;iframe.style.width=settings.initIframeSize.width;settings.initIframeSize=null;return}if(height)iframe.style.height=height+"px";if(width)iframe.style.width=width+"px"};var extendAdvSettings=function(width,height){if(!settings.initIframeSize){resizeIframe(width,
                            height);findByIdInIframe("#adv-settings").slideToggle(100)}else findByIdInIframe("#adv-settings").slideToggle(100,function(){resizeIframe()})};var onExtendExceptionSettings=function(){extendAdvSettings(null,Constants.iframe.exceptionExtendedMenuHeight)};var onExtendDetailedSettings=function(){extendAdvSettings(null,Constants.iframe.extendDetailedSettingsHeight)};var setScopeOneDomainText=function(){var path=getCroppedDomain();findByIdInIframe("#oneDomainText").text(path)};var truncateDecimals=function(number){return Math[number<
                        0?"ceil":"floor"](number)};var getWotClassAndSetWotRating=function(){var strings=getStrings();if(settings.wotRating)return settings.wotRating;var prefix="adg-wot-";var averageWot=options.wotData.reputation;if(averageWot==0){options.wotRatingText=strings.wotUnknown;settings.wotRating=prefix+"unknown";return settings.wotRating}var wotSettings={0:{color:"red",string:strings.wotBad},1:{color:"lightRed",string:strings.wotPoor},2:{color:"yellow",string:strings.wotUnsatisfactory},3:{color:"lightGreen",string:strings.wotGood},
                            4:{color:"green",string:strings.wotExcellent},5:{color:"green",string:strings.wotExcellent}};var current=wotSettings[truncateDecimals(averageWot/20)];options.wotRatingText=current.string;settings.wotRating=prefix+current.color;return settings.wotRating};var getWotClassAndSetWotConfidence=function(){if(settings.wotConfidence)return settings.wotConfidence;var prefix="adg-wot-confidence-";var confidenceWot=options.wotData.confidence;if(confidenceWot>=0&&confidenceWot<6){settings.wotConfidence=prefix+
                            "0";return settings.wotConfidence}if(confidenceWot>=6&&confidenceWot<12){settings.wotConfidence=prefix+"1";return settings.wotConfidence}if(confidenceWot>=12&&confidenceWot<23){settings.wotConfidence=prefix+"2";return settings.wotConfidence}if(confidenceWot>=23&&confidenceWot<34){settings.wotConfidence=prefix+"3";return settings.wotConfidence}if(confidenceWot>=34&&confidenceWot<45){settings.wotConfidence=prefix+"4";return settings.wotConfidence}if(confidenceWot>=45){settings.wotConfidence=prefix+
                            "5";return settings.wotConfidence}};var renderSliderAndBindEvents=function(options){var $document=findIframe().contents();var $slider=AdguardQuery("#slider",$document);$slider.slider({min:options.min,max:options.max,range:"min",value:options.value,start:function(event,ui){return false},change:function(event,ui){refreshTicks(ui.value);var delta=options.value-ui.value;var elem;if(delta>0)elem=options.parents[delta-1];if(delta==0)elem=options.element;if(delta<0)elem=options.childs[Math.abs(delta+1)];
                            options.onSliderMove(elem)}});AdguardQuery(document).mouseup(function(){$(".slider,.ui-slider-handle",$document).unbind("mousemove")});AdguardQuery(".ui-slider-handle",$document).mousedown(function(e){e.preventDefault();return AdguardQuery(this).parent().mousedown()});var $sliderOffsetLeft=$slider.offset().left;var $sliderWidth=$slider.width();var getSliderValue=function(pageX){return(options.max-options.min)/$sliderWidth*(pageX-$sliderOffsetLeft)+options.min};$slider.hover(function(){$slider.bind("click",
                            function(e){var value=getSliderValue(e.pageX);$slider.slider("value",value)});$slider.mousedown(function(){AdguardQuery(this).bind("mousemove",function(e){var value=getSliderValue(e.pageX);AdguardQuery(this).slider("value",value)})}).mouseup(function(){AdguardQuery(this).unbind("mousemove")})},function(){AdguardQuery("#slider",$document).unbind("mousemove");AdguardQuery("#slider",$document).unbind("click")});var sliderItemsCount=options.max-1;var refreshTicks=function(value){var ticks=findByIdInIframe(".tick");
                            var i;for(i=0;i<ticks.length;i++)if(i+1<value)findByIdInIframe(ticks[i]).css("background-color","#86BFCE");else findByIdInIframe(ticks[i]).css("background-color","#E6ECED")};var prepare=function(i){var tick=AdguardQuery("<div>",{class:"tick ui-widget-content"}).appendTo($slider);tick.css({left:100/sliderItemsCount*i+"%",width:100/sliderItemsCount+"%"})};for(var i=0;i<sliderItemsCount;i++)prepare(i);refreshTicks(options.value)};var createSlider=function(element){var strings=getStrings();var parents=
                            utils.getParentsLevel(element);var childs=utils.getAllChilds(element);var value=Math.abs(parents.length+1);var max=parents.length+childs.length+1;var min=1;var options={value:value,min:min,max:max,parents:parents,childs:childs,onSliderMove:onSliderMove,element:element};if(min==max){findByIdInIframe("#slider").hide();findByIdInIframe(".adg-slide-text").text(strings.blockTextIfSliderHided)}renderSliderAndBindEvents(options)};var onSliderMove=function(element){removePreview();settings.selectedElement=
                            element;self.selector.makeBorders(element);settings.path=self.selector.getSelectorPath(element);setPath(settings.path);makeDefaultCheckboxesForDetailedMenu();onScopeChange();makeRadioButtonsAndCheckBoxes();if(haveUrlBlockParameter(element))findByIdInIframe("#block-by-url-p").show();else findByIdInIframe("#block-by-url-p").hide();if(haveClass(element))findByIdInIframe("#block-similar-p").show();else findByIdInIframe("#block-similar-p").hide()};var makeDefaultCheckboxesForDetailedMenu=function(){findByIdInIframe("#blockByUrl").attr("checked",
                            false);findByIdInIframe("#oneDomainRadio").attr("checked",false);findByIdInIframe("#blockSimilar").attr("checked",false);findByIdInIframe("#block-by-url-p >div >span").removeClass("active");findByIdInIframe("#one-domain-p >div >span").removeClass("active");findByIdInIframe("#block-similar-p >div >span").removeClass("active")};var getUrlBlockAttribute=function(element){var value;var i;for(i=0;i<settings.urlBlockAttributes.length;i++){var attr=settings.urlBlockAttributes[i];value=getAttribute(element,
                            attr);if(value)return value}};var onSaveSettings=function(){options.buttonPositionLeft=findByIdInIframe("#onLeft").is(":checked");options.buttonPositionTop=findByIdInIframe("#onTop").is(":checked");options.largeIcon=findByIdInIframe("#isBig").is(":checked");adguardButton.saveSettings();setTimeout(function(){reloadPageBypassCache()},500)};var onComplaintSubmited=function(){var strings=getStrings();var complaintType;if(findByIdInIframe("#phishing").is(":checked"))complaintType=Constants.phishing;if(findByIdInIframe("#wrongRender").is(":checked"))complaintType=
                            Constants.wrongRender;if(findByIdInIframe("#adMissing").is(":checked"))complaintType=Constants.adMissing;if(findByIdInIframe("#another").is(":checked"))complaintType=Constants.another;if(!complaintType){alert(strings.complaintWarning);return}var comment=findByIdInIframe("#Comment").val().substring(0,Constants.maxComplaintCommentLength);ADG_sendComplaint(document.location.href,comment,complaintType);closeAssistant()};var scrollFixHandler=function(){AdguardQuery(window).scrollTop(settings.scrollTop);
                            AdguardQuery(window).unbind("scroll",scrollFixHandler)};var scrollFix=function(){settings.scrollTop=AdguardQuery(window).scrollTop();AdguardQuery(window).scroll(scrollFixHandler)};var onRulePreview=function(){var strings=getStrings();if(settings.lastPreview){removePreview();findByIdInIframe("#adg-preview > span").replaceWith(strings.previewStart);self.selector.showBorders();findByIdInIframe("#slider").show();findByIdInIframe(".adg-slide-text").show();findByIdInIframe("#ExtendedSettingsText").show();
                            scrollFix();return}scrollFix();hideElement();findByIdInIframe("#adg-preview >span").replaceWith(strings.previewEnd);findByIdInIframe("#slider").hide();findByIdInIframe(".adg-slide-text").hide();findByIdInIframe("#ExtendedSettingsText").hide();findByIdInIframe("#adv-settings").hide();settings.initIframeSize=null};var hideElement=function(){self.selector.removeBorders();var selector=settings.similarBlock?getSimilarElementsSelector():getSelector();var style=document.createElement("style");style.setAttribute("type",
                            "text/css");settings.lastPreview=style;var msie=settings.browser.isCompatibilityMode();if(!msie){var head=document.getElementsByTagName("head")[0];if(head){style.appendChild(document.createTextNode(selector+" {display: none !important;}"));head.appendChild(style)}}else if(document.styleSheets&&document.styleSheets.length>0){var lastStyle=document.styleSheets[document.styleSheets.length-1];if(lastStyle.addRule)try{settings.cssRuleIndex=lastStyle.rules.length;lastStyle.addRule(selector,"display: none !important;",
                            settings.cssRuleIndex)}catch(ex){}}};var getSelector=function(){var path=settings.path;var index=path.indexOf("##");return index==-1?path.substring(0,path.length):path.substring(index+2,path.length)};var removePreview=function(){if(settings.lastPreview==null)return;var msie=settings.browser.isCompatibilityMode();if(!msie){var head=document.getElementsByTagName("head")[0];if(head)head.removeChild(settings.lastPreview);settings.lastPreview=null}else if(document.styleSheets&&(document.styleSheets.length>
                            0&&settings.cssRuleIndex>=0)){var lastStyle=document.styleSheets[document.styleSheets.length-1];if(lastStyle.removeRule)try{lastStyle.removeRule(settings.cssRuleIndex);settings.cssRuleIndex=-1}catch(ex){}}};var onScopeChange=function(){var isUrlBlock=makeUrlBlockFilter();if(isUrlBlock){removeSimilarElementsSelection();return}var isSimilarBlock=makeSimilarBlock();if(isSimilarBlock)return;removeSimilarElementsSelection();var path=settings.path;var indexSub=path.indexOf("##");path=path.substring(indexSub+
                            2);var isNeedReverse="true";var prefix=utils.makeDomainPrefix(isNeedReverse);var subsPath=prefix+path;settings.path=subsPath;setPath(settings.path)};var makeSimilarBlock=function(){if(!findByIdInIframe("#blockSimilar").is(":checked"))return false;var isNeedReverse="true";var result=utils.makeDomainPrefix(isNeedReverse);var element=settings.selectedElement;var className=element.className?element.className.trim().replace(/ +(?= )/g,""):null;var classList=className.split(/\s+/);for(var i=0;i<classList.length;i++){var current=
                            classList[i];result+="."+current+(i==classList.length-1?"":",")}settings.similarBlock=result;setPath(settings.similarBlock);return true};var onBlockByUrl=function(){var needMakeSimilarBlock=haveClassName(findByIdInIframe("#block-similar-p > div .checkbox").get(0),"active");if(needMakeSimilarBlock){findByIdInIframe("#blockSimilar").attr("checked",false);findByIdInIframe("#block-similar-p > div .checkbox").removeClass("active")}onScopeChange();removeSimilarElementsSelection()};var onBlockSimilar=function(){var needMakeUrlBlock=
                            haveClassName(findByIdInIframe("#block-by-url-p > div .checkbox").get(0),"active");if(needMakeUrlBlock){findByIdInIframe("#blockByUrl").attr("checked",false);findByIdInIframe("#block-by-url-p > div .checkbox").removeClass("active")}onScopeChange();selectSimilarElements()};var getSimilarElementsSelector=function(){if(!settings.similarBlock)return null;var index=settings.similarBlock.indexOf("##");var selector=index==-1?settings.similarBlock:settings.similarBlock.substring(index+2);return selector};
                        var selectSimilarElements=function(){var active=haveClassName(findByIdInIframe("#block-similar-p > div .checkbox").get(0),"active");if(active)AdguardQuery(getSimilarElementsSelector()).addClass("adg-similar");else removeSimilarElementsSelection()};var removeSimilarElementsSelection=function(){AdguardQuery(getSimilarElementsSelector()).removeClass("adg-similar");settings.similarBlock=null};var haveClassName=function(element,cls){return(" "+element.className+" ").indexOf(" "+cls+" ")>-1};var reloadPageBypassCache=
                            function(){if(!AdguardQuery.browser.webkit){window.location.reload(true);return}AdguardQuery.ajax({url:window.location.href,headers:{"Pragma":"no-cache","Expires":-1,"Cache-Control":"no-cache"}}).always(function(){window.location.reload(true)})};var onRuleAccept=function(){onRulePreview();settings.lastPreview=null;var rule=findByIdInIframe("#filter-rule").val();ADG_addRule(rule);pushToHistory(rule);reloadPageBypassCache();closeAssistant()};this.init=function(){showMenu()}};var AdguardQuery=$.noConflict(true);
                    var config={};config.appId=AdguardSettings.applicationId;config.locale=AdguardSettings.locale;config.version="2.0.24";config.needSetCloseEvent=document.onclick===null;var initAdguardAssistant=function(){adguardButton=new AdguardButton(config);adguardButton.init();userscriptsSupport=new UserscriptsSupport;userscriptsSupport.init()};setTimeout(initAdguardAssistant,100);

                })();
            }
        };

        (function() {
            'use strict';
            var runFlag = "__adg_run_flag" + AdguardSettings.uniqueName;
            if (!wrapped[runFlag]) {
                wrapped[runFlag] = true;
                if (!AdguardSettings.runAt || AdguardSettings.runAt == "document-end") {
                    runAtDocumentEnd(function() {
                        userscript.call(wrapper, wrapper, AdguardSettings, window.__adg_gm_commands_api);
                    })
                } else if (AdguardSettings.runAt == "document-body") {
                    runAtBody(function() {
                        userscript.call(wrapper, wrapper, AdguardSettings, window.__adg_gm_commands_api);
                    })
                } else if (AdguardSettings.runAt == "document-idle") {
                    runAtDocumentEnd(function() {
                        wrapper.setTimeout(function() {
                            userscript.call(wrapper, wrapper, AdguardSettings, window.__adg_gm_commands_api);
                        }, 1)
                    })
                } else {
                    userscript.call(wrapper, wrapper, AdguardSettings, window.__adg_gm_commands_api);
                }
            } else {
                log('Page tries to run userscript second time');
            }
        })();
    } catch (ex) {
        log(ex);
    }
})();
